/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util;

import com.lapissea.util.NotNull;
import com.lapissea.util.Nullable;
import com.lapissea.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ArgumentParser {
    private static final Object NULL = new Object();
    private final Map<String, Object> data = new HashMap<String, Object>();

    public ArgumentParser(@NotNull String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("--")) continue;
            int pos = arg.indexOf("=");
            if (pos == -1) {
                this.data.put(arg.substring(2), NULL);
                continue;
            }
            String val = arg.substring(pos + 1);
            this.data.put(arg.substring(2, pos), "null".equals(val) ? NULL : val);
        }
    }

    public boolean hasValue(@NotNull String key) {
        return this.data.containsKey(key);
    }

    @Nullable
    public String getString(@NotNull String key) {
        return this.getString(key, null);
    }

    @Nullable
    public String getString(@NotNull String key, @Nullable String def) {
        Object o = this.get(key);
        if (o == null) {
            return def;
        }
        return o.toString();
    }

    public void setString(@NotNull String key, String val) {
        this.data.put(key, val);
    }

    public int getInt(@NotNull String key) {
        return this.getInt(key, -1);
    }

    public int getInt(@NotNull String key, int def) {
        Object o = this.get(key);
        if (o == null) {
            return def;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        o = Integer.parseInt((String)o);
        this.data.put(key, o);
        return (Integer)o;
    }

    public void setInt(@NotNull String key, int val) {
        this.data.put(key, val);
    }

    public boolean getBoolean(@NotNull String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(@NotNull String key, boolean def) {
        Object o = this.get(key);
        if (o == null) {
            return def;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        o = Boolean.parseBoolean((String)o);
        this.data.put(key, o);
        return (Boolean)o;
    }

    public void setBoolean(@NotNull String key, boolean val) {
        this.data.put(key, val);
    }

    public <T> T get(@NotNull String key) {
        return this.get(key, null);
    }

    public <T> T get(@NotNull String key, T def) {
        Object o = this.data.get(key);
        return (T)(o == null || o == NULL ? def : o);
    }

    public String toString() {
        return this.data.entrySet().stream().map(e -> {
            Object v = e.getValue();
            String s = v == null || v == NULL ? "" : this.escape(TextUtil.toString(v));
            return "--" + this.escape((String)e.getKey()) + (s.isEmpty() ? "" : "=" + s);
        }).collect(Collectors.joining(" "));
    }

    private String escape(String in) {
        if ((in = in.replaceAll("\"", "\\\"")).chars().anyMatch(Character::isWhitespace)) {
            in = '\"' + in + '\"';
        }
        return in;
    }
}

