/*
 * Decompiled with CFR 0.152.
 */
package com.fourmob.datetimepicker.date;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.view.MotionEvent;
import android.view.View;
import com.fourmob.datetimepicker.R;
import com.fourmob.datetimepicker.Utils;
import com.fourmob.datetimepicker.date.CalendarDay;
import java.security.InvalidParameterException;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;

public class SimpleMonthView
extends View {
    private static final String VIEW_PARAMS_HEIGHT = "height";
    public static final String VIEW_PARAMS_MONTH = "month";
    public static final String VIEW_PARAMS_YEAR = "year";
    public static final String VIEW_PARAMS_SELECTED_DAY = "selected_day";
    public static final String VIEW_PARAMS_WEEK_START = "week_start";
    public static final String VIEW_PARAMS_MIN_DATE_DAY = "minDateDay";
    public static final String VIEW_PARAMS_MAX_DATE_DAY = "maxDateDay";
    public static final String VIEW_PARAMS_MIN_DATE_MONTH = "minDateMonth";
    public static final String VIEW_PARAMS_MIN_DATE_YEAR = "minDateYear";
    public static final String VIEW_PARAMS_MAX_DATE_MONTH = "maxDateMonth";
    public static final String VIEW_PARAMS_MAX_DATE_YEAR = "maxDateYear";
    protected static final int DEFAULT_HEIGHT = 32;
    protected static final int DEFAULT_NUM_ROWS = 6;
    protected static final int DAY_SEPARATOR_WIDTH = 1;
    protected static final int MIN_HEIGHT = 10;
    private int daySelectedCircleSize;
    private int miniDayNumberTextSize;
    private int monthDayLabelTextSize;
    private int monthHeaderSize;
    private int monthLabelTextSize;
    private final int mDayDisabledTextColor;
    private int mPadding = 0;
    private String mDayOfWeekTypeface;
    private String mMonthTitleTypeface;
    private Paint mMonthDayLabelPaint;
    private Paint mMonthNumPaint;
    private Paint mMonthTitlePaint;
    private Paint mSelectedCirclePaint;
    private Paint mHoveredCirclePaint;
    private int mDayTextColor;
    private int mSelectedTextColor;
    private int mTodayNumberColor;
    private boolean mHasToday = false;
    private int mSelectedDay = -1;
    private int mHoveredDay = -1;
    private int mToday = -1;
    private int mWeekStart = 1;
    private int mNumDays;
    private int mNumCells = this.mNumDays = 7;
    private int mDayOfWeekStart = 0;
    private int mMonth;
    private int mRowHeight = 32;
    private int mWidth;
    private int mYear;
    private final Calendar mCalendar;
    private final Calendar mDayLabelCalendar;
    private int mNumRows = 6;
    private DateFormatSymbols mDateFormatSymbols = new DateFormatSymbols();
    private OnDayClickListener mOnDayClickListener;
    private CalendarDay mMinDate;
    private CalendarDay mMaxDate;

    public SimpleMonthView(Context context) {
        super(context);
        Resources resources = context.getResources();
        this.mDayLabelCalendar = Calendar.getInstance();
        this.mCalendar = Calendar.getInstance();
        this.mDayOfWeekTypeface = resources.getString(R.string.day_of_week_label_typeface);
        this.mMonthTitleTypeface = resources.getString(R.string.sans_serif);
        this.mDayTextColor = resources.getColor(R.color.date_picker_text_normal);
        this.mSelectedTextColor = resources.getColor(R.color.date_picker_text_selected);
        this.mDayDisabledTextColor = resources.getColor(R.color.done_text_color_disabled);
        this.mTodayNumberColor = Utils.getPrimaryColor(context);
        this.miniDayNumberTextSize = resources.getDimensionPixelSize(R.dimen.day_number_size);
        this.monthLabelTextSize = resources.getDimensionPixelSize(R.dimen.month_label_size);
        this.monthDayLabelTextSize = resources.getDimensionPixelSize(R.dimen.month_day_label_text_size);
        this.monthHeaderSize = resources.getDimensionPixelOffset(R.dimen.month_list_item_header_height);
        this.daySelectedCircleSize = resources.getDimensionPixelSize(R.dimen.day_number_select_circle_radius);
        this.mRowHeight = (resources.getDimensionPixelOffset(R.dimen.date_picker_view_animator_height) - this.monthHeaderSize) / 6;
        this.initView();
    }

    private int calculateNumRows() {
        int offset = this.findDayOffset();
        int dividend = (offset + this.mNumCells) / this.mNumDays;
        int remainder = (offset + this.mNumCells) % this.mNumDays;
        return dividend + (remainder > 0 ? 1 : 0);
    }

    private void drawMonthDayLabels(Canvas canvas) {
        int y = this.monthHeaderSize - this.monthDayLabelTextSize / 2;
        int dayWidthHalf = (this.mWidth - this.mPadding * 2) / (this.mNumDays * 2);
        for (int i = 0; i < this.mNumDays; ++i) {
            int calendarDay = (i + this.mWeekStart) % this.mNumDays;
            int x = (2 * i + 1) * dayWidthHalf + this.mPadding;
            this.mDayLabelCalendar.set(7, calendarDay);
            canvas.drawText(this.mDateFormatSymbols.getShortWeekdays()[this.mDayLabelCalendar.get(7)].toUpperCase(Locale.getDefault()).substring(0, 1), (float)x, (float)y, this.mMonthDayLabelPaint);
        }
    }

    private void drawMonthTitle(Canvas canvas) {
        int x = (this.mWidth + 2 * this.mPadding) / 2;
        int y = (this.monthHeaderSize - this.monthDayLabelTextSize) / 2 + this.monthLabelTextSize / 3;
        canvas.drawText(this.getMonthAndYearString(), (float)x, (float)y, this.mMonthTitlePaint);
    }

    private int findDayOffset() {
        return (this.mDayOfWeekStart < this.mWeekStart ? this.mDayOfWeekStart + this.mNumDays : this.mDayOfWeekStart) - this.mWeekStart;
    }

    private String getMonthAndYearString() {
        int flags = 52;
        long millis = this.mCalendar.getTimeInMillis();
        return DateUtils.formatDateRange((Context)this.getContext(), (long)millis, (long)millis, (int)flags);
    }

    private void onDayClick(CalendarDay calendarDay) {
        if (this.mOnDayClickListener != null) {
            this.mOnDayClickListener.onDayClick(this, calendarDay);
        }
    }

    private boolean sameDay(int monthDay, Time time) {
        return this.mYear == time.year && this.mMonth == time.month && monthDay == time.monthDay;
    }

    protected void drawMonthNums(Canvas canvas) {
        int y = (this.mRowHeight + this.miniDayNumberTextSize) / 2 - 1 + this.monthHeaderSize;
        int paddingDay = (this.mWidth - 2 * this.mPadding) / (2 * this.mNumDays);
        int dayOffset = this.findDayOffset();
        int day = 1;
        boolean hasDisabledDays = false;
        if (this.mMinDate != null && this.mMonth <= this.mMinDate.month && this.mYear <= this.mMinDate.year) {
            hasDisabledDays = true;
        }
        if (this.mMaxDate != null && this.mMonth >= this.mMaxDate.month && this.mYear >= this.mMaxDate.year) {
            hasDisabledDays = true;
        }
        while (day <= this.mNumCells) {
            boolean isDisabledDay = false;
            int x = paddingDay * (1 + dayOffset * 2) + this.mPadding;
            if (hasDisabledDays) {
                isDisabledDay = this.isDisabledDay(day);
            }
            int textColor = this.mDayTextColor;
            if (!isDisabledDay) {
                if (this.mHasToday && this.mToday == day) {
                    textColor = this.mTodayNumberColor;
                }
                if (this.mSelectedDay == day) {
                    textColor = this.mSelectedTextColor;
                    canvas.drawCircle((float)x, (float)(y - this.miniDayNumberTextSize / 3), (float)this.daySelectedCircleSize, this.mSelectedCirclePaint);
                } else if (this.mHoveredDay == day) {
                    canvas.drawCircle((float)x, (float)(y - this.miniDayNumberTextSize / 3), (float)this.daySelectedCircleSize, this.mHoveredCirclePaint);
                }
            } else {
                textColor = this.mDayDisabledTextColor;
            }
            this.mMonthNumPaint.setColor(textColor);
            canvas.drawText(String.format("%d", day), (float)x, (float)y, this.mMonthNumPaint);
            if (++dayOffset == this.mNumDays) {
                dayOffset = 0;
                y += this.mRowHeight;
            }
            ++day;
        }
    }

    @Nullable
    public CalendarDay getDayFromLocation(float x, float y) {
        int padding = this.mPadding;
        if (x < (float)padding || x > (float)(this.mWidth - this.mPadding)) {
            return null;
        }
        int yDay = (int)(y - (float)this.monthHeaderSize) / this.mRowHeight;
        int day = 1 + ((int)((x - (float)padding) * (float)this.mNumDays / (float)(this.mWidth - padding - this.mPadding)) - this.findDayOffset()) + yDay * this.mNumDays;
        if (day <= 0 || day > this.mNumCells) {
            return null;
        }
        return new CalendarDay(this.mYear, this.mMonth, day);
    }

    protected void initView() {
        this.mMonthTitlePaint = new Paint();
        this.mMonthTitlePaint.setFakeBoldText(true);
        this.mMonthTitlePaint.setAntiAlias(true);
        this.mMonthTitlePaint.setTextSize((float)this.monthLabelTextSize);
        this.mMonthTitlePaint.setTypeface(Typeface.create((String)this.mMonthTitleTypeface, (int)1));
        this.mMonthTitlePaint.setColor(this.mDayTextColor);
        this.mMonthTitlePaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthTitlePaint.setStyle(Paint.Style.FILL);
        this.mSelectedCirclePaint = new Paint();
        this.mSelectedCirclePaint.setFakeBoldText(true);
        this.mSelectedCirclePaint.setAntiAlias(true);
        this.mSelectedCirclePaint.setColor(this.mTodayNumberColor);
        this.mSelectedCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mSelectedCirclePaint.setStyle(Paint.Style.FILL);
        this.mHoveredCirclePaint = new Paint();
        this.mHoveredCirclePaint.setFakeBoldText(true);
        this.mHoveredCirclePaint.setAntiAlias(true);
        this.mHoveredCirclePaint.setColor(this.mDayDisabledTextColor);
        this.mHoveredCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mHoveredCirclePaint.setStyle(Paint.Style.FILL);
        this.mMonthDayLabelPaint = new Paint();
        this.mMonthDayLabelPaint.setAntiAlias(true);
        this.mMonthDayLabelPaint.setTextSize((float)this.monthDayLabelTextSize);
        this.mMonthDayLabelPaint.setColor(this.mDayTextColor);
        this.mMonthDayLabelPaint.setTypeface(Typeface.create((String)this.mDayOfWeekTypeface, (int)0));
        this.mMonthDayLabelPaint.setStyle(Paint.Style.FILL);
        this.mMonthDayLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthNumPaint = new Paint();
        this.mMonthNumPaint.setAntiAlias(true);
        this.mMonthNumPaint.setTextSize((float)this.miniDayNumberTextSize);
        this.mMonthNumPaint.setStyle(Paint.Style.FILL);
        this.mMonthNumPaint.setTextAlign(Paint.Align.CENTER);
    }

    protected void onDraw(Canvas canvas) {
        this.drawMonthTitle(canvas);
        this.drawMonthDayLabels(canvas);
        this.drawMonthNums(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), this.mRowHeight * this.mNumRows + this.monthHeaderSize + this.getResources().getDimensionPixelOffset(R.dimen.month_view_bottom_pad));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mWidth = w;
    }

    private boolean isValidCalendarDay(CalendarDay calendarDay) {
        return calendarDay != null && !this.isDisabledDay(calendarDay.day);
    }

    private boolean isDisabledDay(int day) {
        return this.mMinDate != null && this.mMinDate.isAfter(new CalendarDay(this.mYear, this.mMonth, day)) || this.mMaxDate != null && this.mMaxDate.isBefore(new CalendarDay(this.mYear, this.mMonth, day));
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 1: {
                CalendarDay selectedCalendarDay = this.getDayFromLocation(event.getX(), event.getY());
                if (!this.isValidCalendarDay(selectedCalendarDay)) break;
                if (selectedCalendarDay.day != this.mSelectedDay) {
                    this.onDayClick(selectedCalendarDay);
                    this.mSelectedDay = selectedCalendarDay.day;
                    this.invalidate();
                }
                return true;
            }
            case 0: 
            case 2: {
                CalendarDay hoveredCalendarDay = this.getDayFromLocation(event.getX(), event.getY());
                if (!this.isValidCalendarDay(hoveredCalendarDay)) break;
                if (hoveredCalendarDay.day != this.mHoveredDay) {
                    this.mHoveredDay = hoveredCalendarDay.day;
                    this.invalidate();
                }
                return true;
            }
        }
        if (this.mHoveredDay != -1) {
            this.mHoveredDay = -1;
            this.invalidate();
        }
        return true;
    }

    public void reuse() {
        this.mNumRows = 6;
        this.requestLayout();
    }

    public void setMonthParams(HashMap<String, Integer> params) {
        if (!params.containsKey(VIEW_PARAMS_MONTH) && !params.containsKey(VIEW_PARAMS_YEAR)) {
            throw new InvalidParameterException("You must specify month and year for this view");
        }
        this.setTag(params);
        if (params.containsKey(VIEW_PARAMS_MIN_DATE_DAY) && params.containsKey(VIEW_PARAMS_MIN_DATE_MONTH) && params.containsKey(VIEW_PARAMS_MIN_DATE_YEAR)) {
            this.mMinDate = new CalendarDay(params.get(VIEW_PARAMS_MIN_DATE_YEAR), params.get(VIEW_PARAMS_MIN_DATE_MONTH), params.get(VIEW_PARAMS_MIN_DATE_DAY));
        }
        if (params.containsKey(VIEW_PARAMS_MAX_DATE_DAY) && params.containsKey(VIEW_PARAMS_MAX_DATE_MONTH) && params.containsKey(VIEW_PARAMS_MAX_DATE_YEAR)) {
            this.mMaxDate = new CalendarDay(params.get(VIEW_PARAMS_MAX_DATE_YEAR), params.get(VIEW_PARAMS_MAX_DATE_MONTH), params.get(VIEW_PARAMS_MAX_DATE_DAY));
        }
        if (params.containsKey(VIEW_PARAMS_HEIGHT)) {
            this.mRowHeight = params.get(VIEW_PARAMS_HEIGHT);
            if (this.mRowHeight < 10) {
                this.mRowHeight = 10;
            }
        }
        this.mHoveredDay = -1;
        this.mSelectedDay = -1;
        if (params.containsKey(VIEW_PARAMS_SELECTED_DAY)) {
            this.mSelectedDay = params.get(VIEW_PARAMS_SELECTED_DAY);
        }
        this.mMonth = params.get(VIEW_PARAMS_MONTH);
        this.mYear = params.get(VIEW_PARAMS_YEAR);
        Time today = new Time(Time.getCurrentTimezone());
        today.setToNow();
        this.mHasToday = false;
        this.mToday = -1;
        this.mCalendar.set(2, this.mMonth);
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(5, 1);
        this.mDayOfWeekStart = this.mCalendar.get(7);
        this.mWeekStart = params.containsKey(VIEW_PARAMS_WEEK_START) ? params.get(VIEW_PARAMS_WEEK_START).intValue() : this.mCalendar.getFirstDayOfWeek();
        this.mNumCells = Utils.getDaysInMonth(this.mMonth, this.mYear);
        for (int i = 0; i < this.mNumCells; ++i) {
            int day = i + 1;
            if (!this.sameDay(day, today)) continue;
            this.mHasToday = true;
            this.mToday = day;
        }
        this.mNumRows = this.calculateNumRows();
    }

    public void setOnDayClickListener(OnDayClickListener onDayClickListener) {
        this.mOnDayClickListener = onDayClickListener;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public int getYear() {
        return this.mYear;
    }

    public void clearSelection() {
        this.mSelectedDay = -1;
        this.invalidate();
    }

    public static interface OnDayClickListener {
        public void onDayClick(SimpleMonthView var1, CalendarDay var2);
    }
}

