/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.generate.processors.copy;

import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.api.GeneratedFunction;
import in.kyle.api.generate.api.GeneratorHandler;
import in.kyle.api.generate.api.Invoke;
import in.kyle.api.generate.api.Matcher;
import in.kyle.api.generate.helper.Assist;
import in.kyle.api.generate.helper.ReflectHelper;
import in.kyle.api.generate.processors.Processor;
import in.kyle.api.generate.processors.copy.Copy;
import in.kyle.api.utils.StringUtils;
import in.kyle.api.utils.Try;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class CopyProcessor
implements Processor<Method> {
    private static final ClassPool pool = Assist.POOL;
    static final Map<String, Class<?>> genClasses = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <I extends Generated> void process(Class<I> clazz, I instance, Method srcMethod, GeneratorHandler handler) throws Exception {
        Class target;
        Copy copy = srcMethod.getAnnotation(Copy.class);
        Class<?> srcClass = copy.value();
        Map<String, Class<?>> map = genClasses;
        synchronized (map) {
            target = (Class)Try.to(() -> this.makeImplementingClass(srcMethod, srcClass));
        }
        handler.addFunction(new Function(target, srcMethod));
    }

    private Class<?> makeImplementingClass(Method srcMethod, Class<?> srcClass) throws Exception {
        String name = StringUtils.replaceVariables((String)"Gen_Target_{}_{}", (Object[])new Object[]{srcMethod.getDeclaringClass().getName().replace(".", "_"), srcMethod.getName()});
        if (genClasses.containsKey(name)) {
            return genClasses.get(name);
        }
        CtClass ctTarget = pool.makeClass(name);
        ctTarget.setSuperclass(pool.get(srcMethod.getDeclaringClass().getName()));
        CtClass ctSrc = Assist.getClass(srcClass);
        CtClass[] invokeParams = Assist.getClasses(srcMethod.getParameterTypes());
        CtMethod ctSrcMethod = ctSrc.getDeclaredMethod(srcMethod.getName(), invokeParams);
        CtMethod targetMethod = CtNewMethod.copy((CtMethod)ctSrcMethod, (CtClass)ctTarget, null);
        ctTarget.addMethod(targetMethod);
        CtClass invokeClass = pool.get(srcMethod.getDeclaringClass().getName());
        for (CtField field : invokeClass.getDeclaredFields()) {
            CtField ctSrcField = new CtField(field, ctTarget);
            ctSrcField.setModifiers(1);
            ctTarget.addField(ctSrcField);
        }
        Class target = ctTarget.toClass();
        genClasses.put(name, target);
        return target;
    }

    static class Function
    implements GeneratedFunction {
        private final Matcher matcher;
        private final Class<? extends Generated> target;
        private final Method copiedMethod;

        Function(Class<? extends Generated> target, Method method) throws NoSuchMethodException {
            this.target = target;
            this.matcher = Matcher.exact(method);
            this.copiedMethod = target.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }

        @Override
        public Matcher getMatcher() {
            return this.matcher;
        }

        @Override
        public Object invoke(GeneratorHandler handler, Invoke invoke) throws Throwable {
            Generated generatedInstance = handler.getGenerator().create(this.target);
            this.copyFieldValues(generatedInstance, handler);
            return this.copiedMethod.invoke((Object)generatedInstance, invoke.getArgs());
        }

        private void copyFieldValues(Object to, GeneratorHandler handler) throws IllegalAccessException {
            for (Field field : ReflectHelper.getFields(to.getClass())) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                field.set(to, handler.getValue(field.getName()));
            }
        }
    }
}

