/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.generate.processors;

import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.api.GeneratorHandler;
import in.kyle.api.generate.api.Matcher;
import in.kyle.api.generate.helper.CamelCaseHelper;
import in.kyle.api.generate.processors.Processor;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;

public abstract class CollectionProcessor<A extends Annotation, B extends Collection<Object>>
implements Processor<Field> {
    private final Class<A> annotationClass;

    @Override
    public <I extends Generated> void process(Class<I> clazz, I instance, Field field, GeneratorHandler handler) throws Exception {
        A annotation = field.getAnnotation(this.annotationClass);
        String methodSuffix = CamelCaseHelper.toUpperCamelCase(field.getName());
        methodSuffix = methodSuffix.substring(0, methodSuffix.length() - 1);
        Collection value = (Collection)handler.getValueOrDefault(field.getName(), this.createDefaultCollection());
        Class<?> type = this.getType(annotation);
        Matcher addMatcher = Matcher.builder().args(type).nameEquals("add" + methodSuffix).build();
        handler.createAndAddFunction(addMatcher, invoke -> value.add(invoke.getArg(0)));
        Matcher addForceMatcher = Matcher.builder().args(type, Boolean.TYPE).nameEquals("add" + methodSuffix).build();
        handler.createAndAddFunction(addForceMatcher, invoke -> value.add(invoke.getArg(0)));
        Matcher addPluralMatcher = Matcher.builder().args(Collection.class).nameEquals("add" + methodSuffix + "s").build();
        handler.createAndAddFunction(addPluralMatcher, invoke -> value.addAll((Collection)invoke.getArg(0)));
        Matcher hasMater = Matcher.builder().args(type).nameEquals("has" + methodSuffix).build();
        handler.createAndAddFunction(hasMater, invoke -> value.contains(invoke.getArg(0)));
        Matcher removeMater = Matcher.builder().args(type).nameEquals("remove" + methodSuffix).build();
        handler.createAndAddFunction(removeMater, invoke -> value.remove(invoke.getArg(0)));
    }

    protected abstract Class<?> getType(A var1);

    protected abstract B createDefaultCollection();

    @ConstructorProperties(value={"annotationClass"})
    public CollectionProcessor(Class<A> annotationClass) {
        this.annotationClass = annotationClass;
    }
}

