/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.generate.helper;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;

public final class ReflectHelper {
    private ReflectHelper() {
    }

    public static Field getAccessibleField(Class<?> clazz, String name) {
        Field field = ReflectHelper.getField(clazz, name);
        if (field != null) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Field getField(Class<?> clazz, String name) {
        return ReflectHelper.getFields(clazz).stream().filter(field -> field.getName().equals(name)).findFirst().orElse(null);
    }

    public static Collection<Field> getFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (!clazz.equals(Object.class)) {
            fields.addAll(ReflectHelper.getFields(clazz.getSuperclass()));
        }
        return fields;
    }

    public static Collection<Method> getMethods(Class<?> clazz) {
        HashSet<Method> methods = new HashSet<Method>();
        methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        if (!clazz.equals(Object.class)) {
            methods.addAll(ReflectHelper.getMethods(clazz.getSuperclass()));
        }
        return methods;
    }

    public static Collection<Member> getMembers(Class<?> src) {
        HashSet<Member> members = new HashSet<Member>();
        members.addAll(ReflectHelper.getFields(src));
        members.addAll(ReflectHelper.getMethods(src));
        return members;
    }

    public static Collection<AnnotatedElement> getAnnotatedElements(Class<?> src) {
        return ReflectHelper.getMembers(src).stream().map(m -> (AnnotatedElement)((Object)m)).collect(Collectors.toSet());
    }
}

