/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.generate.api;

import in.kyle.api.generate.helper.CamelCaseHelper;
import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.util.Arrays;

public class Invoke {
    private final Method method;
    private final Object object;
    private final Object[] args;

    public <T> T getArg(int index) {
        return (T)this.args[index];
    }

    public String removePrefix(String prefix) {
        String methodName = this.method.getName();
        return CamelCaseHelper.toLowerCamelCase(methodName.substring(prefix.length()));
    }

    @ConstructorProperties(value={"method", "object", "args"})
    public Invoke(Method method, Object object, Object[] args) {
        this.method = method;
        this.object = object;
        this.args = args;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getObject() {
        return this.object;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Invoke)) {
            return false;
        }
        Invoke other = (Invoke)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        Object this$object = this.getObject();
        Object other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        return Arrays.deepEquals(this.getArgs(), other.getArgs());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Invoke;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        Object $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArgs());
        return result;
    }

    public String toString() {
        return "Invoke(method=" + this.getMethod() + ", object=" + this.getObject() + ", args=" + Arrays.deepToString(this.getArgs()) + ")";
    }
}

