/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.generate.api;

import in.kyle.api.generate.api.GenerateException;
import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.api.GeneratorHandler;
import in.kyle.api.generate.helper.ReflectHelper;
import in.kyle.api.generate.processors.Global;
import in.kyle.api.generate.processors.Processor;
import in.kyle.api.generate.processors.collection.list.ImplementList;
import in.kyle.api.generate.processors.collection.list.ListProcessor;
import in.kyle.api.generate.processors.collection.set.ImplementSet;
import in.kyle.api.generate.processors.collection.set.SetProcessor;
import in.kyle.api.generate.processors.copy.Copy;
import in.kyle.api.generate.processors.copy.CopyProcessor;
import in.kyle.api.generate.processors.create.Create;
import in.kyle.api.generate.processors.create.CreateProcessor;
import in.kyle.api.generate.processors.increment.Increment;
import in.kyle.api.generate.processors.increment.IncrementProcessor;
import in.kyle.api.generate.processors.map.ImplementMap;
import in.kyle.api.generate.processors.map.MapProcessor;
import in.kyle.api.generate.processors.setup.Setup;
import in.kyle.api.generate.processors.setup.SetupProcessor;
import in.kyle.api.utils.Try;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;

public final class Generator {
    private static final Map<Class<?>, Object> globals = new HashMap();
    protected final Map<Class<? extends Annotation>, Processor<?>> processors = new LinkedHashMap();

    private Generator() {
        this.addDefaultProcessors();
    }

    private void addDefaultProcessors() {
        this.addProcessor(Create.class, new CreateProcessor());
        this.addProcessor(Copy.class, new CopyProcessor());
        this.addProcessor(Increment.class, new IncrementProcessor());
        this.addProcessor(ImplementSet.class, new SetProcessor());
        this.addProcessor(ImplementList.class, new ListProcessor());
        this.addProcessor(ImplementMap.class, new MapProcessor());
        this.addProcessor(Setup.class, new SetupProcessor());
    }

    public void inject(Object target) {
        ReflectHelper.getFields(target.getClass()).stream().filter(field -> Generated.class.isAssignableFrom(field.getType())).forEach(field -> {
            field.setAccessible(true);
            Try.to(() -> this.inject(target, (Field)field), e -> new GenerateException((Throwable)e, "Unable to inject field {}:{} in class {}", (Object)field.getType().getSimpleName(), (Object)field.getName(), (Object)field.getDeclaringClass()));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T extends Generated> T create(Class<T> clazz) {
        Map<Class<?>, Object> map = globals;
        synchronized (map) {
            if (globals.containsKey(clazz)) {
                return (T)((Generated)globals.get(clazz));
            }
        }
        GeneratorHandler handler = new GeneratorHandler(this);
        Object instance = this.createInstance(clazz, handler);
        this.modifyMembers(clazz);
        Collection<AnnotatedElement> members = ReflectHelper.getAnnotatedElements(clazz);
        this.processors.forEach((a, p) -> {
            for (AnnotatedElement member : members) {
                if (!member.isAnnotationPresent((Class<? extends Annotation>)a)) continue;
                Try.to(() -> p.process(clazz, instance, member, handler), e -> new GenerateException((Throwable)e, "Unable to process element {}", (Object)member));
            }
        });
        this.processGlobals(clazz, instance);
        return instance;
    }

    private <T extends Generated> void processGlobals(Class<T> clazz, T instance) {
        for (Field field : ReflectHelper.getFields(clazz)) {
            field.setAccessible(true);
            Try.to(() -> {
                if (field.getType().isAnnotationPresent(Global.class) && field.get(instance) == null) {
                    Class<?> type = field.getType();
                    field.set(instance, this.create(type));
                }
            }, e -> new GenerateException((Throwable)e, "Failed to inject global variable {} in {}", (Object)field.getName(), (Object)clazz.getName()));
        }
    }

    private <T extends Generated> void modifyMembers(Class<T> clazz) {
        ReflectHelper.getMembers(clazz).stream().map(m -> (AccessibleObject)((Object)m)).forEach(a -> a.setAccessible(true));
        for (Field field : ReflectHelper.getFields(clazz)) {
            field.setAccessible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Generated> T createInstance(Class<T> clazz, GeneratorHandler handler) throws GenerateException {
        if (!Generated.class.isAssignableFrom(clazz)) {
            throw new GenerateException("Not generated instance {}", clazz.getName());
        }
        boolean global = clazz.isAnnotationPresent(Global.class);
        ProxyFactory factory = new ProxyFactory();
        factory.setSuperclass(clazz);
        factory.setFilter(method -> Modifier.isAbstract(method.getModifiers()));
        Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
        Object[] values = new Object[constructor.getParameterCount()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.create(constructor.getParameterTypes()[i]);
        }
        Generated t = (Generated)Try.to(() -> factory.create((Class[])constructor.getParameterTypes(), values, (MethodHandler)handler), e -> this.makeGenerateException(clazz, (Throwable)e));
        handler.setObject(t);
        if (global) {
            Map<Class<?>, Object> map = globals;
            synchronized (map) {
                globals.put(clazz, t);
            }
        }
        return (T)t;
    }

    private <T extends Generated> Throwable makeGenerateException(Class<T> clazz, Throwable e) {
        return new GenerateException(e, "Failed to create instance of {}", clazz.getName());
    }

    public <T extends Annotation> void addProcessor(Class<T> annotation, Processor<?> processor) {
        this.processors.put(annotation, processor);
    }

    private void inject(Object target, Field field) throws IllegalAccessException {
        field.set(target, this.create(field.getType()));
    }

    public static Generator create() {
        return new Generator();
    }
}

