/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.generate;

import in.kyle.api.generate.api.GeneratedFunction;
import in.kyle.api.generate.api.Generator;
import in.kyle.api.generate.api.GeneratorHandler;
import in.kyle.api.generate.api.Invoke;
import in.kyle.api.generate.api.Matcher;
import in.kyle.api.utils.Try;
import java.util.Map;

public enum DefaultFunctions implements GeneratedFunction
{
    SETTER_FUNCTION{
        private final Matcher setterMatcher = Matcher.builder().argsLength(1).nameStartsWith("set").returnType(Void.TYPE).build();

        @Override
        public Matcher getMatcher() {
            return this.setterMatcher;
        }

        @Override
        public Object invoke(GeneratorHandler handler, Invoke invoke) {
            handler.setValue(invoke.removePrefix("set"), invoke.getArg(0));
            return null;
        }
    }
    ,
    SETTER_API_FUNCTION{
        private final Matcher setterMultiMatcher = Matcher.builder().args(String.class, Object.class).nameEquals("set").returnType(Void.TYPE).build();

        @Override
        public Matcher getMatcher() {
            return this.setterMultiMatcher;
        }

        @Override
        public Object invoke(GeneratorHandler handler, Invoke invoke) {
            handler.setValue((String)invoke.getArg(0), invoke.getArg(1));
            return null;
        }
    }
    ,
    SETTER_MULTI_FUNCTION{
        private final Matcher setterMultiMatcher = Matcher.builder().argsLength(2).nameStartsWith("set").returnType(Void.TYPE).build();

        @Override
        public Matcher getMatcher() {
            return this.setterMultiMatcher;
        }

        @Override
        public Object invoke(GeneratorHandler handler, Invoke invoke) {
            handler.setValue(invoke.removePrefix("set"), invoke.getArg(0));
            return null;
        }
    }
    ,
    GET_FIELDS_FUNCTION{
        private final Matcher getFieldsMatcher = Matcher.builder().argsLength(0).nameEquals("getFields").returnType(Map.class).build();

        @Override
        public Matcher getMatcher() {
            return this.getFieldsMatcher;
        }

        @Override
        public Object invoke(GeneratorHandler handler, Invoke invoke) {
            return Try.to(handler::getEffectiveValues);
        }
    }
    ,
    GET_HANDLER_FUNCTION{
        private final Matcher handlerMatcher = Matcher.builder().nameEquals("getGenerationHandler").returnType(GeneratorHandler.class).argsLength(0).build();

        @Override
        public Matcher getMatcher() {
            return this.handlerMatcher;
        }

        @Override
        public Object invoke(GeneratorHandler handler, Invoke invoke) {
            return handler;
        }
    }
    ,
    GET_GENERATOR_FUNCTION{
        private final Matcher handlerMatcher = Matcher.builder().nameEquals("getInternalGenerator").returnType(Generator.class).argsLength(0).build();

        @Override
        public Matcher getMatcher() {
            return this.handlerMatcher;
        }

        @Override
        public Object invoke(GeneratorHandler handler, Invoke invoke) {
            return handler.getGenerator();
        }
    }
    ,
    GETTER_FUNCTION{
        private final Matcher getterMatcher = Matcher.builder().argsLength(0).nameStartsWith("get", "is", "has").build();

        @Override
        public Matcher getMatcher() {
            return this.getterMatcher;
        }

        @Override
        public Object invoke(GeneratorHandler handler, Invoke invoke) {
            if (invoke.getMethod().getName().startsWith("is")) {
                return handler.getValueOrDefault(invoke.removePrefix("is"), handler.getDefaultReturnValue(invoke.getMethod()));
            }
            return handler.getValueOrDefault(invoke.removePrefix("get"), handler.getDefaultReturnValue(invoke.getMethod()));
        }
    };


    public static void addTo(GeneratorHandler handler) {
        for (DefaultFunctions function : DefaultFunctions.values()) {
            handler.addFunction(function);
        }
    }
}

