package in.kyle.api.generate.processors.map;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import in.kyle.api.generate.api.GeneratorHandler;
import in.kyle.api.generate.processors.Processor;
import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.api.Matcher;
import in.kyle.api.generate.helper.CamelCaseHelper;

public class MapProcessor implements Processor<Field> {
    @Override
    public <I extends Generated> void process(Class<I> clazz,
                                              I instance,
                                              Field field,
                                              GeneratorHandler handler) throws Exception {
        ImplementMap annotation = field.getAnnotation(ImplementMap.class);
        String methodSuffix = CamelCaseHelper.toUpperCamelCase(field.getName());
        methodSuffix = methodSuffix.substring(0, methodSuffix.length() - 1); // remove plural
        Map<Object, Object> value = handler.getValueOrDefault(field.getName(), new HashMap<>());
        
        // put
        Matcher addMatcher = Matcher.builder()
                                    .args(annotation.key(), annotation.value())
                                    .nameEquals("put" + methodSuffix)
                                    .build();
        handler.createAndAddFunction(addMatcher, invoke -> value.put(invoke.getArg(0), invoke.getArg(1)));
        
        // get
        Matcher hasMater =
                Matcher.builder().args(annotation.key()).nameEquals("get" + methodSuffix).build();
        handler.createAndAddFunction(hasMater, invoke -> value.get(invoke.getArg(0)));
    }
}
