package in.kyle.api.generate.processors.increment;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import in.kyle.api.generate.api.GeneratorHandler;
import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.processors.Processor;
import in.kyle.api.utils.Try;

public class IncrementProcessor implements Processor<Field> {
    
    private final Map<Field, Integer> values = new HashMap<>();
    
    @Override
    public <I extends Generated> void process(Class<I> clazz,
                                              I instance,
                                              Field field,
                                              GeneratorHandler handler) throws Exception {
        field.setAccessible(true);
        
        Increment increment = field.getAnnotation(Increment.class);
        
        int value = values.getOrDefault(field, increment.start());
        values.put(field, value + 1);
        if (field.getType().equals(String.class)) {
            Try.to(() -> field.set(instance, clazz.getSimpleName() + "-" + value));
        } else if (field.getType().equals(int.class)) {
            Try.to(() -> field.set(instance, value));
        } else {
            throw new RuntimeException("Type not supported for increment " + field.getType());
        }
    }
}
