package in.kyle.api.generate.api;

import java.lang.reflect.Method;

import in.kyle.api.generate.helper.CamelCaseHelper;
import lombok.Data;

@Data
public class Invoke {
    private final Method method;
    private final Object object;
    private final Object[] args;
    
    public <T> T getArg(int index) {
        return (T) args[index];
    }
    
    public String removePrefix(String prefix) {
        String methodName = method.getName();
        return CamelCaseHelper.toLowerCamelCase(methodName.substring(prefix.length()));
    }
}