package in.kyle.api.generate.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

// Modified from Google Guava
public final class Defaults {
    
    private static final Map<Class<?>, Object> DEFAULTS;
    
    static {
        Map<Class<?>, Object> map = new HashMap<>();
        put(map, Boolean.TYPE, false);
        put(map, Character.TYPE, ' ');
        put(map, Byte.TYPE, (byte) 0);
        put(map, Short.TYPE, (short) 0);
        put(map, Integer.TYPE, 0);
        put(map, Long.TYPE, 0L);
        put(map, Float.TYPE, 0.0F);
        put(map, Double.TYPE, 0.0D);
        put(map, String.class, "");
        DEFAULTS = Collections.unmodifiableMap(map);
    }
    
    private Defaults() {
    }
    
    private static <T> void put(Map<Class<?>, Object> map, Class<T> type, T value) {
        map.put(type, value);
    }
    
    public static <T> T defaultValue(Class<T> type) {
        T t = (T) DEFAULTS.get(type);
        return t;
    }
}
