/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.bukkit.plugin;

import in.kyle.api.utils.Try;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public abstract class TestPluginManager
implements PluginManager {
    private final Map<Listener, Set<Consumer<Event>>> listeners = new HashMap<Listener, Set<Consumer<Event>>>();
    private final Set<Plugin> plugins = new HashSet<Plugin>();

    public Plugin getPlugin(String name) {
        return this.plugins.stream().filter(plugin -> plugin.getName().equals(name)).findAny().orElse(null);
    }

    public Plugin[] getPlugins() {
        return this.plugins.toArray(new Plugin[this.plugins.size()]);
    }

    public boolean isPluginEnabled(String name) {
        return this.getPlugin(name) != null;
    }

    public boolean isPluginEnabled(Plugin plugin) {
        return this.plugins.contains(plugin);
    }

    public void disablePlugins() {
        for (Plugin plugin : this.plugins) {
            plugin.onDisable();
        }
    }

    public void clearPlugins() {
        this.disablePlugins();
        this.plugins.clear();
    }

    public void callEvent(Event event) throws IllegalStateException {
        HashSet run = new HashSet();
        this.listeners.values().forEach(run::addAll);
        run.forEach(c -> c.accept(event));
    }

    public void registerEvents(Listener listener, Plugin plugin) {
        for (Method method : listener.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(EventHandler.class) || method.getParameterCount() != 1) continue;
            EventHandler annotation = method.getAnnotation(EventHandler.class);
            Class<?> clazz = method.getParameterTypes()[0];
            this.registerEvent(clazz, listener, annotation.priority(), (listener1, event) -> Try.to(() -> method.invoke((Object)listener, event)), plugin, annotation.ignoreCancelled());
        }
    }

    public void registerEvent(Class<? extends Event> event, Listener listener, EventPriority priority, EventExecutor executor, Plugin plugin) {
        this.registerEvent(event, listener, priority, executor, plugin, false);
    }

    public void registerEvent(Class<? extends Event> event, Listener listener, EventPriority priority, EventExecutor executor, Plugin plugin, boolean ignoreCancelled) {
        Set consumers = this.listeners.getOrDefault(listener, new HashSet());
        consumers.add(e -> {
            if (e.getClass().equals(event)) {
                if (e instanceof Cancellable && !ignoreCancelled && ((Cancellable)e).isCancelled()) {
                    return;
                }
                Try.to(() -> executor.execute(listener, e));
            }
        });
        this.listeners.put(listener, consumers);
    }

    public void enablePlugin(Plugin plugin) {
        if (this.isPluginEnabled(plugin)) {
            throw new IllegalStateException("Plugin already enabled");
        }
        this.plugins.add(plugin);
        plugin.onEnable();
    }

    public void disablePlugin(Plugin plugin) {
        if (!this.isPluginEnabled(plugin)) {
            throw new IllegalStateException("Plugin already enabled");
        }
        this.plugins.add(plugin);
        plugin.onEnable();
    }

    public boolean useTimings() {
        return false;
    }

    public Map<Listener, Set<Consumer<Event>>> getListeners() {
        return this.listeners;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestPluginManager)) {
            return false;
        }
        TestPluginManager other = (TestPluginManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Listener, Set<Consumer<Event>>> this$listeners = this.getListeners();
        Map<Listener, Set<Consumer<Event>>> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        return Arrays.deepEquals(this.getPlugins(), other.getPlugins());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestPluginManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Listener, Set<Consumer<Event>>> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPlugins());
        return result;
    }

    public String toString() {
        return "TestPluginManager(listeners=" + this.getListeners() + ", plugins=" + Arrays.deepToString(this.getPlugins()) + ")";
    }
}

