/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.bukkit.inventory;

import in.kyle.api.bukkit.util.BoundedArrayList;
import in.kyle.api.generate.NotImplementedException;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CommonInventory {
    private static final AtomicInteger idIndex = new AtomicInteger();
    private final InventoryType type;
    private final InventoryHolder holder;
    private final List<ItemStack> items;
    private final List<HumanEntity> viewers = new ArrayList<HumanEntity>();
    private final String name = "inv-" + idIndex.incrementAndGet();
    private final String title;
    private final int size;
    private int maxStackSize;
    private Location location;

    public CommonInventory(InventoryType type, InventoryHolder holder, String title) {
        this(type, holder, new BoundedArrayList<ItemStack>(type.getDefaultSize()), title, type.getDefaultSize());
    }

    public CommonInventory(InventoryType type, InventoryHolder holder) {
        this(type, holder, type.getDefaultTitle());
    }

    public ItemStack getItem(int index) {
        return this.items.get(index);
    }

    public void setItem(int index, ItemStack item) {
        this.items.set(index, item);
    }

    public HashMap<Integer, ItemStack> addItem(ItemStack ... items) throws IllegalArgumentException {
        throw new NotImplementedException("Method not implemented");
    }

    public HashMap<Integer, ItemStack> removeItem(ItemStack ... items) throws IllegalArgumentException {
        throw new NotImplementedException("Method not implemented");
    }

    public ItemStack[] getContents() {
        return this.items.toArray(new ItemStack[this.items.size()]);
    }

    public void setContents(ItemStack[] items) throws IllegalArgumentException {
        for (int i = 0; i < items.length; ++i) {
            this.items.set(i, items[i]);
        }
    }

    public ItemStack[] getStorageContents() {
        return this.getContents();
    }

    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        this.setContents(items);
    }

    public boolean contains(int materialId) {
        return this.items.stream().anyMatch(itemStack -> itemStack.getType().getId() == materialId);
    }

    public boolean contains(Material material) throws IllegalArgumentException {
        return this.contains(material.getId());
    }

    public boolean contains(ItemStack item) {
        return this.items.stream().anyMatch(itemStack -> itemStack.equals((Object)item));
    }

    private int getAmount(ItemStack is) {
        return (int)this.items.stream().filter(itemStack -> itemStack.equals((Object)is)).count();
    }

    private int getAmount(Material material) {
        return (int)this.items.stream().filter(itemStack -> itemStack.getType() == material).count();
    }

    public boolean contains(int materialId, int amount) {
        return this.getAmount(Material.getMaterial((int)materialId)) >= amount;
    }

    public boolean contains(Material material, int amount) throws IllegalArgumentException {
        return this.contains(material.getId(), amount);
    }

    public boolean contains(ItemStack item, int amount) {
        return this.getAmount(item) >= amount;
    }

    public boolean containsAtLeast(ItemStack item, int amount) {
        return this.contains(item, amount);
    }

    public HashMap<Integer, ? extends ItemStack> all(int materialId) {
        return new HashMap<Integer, ItemStack>(this.items.stream().filter(item -> item.getTypeId() == materialId).collect(Collectors.toMap(this.items::indexOf, item -> item)));
    }

    public HashMap<Integer, ? extends ItemStack> all(Material material) throws IllegalArgumentException {
        return this.all(material.getId());
    }

    public HashMap<Integer, ? extends ItemStack> all(ItemStack itemStack) {
        return new HashMap<Integer, ItemStack>(this.items.stream().filter(item -> item.equals((Object)itemStack)).collect(Collectors.toMap(this.items::indexOf, item -> item)));
    }

    public int first(int materialId) {
        return this.items.stream().filter(item -> item.getTypeId() == materialId).findFirst().map(this.items::indexOf).orElse(-1);
    }

    public int first(Material material) throws IllegalArgumentException {
        return this.first(material.getId());
    }

    public int first(ItemStack item) {
        return this.items.stream().filter(i -> i.equals((Object)item)).findFirst().map(this.items::indexOf).orElse(-1);
    }

    public int firstEmpty() {
        return this.items.stream().filter(i -> i.getTypeId() == 0).findFirst().map(this.items::indexOf).orElse(-1);
    }

    public void remove(int materialId) {
        this.items.removeIf(itemStack -> itemStack.getTypeId() == materialId);
    }

    public void remove(Material material) throws IllegalArgumentException {
        this.items.removeIf(itemStack -> itemStack.getType() == material);
    }

    public void remove(ItemStack item) {
        this.items.removeIf(itemStack -> itemStack.equals((Object)item));
    }

    public void clear(int index) {
        this.setItem(index, new ItemStack(Material.AIR));
    }

    public void clear() {
        for (int i = 0; i < this.items.size(); ++i) {
            this.clear(i);
        }
    }

    public ListIterator<ItemStack> iterator() {
        return this.items.listIterator();
    }

    public ListIterator<ItemStack> iterator(int index) {
        return this.items.listIterator(index);
    }

    public InventoryType getType() {
        return this.type;
    }

    public InventoryHolder getHolder() {
        return this.holder;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public List<HumanEntity> getViewers() {
        return this.viewers;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonInventory)) {
            return false;
        }
        CommonInventory other = (CommonInventory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InventoryType this$type = this.getType();
        InventoryType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        InventoryHolder this$holder = this.getHolder();
        InventoryHolder other$holder = other.getHolder();
        if (this$holder == null ? other$holder != null : !this$holder.equals(other$holder)) {
            return false;
        }
        List<ItemStack> this$items = this.getItems();
        List<ItemStack> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        List<HumanEntity> this$viewers = this.getViewers();
        List<HumanEntity> other$viewers = other.getViewers();
        if (this$viewers == null ? other$viewers != null : !((Object)this$viewers).equals(other$viewers)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getMaxStackSize() != other.getMaxStackSize()) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        return !(this$location == null ? other$location != null : !this$location.equals(other$location));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonInventory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InventoryType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        InventoryHolder $holder = this.getHolder();
        result = result * 59 + ($holder == null ? 43 : $holder.hashCode());
        List<ItemStack> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        List<HumanEntity> $viewers = this.getViewers();
        result = result * 59 + ($viewers == null ? 43 : ((Object)$viewers).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        result = result * 59 + this.getSize();
        result = result * 59 + this.getMaxStackSize();
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        return result;
    }

    public String toString() {
        return "CommonInventory(type=" + this.getType() + ", holder=" + this.getHolder() + ", items=" + this.getItems() + ", viewers=" + this.getViewers() + ", name=" + this.getName() + ", title=" + this.getTitle() + ", size=" + this.getSize() + ", maxStackSize=" + this.getMaxStackSize() + ", location=" + this.getLocation() + ")";
    }

    @ConstructorProperties(value={"type", "holder", "items", "title", "size"})
    public CommonInventory(InventoryType type, InventoryHolder holder, List<ItemStack> items, String title, int size) {
        this.type = type;
        this.holder = holder;
        this.items = items;
        this.title = title;
        this.size = size;
    }
}

