/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.bukkit.entity;

import in.kyle.api.bukkit.TestServer;
import in.kyle.api.bukkit.entity.TestEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public abstract class TestItem
extends TestEntity
implements Item {
    private ItemStack itemStack;
    private int pickupDelay = 0;
    private Vector velocity = new Vector(0, 0, 0);
    private boolean alive = true;

    public TestItem(TestServer server) {
        super(server);
        this.setType(EntityType.DROPPED_ITEM);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public int getPickupDelay() {
        return this.pickupDelay;
    }

    @Override
    public Vector getVelocity() {
        return this.velocity;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public void setPickupDelay(int pickupDelay) {
        this.pickupDelay = pickupDelay;
    }

    @Override
    public void setVelocity(Vector velocity) {
        this.velocity = velocity;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestItem)) {
            return false;
        }
        TestItem other = (TestItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ItemStack this$itemStack = this.getItemStack();
        ItemStack other$itemStack = other.getItemStack();
        if (this$itemStack == null ? other$itemStack != null : !this$itemStack.equals(other$itemStack)) {
            return false;
        }
        if (this.getPickupDelay() != other.getPickupDelay()) {
            return false;
        }
        Vector this$velocity = this.getVelocity();
        Vector other$velocity = other.getVelocity();
        if (this$velocity == null ? other$velocity != null : !this$velocity.equals(other$velocity)) {
            return false;
        }
        return this.isAlive() == other.isAlive();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ItemStack $itemStack = this.getItemStack();
        result = result * 59 + ($itemStack == null ? 43 : $itemStack.hashCode());
        result = result * 59 + this.getPickupDelay();
        Vector $velocity = this.getVelocity();
        result = result * 59 + ($velocity == null ? 43 : $velocity.hashCode());
        result = result * 59 + (this.isAlive() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "TestItem(itemStack=" + this.getItemStack() + ", pickupDelay=" + this.getPickupDelay() + ", velocity=" + this.getVelocity() + ", alive=" + this.isAlive() + ")";
    }
}

