/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.bukkit.entity;

import in.kyle.api.bukkit.TestCommandSender;
import in.kyle.api.bukkit.TestServer;
import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.processors.collection.list.ImplementList;
import in.kyle.api.generate.processors.collection.set.ImplementSet;
import in.kyle.api.generate.processors.copy.Copy;
import in.kyle.api.generate.processors.increment.Increment;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;

public abstract class TestEntity
extends TestCommandSender
implements Entity,
Generated {
    private final Server server;
    @ImplementList(type=Entity.class)
    private final List<Entity> passengers = new ArrayList<Entity>();
    @ImplementSet(type=String.class)
    private final Set<String> scoreboardTags = new HashSet<String>();
    private UUID uniqueId = UUID.randomUUID();
    @Increment
    private int entityId;
    private Vector velocity = new Vector(0, 0, 0);
    private Location location;
    private EntityType type;

    protected TestEntity(TestServer server) {
        this.server = server;
        this.location = new Location(server.getWorld(), 0.0, 0.0, 0.0);
    }

    @Copy(value=CraftEntity.class)
    public abstract Location getLocation(Location var1);

    public boolean teleport(Location location) {
        this.location = location;
        return true;
    }

    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(destination.getLocation());
    }

    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(location);
    }

    public boolean teleport(Entity destination) {
        return this.teleport(destination.getLocation());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestEntity)) {
            return false;
        }
        TestEntity other = (TestEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Server this$server = this.getServer();
        Server other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        List<Entity> this$passengers = this.getPassengers();
        List<Entity> other$passengers = other.getPassengers();
        if (this$passengers == null ? other$passengers != null : !((Object)this$passengers).equals(other$passengers)) {
            return false;
        }
        Set<String> this$scoreboardTags = this.getScoreboardTags();
        Set<String> other$scoreboardTags = other.getScoreboardTags();
        if (this$scoreboardTags == null ? other$scoreboardTags != null : !((Object)this$scoreboardTags).equals(other$scoreboardTags)) {
            return false;
        }
        UUID this$uniqueId = this.getUniqueId();
        UUID other$uniqueId = other.getUniqueId();
        if (this$uniqueId == null ? other$uniqueId != null : !((Object)this$uniqueId).equals(other$uniqueId)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        Vector this$velocity = this.getVelocity();
        Vector other$velocity = other.getVelocity();
        if (this$velocity == null ? other$velocity != null : !this$velocity.equals(other$velocity)) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        EntityType this$type = this.getType();
        EntityType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Server $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        List<Entity> $passengers = this.getPassengers();
        result = result * 59 + ($passengers == null ? 43 : ((Object)$passengers).hashCode());
        Set<String> $scoreboardTags = this.getScoreboardTags();
        result = result * 59 + ($scoreboardTags == null ? 43 : ((Object)$scoreboardTags).hashCode());
        UUID $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : ((Object)$uniqueId).hashCode());
        result = result * 59 + this.getEntityId();
        Vector $velocity = this.getVelocity();
        result = result * 59 + ($velocity == null ? 43 : $velocity.hashCode());
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        EntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public Server getServer() {
        return this.server;
    }

    public List<Entity> getPassengers() {
        return this.passengers;
    }

    public Set<String> getScoreboardTags() {
        return this.scoreboardTags;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public Vector getVelocity() {
        return this.velocity;
    }

    public Location getLocation() {
        return this.location;
    }

    public EntityType getType() {
        return this.type;
    }

    public void setUniqueId(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setVelocity(Vector velocity) {
        this.velocity = velocity;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setType(EntityType type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "TestEntity(server=" + this.getServer() + ", passengers=" + this.getPassengers() + ", scoreboardTags=" + this.getScoreboardTags() + ", uniqueId=" + this.getUniqueId() + ", entityId=" + this.getEntityId() + ", velocity=" + this.getVelocity() + ", location=" + this.getLocation() + ", type=" + this.getType() + ")";
    }
}

