/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.bukkit.entity;

import in.kyle.api.bukkit.entity.TestArrow;
import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.api.Generator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;

public final class EntityFactory {
    private static final Map<Class<? extends Entity>, Function<Generator, Entity>> TYPE_MAP = new HashMap<Class<? extends Entity>, Function<Generator, Entity>>();

    private EntityFactory() {
    }

    public static <T extends Entity> void add(Class<T> clazz, Function<Generator, T> function) {
        TYPE_MAP.put(clazz, function);
    }

    public static <T extends Entity> T make(Generated generated, Class<T> clazz) {
        Function<Generator, Entity> function = TYPE_MAP.get(clazz);
        if (function == null) {
            throw new RuntimeException("Factory not defined for type " + clazz.getName());
        }
        return (T)function.apply(generated.getInternalGenerator());
    }

    static {
        EntityFactory.add(Arrow.class, g -> (TestArrow)g.create(TestArrow.class));
    }
}

