/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.bukkit.block;

import in.kyle.api.bukkit.TestWorld;
import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.processors.copy.Copy;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlock;

public abstract class TestBlock
implements Block,
Generated {
    private int x;
    private int y;
    private int z;
    private Chunk chunk;
    private byte data = 0;
    private Material type = Material.AIR;

    public Block getRelative(int x, int y, int z) {
        return this.chunk.getWorld().getBlockAt(this.x + x, this.y + y, this.z + z);
    }

    public Block getRelative(BlockFace blockFace) {
        return this.getRelative(blockFace, 1);
    }

    public Block getRelative(BlockFace blockFace, int i) {
        return this.getRelative(blockFace.getModX() * i, blockFace.getModY() * i, blockFace.getModZ() * i);
    }

    public int getTypeId() {
        return this.getType().getId();
    }

    public TestWorld getWorld() {
        return (TestWorld)this.chunk.getWorld();
    }

    public Location getLocation() {
        return new Location(this.chunk.getWorld(), (double)this.x, (double)this.y, (double)this.z);
    }

    public Location getLocation(Location location) {
        location.setX((double)this.x);
        location.setY((double)this.y);
        location.setZ((double)this.z);
        return location;
    }

    public void setData(byte b, boolean b1) {
        this.setData(b);
    }

    public void setType(Material material, boolean b) {
        this.setType(material);
    }

    public boolean setTypeId(int i) {
        Material material = Material.getMaterial((int)i);
        boolean b = material != this.type;
        this.setType(material);
        return b;
    }

    public boolean setTypeId(int i, boolean b) {
        this.setTypeId(i);
        return true;
    }

    public boolean setTypeIdAndData(int i, byte b, boolean b1) {
        this.setData(b);
        return this.setTypeId(i);
    }

    @Copy(value=CraftBlock.class)
    public abstract BlockFace getFace(Block var1);

    public Biome getBiome() {
        return this.getWorld().getBiome(this.x, this.z);
    }

    public void setBiome(Biome biome) {
        this.getWorld().setBiome(this.x, this.z, biome);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public byte getData() {
        return this.data;
    }

    public Material getType() {
        return this.type;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void setChunk(Chunk chunk) {
        this.chunk = chunk;
    }

    public void setData(byte data) {
        this.data = data;
    }

    public void setType(Material type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestBlock)) {
            return false;
        }
        TestBlock other = (TestBlock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        if (this.getZ() != other.getZ()) {
            return false;
        }
        Chunk this$chunk = this.getChunk();
        Chunk other$chunk = other.getChunk();
        if (this$chunk == null ? other$chunk != null : !this$chunk.equals(other$chunk)) {
            return false;
        }
        if (this.getData() != other.getData()) {
            return false;
        }
        Material this$type = this.getType();
        Material other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestBlock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getZ();
        Chunk $chunk = this.getChunk();
        result = result * 59 + ($chunk == null ? 43 : $chunk.hashCode());
        result = result * 59 + this.getData();
        Material $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "TestBlock(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", chunk=" + this.getChunk() + ", data=" + this.getData() + ", type=" + this.getType() + ")";
    }
}

