/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.bukkit;

import in.kyle.api.bukkit.TestChunk;
import in.kyle.api.bukkit.TestChunkGenerator;
import in.kyle.api.bukkit.TestServer;
import in.kyle.api.bukkit.entity.EntityFactory;
import in.kyle.api.bukkit.entity.TestItem;
import in.kyle.api.generate.api.Generated;
import in.kyle.api.utils.Conditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.bukkit.Chunk;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Consumer;
import org.bukkit.util.Vector;

public abstract class TestWorld
implements World,
Generated {
    private static final AtomicInteger idIndex = new AtomicInteger();
    private final TestServer server;
    private final Map<Long, Chunk> chunks = new HashMap<Long, Chunk>();
    private final Map<Vector, Entity> entities = new HashMap<Vector, Entity>();
    private final UUID uid = UUID.randomUUID();
    private final Map<String, String> gameRules = new HashMap<String, String>();
    private Location spawnLocation = new Location((World)this, 0.0, 0.0, 0.0);
    private String name = "world-" + idIndex.incrementAndGet();
    private long time = 0L;
    private long fullTime = 0L;
    private boolean pvp = true;
    private World.Environment environment = World.Environment.NORMAL;
    private ChunkGenerator generator = new TestChunkGenerator();
    private boolean storm = false;
    private boolean thundering;
    private int thunderDuration = 0;
    private int weatherDuration = 0;
    private boolean allowAnimals = true;
    private boolean allowMonsters = true;
    private Difficulty difficulty = Difficulty.EASY;

    public TestWorld(TestServer server) {
        this.server = server;
    }

    private long getKey(Chunk chunk) {
        return this.getKey(chunk.getX(), chunk.getZ());
    }

    private long getKey(int chunkX, int chunkY) {
        return (long)chunkX << 31 | (long)chunkY;
    }

    private long getChunk(int blockX, int blockZ) {
        return this.getKey(blockX >> 4, blockZ >> 4);
    }

    public Block getBlockAt(int x, int y, int z) {
        return this.chunks.get(this.getChunk(x, z)).getBlock(x, y, z);
    }

    public Block getBlockAt(Location location) {
        Conditions.isTrue((boolean)this.equals(location.getWorld()), (String)"Worlds differ", (Object[])new Object[0]);
        return this.getBlockAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public int getBlockTypeIdAt(int x, int y, int z) {
        return this.getBlockAt(x, y, z).getTypeId();
    }

    public int getBlockTypeIdAt(Location location) {
        return this.getBlockAt(location).getTypeId();
    }

    public Chunk getChunkAt(int x, int z) {
        return this.chunks.get(this.getKey(x, z));
    }

    public Chunk getChunkAt(Location location) {
        Conditions.isTrue((boolean)this.equals(location.getWorld()), (String)"Worlds differ", (Object[])new Object[0]);
        return this.getChunkAt(location.getBlockX(), location.getBlockZ());
    }

    public Chunk getChunkAt(Block block) {
        return this.getChunkAt(block.getLocation());
    }

    public boolean isChunkLoaded(Chunk chunk) {
        return this.chunks.containsKey(this.getKey(chunk.getX(), chunk.getZ()));
    }

    public Chunk[] getLoadedChunks() {
        return this.chunks.values().toArray(new Chunk[this.chunks.size()]);
    }

    public void loadChunk(Chunk chunk) {
        this.chunks.put(this.getKey(chunk), chunk);
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.getChunkAt(x, z) != null;
    }

    public boolean unloadChunk(Chunk chunk) {
        return this.chunks.remove(this.getKey(chunk)) != null;
    }

    public boolean unloadChunk(int x, int y) {
        return this.chunks.remove(this.getKey(x, y)) != null;
    }

    public boolean unloadChunk(int x, int y, boolean save) {
        return this.unloadChunk(x, y);
    }

    public boolean unloadChunk(int x, int y, boolean save, boolean safe) {
        return this.unloadChunk(x, y, save);
    }

    public boolean unloadChunkRequest(int x, int y) {
        return this.unloadChunk(x, y);
    }

    public boolean unloadChunkRequest(int x, int y, boolean safe) {
        return this.unloadChunk(x, y);
    }

    public boolean regenerateChunk(int x, int y) {
        this.unloadChunk(x, y);
        TestChunk chunk = (TestChunk)this.getInternalGenerator().create(TestChunk.class);
        chunk.setX(x);
        chunk.setZ(y);
        chunk.setWorld(this);
        this.loadChunk(chunk);
        return true;
    }

    public boolean refreshChunk(int x, int y) {
        return true;
    }

    public void removeEntity(Entity entity) {
        this.entities.remove(entity.getLocation().toVector(), entity);
    }

    public Item dropItem(Location location, ItemStack itemStack) {
        TestItem testItem = (TestItem)this.getInternalGenerator().create(TestItem.class);
        testItem.setLocation(location);
        testItem.setItemStack(itemStack);
        this.entities.put(location.toVector(), testItem);
        return testItem;
    }

    public Item dropItemNaturally(Location location, ItemStack itemStack) {
        return this.dropItem(location, itemStack);
    }

    public List<Entity> getEntities() {
        return new ArrayList<Entity>(this.entities.values());
    }

    public List<LivingEntity> getLivingEntities() {
        return new ArrayList<LivingEntity>(this.getEntitiesByClass(LivingEntity.class));
    }

    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T>[] classes) {
        return new ArrayList<T>(this.getEntities(classes));
    }

    @SafeVarargs
    private final <T extends Entity> Collection<T> getEntities(Class<T> ... classes) {
        return this.entities.values().stream().filter(entity -> {
            for (Class clazz : classes) {
                if (!clazz.isAssignableFrom(entity.getClass())) continue;
                return true;
            }
            return false;
        }).map(e -> e).collect(Collectors.toList());
    }

    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> aClass) {
        return this.getEntities(aClass);
    }

    public Collection<Entity> getEntitiesByClasses(Class<?>[] classes) {
        return this.getEntities(classes);
    }

    public List<Player> getPlayers() {
        ArrayList<Player> online = new ArrayList<Player>();
        for (Player player : this.server.getOnlinePlayers()) {
            if (!player.getWorld().equals(this)) continue;
            online.add(player);
        }
        return online;
    }

    public UUID getUID() {
        return this.uid;
    }

    public boolean setSpawnLocation(int x, int y, int z) {
        this.spawnLocation.setX((double)x);
        this.spawnLocation.setY((double)y);
        this.spawnLocation.setZ((double)z);
        return true;
    }

    public boolean hasStorm() {
        return this.storm;
    }

    public long getSeed() {
        return 0L;
    }

    public boolean getPVP() {
        return this.pvp;
    }

    public void setPVP(boolean b) {
        this.pvp = b;
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz) throws IllegalArgumentException {
        T entity = EntityFactory.make(this, clazz);
        entity.teleport(location);
        this.entities.put(entity.getLocation().toVector(), (Entity)entity);
        return entity;
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<T> consumer) throws IllegalArgumentException {
        T entity = this.spawn(location, clazz);
        consumer.accept(entity);
        return entity;
    }

    public boolean getAllowAnimals() {
        return this.allowAnimals;
    }

    public boolean getAllowMonsters() {
        return this.allowMonsters;
    }

    public int getMaxHeight() {
        return 256;
    }

    public int getSeaLevel() {
        return 63;
    }

    public WorldType getWorldType() {
        return WorldType.CUSTOMIZED;
    }

    public String[] getGameRules() {
        return this.gameRules.keySet().toArray(new String[this.gameRules.size()]);
    }

    public String getGameRuleValue(String s) {
        return this.gameRules.get(s);
    }

    public boolean setGameRuleValue(String key, String value) {
        this.gameRules.put(key, value);
        return true;
    }

    public boolean isGameRule(String key) {
        return this.gameRules.containsKey(key);
    }

    public TestServer getServer() {
        return this.server;
    }

    public Map<Long, Chunk> getChunks() {
        return this.chunks;
    }

    public Location getSpawnLocation() {
        return this.spawnLocation;
    }

    public String getName() {
        return this.name;
    }

    public long getTime() {
        return this.time;
    }

    public long getFullTime() {
        return this.fullTime;
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public ChunkGenerator getGenerator() {
        return this.generator;
    }

    public boolean isStorm() {
        return this.storm;
    }

    public boolean isThundering() {
        return this.thundering;
    }

    public int getThunderDuration() {
        return this.thunderDuration;
    }

    public int getWeatherDuration() {
        return this.weatherDuration;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setSpawnLocation(Location spawnLocation) {
        this.spawnLocation = spawnLocation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setFullTime(long fullTime) {
        this.fullTime = fullTime;
    }

    public void setEnvironment(World.Environment environment) {
        this.environment = environment;
    }

    public void setGenerator(ChunkGenerator generator) {
        this.generator = generator;
    }

    public void setStorm(boolean storm) {
        this.storm = storm;
    }

    public void setThundering(boolean thundering) {
        this.thundering = thundering;
    }

    public void setThunderDuration(int thunderDuration) {
        this.thunderDuration = thunderDuration;
    }

    public void setWeatherDuration(int weatherDuration) {
        this.weatherDuration = weatherDuration;
    }

    public void setAllowAnimals(boolean allowAnimals) {
        this.allowAnimals = allowAnimals;
    }

    public void setAllowMonsters(boolean allowMonsters) {
        this.allowMonsters = allowMonsters;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestWorld)) {
            return false;
        }
        TestWorld other = (TestWorld)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TestServer this$server = this.getServer();
        TestServer other$server = other.getServer();
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        Map<Long, Chunk> this$chunks = this.getChunks();
        Map<Long, Chunk> other$chunks = other.getChunks();
        if (this$chunks == null ? other$chunks != null : !((Object)this$chunks).equals(other$chunks)) {
            return false;
        }
        List<Entity> this$entities = this.getEntities();
        List<Entity> other$entities = other.getEntities();
        if (this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities)) {
            return false;
        }
        UUID this$uid = this.getUID();
        UUID other$uid = other.getUID();
        if (this$uid == null ? other$uid != null : !((Object)this$uid).equals(other$uid)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getGameRules(), other.getGameRules())) {
            return false;
        }
        Location this$spawnLocation = this.getSpawnLocation();
        Location other$spawnLocation = other.getSpawnLocation();
        if (this$spawnLocation == null ? other$spawnLocation != null : !this$spawnLocation.equals(other$spawnLocation)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        if (this.getFullTime() != other.getFullTime()) {
            return false;
        }
        if (this.getPVP() != other.getPVP()) {
            return false;
        }
        World.Environment this$environment = this.getEnvironment();
        World.Environment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        ChunkGenerator this$generator = this.getGenerator();
        ChunkGenerator other$generator = other.getGenerator();
        if (this$generator == null ? other$generator != null : !this$generator.equals(other$generator)) {
            return false;
        }
        if (this.isStorm() != other.isStorm()) {
            return false;
        }
        if (this.isThundering() != other.isThundering()) {
            return false;
        }
        if (this.getThunderDuration() != other.getThunderDuration()) {
            return false;
        }
        if (this.getWeatherDuration() != other.getWeatherDuration()) {
            return false;
        }
        if (this.getAllowAnimals() != other.getAllowAnimals()) {
            return false;
        }
        if (this.getAllowMonsters() != other.getAllowMonsters()) {
            return false;
        }
        Difficulty this$difficulty = this.getDifficulty();
        Difficulty other$difficulty = other.getDifficulty();
        return !(this$difficulty == null ? other$difficulty != null : !this$difficulty.equals(other$difficulty));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestWorld;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TestServer $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        Map<Long, Chunk> $chunks = this.getChunks();
        result = result * 59 + ($chunks == null ? 43 : ((Object)$chunks).hashCode());
        List<Entity> $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        UUID $uid = this.getUID();
        result = result * 59 + ($uid == null ? 43 : ((Object)$uid).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getGameRules());
        Location $spawnLocation = this.getSpawnLocation();
        result = result * 59 + ($spawnLocation == null ? 43 : $spawnLocation.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        long $fullTime = this.getFullTime();
        result = result * 59 + (int)($fullTime >>> 32 ^ $fullTime);
        result = result * 59 + (this.getPVP() ? 79 : 97);
        World.Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        ChunkGenerator $generator = this.getGenerator();
        result = result * 59 + ($generator == null ? 43 : $generator.hashCode());
        result = result * 59 + (this.isStorm() ? 79 : 97);
        result = result * 59 + (this.isThundering() ? 79 : 97);
        result = result * 59 + this.getThunderDuration();
        result = result * 59 + this.getWeatherDuration();
        result = result * 59 + (this.getAllowAnimals() ? 79 : 97);
        result = result * 59 + (this.getAllowMonsters() ? 79 : 97);
        Difficulty $difficulty = this.getDifficulty();
        result = result * 59 + ($difficulty == null ? 43 : $difficulty.hashCode());
        return result;
    }

    public String toString() {
        return "TestWorld(server=" + this.getServer() + ", chunks=" + this.getChunks() + ", entities=" + this.getEntities() + ", uid=" + this.getUID() + ", gameRules=" + Arrays.deepToString(this.getGameRules()) + ", spawnLocation=" + this.getSpawnLocation() + ", name=" + this.getName() + ", time=" + this.getTime() + ", fullTime=" + this.getFullTime() + ", pvp=" + this.getPVP() + ", environment=" + this.getEnvironment() + ", generator=" + this.getGenerator() + ", storm=" + this.isStorm() + ", thundering=" + this.isThundering() + ", thunderDuration=" + this.getThunderDuration() + ", weatherDuration=" + this.getWeatherDuration() + ", allowAnimals=" + this.getAllowAnimals() + ", allowMonsters=" + this.getAllowMonsters() + ", difficulty=" + this.getDifficulty() + ")";
    }
}

