/*
 * Decompiled with CFR 0.152.
 */
package in.kyle.api.bukkit;

import in.kyle.api.bukkit.TestOfflinePlayer;
import in.kyle.api.bukkit.TestWorld;
import in.kyle.api.bukkit.inventory.TestInventory;
import in.kyle.api.bukkit.plugin.TestPluginManager;
import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.processors.Global;
import in.kyle.api.generate.processors.copy.Copy;
import in.kyle.api.generate.processors.increment.Increment;
import in.kyle.api.utils.Try;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.scheduler.CraftScheduler;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.SimpleServicesManager;
import org.bukkit.scheduler.BukkitScheduler;

@Global
public abstract class TestServer
extends TestPluginManager
implements Server,
PluginManager,
Generated {
    private final Set<Player> onlinePlayers = new HashSet<Player>();
    private final Set<OfflinePlayer> whitelistedPlayers = new HashSet<OfflinePlayer>();
    private final Set<OfflinePlayer> bannedPlayers = new HashSet<OfflinePlayer>();
    private final Set<OfflinePlayer> operators = new HashSet<OfflinePlayer>();
    private final PluginManager pluginManager = this;
    private final CraftScheduler scheduler = null;
    private final ServicesManager servicesManager = new SimpleServicesManager();
    private final List<World> worlds = new ArrayList<World>();
    private final SimpleCommandMap commandMap = new SimpleCommandMap((Server)this);
    private final Set<String> iPBans = new HashSet<String>();
    private GameMode defaultGameMode = GameMode.SURVIVAL;
    @Increment
    private String serverId;
    private String name;
    private String serverName = this.name = "Test Server";
    private String version = "1";
    private String bukkitVersion = "1";
    private String worldType = "void";
    private String motd = "default motd";
    private String shutdownMessage = "Server shut down";
    private String ip = "localhost";
    private int port = 25565;
    private boolean schedulerStarted;

    public World createDefaultWorld() {
        this.worlds.add((World)this.getInternalGenerator().create(TestWorld.class));
        return this.getWorld();
    }

    public World getWorld() {
        if (this.worlds.size() == 0) {
            return this.createDefaultWorld();
        }
        return this.worlds.get(0);
    }

    public void startScheduler(AtomicBoolean running) {
        this.schedulerStarted = true;
        int tick = 1;
        while (running.get()) {
            this.scheduler.mainThreadHeartbeat(tick);
            if (++tick > 20) {
                tick = 1;
            }
            Try.to(() -> Thread.sleep(50L));
        }
    }

    @Copy(value=CraftServer.class)
    public abstract int broadcast(String var1, String var2);

    @Copy(value=CraftServer.class)
    public abstract int broadcastMessage(String var1);

    @Copy(value=CraftServer.class)
    public abstract boolean dispatchCommand(CommandSender var1, String var2) throws CommandException;

    public Player getPlayer(String name) {
        return this.onlinePlayers.stream().filter(player -> player.getName().equals(name)).findAny().orElse(null);
    }

    public Player getPlayerExact(String name) {
        return this.getPlayer(name);
    }

    public List<Player> matchPlayer(String name) {
        return this.onlinePlayers.stream().filter(player -> player.getName().contains(name)).collect(Collectors.toList());
    }

    public Player getPlayer(UUID id) {
        return this.onlinePlayers.stream().filter(player -> player.getUniqueId().equals(id)).findAny().orElse(null);
    }

    public BukkitScheduler getScheduler() {
        if (!this.schedulerStarted) {
            System.err.println("Warning scheduler not started, call TestServer#startScheduler");
        }
        return this.scheduler;
    }

    public World createWorld(WorldCreator creator) {
        World world = creator.createWorld();
        this.worlds.add(world);
        return world;
    }

    public boolean unloadWorld(String name, boolean save) {
        return this.unloadWorld(this.getWorld(name), save);
    }

    public boolean unloadWorld(World world, boolean save) {
        return this.worlds.remove(world);
    }

    public World getWorld(String name) {
        return this.worlds.stream().filter(world -> world.getName().equals(name)).findAny().orElse(null);
    }

    public World getWorld(UUID uid) {
        return this.worlds.stream().filter(world -> world.getUID().equals(uid)).findAny().orElse(null);
    }

    public Logger getLogger() {
        return Logger.getLogger(this.getServerName());
    }

    @Copy(value=CraftServer.class)
    public abstract PluginCommand getPluginCommand(String var1);

    public Map<String, String[]> getCommandAliases() {
        return Collections.emptyMap();
    }

    public OfflinePlayer getOfflinePlayer(String name) {
        TestOfflinePlayer op = (TestOfflinePlayer)this.getInternalGenerator().create(TestOfflinePlayer.class);
        op.setName(name);
        return op;
    }

    public OfflinePlayer getOfflinePlayer(UUID uuid) {
        TestOfflinePlayer op = (TestOfflinePlayer)this.getInternalGenerator().create(TestOfflinePlayer.class);
        op.setUniqueId(uuid);
        return op;
    }

    public void banIP(String address) {
        this.iPBans.add(address);
    }

    public void unbanIP(String address) {
        this.iPBans.remove(address);
    }

    public Inventory createInventory(InventoryHolder owner, InventoryType type) {
        return new TestInventory(type, owner);
    }

    public Inventory createInventory(InventoryHolder owner, InventoryType type, String title) {
        return new TestInventory(type, owner, title);
    }

    private InventoryType getType(int size) {
        for (InventoryType inventoryType : InventoryType.values()) {
            if (inventoryType.getDefaultSize() != size) continue;
            return inventoryType;
        }
        return null;
    }

    public Inventory createInventory(InventoryHolder owner, int size) throws IllegalArgumentException {
        return this.createInventory(owner, this.getType(size));
    }

    public Inventory createInventory(InventoryHolder owner, int size, String title) throws IllegalArgumentException {
        return this.createInventory(owner, this.getType(size), title);
    }

    public Warning.WarningState getWarningState() {
        return Warning.WarningState.DEFAULT;
    }

    public void unsubscribeFromDefaultPerms(boolean op, Permissible permissible) {
    }

    public void unsubscribeFromPermission(String permission, Permissible permissible) {
    }

    public Set<Permission> getDefaultPermissions(boolean op) {
        return Collections.emptySet();
    }

    public void subscribeToDefaultPerms(boolean op, Permissible permissible) {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestServer)) {
            return false;
        }
        TestServer other = (TestServer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Collection this$onlinePlayers = this.getOnlinePlayers();
        Collection other$onlinePlayers = other.getOnlinePlayers();
        if (this$onlinePlayers == null ? other$onlinePlayers != null : !((Object)this$onlinePlayers).equals(other$onlinePlayers)) {
            return false;
        }
        Set<OfflinePlayer> this$whitelistedPlayers = this.getWhitelistedPlayers();
        Set<OfflinePlayer> other$whitelistedPlayers = other.getWhitelistedPlayers();
        if (this$whitelistedPlayers == null ? other$whitelistedPlayers != null : !((Object)this$whitelistedPlayers).equals(other$whitelistedPlayers)) {
            return false;
        }
        Set<OfflinePlayer> this$bannedPlayers = this.getBannedPlayers();
        Set<OfflinePlayer> other$bannedPlayers = other.getBannedPlayers();
        if (this$bannedPlayers == null ? other$bannedPlayers != null : !((Object)this$bannedPlayers).equals(other$bannedPlayers)) {
            return false;
        }
        Set<OfflinePlayer> this$operators = this.getOperators();
        Set<OfflinePlayer> other$operators = other.getOperators();
        if (this$operators == null ? other$operators != null : !((Object)this$operators).equals(other$operators)) {
            return false;
        }
        PluginManager this$pluginManager = this.getPluginManager();
        PluginManager other$pluginManager = other.getPluginManager();
        if (this$pluginManager == null ? other$pluginManager != null : !this$pluginManager.equals(other$pluginManager)) {
            return false;
        }
        BukkitScheduler this$scheduler = this.getScheduler();
        BukkitScheduler other$scheduler = other.getScheduler();
        if (this$scheduler == null ? other$scheduler != null : !this$scheduler.equals(other$scheduler)) {
            return false;
        }
        ServicesManager this$servicesManager = this.getServicesManager();
        ServicesManager other$servicesManager = other.getServicesManager();
        if (this$servicesManager == null ? other$servicesManager != null : !this$servicesManager.equals(other$servicesManager)) {
            return false;
        }
        List<World> this$worlds = this.getWorlds();
        List<World> other$worlds = other.getWorlds();
        if (this$worlds == null ? other$worlds != null : !((Object)this$worlds).equals(other$worlds)) {
            return false;
        }
        SimpleCommandMap this$commandMap = this.getCommandMap();
        SimpleCommandMap other$commandMap = other.getCommandMap();
        if (this$commandMap == null ? other$commandMap != null : !this$commandMap.equals(other$commandMap)) {
            return false;
        }
        Set<String> this$iPBans = this.getIPBans();
        Set<String> other$iPBans = other.getIPBans();
        if (this$iPBans == null ? other$iPBans != null : !((Object)this$iPBans).equals(other$iPBans)) {
            return false;
        }
        GameMode this$defaultGameMode = this.getDefaultGameMode();
        GameMode other$defaultGameMode = other.getDefaultGameMode();
        if (this$defaultGameMode == null ? other$defaultGameMode != null : !this$defaultGameMode.equals(other$defaultGameMode)) {
            return false;
        }
        String this$serverId = this.getServerId();
        String other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$serverName = this.getServerName();
        String other$serverName = other.getServerName();
        if (this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$bukkitVersion = this.getBukkitVersion();
        String other$bukkitVersion = other.getBukkitVersion();
        if (this$bukkitVersion == null ? other$bukkitVersion != null : !this$bukkitVersion.equals(other$bukkitVersion)) {
            return false;
        }
        String this$worldType = this.getWorldType();
        String other$worldType = other.getWorldType();
        if (this$worldType == null ? other$worldType != null : !this$worldType.equals(other$worldType)) {
            return false;
        }
        String this$motd = this.getMotd();
        String other$motd = other.getMotd();
        if (this$motd == null ? other$motd != null : !this$motd.equals(other$motd)) {
            return false;
        }
        String this$shutdownMessage = this.getShutdownMessage();
        String other$shutdownMessage = other.getShutdownMessage();
        if (this$shutdownMessage == null ? other$shutdownMessage != null : !this$shutdownMessage.equals(other$shutdownMessage)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        return this.isSchedulerStarted() == other.isSchedulerStarted();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestServer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Collection $onlinePlayers = this.getOnlinePlayers();
        result = result * 59 + ($onlinePlayers == null ? 43 : ((Object)$onlinePlayers).hashCode());
        Set<OfflinePlayer> $whitelistedPlayers = this.getWhitelistedPlayers();
        result = result * 59 + ($whitelistedPlayers == null ? 43 : ((Object)$whitelistedPlayers).hashCode());
        Set<OfflinePlayer> $bannedPlayers = this.getBannedPlayers();
        result = result * 59 + ($bannedPlayers == null ? 43 : ((Object)$bannedPlayers).hashCode());
        Set<OfflinePlayer> $operators = this.getOperators();
        result = result * 59 + ($operators == null ? 43 : ((Object)$operators).hashCode());
        PluginManager $pluginManager = this.getPluginManager();
        result = result * 59 + ($pluginManager == null ? 43 : $pluginManager.hashCode());
        BukkitScheduler $scheduler = this.getScheduler();
        result = result * 59 + ($scheduler == null ? 43 : $scheduler.hashCode());
        ServicesManager $servicesManager = this.getServicesManager();
        result = result * 59 + ($servicesManager == null ? 43 : $servicesManager.hashCode());
        List<World> $worlds = this.getWorlds();
        result = result * 59 + ($worlds == null ? 43 : ((Object)$worlds).hashCode());
        SimpleCommandMap $commandMap = this.getCommandMap();
        result = result * 59 + ($commandMap == null ? 43 : $commandMap.hashCode());
        Set<String> $iPBans = this.getIPBans();
        result = result * 59 + ($iPBans == null ? 43 : ((Object)$iPBans).hashCode());
        GameMode $defaultGameMode = this.getDefaultGameMode();
        result = result * 59 + ($defaultGameMode == null ? 43 : $defaultGameMode.hashCode());
        String $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 43 : $serverId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $serverName = this.getServerName();
        result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $bukkitVersion = this.getBukkitVersion();
        result = result * 59 + ($bukkitVersion == null ? 43 : $bukkitVersion.hashCode());
        String $worldType = this.getWorldType();
        result = result * 59 + ($worldType == null ? 43 : $worldType.hashCode());
        String $motd = this.getMotd();
        result = result * 59 + ($motd == null ? 43 : $motd.hashCode());
        String $shutdownMessage = this.getShutdownMessage();
        result = result * 59 + ($shutdownMessage == null ? 43 : $shutdownMessage.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isSchedulerStarted() ? 79 : 97);
        return result;
    }

    public Set<Player> getOnlinePlayers() {
        return this.onlinePlayers;
    }

    public Set<OfflinePlayer> getWhitelistedPlayers() {
        return this.whitelistedPlayers;
    }

    public Set<OfflinePlayer> getBannedPlayers() {
        return this.bannedPlayers;
    }

    public Set<OfflinePlayer> getOperators() {
        return this.operators;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    public List<World> getWorlds() {
        return this.worlds;
    }

    public SimpleCommandMap getCommandMap() {
        return this.commandMap;
    }

    public Set<String> getIPBans() {
        return this.iPBans;
    }

    public GameMode getDefaultGameMode() {
        return this.defaultGameMode;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getName() {
        return this.name;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBukkitVersion() {
        return this.bukkitVersion;
    }

    public String getWorldType() {
        return this.worldType;
    }

    public String getMotd() {
        return this.motd;
    }

    public String getShutdownMessage() {
        return this.shutdownMessage;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSchedulerStarted() {
        return this.schedulerStarted;
    }

    public void setDefaultGameMode(GameMode defaultGameMode) {
        this.defaultGameMode = defaultGameMode;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setBukkitVersion(String bukkitVersion) {
        this.bukkitVersion = bukkitVersion;
    }

    public void setWorldType(String worldType) {
        this.worldType = worldType;
    }

    public void setMotd(String motd) {
        this.motd = motd;
    }

    public void setShutdownMessage(String shutdownMessage) {
        this.shutdownMessage = shutdownMessage;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSchedulerStarted(boolean schedulerStarted) {
        this.schedulerStarted = schedulerStarted;
    }

    @Override
    public String toString() {
        return "TestServer(onlinePlayers=" + this.getOnlinePlayers() + ", whitelistedPlayers=" + this.getWhitelistedPlayers() + ", bannedPlayers=" + this.getBannedPlayers() + ", operators=" + this.getOperators() + ", pluginManager=" + this.getPluginManager() + ", scheduler=" + this.getScheduler() + ", servicesManager=" + this.getServicesManager() + ", worlds=" + this.getWorlds() + ", commandMap=" + this.getCommandMap() + ", iPBans=" + this.getIPBans() + ", defaultGameMode=" + this.getDefaultGameMode() + ", serverId=" + this.getServerId() + ", name=" + this.getName() + ", serverName=" + this.getServerName() + ", version=" + this.getVersion() + ", bukkitVersion=" + this.getBukkitVersion() + ", worldType=" + this.getWorldType() + ", motd=" + this.getMotd() + ", shutdownMessage=" + this.getShutdownMessage() + ", ip=" + this.getIp() + ", port=" + this.getPort() + ", schedulerStarted=" + this.isSchedulerStarted() + ")";
    }

    public TestServer() {
        Bukkit.setServer((Server)this);
    }
}

