package in.kyle.api.bukkit.util;

import java.util.ArrayList;

import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
public class BoundedArrayList<T> extends ArrayList<T> {
    
    private final int bound;
    
    @Override
    public boolean add(T t) {
        if (size() + 1 < bound) {
            return super.add(t);
        } else {
            throw new IndexOutOfBoundsException("List is full");
        }
    }
}
