package in.kyle.api.bukkit.plugin;

import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

import java.io.InputStream;
import java.util.logging.Logger;

import in.kyle.api.bukkit.TestServer;
import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.processors.increment.Increment;
import lombok.Data;
import lombok.extern.java.Log;

@Data
@Log
public abstract class TestPlugin implements Plugin, Generated {

    private final TestServer server;
    
    private FileConfiguration config = new YamlConfiguration();
    
    @Increment
    private String name;
    
    private boolean enabled = true;
    
    @Override
    public InputStream getResource(String filename) {
        return getClass().getResourceAsStream(filename);
    }
    
    @Override
    public Logger getLogger() {
        return Logger.getLogger(name);
    }
}
