package in.kyle.api.bukkit.inventory;

import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

import in.kyle.api.generate.NotImplementedException;
import lombok.Data;
import lombok.experimental.Delegate;

@Data
public class TestPlayerInventory implements PlayerInventory {
    
    interface Holder {
        InventoryHolder getHolder();
    }
    
    @Delegate(excludes = Holder.class)
    private final CommonInventory inventory;
    private final HumanEntity holder;
    
    private ItemStack[] armorContents;
    private ItemStack[] extraContents;
    
    private ItemStack helmet;
    private ItemStack chestplate;
    private ItemStack leggings;
    private ItemStack boots;
    
    private ItemStack itemInHand;
    private ItemStack itemInMainHand;
    private ItemStack itemInOffHand;
    
    private int heldItemSlot;
    
    public TestPlayerInventory(HumanEntity holder, String title) {
        this.holder = holder;
        this.inventory = new CommonInventory(InventoryType.PLAYER, holder, title);
    }
    
    public TestPlayerInventory(HumanEntity holder) {
        this(holder, InventoryType.PLAYER.getDefaultTitle());
    }
    
    @Override
    public int clear(int id, int data) {
        throw new NotImplementedException("Method not implemented");
    }
    
    @Override
    public HumanEntity getHolder() {
        return holder;
    }
}
