package in.kyle.api.bukkit.entity;

import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

import java.util.List;
import java.util.Map;

import in.kyle.api.bukkit.TestOfflinePlayer;
import in.kyle.api.bukkit.TestServer;
import in.kyle.api.generate.api.Generated;
import in.kyle.api.generate.processors.copy.Copy;
import in.kyle.api.generate.processors.create.Create;
import in.kyle.api.generate.processors.setup.Setup;
import io.reactivex.subjects.PublishSubject;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Delegate;

@EqualsAndHashCode(callSuper = true)
@Data
public abstract class TestPlayer extends TestLivingEntity implements Player {
    
    private final PublishSubject<String> kick = PublishSubject.create();
    
    private boolean op;
    
    private interface Exclude extends Generated {
        boolean isBanned();
        
        void setWhitelisted(boolean value);
        
        boolean isWhitelisted();
        
        Map<String, Object> serialize();
        
        boolean isOnline();
        
        boolean isOp();
        
        boolean setOp(boolean v);
    }
    
    @Delegate(excludes = Exclude.class)
    @Create
    private TestOfflinePlayer offlinePlayer;
    
    public TestPlayer(TestServer server) {
        super(server);
    }
    
    @Setup
    public void setup() {
        offlinePlayer.setName(super.getName());
        offlinePlayer.setOp(offlinePlayer.isOp());
    }
    
    @Override
    public void sendRawMessage(String message) {
        sendMessage(message);
    }
    
    @Override
    public void chat(String msg) {
        sendRawMessage(msg);
    }
    
    @Override
    public EntityType getType() {
        return EntityType.PLAYER;
    }
    
    @Override
    @Copy(CraftPlayer.class)
    public abstract boolean performCommand(String command);
    
    @Override
    @Copy(CraftPlayer.class)
    public abstract void resetPlayerTime();
    
    @Override
    @Copy(CraftPlayer.class)
    public abstract boolean isBanned();
    
    @Override
    @Copy(CraftPlayer.class)
    public abstract void setWhitelisted(boolean value);
    
    @Override
    @Copy(CraftPlayer.class)
    public abstract boolean isWhitelisted();
    
    @Override
    @Copy(CraftPlayer.class)
    public abstract Map<String, Object> serialize();
    
    @Override
    @Copy(CraftPlayer.class)
    public abstract void setMetadata(String metadataKey, MetadataValue newMetadataValue);
    
    @Override
    @Copy(CraftPlayer.class)
    public abstract List<MetadataValue> getMetadata(String metadataKey);
    
    @Override
    @Copy(CraftPlayer.class)
    public abstract boolean hasMetadata(String metadataKey);
    
    @Override
    @Copy(CraftPlayer.class)
    public abstract void removeMetadata(String metadataKey, Plugin owningPlugin);
    
    @Override
    @Copy(CraftPlayer.class)
    public abstract boolean isOnline();
}
