package in.kyle.api.bukkit.entity;

import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.PlayerInventory;

import in.kyle.api.bukkit.TestServer;
import in.kyle.api.bukkit.inventory.TestPlayerInventory;
import in.kyle.api.generate.processors.increment.Increment;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
public abstract class TestHumanEntity extends TestEntity
        implements HumanEntity {
    
    @Increment
    private String name;
    
    private MainHand mainHand = MainHand.RIGHT;
    
    private PlayerInventory inventory;
    private Inventory enderChest;
    
    public TestHumanEntity(TestServer server) {
        super(server);
        inventory = new TestPlayerInventory(this);
        enderChest = server.createInventory(this, InventoryType.ENDER_CHEST);
    }
    
    @Override
    public ItemStack getItemInHand() {
        return inventory.getItemInHand();
    }
    
    @Override
    public void setItemInHand(ItemStack item) {
        inventory.setItemInHand(item);
    }
}
