package in.kyle.api.bukkit;

import org.bukkit.command.CommandSender;

import io.reactivex.subjects.PublishSubject;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
public abstract class TestCommandSender extends TestPermissible implements CommandSender {
    
    private final PublishSubject<String> messages = PublishSubject.create();
    
    @Override
    public void sendMessage(String message) {
        messages.onNext(message);
    }
    
    @Override
    public void sendMessage(String[] messages) {
        for (String message : messages) {
            sendMessage(message);
        }
    }
}
