package in.kyle.api.bukkit;

import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import in.kyle.api.bukkit.block.TestBlock;
import in.kyle.api.generate.api.Generated;
import lombok.Data;

@Data
public abstract class TestChunk implements Chunk, Generated {
    
    private final Map<Vector, Block> blocks = new HashMap<>();
    private final Set<Entity> entities = new HashSet<>();
    
    private int x;
    private int z;
    private World world;
    
    public Block getBlock(int x, int y, int z) {
        Vector key = new Vector(x, y, z);
        if (blocks.containsKey(key)) {
            return blocks.get(key);
        } else {
            TestBlock block = getInternalGenerator().create(TestBlock.class);
            block.setX(x);
            block.setY(y);
            block.setZ(z);
            block.setChunk(this);
            return block;
        }
    }
    
    public Entity[] getEntities() {
        return entities.toArray(new Entity[entities.size()]);
    }
    
    public boolean isLoaded() {
        return true;
    }
}
