/*
 * Decompiled with CFR 0.152.
 */
package kweb.shoebox.stores;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.protobuf.ProtoBuf;
import kweb.shoebox.KeyValue;
import kweb.shoebox.Store;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;

@ExperimentalSerializationApi
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0011\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010!\u001a\u0004\u0018\u00018\u00002\u0006\u0010\"\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010#J\u0017\u0010$\u001a\u0004\u0018\u00018\u00002\u0006\u0010\"\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010#J \u0010%\u001a\u0004\u0018\u00018\u00002\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010&\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010'R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R-\u0010\u0014\u001a\u001e\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00170\u00170\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Lkweb/shoebox/stores/MapDBStore;", "T", "", "Lkweb/shoebox/Store;", "db", "Lorg/mapdb/DB;", "name", "", "serializer", "Lkotlinx/serialization/KSerializer;", "maxSizeBytes", "", "(Lorg/mapdb/DB;Ljava/lang/String;Lkotlinx/serialization/KSerializer;Ljava/lang/Long;)V", "getDb", "()Lorg/mapdb/DB;", "entries", "", "Lkweb/shoebox/KeyValue;", "getEntries", "()Ljava/lang/Iterable;", "map", "Lorg/mapdb/HTreeMap;", "kotlin.jvm.PlatformType", "", "getMap", "()Lorg/mapdb/HTreeMap;", "getMaxSizeBytes", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getName", "()Ljava/lang/String;", "getSerializer", "()Lkotlinx/serialization/KSerializer;", "get", "key", "(Ljava/lang/String;)Ljava/lang/Object;", "remove", "set", "value", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "shoebox"})
public final class MapDBStore<T>
implements Store<T> {
    @NotNull
    private final DB db;
    @NotNull
    private final String name;
    @NotNull
    private final KSerializer<T> serializer;
    @Nullable
    private final Long maxSizeBytes;
    @NotNull
    private final HTreeMap<String, byte[]> map;

    public MapDBStore(@NotNull DB db, @NotNull String name, @NotNull KSerializer<T> serializer2, @Nullable Long maxSizeBytes) {
        HTreeMap hTreeMap;
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        this.db = db;
        this.name = name;
        this.serializer = serializer2;
        this.maxSizeBytes = maxSizeBytes;
        if (this.maxSizeBytes == null) {
            DB.HashMapMaker hashMapMaker = this.db.hashMap(this.name);
            GroupSerializer groupSerializer = Serializer.STRING;
            Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"STRING");
            DB.HashMapMaker hashMapMaker2 = hashMapMaker.keySerializer((Serializer)groupSerializer);
            groupSerializer = Serializer.BYTE_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"BYTE_ARRAY");
            hTreeMap = hashMapMaker2.valueSerializer((Serializer)groupSerializer).createOrOpen();
        } else {
            DB.HashMapMaker hashMapMaker = this.db.hashMap(this.name).expireStoreSize(this.maxSizeBytes.longValue()).expireAfterGet();
            GroupSerializer groupSerializer = Serializer.STRING;
            Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"STRING");
            DB.HashMapMaker hashMapMaker3 = hashMapMaker.keySerializer((Serializer)groupSerializer);
            groupSerializer = Serializer.BYTE_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"BYTE_ARRAY");
            hTreeMap = hashMapMaker3.valueSerializer((Serializer)groupSerializer).createOrOpen();
        }
        this.map = hTreeMap;
    }

    public /* synthetic */ MapDBStore(DB dB, String string, KSerializer kSerializer, Long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l = null;
        }
        this(dB, string, kSerializer, l);
    }

    @NotNull
    public final DB getDb() {
        return this.db;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final KSerializer<T> getSerializer() {
        return this.serializer;
    }

    @Nullable
    public final Long getMaxSizeBytes() {
        return this.maxSizeBytes;
    }

    @NotNull
    public final HTreeMap<String, byte[]> getMap() {
        return this.map;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<KeyValue<T>> getEntries() {
        void $this$mapTo$iv$iv;
        Map $this$map$iv = (Map)this.map;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void $dstr$k$v;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var12_12 = $dstr$k$v;
            boolean bl3 = false;
            String k = (String)var12_12.getKey();
            void var13_13 = $dstr$k$v;
            boolean bl4 = false;
            byte[] v = (byte[])var13_13.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)k, (String)"k");
            DeserializationStrategy deserializationStrategy = (DeserializationStrategy)this.getSerializer();
            Intrinsics.checkNotNullExpressionValue((Object)v, (String)"v");
            KeyValue<Object> keyValue = new KeyValue<Object>(k, ProtoBuf.Default.decodeFromByteArray(deserializationStrategy, v));
            collection.add(keyValue);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public T remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] v = (byte[])this.map.remove((Object)key);
        return (T)(v == null ? null : ProtoBuf.Default.decodeFromByteArray((DeserializationStrategy)this.serializer, v));
    }

    @Override
    @Nullable
    public T get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] v = (byte[])this.map.get((Object)key);
        return (T)(v == null ? null : ProtoBuf.Default.decodeFromByteArray((DeserializationStrategy)this.serializer, v));
    }

    @Override
    @Nullable
    public T set(@NotNull String key, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        byte[] v = (byte[])this.map.get((Object)key);
        Map map = (Map)this.map;
        byte[] byArray = ProtoBuf.Default.encodeToByteArray((SerializationStrategy)this.serializer, value);
        boolean bl = false;
        map.put(key, byArray);
        return (T)(v == null ? null : ProtoBuf.Default.decodeFromByteArray((DeserializationStrategy)this.serializer, v));
    }
}

