/*
 * Decompiled with CFR 0.152.
 */
package kweb.shoebox.stores;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.protobuf.ProtoBuf;
import kweb.shoebox.KeyValue;
import kweb.shoebox.Store;
import kweb.shoebox.UtilsKt;
import kweb.shoebox.stores.DirectoryStoreKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u0000 %*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002$%B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0004J\u0018\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0017\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u001cJ \u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010 \u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u000bR&\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0017*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lkweb/shoebox/stores/DirectoryStore;", "T", "", "Lkweb/shoebox/Store;", "directory", "Ljava/nio/file/Path;", "kSerializer", "Lkotlinx/serialization/KSerializer;", "(Ljava/nio/file/Path;Lkotlinx/serialization/KSerializer;)V", "cache", "Lcom/google/common/cache/LoadingCache;", "", "Lkweb/shoebox/stores/DirectoryStore$CachedValueWithTime;", "getCache$shoebox", "()Lcom/google/common/cache/LoadingCache;", "getDirectory", "()Ljava/nio/file/Path;", "entries", "", "Lkweb/shoebox/KeyValue;", "getEntries", "()Ljava/lang/Iterable;", "lockFilePath", "kotlin.jvm.PlatformType", "finalize", "", "get", "key", "(Ljava/lang/String;)Ljava/lang/Object;", "load", "remove", "set", "value", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "toPath", "unsanitizedKey", "CachedValueWithTime", "Companion", "shoebox"})
public final class DirectoryStore<T>
implements Store<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path directory;
    @NotNull
    private final KSerializer<T> kSerializer;
    @NotNull
    private final LoadingCache<String, CachedValueWithTime<T>> cache;
    private final Path lockFilePath;
    @NotNull
    private static final String LOCK_FILENAME = "shoebox.lock";
    private static final Duration LOCK_TOUCH_TIME = Duration.ofMillis(100L);
    private static final Duration LOCK_STALE_TIME = LOCK_TOUCH_TIME.multipliedBy(20L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectoryStore(@NotNull Path directory, @NotNull KSerializer<T> kSerializer) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter(kSerializer, (String)"kSerializer");
        this.directory = directory;
        this.kSerializer = kSerializer;
        Object object = CacheBuilder.newBuilder().build(new CacheLoader<String, CachedValueWithTime<T>>(this){
            final /* synthetic */ DirectoryStore<T> this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public CachedValueWithTime<T> load(@NotNull String key) {
                CachedValueWithTime cachedValueWithTime;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Path filePath = this.this$0.toPath(key);
                if (Files.exists(filePath, new LinkOption[0])) {
                    Object object;
                    if (Files.isDirectory(filePath, new LinkOption[0])) {
                        throw new IllegalStateException("File " + filePath + " is a directory, not a file");
                    }
                    Object object2 = filePath;
                    Object object3 = new OpenOption[]{};
                    boolean bl = false;
                    InputStream inputStream = Files.newInputStream((Path)object2, Arrays.copyOf(object3, ((OpenOption[])object3).length));
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"Files.newInputStream(this, *options)");
                    object2 = inputStream;
                    object3 = this.this$0;
                    bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)object2;
                        boolean bl3 = false;
                        object = ProtoBuf.Default.decodeFromByteArray((DeserializationStrategy)DirectoryStore.access$getKSerializer$p((DirectoryStore)object3), ByteStreamsKt.readBytes((InputStream)it));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                    }
                    Object o = object;
                    object2 = Files.getLastModifiedTime(filePath, new LinkOption[0]).toInstant();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getLastModifiedTime(filePath).toInstant()");
                    CachedValueWithTime<Object> cachedValueWithTime2 = new CachedValueWithTime<Object>(o, (Instant)object2);
                    cachedValueWithTime = cachedValueWithTime2;
                } else {
                    cachedValueWithTime = null;
                }
                return cachedValueWithTime;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newBuilder().build(\n            object : CacheLoader<String, CachedValueWithTime<T>>() {\n                override fun load(key: String): CachedValueWithTime<T>? {\n                    val filePath = this@DirectoryStore.toPath(key)\n                    return if (Files.exists(filePath)) {\n                        if (Files.isDirectory(filePath)) {\n                            throw IllegalStateException(\"File $filePath is a directory, not a file\")\n                        }\n                        val o = filePath.inputStream().use {\n                            ProtoBuf.decodeFromByteArray(kSerializer, it.readBytes())\n                        }\n                        CachedValueWithTime(o, Files.getLastModifiedTime(filePath).toInstant())\n                    } else {\n                        null\n                    }\n                }\n            }\n    )");
        this.cache = object;
        this.lockFilePath = this.directory.resolve(LOCK_FILENAME);
        Files.createDirectories(this.directory, new FileAttribute[0]);
        if (Files.exists(this.lockFilePath, new LinkOption[0])) {
            Duration durationSinceLock = Duration.between(Files.getLastModifiedTime(this.lockFilePath, new LinkOption[0]).toInstant(), Instant.now());
            if (durationSinceLock.compareTo(LOCK_STALE_TIME) < 0) {
                throw new RuntimeException(this.directory + " locked by " + this.lockFilePath + ", created " + (System.currentTimeMillis() - Files.getLastModifiedTime(this.lockFilePath, new LinkOption[0]).toMillis()) + "ms ago.");
            }
            Files.setLastModifiedTime(this.lockFilePath, FileTime.fromMillis(System.currentTimeMillis()));
        } else {
            object = Files.newBufferedWriter(this.lockFilePath, new OpenOption[0]);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BufferedWriter it = (BufferedWriter)object;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Appendable appendable = it;
                CharSequence charSequence = "locked";
                boolean bl4 = false;
                Appendable appendable2 = appendable.append(charSequence);
                Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(value)");
                Appendable appendable3 = StringsKt.appendln((Appendable)appendable2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        UtilsKt.getScheduledExecutor().scheduleWithFixedDelay(() -> DirectoryStore._init_$lambda-1(this), LOCK_TOUCH_TIME.toMillis(), LOCK_TOUCH_TIME.toMillis(), TimeUnit.MILLISECONDS);
    }

    @NotNull
    public final Path getDirectory() {
        return this.directory;
    }

    @NotNull
    public final LoadingCache<String, CachedValueWithTime<T>> getCache$shoebox() {
        return this.cache;
    }

    @Override
    @NotNull
    public Iterable<KeyValue<T>> getEntries() {
        String it;
        Iterable $this$filterTo$iv$iv;
        Object it2;
        boolean bl;
        Object element$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.directory);
        Intrinsics.checkNotNullExpressionValue(directoryStream, (String)"newDirectoryStream(directory)");
        Iterable $this$mapNotNull$iv = directoryStream;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Object $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl = false;
            it2 = (Path)element$iv$iv;
            boolean bl2 = false;
            if (((Object)it2.getFileName()).toString() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv2;
            boolean bl6 = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)LOCK_FILENAME))) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv3;
            boolean bl7 = false;
            element$iv$iv = it;
            bl = false;
            boolean bl8 = !StringsKt.isBlank(element$iv$iv);
            if (!bl8) continue;
            destination$iv$iv.add(element$iv$iv3);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            KeyValue<String> keyValue;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl = false;
            it2 = (String)element$iv$iv;
            boolean bl9 = false;
            T v = this.get((String)it2);
            if (v != null) {
                String string = URLDecoder.decode((String)it2, "UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(it, \"UTF-8\")");
                String string2 = string;
                string = this.get((String)it2);
                Intrinsics.checkNotNull((Object)string);
                keyValue = new KeyValue<String>(string2, string);
            } else {
                keyValue = null;
            }
            if (keyValue == null) continue;
            KeyValue<String> keyValue2 = keyValue;
            boolean bl10 = false;
            boolean bl11 = false;
            KeyValue<String> it$iv$iv = keyValue2;
            boolean bl12 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public T get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CharSequence charSequence = key;
        boolean bl = false;
        boolean bl2 = !StringsKt.isBlank((CharSequence)charSequence);
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "key(\"" + key + "\") must not be blank";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        CachedValueWithTime<T> cachedValueWithTime = this.load(key);
        return cachedValueWithTime == null ? null : (T)cachedValueWithTime.getValue();
    }

    @Override
    @Nullable
    public T remove(@NotNull String key) {
        Path filePath;
        Object cachedValue;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CharSequence charSequence = key;
        boolean bl = false;
        boolean bl2 = !StringsKt.isBlank((CharSequence)charSequence);
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "key(\"" + key + "\") must not be blank";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        CachedValueWithTime cachedValueWithTime = (CachedValueWithTime)this.cache.getIfPresent((Object)key);
        Object v0 = cachedValue = cachedValueWithTime == null ? null : cachedValueWithTime.getValue();
        if (cachedValue != null) {
            this.cache.invalidate((Object)key);
        }
        if (Files.exists(filePath = this.toPath(key), new LinkOption[0])) {
            Object v2;
            Object oldValue;
            CachedValueWithTime<T> cachedValueWithTime2;
            Object var5_11 = cachedValue;
            Object v1 = var5_11 == null ? ((cachedValueWithTime2 = this.load(key)) == null ? null : cachedValueWithTime2.getValue()) : (oldValue = var5_11);
            if (oldValue != null) {
                Files.delete(filePath);
                v2 = oldValue;
            } else {
                v2 = null;
            }
            return v2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T set(@NotNull String key, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        CharSequence charSequence = key;
        boolean bl = false;
        boolean bl2 = !StringsKt.isBlank((CharSequence)charSequence);
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "key(\"" + key + "\") must not be blank";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        T previousValue = this.get(key);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.cache.put((Object)key, new CachedValueWithTime<T>(value, instant));
        if (!Intrinsics.areEqual(value, previousValue)) {
            if (!UtilsKt.exists(this.directory)) {
                throw new RuntimeException("Parent directory doesn't exist");
            }
            Path filePath = this.toPath(key);
            Object object = filePath;
            OpenOption[] openOptionArray = new OpenOption[]{};
            boolean bl5 = false;
            OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"Files.newOutputStream(this, *options)");
            object = outputStream;
            boolean bl6 = false;
            bl5 = false;
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)object;
                boolean bl7 = false;
                it.write(ProtoBuf.Default.encodeToByteArray((SerializationStrategy)this.kSerializer, value));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        return previousValue;
    }

    private final CachedValueWithTime<T> load(String key) {
        CachedValueWithTime cachedValueWithTime;
        CachedValueWithTime cachedValueWithTime2;
        Path filePath = this.toPath(key);
        try {
            cachedValueWithTime2 = (CachedValueWithTime)this.cache.get((Object)key);
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            cachedValueWithTime2 = null;
        }
        CachedValueWithTime cached = cachedValueWithTime2;
        if (cached != null) {
            boolean cacheIsOutOfDate;
            boolean bl = cacheIsOutOfDate = !cached.getTime().isAfter(Files.getLastModifiedTime(filePath, new LinkOption[0]).toInstant());
            if (cacheIsOutOfDate) {
                this.cache.invalidate((Object)key);
                cachedValueWithTime = (CachedValueWithTime)this.cache.get((Object)key);
            } else {
                cachedValueWithTime = cached;
            }
        } else {
            cachedValueWithTime = null;
        }
        return cachedValueWithTime;
    }

    @NotNull
    public final Path toPath(@NotNull String unsanitizedKey) {
        Intrinsics.checkNotNullParameter((Object)unsanitizedKey, (String)"unsanitizedKey");
        CharSequence charSequence = unsanitizedKey;
        boolean bl = false;
        boolean bl2 = !StringsKt.isBlank((CharSequence)charSequence);
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "key(\"" + unsanitizedKey + "\") must not be blank";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String key = DirectoryStoreKt.escapeStringAsFilename(unsanitizedKey);
        Path filePath = this.directory.resolve(key);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"filePath");
        return filePath;
    }

    protected final void finalize() {
        Files.delete(this.lockFilePath);
    }

    private static final void _init_$lambda-1(DirectoryStore this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Files.setLastModifiedTime(this$0.lockFilePath, FileTime.fromMillis(System.currentTimeMillis()));
    }

    public static final /* synthetic */ KSerializer access$getKSerializer$p(DirectoryStore $this) {
        return $this.kSerializer;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkweb/shoebox/stores/DirectoryStore$Companion;", "", "()V", "LOCK_FILENAME", "", "LOCK_STALE_TIME", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "LOCK_TOUCH_TIME", "shoebox"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lkweb/shoebox/stores/DirectoryStore$CachedValueWithTime;", "T", "", "value", "time", "Ljava/time/Instant;", "(Ljava/lang/Object;Ljava/time/Instant;)V", "getTime", "()Ljava/time/Instant;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/time/Instant;)Lkweb/shoebox/stores/DirectoryStore$CachedValueWithTime;", "equals", "", "other", "hashCode", "", "toString", "", "shoebox"})
    public static final class CachedValueWithTime<T> {
        @NotNull
        private final T value;
        @NotNull
        private final Instant time;

        public CachedValueWithTime(@NotNull T value, @NotNull Instant time) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            this.value = value;
            this.time = time;
        }

        @NotNull
        public final T getValue() {
            return this.value;
        }

        @NotNull
        public final Instant getTime() {
            return this.time;
        }

        @NotNull
        public final T component1() {
            return this.value;
        }

        @NotNull
        public final Instant component2() {
            return this.time;
        }

        @NotNull
        public final CachedValueWithTime<T> copy(@NotNull T value, @NotNull Instant time) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            return new CachedValueWithTime<T>(value, time);
        }

        public static /* synthetic */ CachedValueWithTime copy$default(CachedValueWithTime cachedValueWithTime, Object object, Instant instant, int n, Object object2) {
            if ((n & 1) != 0) {
                object = cachedValueWithTime.value;
            }
            if ((n & 2) != 0) {
                instant = cachedValueWithTime.time;
            }
            return cachedValueWithTime.copy(object, instant);
        }

        @NotNull
        public String toString() {
            return "CachedValueWithTime(value=" + this.value + ", time=" + this.time + ')';
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = result * 31 + this.time.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CachedValueWithTime)) {
                return false;
            }
            CachedValueWithTime cachedValueWithTime = (CachedValueWithTime)other;
            if (!Intrinsics.areEqual(this.value, cachedValueWithTime.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.time, (Object)cachedValueWithTime.time);
        }
    }
}

