/*
 * Decompiled with CFR 0.152.
 */
package kweb.shoebox;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kweb.shoebox.BinarySearchResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a1\u0010\u0011\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u00132\u0006\u0010\u0014\u001a\u0002H\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016\u00a2\u0006\u0002\u0010\u0017\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u001a\u001a\n\u0010\u001b\u001a\u00020\u001a*\u00020\u001a\u001a\u0012\u0010\u001c\u001a\n \n*\u0004\u0018\u00010\u001d0\u001d*\u00020\u001a\u001a+\u0010\u001e\u001a\n \n*\u0004\u0018\u00010\u001f0\u001f*\u00020\u001a2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!\"\u00020\"\u00a2\u0006\u0002\u0010#\u001a\u001c\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u00120%\"\u0004\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u0013\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0019\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"listenerHandleSource", "Ljava/util/concurrent/atomic/AtomicLong;", "getListenerHandleSource", "()Ljava/util/concurrent/atomic/AtomicLong;", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "scheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getScheduledExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "toBinarySearchResult", "Lkweb/shoebox/BinarySearchResult;", "result", "", "betterBinarySearch", "T", "", "v", "comparator", "Ljava/util/Comparator;", "(Ljava/util/List;Ljava/lang/Object;Ljava/util/Comparator;)Lkweb/shoebox/BinarySearchResult;", "exists", "", "Ljava/nio/file/Path;", "mkdirIfAbsent", "newBufferedReader", "Ljava/io/BufferedReader;", "newBufferedWriter", "Ljava/io/BufferedWriter;", "openOptions", "", "Ljava/nio/file/OpenOption;", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/BufferedWriter;", "toArrayList", "Ljava/util/ArrayList;", "shoebox"})
public final class UtilsKt {
    private static final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1);
    @NotNull
    private static final Random random = new Random();
    @NotNull
    private static final AtomicLong listenerHandleSource = new AtomicLong(0L);

    public static final ScheduledExecutorService getScheduledExecutor() {
        return scheduledExecutor;
    }

    public static final BufferedReader newBufferedReader(@NotNull Path $this$newBufferedReader) {
        Intrinsics.checkNotNullParameter((Object)$this$newBufferedReader, (String)"<this>");
        return Files.newBufferedReader($this$newBufferedReader);
    }

    public static final BufferedWriter newBufferedWriter(@NotNull Path $this$newBufferedWriter, OpenOption ... openOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$newBufferedWriter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)openOptions, (String)"openOptions");
        return Files.newBufferedWriter($this$newBufferedWriter, Arrays.copyOf(openOptions, openOptions.length));
    }

    public static final boolean exists(@NotNull Path $this$exists) {
        Intrinsics.checkNotNullParameter((Object)$this$exists, (String)"<this>");
        return Files.exists($this$exists, new LinkOption[0]);
    }

    @NotNull
    public static final Path mkdirIfAbsent(@NotNull Path $this$mkdirIfAbsent) {
        Intrinsics.checkNotNullParameter((Object)$this$mkdirIfAbsent, (String)"<this>");
        if (!UtilsKt.exists($this$mkdirIfAbsent)) {
            Files.createDirectory($this$mkdirIfAbsent, new FileAttribute[0]);
        }
        return $this$mkdirIfAbsent;
    }

    @NotNull
    public static final Random getRandom() {
        return random;
    }

    @NotNull
    public static final AtomicLong getListenerHandleSource() {
        return listenerHandleSource;
    }

    @NotNull
    public static final <T> BinarySearchResult betterBinarySearch(@NotNull List<? extends T> $this$betterBinarySearch, T v, @NotNull Comparator<T> comparator) {
        Intrinsics.checkNotNullParameter($this$betterBinarySearch, (String)"<this>");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        return UtilsKt.toBinarySearchResult(CollectionsKt.binarySearch$default($this$betterBinarySearch, v, comparator, (int)0, (int)0, (int)12, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> ArrayList<T> toArrayList(@NotNull List<? extends T> $this$toArrayList) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter($this$toArrayList, (String)"<this>");
        if ($this$toArrayList instanceof ArrayList) {
            arrayList = (ArrayList)$this$toArrayList;
        } else {
            void var1_1;
            ArrayList r = new ArrayList();
            r.addAll($this$toArrayList);
            arrayList = var1_1;
        }
        return arrayList;
    }

    private static final BinarySearchResult toBinarySearchResult(int result) {
        BinarySearchResult binarySearchResult;
        if (result >= 0) {
            binarySearchResult = new BinarySearchResult.Exact(result);
        } else {
            int insertionPoint = -result - 1;
            binarySearchResult = new BinarySearchResult.Between(insertionPoint - 1, insertionPoint);
        }
        return binarySearchResult;
    }
}

