/*
 * Decompiled with CFR 0.152.
 */
package kweb.shoebox;

import java.nio.file.Path;
import java.util.Collection;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kweb.shoebox.KeyValue;
import kweb.shoebox.Source;
import kweb.shoebox.Store;
import kweb.shoebox.UtilsKt;
import kweb.shoebox.View;
import kweb.shoebox.stores.DirectoryStore;
import kweb.shoebox.stores.MapDBStore;
import kweb.shoebox.stores.MemoryStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u001d\u001a\u00020\r2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u001fJ\u000e\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\tJ\u0016\u0010 \u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\tJ\u000e\u0010#\u001a\u00020\r2\u0006\u0010!\u001a\u00020\tJ\u000e\u0010$\u001a\u00020\r2\u0006\u0010!\u001a\u00020\tJ\u0018\u0010%\u001a\u0004\u0018\u00018\u00002\u0006\u0010\"\u001a\u00020\u0013H\u0086\u0002\u00a2\u0006\u0002\u0010&J\"\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020\u00132\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u001fJ,\u0010*\u001a\u00020\t2$\u0010+\u001a \u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\nJ.\u0010*\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00132\u001e\u0010+\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\nJ&\u0010,\u001a\u00020\t2\u001e\u0010+\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0019J&\u0010-\u001a\u00020\t2\u001e\u0010+\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0019J\u0015\u0010.\u001a\u0004\u0018\u00018\u00002\u0006\u0010\"\u001a\u00020\u0013\u00a2\u0006\u0002\u0010&J\u001e\u0010/\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u00132\u0006\u00100\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u00101J2\u00102\u001a\b\u0012\u0004\u0012\u00028\u0000032\u0006\u00104\u001a\u00020\u00132\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00130\u001f2\b\b\u0002\u00106\u001a\u000207R8\u0010\u0007\u001a,\u0012\u0004\u0012\u00020\t\u0012\"\u0012 \u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R>\u0010\u0012\u001a2\u0012\u0004\u0012\u00020\u0013\u0012(\u0012&\u0012\u0004\u0012\u00020\t\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\n0\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R2\u0010\u0018\u001a&\u0012\u0004\u0012\u00020\t\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u00190\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u001a\u001a&\u0012\u0004\u0012\u00020\t\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u00190\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00068"}, d2={"Lkweb/shoebox/Shoebox;", "T", "", "()V", "store", "Lkweb/shoebox/Store;", "(Lkweb/shoebox/Store;)V", "changeListeners", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkotlin/Function3;", "Lkweb/shoebox/KeyValue;", "Lkweb/shoebox/Source;", "", "entries", "", "getEntries", "()Ljava/lang/Iterable;", "keySpecificChangeListeners", "", "keysForSynchronization", "Ljava/util/WeakHashMap;", "getKeysForSynchronization", "()Ljava/util/WeakHashMap;", "newListeners", "Lkotlin/Function2;", "removeListeners", "getStore", "()Lkweb/shoebox/Store;", "atomicModify", "modification", "Lkotlin/Function1;", "deleteChangeListener", "handle", "key", "deleteNewListener", "deleteRemoveListener", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "modify", "", "modifier", "onChange", "listener", "onNew", "onRemove", "remove", "set", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "view", "Lkweb/shoebox/View;", "name", "by", "verify", "Lkweb/shoebox/View$VerifyBehavior;", "shoebox"})
public final class Shoebox<T> {
    @NotNull
    private final Store<T> store;
    @NotNull
    private final ConcurrentHashMap<String, ConcurrentHashMap<Long, Function3<T, T, Source, Unit>>> keySpecificChangeListeners;
    @NotNull
    private final ConcurrentHashMap<Long, Function2<KeyValue<T>, Source, Unit>> newListeners;
    @NotNull
    private final ConcurrentHashMap<Long, Function2<KeyValue<T>, Source, Unit>> removeListeners;
    @NotNull
    private final ConcurrentHashMap<Long, Function3<T, KeyValue<T>, Source, Unit>> changeListeners;
    @NotNull
    private final WeakHashMap<String, String> keysForSynchronization;

    public Shoebox(@NotNull Store<T> store) {
        Intrinsics.checkNotNullParameter(store, (String)"store");
        this.store = store;
        this.keySpecificChangeListeners = new ConcurrentHashMap();
        this.newListeners = new ConcurrentHashMap();
        this.removeListeners = new ConcurrentHashMap();
        this.changeListeners = new ConcurrentHashMap();
        this.keysForSynchronization = new WeakHashMap();
    }

    @NotNull
    public final Store<T> getStore() {
        return this.store;
    }

    public Shoebox() {
        this(new MemoryStore());
    }

    @Nullable
    public final T get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            return this.store.get(key);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in call to get(\"" + key + "\")", e);
        }
    }

    @Nullable
    public final T remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        T removed = this.store.remove(key);
        if (removed != null) {
            Collection<Function2<KeyValue<T>, Source, Unit>> collection = this.removeListeners.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"removeListeners.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function2 it = (Function2)element$iv;
                boolean bl = false;
                it.invoke(new KeyValue<T>(key, removed), (Object)Source.LOCAL);
            }
        }
        return removed;
    }

    public final void set(@NotNull String key, @NotNull T value) {
        block9: {
            Collection<Function3<T, T, Source, Unit>> collection;
            T previousValue;
            block8: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter(value, (String)"value");
                previousValue = this.store.set(key, value);
                if (previousValue != null) break block8;
                Collection<Function2<KeyValue<T>, Source, Unit>> collection2 = this.newListeners.values();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"newListeners.values");
                Iterable $this$forEach$iv = collection2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function2 l = (Function2)element$iv;
                    boolean bl = false;
                    try {
                        l.invoke(new KeyValue<T>(key, value), (Object)Source.LOCAL);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
                break block9;
            }
            if (Intrinsics.areEqual(value, previousValue)) break block9;
            Iterable<Object> $this$forEach$iv = this.changeListeners.values();
            Intrinsics.checkNotNullExpressionValue($this$forEach$iv, (String)"changeListeners.values");
            $this$forEach$iv = $this$forEach$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function3 cl = (Function3)element$iv;
                boolean bl = false;
                cl.invoke(previousValue, new KeyValue<T>(key, value), (Object)Source.LOCAL);
            }
            ConcurrentHashMap<Long, Function3<T, T, Source, Unit>> concurrentHashMap = this.keySpecificChangeListeners.get(key);
            if (concurrentHashMap != null && (collection = concurrentHashMap.values()) != null) {
                Iterable $this$forEach$iv2 = collection;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Function3 l = (Function3)element$iv;
                    boolean bl = false;
                    try {
                        l.invoke(previousValue, value, (Object)Source.LOCAL);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    @NotNull
    public final WeakHashMap<String, String> getKeysForSynchronization() {
        return this.keysForSynchronization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean modify(@NotNull String key, @NotNull Function1<? super T, ? extends T> modifier) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
        String keyForSync = this.keysForSynchronization.computeIfAbsent(key, arg_0 -> Shoebox.modify$lambda-4(key, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)keyForSync, (String)"keyForSync");
        String string = keyForSync;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (string) {
            boolean bl3;
            boolean bl4 = false;
            T oldValue = this.get(key);
            if (oldValue == null) {
                bl3 = false;
            } else {
                this.set(key, modifier.invoke(oldValue));
                bl3 = true;
            }
            boolean bl5 = bl3;
            return bl5;
        }
    }

    @NotNull
    public final Iterable<KeyValue<T>> getEntries() {
        return this.store.getEntries();
    }

    public final long onNew(@NotNull Function2<? super KeyValue<T>, ? super Source, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        long handle = UtilsKt.getListenerHandleSource().incrementAndGet();
        this.newListeners.put(handle, listener);
        return handle;
    }

    public final void deleteNewListener(long handle) {
        this.newListeners.remove(handle);
    }

    public final long onRemove(@NotNull Function2<? super KeyValue<T>, ? super Source, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        long handle = UtilsKt.getListenerHandleSource().incrementAndGet();
        this.removeListeners.put(handle, listener);
        return handle;
    }

    public final void deleteRemoveListener(long handle) {
        this.removeListeners.remove(handle);
    }

    public final long onChange(@NotNull Function3<? super T, ? super KeyValue<T>, ? super Source, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        long handle = UtilsKt.getListenerHandleSource().incrementAndGet();
        this.changeListeners.put(handle, listener);
        return handle;
    }

    public final long onChange(@NotNull String key, @NotNull Function3<? super T, ? super T, ? super Source, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        long handle = UtilsKt.getListenerHandleSource().incrementAndGet();
        this.keySpecificChangeListeners.computeIfAbsent(key, Shoebox::onChange$lambda-6).put(handle, listener);
        return handle;
    }

    public final void deleteChangeListener(long handle) {
        this.changeListeners.remove(handle);
    }

    public final void deleteChangeListener(@NotNull String key, long handle) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ConcurrentHashMap<Long, Function3<T, T, Source, Unit>> concurrentHashMap = this.keySpecificChangeListeners.get(key);
        if (concurrentHashMap != null) {
            ConcurrentHashMap<Long, Function3<T, T, Source, Unit>> concurrentHashMap2 = concurrentHashMap;
            boolean bl = false;
            boolean bl2 = false;
            ConcurrentHashMap<Long, Function3<T, T, Source, Unit>> it = concurrentHashMap2;
            boolean bl3 = false;
            it.remove(handle);
            if (it.isEmpty()) {
                this.keySpecificChangeListeners.remove(key);
            }
        }
    }

    public final void atomicModify(@NotNull Function1<? super T, ? extends T> modification) {
        Intrinsics.checkNotNullParameter(modification, (String)"modification");
    }

    @NotNull
    public final View<T> view(@NotNull String name, @NotNull Function1<? super T, String> by, @NotNull View.VerifyBehavior verify) {
        Store store;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(by, (String)"by");
        Intrinsics.checkNotNullParameter((Object)((Object)verify), (String)"verify");
        Store<T> store2 = this.store;
        if (store2 instanceof MemoryStore) {
            store = new MemoryStore();
        } else if (store2 instanceof DirectoryStore) {
            Path path = ((DirectoryStore)this.store).getDirectory().getParent().resolve(((DirectoryStore)this.store).getDirectory().getFileName() + '-' + name + "-view");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"store.directory.parent.resolve(\"${store.directory.fileName}-$name-view\")");
            store = new DirectoryStore<View.Reference>(path, View.Reference.Companion.serializer());
        } else if (store2 instanceof MapDBStore) {
            store = new MapDBStore(((MapDBStore)this.store).getDb(), ((MapDBStore)this.store).getName() + '-' + name + "-view", View.Reference.Companion.serializer(), null, 8, null);
        } else {
            throw new RuntimeException(Intrinsics.stringPlus((String)"Shoebox doesn't currently support creating a view for store type ", (Object)Reflection.getOrCreateKotlinClass(this.store.getClass()).getSimpleName()));
        }
        Store store3 = store;
        return new View<T>(new Shoebox<View.Reference>(store3), this, verify, by);
    }

    public static /* synthetic */ View view$default(Shoebox shoebox, String string, Function1 function1, View.VerifyBehavior verifyBehavior, int n, Object object) {
        if ((n & 4) != 0) {
            verifyBehavior = View.VerifyBehavior.BLOCKING_VERIFY;
        }
        return shoebox.view(string, function1, verifyBehavior);
    }

    private static final String modify$lambda-4(String $key, String it) {
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        return $key;
    }

    private static final ConcurrentHashMap onChange$lambda-6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ConcurrentHashMap();
    }
}

