/*
 * Decompiled with CFR 0.152.
 */
package kweb.shoebox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kweb.shoebox.BinarySearchResult;
import kweb.shoebox.KeyValue;
import kweb.shoebox.Source;
import kweb.shoebox.UtilsKt;
import kweb.shoebox.View;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00028\u00000\bj\b\u0012\u0004\u0012\u00028\u0000`\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\fJ\u000e\u0010+\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\fJ\u000e\u0010,\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\fJ\b\u0010-\u001a\u00020\u0018H\u0004J&\u0010.\u001a\u00020\f2\u001e\u0010/\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0017\u0012\u0004\u0012\u00020\u00180\u0015J>\u00100\u001a\u00020\f26\u0010/\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00180\u0015J&\u00101\u001a\u00020\f2\u001e\u0010/\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0017\u0012\u0004\u0012\u00020\u00180\u0015R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00028\u00000\bj\b\u0012\u0004\u0012\u00028\u0000`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R2\u0010\u0013\u001a&\u0012\u0004\u0012\u00020\f\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0017\u0012\u0004\u0012\u00020\u00180\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00170\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\u001c\u001a>\u0012\u0004\u0012\u00020\f\u00124\u00122\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00180\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00170\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010$\u001a&\u0012\u0004\u0012\u00020\f\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0017\u0012\u0004\u0012\u00020\u00180\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00062"}, d2={"Lkweb/shoebox/OrderedViewSet;", "T", "", "view", "Lkweb/shoebox/View;", "viewKey", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Lkweb/shoebox/View;Ljava/lang/String;Ljava/util/Comparator;)V", "additionHandle", "", "getComparator", "()Ljava/util/Comparator;", "entries", "", "getEntries", "()Ljava/util/List;", "insertListeners", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Function2;", "", "Lkweb/shoebox/KeyValue;", "", "keyValueEntries", "getKeyValueEntries", "modificationHandlers", "modifyListeners", "Lkotlin/ParameterName;", "name", "old", "new", "orderedList", "Ljava/util/concurrent/CopyOnWriteArrayList;", "removalHandle", "removeListeners", "getView", "()Lkweb/shoebox/View;", "getViewKey", "()Ljava/lang/String;", "deleteInsertListener", "handle", "deleteModifyListener", "deleteRemoveListener", "finalize", "onInsert", "listener", "onModify", "onRemove", "shoebox"})
public final class OrderedViewSet<T> {
    @NotNull
    private final View<T> view;
    @NotNull
    private final String viewKey;
    @NotNull
    private final Comparator<T> comparator;
    @NotNull
    private final CopyOnWriteArrayList<KeyValue<T>> orderedList;
    @NotNull
    private final ConcurrentHashMap<String, Long> modificationHandlers;
    private final long additionHandle;
    private final long removalHandle;
    @NotNull
    private final ConcurrentHashMap<Long, Function2<Integer, KeyValue<T>, Unit>> insertListeners;
    @NotNull
    private final ConcurrentHashMap<Long, Function2<Integer, KeyValue<T>, Unit>> removeListeners;
    @NotNull
    private final ConcurrentHashMap<Long, Function2<T, T, Unit>> modifyListeners;
    @NotNull
    private final List<KeyValue<T>> keyValueEntries;

    public OrderedViewSet(@NotNull View<T> view, @NotNull String viewKey, @NotNull Comparator<T> comparator) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)viewKey, (String)"viewKey");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        this.view = view;
        this.viewKey = viewKey;
        this.comparator = comparator;
        this.modificationHandlers = new ConcurrentHashMap();
        this.orderedList = new CopyOnWriteArrayList();
        Comparator comparator2 = (arg_0, arg_1) -> OrderedViewSet._init_$lambda-0(this, arg_0, arg_1);
        boolean bl = false;
        final Comparator kvComparator = new Comparator<T>(comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    boolean bl = false;
                    KeyValue p0 = (KeyValue)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)p0.getKey());
                    p0 = (KeyValue)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = p0.getKey();
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
                return n;
            }
        };
        this.orderedList.addAll((Collection)this.view.getKeyValues(this.viewKey));
        CollectionsKt.sortWith((List)this.orderedList, (Comparator)kvComparator);
        this.additionHandle = this.view.onAdd(this.viewKey, (Function1)new Function1<KeyValue<T>, Unit>(){

            public final void invoke(@NotNull KeyValue<T> keyValue) {
                int n;
                Intrinsics.checkNotNullParameter(keyValue, (String)"keyValue");
                Object binarySearchResult = UtilsKt.betterBinarySearch(orderedList, keyValue, kvComparator);
                if (binarySearchResult instanceof BinarySearchResult.Exact) {
                    n = ((BinarySearchResult.Exact)binarySearchResult).getIndex();
                } else if (binarySearchResult instanceof BinarySearchResult.Between) {
                    n = ((BinarySearchResult.Between)binarySearchResult).getHighIndex();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                int insertionPoint = n;
                orderedList.add(insertionPoint, keyValue);
                binarySearchResult = insertListeners.values();
                Intrinsics.checkNotNullExpressionValue((Object)binarySearchResult, (String)"insertListeners.values");
                Iterable $this$forEach$iv = (Iterable)binarySearchResult;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function2 it = (Function2)element$iv;
                    boolean bl = false;
                    try {
                        it.invoke((Object)insertionPoint, keyValue);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
        });
        this.removalHandle = this.view.onRemove(this.viewKey, (Function1)new Function1<KeyValue<T>, Unit>(){

            public final void invoke(@NotNull KeyValue<T> keyValue) {
                Intrinsics.checkNotNullParameter(keyValue, (String)"keyValue");
                if (keyValue.getValue() != null) {
                    BinarySearchResult binarySearchResult = UtilsKt.betterBinarySearch(orderedList, keyValue, kvComparator);
                    if (binarySearchResult instanceof BinarySearchResult.Exact) {
                        Collection collection = removeListeners.values();
                        Intrinsics.checkNotNullExpressionValue(collection, (String)"removeListeners.values");
                        Iterable $this$forEach$iv = collection;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Function2 it = (Function2)element$iv;
                            boolean bl = false;
                            it.invoke((Object)((BinarySearchResult.Exact)binarySearchResult).getIndex(), keyValue);
                        }
                        orderedList.remove(((BinarySearchResult.Exact)binarySearchResult).getIndex());
                    } else if (binarySearchResult instanceof BinarySearchResult.Between) {
                        throw new RuntimeException(keyValue + " not found in orderedList " + orderedList);
                    }
                }
            }
        });
        Iterable $this$forEach$iv = this.orderedList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyValue kv = (KeyValue)element$iv;
            boolean bl2 = false;
            Map map = this.modificationHandlers;
            String string = kv.getKey();
            Long l = this.getView().getViewOf().onChange(kv.getKey(), (Function3)new Function3<T, T, Source, Unit>(this, kv, kvComparator){
                final /* synthetic */ OrderedViewSet<T> this$0;
                final /* synthetic */ KeyValue<T> $kv;
                final /* synthetic */ Comparator<KeyValue<T>> $kvComparator;
                {
                    this.this$0 = $receiver;
                    this.$kv = $kv;
                    this.$kvComparator = $kvComparator;
                    super(3);
                }

                public final void invoke(@NotNull T oldValue, @NotNull T newValue, @NotNull Source $noName_2) {
                    Intrinsics.checkNotNullParameter(oldValue, (String)"oldValue");
                    Intrinsics.checkNotNullParameter(newValue, (String)"newValue");
                    Intrinsics.checkNotNullParameter((Object)((Object)$noName_2), (String)"$noName_2");
                    if (this.this$0.getComparator().compare(oldValue, newValue) != 0) {
                        int n;
                        KeyValue<T> newKeyValue = new KeyValue<T>(this.$kv.getKey(), newValue);
                        Object insertPoint = UtilsKt.betterBinarySearch(OrderedViewSet.access$getOrderedList$p(this.this$0), newKeyValue, this.$kvComparator);
                        if (insertPoint instanceof BinarySearchResult.Exact) {
                            n = ((BinarySearchResult.Exact)insertPoint).getIndex();
                        } else if (insertPoint instanceof BinarySearchResult.Between) {
                            n = ((BinarySearchResult.Between)insertPoint).getHighIndex();
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        int insertionIndex = n;
                        insertPoint = OrderedViewSet.access$getInsertListeners$p(this.this$0).values();
                        Intrinsics.checkNotNullExpressionValue((Object)insertPoint, (String)"insertListeners.values");
                        Iterable $this$forEach$iv = (Iterable)insertPoint;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Function2 it = (Function2)element$iv;
                            boolean bl = false;
                            it.invoke((Object)insertionIndex, newKeyValue);
                        }
                        KeyValue<T> oldKeyValue = new KeyValue<T>(this.$kv.getKey(), oldValue);
                        OrderedViewSet.access$getOrderedList$p(this.this$0).add(insertionIndex, newKeyValue);
                        BinarySearchResult removePoint = UtilsKt.betterBinarySearch(OrderedViewSet.access$getOrderedList$p(this.this$0), oldKeyValue, this.$kvComparator);
                        if (removePoint instanceof BinarySearchResult.Exact) {
                            OrderedViewSet.access$getOrderedList$p(this.this$0).remove(((BinarySearchResult.Exact)removePoint).getIndex());
                            Collection<V> collection = OrderedViewSet.access$getRemoveListeners$p(this.this$0).values();
                            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"removeListeners.values");
                            Iterable $this$forEach$iv2 = collection;
                            boolean $i$f$forEach2 = false;
                            for (T element$iv : $this$forEach$iv2) {
                                Function2 it = (Function2)element$iv;
                                boolean bl = false;
                                it.invoke((Object)((BinarySearchResult.Exact)removePoint).getIndex(), oldKeyValue);
                            }
                        }
                        for (Function2 modifyListener : OrderedViewSet.access$getModifyListeners$p(this.this$0).values()) {
                            modifyListener.invoke(oldValue, newValue);
                        }
                    }
                }
            });
            boolean bl3 = false;
            map.put(string, l);
        }
        this.insertListeners = new ConcurrentHashMap();
        this.removeListeners = new ConcurrentHashMap();
        this.modifyListeners = new ConcurrentHashMap();
        this.keyValueEntries = this.orderedList;
    }

    @NotNull
    public final View<T> getView() {
        return this.view;
    }

    @NotNull
    public final String getViewKey() {
        return this.viewKey;
    }

    @NotNull
    public final Comparator<T> getComparator() {
        return this.comparator;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> getEntries() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.keyValueEntries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            KeyValue keyValue = (KeyValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = p0.getValue();
            collection.add(v);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<KeyValue<T>> getKeyValueEntries() {
        return this.keyValueEntries;
    }

    public final long onInsert(@NotNull Function2<? super Integer, ? super KeyValue<T>, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        long handle = UtilsKt.getListenerHandleSource().incrementAndGet();
        Map map = this.insertListeners;
        Long l = handle;
        boolean bl = false;
        map.put(l, listener);
        return handle;
    }

    public final void deleteInsertListener(long handle) {
        this.insertListeners.remove(handle);
    }

    public final long onRemove(@NotNull Function2<? super Integer, ? super KeyValue<T>, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        long handle = UtilsKt.getListenerHandleSource().incrementAndGet();
        Map map = this.removeListeners;
        Long l = handle;
        boolean bl = false;
        map.put(l, listener);
        return handle;
    }

    public final long onModify(@NotNull Function2<? super T, ? super T, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        long handle = UtilsKt.getListenerHandleSource().incrementAndGet();
        Map map = this.modifyListeners;
        Long l = handle;
        boolean bl = false;
        map.put(l, listener);
        return handle;
    }

    public final void deleteModifyListener(long handle) {
        this.modifyListeners.remove(handle);
    }

    public final void deleteRemoveListener(long handle) {
        this.removeListeners.remove(handle);
    }

    protected final void finalize() {
        this.view.deleteAddListener(this.viewKey, this.additionHandle);
        this.view.deleteRemoveListener(this.viewKey, this.removalHandle);
        Map $this$forEach$iv = this.modificationHandlers;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$key$handler = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$key$handler;
            boolean bl3 = false;
            String key = (String)entry.getKey();
            Map.Entry entry2 = $dstr$key$handler;
            boolean bl4 = false;
            long handler = ((Number)entry2.getValue()).longValue();
            this.getView().getViewOf().deleteChangeListener(key, handler);
        }
    }

    private static final int _init_$lambda-0(OrderedViewSet this$0, KeyValue o1, KeyValue o2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getComparator().compare(o1.getValue(), o2.getValue());
    }

    public static final /* synthetic */ ConcurrentHashMap access$getModifyListeners$p(OrderedViewSet $this) {
        return $this.modifyListeners;
    }
}

