/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jpedal.io.PathSerializer;

public class Vector_Rectangle
implements Serializable {
    private static final long serialVersionUID = -4213299865911400839L;
    int increment_size = 1000;
    protected int current_item = 0;
    int max_size = 250;
    private Rectangle[] items = new Rectangle[this.max_size];
    private int checkPoint = -1;

    public Vector_Rectangle(int number) {
        this.max_size = number;
        this.items = new Rectangle[this.max_size];
    }

    public void writeToStream(ByteArrayOutputStream bos) throws IOException {
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(this.max_size);
        for (int i = 0; i < this.max_size; ++i) {
            Rectangle nextObj = this.items[i];
            if (nextObj == null) {
                os.writeObject(null);
                continue;
            }
            PathIterator pathIterator = nextObj.getPathIterator(new AffineTransform());
            PathSerializer.serializePath(os, pathIterator);
        }
    }

    public void restoreFromStream(ByteArrayInputStream bis) throws IOException, ClassNotFoundException {
        int size;
        ObjectInputStream os = new ObjectInputStream(bis);
        this.max_size = size = ((Integer)os.readObject()).intValue();
        this.items = new Rectangle[size];
        for (int i = 0; i < size; ++i) {
            GeneralPath path = PathSerializer.deserializePath(os);
            this.items[i] = path == null ? null : path.getBounds();
        }
    }

    public Vector_Rectangle() {
    }

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1) {
            this.checkPoint = this.current_item;
        }
    }

    protected static int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 16000 ? (increment_size *= 2) : (increment_size += 2000));
        return increment_size;
    }

    public synchronized void addElement(Rectangle value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final void removeElementAt(int id) {
        if (id >= 0) {
            System.arraycopy(this.items, id + 1, this.items, id, this.current_item - 1 - id);
            this.items[this.current_item - 1] = new Rectangle();
        } else {
            this.items[0] = new Rectangle();
        }
        --this.current_item;
    }

    public static final boolean contains(Rectangle value) {
        return false;
    }

    public final void clear() {
        this.checkPoint = -1;
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = null;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = null;
            }
        }
        this.current_item = 0;
    }

    public final Rectangle[] get() {
        return this.items;
    }

    public final synchronized Rectangle elementAt(int id) {
        if (id >= this.max_size) {
            return null;
        }
        return this.items[id];
    }

    public final void set(Rectangle[] new_items) {
        this.items = new_items;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final synchronized void setElementAt(Rectangle new_name, int id) {
        if (id >= this.max_size) {
            this.checkSize(id);
        }
        this.items[id] = new_name;
    }

    private final void checkSize(int i) {
        if (i >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i) {
                this.max_size = i + this.increment_size + 2;
            }
            Rectangle[] temp = this.items;
            this.items = new Rectangle[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = Vector_Rectangle.incrementSize(this.increment_size);
        }
    }

    public void trim() {
        Rectangle[] newItems = new Rectangle[this.current_item];
        System.arraycopy(this.items, 0, newItems, 0, this.current_item);
        this.items = newItems;
        this.max_size = this.current_item;
    }

    public void setSize(int currentItem) {
        this.current_item = currentItem;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Vector_Rectangle current_item=");
        builder.append(this.current_item);
        builder.append(", ");
        if (this.items != null) {
            builder.append("items=[");
            for (int i = 0; i < this.size(); ++i) {
                if (this.items[i] == null) continue;
                builder.append(this.items[i]);
                builder.append(", ");
            }
            builder.append("], ");
        }
        builder.append("checkPoint=");
        builder.append(this.checkPoint);
        builder.append("]");
        return builder.toString();
    }
}

