/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import org.jpedal.utils.StringUtils;

public class Strip {
    private static final String strip_start_token_deliminator = "<&";
    private static final String strip_end_token_deliminator = ">;";

    public static StringBuilder stripXML(String raw_data, boolean isXMLExtraction) {
        if (raw_data == null) {
            return null;
        }
        return Strip.stripXML(new StringBuilder(raw_data), isXMLExtraction);
    }

    public static StringBuilder stripXML(StringBuilder all_tags, boolean isXMLExtraction) {
        int rawLength = all_tags.length();
        StringBuilder general_buffer = new StringBuilder(rawLength);
        StringBuilder tag = new StringBuilder(rawLength);
        if (all_tags == null) {
            return general_buffer;
        }
        if (isXMLExtraction) {
            char start = ' ';
            boolean inToken = false;
            int length = all_tags.length();
            for (int i = 0; i < length; ++i) {
                char next_token = all_tags.charAt(i);
                boolean match = false;
                if (inToken && start == '&' && (next_token == '<' || next_token == '&')) {
                    general_buffer.append((CharSequence)tag);
                    tag = new StringBuilder(5);
                }
                if (strip_start_token_deliminator.indexOf(next_token) != -1) {
                    inToken = true;
                    start = next_token;
                    match = true;
                }
                if (inToken && start == '&' && next_token == ' ') {
                    inToken = false;
                    general_buffer.append('&');
                    tag = new StringBuilder(5);
                }
                if (!inToken) {
                    general_buffer.append(next_token);
                } else {
                    tag.append(next_token);
                }
                if (match) continue;
                int endPointer = strip_end_token_deliminator.indexOf(next_token);
                if (endPointer == 1 & start == '&') {
                    if (tag.toString().equals("&lt;")) {
                        general_buffer.append('<');
                    } else if (tag.toString().equals("&gt;")) {
                        general_buffer.append('>');
                    } else if (tag.toString().equals("&amp;")) {
                        general_buffer.append('&');
                    }
                    inToken = false;
                    tag = new StringBuilder();
                    continue;
                }
                if (endPointer == 0 & start == '<') {
                    inToken = false;
                    tag = new StringBuilder();
                    continue;
                }
                if (next_token != '&') continue;
                System.out.println(next_token + " " + start + ' ' + endPointer);
                general_buffer.append('&');
            }
        } else {
            general_buffer = all_tags;
        }
        general_buffer = Strip.trim(general_buffer);
        return general_buffer;
    }

    public static StringBuilder stripXMLArrows(StringBuilder all_tags, boolean isXMLExtraction) {
        StringBuilder general_buffer = new StringBuilder();
        StringBuilder tag = new StringBuilder();
        if (all_tags == null) {
            return general_buffer;
        }
        if (isXMLExtraction) {
            int start = 32;
            boolean inToken = false;
            int length = all_tags.length();
            for (int i = 0; i < length; ++i) {
                char next_token = all_tags.charAt(i);
                if (strip_start_token_deliminator.indexOf(next_token) != -1) {
                    inToken = true;
                    start = next_token;
                }
                if (!inToken) {
                    general_buffer.append(next_token);
                } else {
                    tag.append(next_token);
                }
                int endPointer = strip_end_token_deliminator.indexOf(next_token);
                if (endPointer == 1 & start == 38) {
                    if (!tag.toString().equals("&lt;") && !tag.toString().equals("&gt;")) {
                        general_buffer.append((CharSequence)tag);
                    }
                    inToken = false;
                    tag = new StringBuilder();
                    continue;
                }
                if (!(endPointer == 0 & start == 60)) continue;
                inToken = false;
                tag = new StringBuilder();
            }
        } else {
            general_buffer = all_tags;
        }
        general_buffer = Strip.trim(general_buffer);
        return general_buffer;
    }

    public static final StringBuilder trim(StringBuilder content_buffer) {
        int length = content_buffer.length();
        String aa = content_buffer.toString();
        int i = 0;
        try {
            for (i = length - 1; i > -1; --i) {
                char c = content_buffer.charAt(i);
                if (c == ' ') {
                    content_buffer.deleteCharAt(i);
                    continue;
                }
                i = -1;
            }
        }
        catch (Exception e) {
            System.out.println(aa + "<>" + content_buffer + "<>" + i);
        }
        return content_buffer;
    }

    public static final String removeMultipleSpacesAndReturns(String data) {
        StringBuilder all_data = new StringBuilder(data);
        int i = 1;
        while (i < all_data.length()) {
            if (all_data.charAt(i) == ' ' & all_data.charAt(i - 1) == ' ' | all_data.charAt(i) == '\r' & all_data.charAt(i - 1) == '\r') {
                all_data.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        return all_data.toString();
    }

    public static final String stripSpaces(String data) {
        StringBuilder text = new StringBuilder(data);
        block0: while (text.length() > 0 && text.charAt(0) == ' ') {
            text.deleteCharAt(0);
            int pointer2 = text.length() - 1;
            while (pointer2 > 0 && text.charAt(pointer2) == ' ') {
                text.deleteCharAt(pointer2);
                if (--pointer2 >= 0) continue;
                continue block0;
            }
        }
        return text.toString();
    }

    public static final String stripAllSpaces(String data) {
        StringBuilder text = new StringBuilder(data);
        int pointer2 = text.length() - 1;
        while (pointer2 > 0) {
            if (text.charAt(pointer2) == ' ') {
                text.deleteCharAt(pointer2);
            }
            if (--pointer2 >= 0) continue;
            break;
        }
        return text.toString();
    }

    public static final StringBuilder stripArrows(StringBuilder text) {
        block1: {
            int pointer2 = text.length() - 1;
            if (pointer2 < 0) break block1;
            do {
                if (text.charAt(pointer2) != '<' && text.charAt(pointer2) != '>') continue;
                text.deleteCharAt(pointer2);
            } while (--pointer2 >= 0);
        }
        return text;
    }

    public static final StringBuilder stripAllSpaces(StringBuilder text) {
        int pointer2 = text.length() - 1;
        while (pointer2 > 0) {
            if (text.charAt(pointer2) == ' ') {
                text.deleteCharAt(pointer2);
            }
            if (--pointer2 >= 0) continue;
            break;
        }
        return text;
    }

    public static final String convertToText(String input, boolean isXMLExtraction) {
        StringBuffer output_data;
        if (isXMLExtraction) {
            byte[] rawData = StringUtils.toBytes(input);
            int length = rawData.length;
            int ptr = 0;
            boolean inToken = false;
            for (int i = 0; i < length; ++i) {
                if (rawData[i] == 60) {
                    inToken = true;
                    if (rawData[i + 1] != 83 || rawData[i + 2] != 112 || rawData[i + 3] != 97 || rawData[i + 4] != 99 || rawData[i + 5] != 101) continue;
                    rawData[ptr] = 9;
                    ++ptr;
                    continue;
                }
                if (rawData[i] == 62) {
                    inToken = false;
                    continue;
                }
                if (inToken) continue;
                rawData[ptr] = rawData[i];
                ++ptr;
            }
            byte[] cleanedString = new byte[ptr];
            System.arraycopy(rawData, 0, cleanedString, 0, ptr);
            output_data = new StringBuffer(new String(cleanedString));
        } else {
            output_data = new StringBuffer(input);
        }
        return output_data.toString();
    }

    public static final String stripComment(String value) {
        if (value != null) {
            int pointer = value.indexOf("**");
            if (pointer > 0) {
                value = value.substring(0, pointer - 1).trim();
            }
            if (pointer == 0) {
                value = "";
            }
        }
        return value;
    }

    public static final String checkRemoveLeadingSlach(String command) {
        if (command != null && command.length() > 0 && command.charAt(0) == '/') {
            return command.substring(1);
        }
        return command;
    }

    public static StringBuilder stripAmpHash(StringBuilder current_text) {
        StringBuilder sb = new StringBuilder();
        boolean inEscape = false;
        for (int i = 0; i < current_text.length(); ++i) {
            char nextChar = current_text.charAt(i);
            if (inEscape) {
                if (nextChar != ';') continue;
                inEscape = false;
                continue;
            }
            if (nextChar == '&') {
                inEscape = true;
                continue;
            }
            sb.append(nextChar);
        }
        return sb;
    }
}

