/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.FileWriter;
import java.io.PrintWriter;
import org.jpedal.utils.LogScanner;
import org.jpedal.utils.TimeNow;

public class LogWriter {
    public static LogScanner logScanner = null;
    public static boolean debug = false;
    public static String log_name = null;
    public static boolean testing = false;
    private static boolean verbose = false;

    public static final void resetLogFile() {
        if (log_name != null) {
            try {
                PrintWriter log_file = new PrintWriter(new FileWriter(log_name, false));
                log_file.println(TimeNow.getTimeNow() + " Running Storypad");
                log_file.flush();
                log_file.close();
            }
            catch (Exception e) {
                System.err.println("Exception " + e + " attempting to write to log file " + log_name);
            }
        }
    }

    public static final boolean isOutput() {
        return verbose || logScanner != null;
    }

    public static final void writeLog(String message) {
        if (logScanner != null) {
            logScanner.message(message);
        }
        if (verbose) {
            System.out.println(message);
        }
        if (log_name != null) {
            try {
                PrintWriter log_file = new PrintWriter(new FileWriter(log_name, true));
                if (!testing) {
                    log_file.println(TimeNow.getTimeNow() + ' ' + message);
                }
                log_file.println(message);
                log_file.flush();
                log_file.close();
            }
            catch (Exception e) {
                System.err.println("Exception " + e + " attempting to write to log file " + log_name);
            }
        }
    }

    public static final void setupLogFile(String command_line_values) {
        if (command_line_values != null) {
            if (command_line_values.indexOf(118) != -1) {
                verbose = true;
                LogWriter.writeLog("Verbose on");
            } else {
                verbose = false;
            }
        }
        if (!testing) {
            LogWriter.writeLog("Software version - 4.92b23-OS");
            LogWriter.writeLog("Software started - " + TimeNow.getTimeNow());
        }
        LogWriter.writeLog("=======================================================");
    }

    public static void writeFormLog(String message, boolean print) {
        if (print) {
            System.out.println("[forms] " + message);
        }
        LogWriter.writeLog("[forms] " + message);
    }
}

