/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.text;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.utils.repositories.Vector_Rectangle;

public class TextLines {
    private Map lineAreas = new HashMap();
    private Map lineWritingMode = new HashMap();
    public Map areas = new HashMap();

    public Rectangle setFoundParagraph(int x, int y, int page) {
        Rectangle[] lines = this.getLineAreas(page);
        if (lines != null) {
            Rectangle point = new Rectangle(x, y, 1, 1);
            Rectangle current = new Rectangle(0, 0, 0, 0);
            boolean lineFound = false;
            int selectedLine = 0;
            for (int i = 0; i != lines.length; ++i) {
                if (!lines[i].intersects(point)) continue;
                selectedLine = i;
                lineFound = true;
                break;
            }
            if (lineFound) {
                int i;
                double left = lines[selectedLine].x;
                double cx = lines[selectedLine].getCenterX();
                double right = lines[selectedLine].x + lines[selectedLine].width;
                double cy = lines[selectedLine].getCenterY();
                int h = lines[selectedLine].height;
                current.x = lines[selectedLine].x;
                current.y = lines[selectedLine].y;
                current.width = lines[selectedLine].width;
                current.height = lines[selectedLine].height;
                boolean foundTop = true;
                boolean foundBottom = true;
                Vector_Rectangle selected = new Vector_Rectangle(0);
                selected.addElement(lines[selectedLine]);
                block1: while (foundTop) {
                    foundTop = false;
                    for (i = 0; i != lines.length; ++i) {
                        if (!lines[i].contains(left, cy + (double)h) && !lines[i].contains(cx, cy + (double)h) && !lines[i].contains(right, cy + (double)h)) continue;
                        selected.addElement(lines[i]);
                        foundTop = true;
                        cy = lines[i].getCenterY();
                        h = lines[i].height;
                        if (current.x > lines[i].x) {
                            current.width = current.x + current.width - lines[i].x;
                            current.x = lines[i].x;
                        }
                        if (current.x + current.width < lines[i].x + lines[i].width) {
                            current.width = lines[i].x + lines[i].width - current.x;
                        }
                        if (current.y > lines[i].y) {
                            current.height = current.y + current.height - lines[i].y;
                            current.y = lines[i].y;
                        }
                        if (current.y + current.height >= lines[i].y + lines[i].height) continue block1;
                        current.height = lines[i].y + lines[i].height - current.y;
                        continue block1;
                    }
                }
                left = lines[selectedLine].x;
                cx = lines[selectedLine].getCenterX();
                right = lines[selectedLine].x + lines[selectedLine].width;
                cy = lines[selectedLine].getCenterY();
                h = lines[selectedLine].height;
                block3: while (foundBottom) {
                    foundBottom = false;
                    for (i = 0; i != lines.length; ++i) {
                        if (!lines[i].contains(left, cy - (double)h) && !lines[i].contains(cx, cy - (double)h) && !lines[i].contains(right, cy - (double)h)) continue;
                        selected.addElement(lines[i]);
                        foundBottom = true;
                        cy = lines[i].getCenterY();
                        h = lines[i].height;
                        if (current.x > lines[i].x) {
                            current.width = current.x + current.width - lines[i].x;
                            current.x = lines[i].x;
                        }
                        if (current.x + current.width < lines[i].x + lines[i].width) {
                            current.width = lines[i].x + lines[i].width - current.x;
                        }
                        if (current.y > lines[i].y) {
                            current.height = current.y + current.height - lines[i].y;
                            current.y = lines[i].y;
                        }
                        if (current.y + current.height >= lines[i].y + lines[i].height) continue block3;
                        current.height = lines[i].y + lines[i].height - current.y;
                        continue block3;
                    }
                }
                selected.trim();
                this.addHighlights(selected.get(), true, page);
                return current;
            }
            return null;
        }
        return null;
    }

    public void addToLineAreas(Rectangle area, int writingMode, int page) {
        boolean addNew = true;
        if (this.lineAreas == null) {
            this.lineAreas = new HashMap();
            this.lineAreas.put(page, new Rectangle[]{area});
            this.lineWritingMode = new HashMap();
            this.lineWritingMode.put(page, new int[]{writingMode});
        } else {
            Rectangle[] lastAreas = (Rectangle[])this.lineAreas.get(page);
            int[] lastWritingMode = (int[])this.lineWritingMode.get(page);
            if (area != null) {
                if (lastAreas != null) {
                    block6: for (int i = 0; i != lastAreas.length; ++i) {
                        int lwm = lastWritingMode[i];
                        int cwm = writingMode;
                        int cx = area.x;
                        int cy = area.y;
                        int cw = area.width;
                        int ch = area.height;
                        int lx = lastAreas[i].x;
                        int ly = lastAreas[i].y;
                        int lw = lastAreas[i].width;
                        int lh = lastAreas[i].height;
                        float heightMod = 5.0f;
                        float widthMod = 1.1f;
                        switch (writingMode) {
                            case 0: {
                                if (lwm != cwm || !((float)ly > (float)cy - (float)ch / heightMod) || !((float)ly < (float)cy + (float)ch / heightMod) || !((float)lh < (float)ch + (float)ch / heightMod) || !((float)lh > (float)ch - (float)ch / heightMod) || !((float)lx > (float)(cx + cw) - (float)ch * widthMod && (float)lx < (float)(cx + cw) + (float)ch * widthMod || (float)(lx + lw) > (float)cx - (float)ch * widthMod && (float)(lx + lw) < (float)cx + (float)ch * widthMod) && !lastAreas[i].intersects(area)) continue block6;
                                addNew = false;
                                lastAreas[i] = TextLines.mergePartLines(lastAreas[i], area);
                                continue block6;
                            }
                            case 1: {
                                lx = lastAreas[i].x;
                                ly = lastAreas[i].y;
                                lw = lastAreas[i].width;
                                lh = lastAreas[i].height;
                                cx = area.x;
                                cy = area.y;
                                cw = area.width;
                                ch = area.height;
                                if (lwm != cwm || ly <= cy - 5 || ly >= cy + 5 || lh > ch + ch / 5 || lh < ch - ch / 5 || !((double)lx > (double)(cx + cw) - (double)ch * 0.6 && (double)lx < (double)(cx + cw) + (double)ch * 0.6 || (double)(lx + lw) > (double)cx - (double)ch * 0.6 && (double)(lx + lw) < (double)cx + (double)ch * 0.6) && !lastAreas[i].intersects(area)) continue block6;
                                addNew = false;
                                lastAreas[i] = TextLines.mergePartLines(lastAreas[i], area);
                                continue block6;
                            }
                            case 2: {
                                lx = lastAreas[i].y;
                                ly = lastAreas[i].x;
                                lw = lastAreas[i].height;
                                lh = lastAreas[i].width;
                                cx = area.y;
                                cy = area.x;
                                cw = area.height;
                                ch = area.width;
                                if (lwm != cwm || ly <= cy - 5 || ly >= cy + 5 || lh > ch + ch / 5 || lh < ch - ch / 5 || !((double)lx > (double)(cx + cw) - (double)ch * 0.6 && (double)lx < (double)(cx + cw) + (double)ch * 0.6 || (double)(lx + lw) > (double)cx - (double)ch * 0.6 && (double)(lx + lw) < (double)cx + (double)ch * 0.6) && !lastAreas[i].intersects(area)) continue block6;
                                addNew = false;
                                lastAreas[i] = TextLines.mergePartLines(lastAreas[i], area);
                                continue block6;
                            }
                            case 3: {
                                int currentBaseLine = cx + cw;
                                int lastBaseLine = lx + lw;
                                if (lwm != cwm || currentBaseLine < lastBaseLine - lw / 3 || currentBaseLine > lastBaseLine + lw / 3 || !((double)ly + ((double)lh + (double)lw * 0.6) > (double)cy && (double)ly + ((double)lh - (double)lw * 0.6) < (double)cy || (double)ly + (double)lw * 0.6 > (double)(cy + ch) && (double)ly - (double)lw * 0.6 < (double)(cy + ch)) && !area.intersects(lastAreas[i])) continue block6;
                                addNew = false;
                                lastAreas[i] = TextLines.mergePartLines(lastAreas[i], area);
                            }
                        }
                    }
                } else {
                    addNew = true;
                }
                if (addNew) {
                    int[] lineWritingMode;
                    Rectangle[] lineAreas;
                    if (lastAreas != null) {
                        int i;
                        lineAreas = new Rectangle[lastAreas.length + 1];
                        for (i = 0; i != lastAreas.length; ++i) {
                            lineAreas[i] = lastAreas[i];
                        }
                        lineAreas[lineAreas.length - 1] = area;
                        lineWritingMode = new int[lastWritingMode.length + 1];
                        for (i = 0; i != lastWritingMode.length; ++i) {
                            lineWritingMode[i] = lastWritingMode[i];
                        }
                        lineWritingMode[lineWritingMode.length - 1] = writingMode;
                    } else {
                        lineAreas = new Rectangle[]{area};
                        lineWritingMode = new int[]{writingMode};
                    }
                    this.lineAreas.put(page, lineAreas);
                    this.lineWritingMode.put(page, lineWritingMode);
                }
            }
        }
    }

    public void removeFoundTextArea(Rectangle rectArea, int page) {
        if (rectArea == null || this.areas == null) {
            return;
        }
        Integer p = page;
        Rectangle[] areas = (Rectangle[])this.areas.get(p);
        if (areas != null) {
            int size = areas.length;
            for (int i = 0; i < size; ++i) {
                if (areas[i] == null || !areas[i].contains(rectArea) && (areas[i].x != rectArea.x || areas[i].y != rectArea.y || areas[i].width != rectArea.width || areas[i].height != rectArea.height)) continue;
                areas[i] = null;
                i = size;
            }
            this.areas.put(p, areas);
        }
    }

    public void removeFoundTextAreas(Rectangle[] rectArea, int page) {
        if (rectArea == null) {
            this.areas = null;
        } else {
            for (Rectangle aRectArea : rectArea) {
                this.removeFoundTextArea(aRectArea, page);
            }
            boolean allNull = true;
            Integer p = page;
            Rectangle[] areas = (Rectangle[])this.areas.get(p);
            if (areas != null) {
                for (int ii = 0; ii < areas.length; ++ii) {
                    if (areas[ii] == null) continue;
                    allNull = false;
                    ii = areas.length;
                }
                if (allNull) {
                    areas = null;
                    this.areas.put(p, areas);
                }
            }
        }
    }

    public void clearHighlights() {
        this.areas = null;
    }

    public void addHighlights(Rectangle[] highlights, boolean areaSelect, int page) {
        block37: {
            if (highlights == null) break block37;
            if (!areaSelect) {
                for (int j = 0; j != highlights.length; ++j) {
                    if (highlights[j] == null) continue;
                    Point startPoint = new Point(highlights[j].x + 1, highlights[j].y + 1);
                    Point endPoint = new Point(highlights[j].x + highlights[j].width - 1, highlights[j].y + highlights[j].height - 1);
                    if (this.areas == null) {
                        this.areas = new HashMap();
                    }
                    Rectangle[] lines = this.getLineAreas(page);
                    int[] writingMode = this.getLineWritingMode(page);
                    int start = -1;
                    int finish = -1;
                    boolean backward = false;
                    if (lines == null) continue;
                    for (int i = 0; i != lines.length; ++i) {
                        if (lines[i].contains(startPoint)) {
                            start = i;
                        }
                        if (lines[i].contains(endPoint)) {
                            finish = i;
                        }
                        if (start != -1 && finish != -1) break;
                    }
                    if (start > finish) {
                        int temp = start;
                        start = finish;
                        finish = temp;
                        backward = true;
                    }
                    if (start == finish && startPoint.x > endPoint.x) {
                        Point temp = startPoint;
                        startPoint = endPoint;
                        endPoint = temp;
                    }
                    if (start == -1 || finish == -1) continue;
                    Integer p = page;
                    Rectangle[] areas = new Rectangle[finish - start + 1];
                    System.arraycopy(lines, start + 0, areas, 0, finish - start + 1);
                    if (areas.length > 0) {
                        int top = 0;
                        int bottom = areas.length - 1;
                        if (areas[top] != null && areas[bottom] != null) {
                            switch (writingMode[start]) {
                                case 0: {
                                    if (backward) {
                                        if (endPoint.x - 15 <= areas[top].x) break;
                                        areas[top].width -= endPoint.x - areas[top].x;
                                        areas[top].x = endPoint.x;
                                        break;
                                    }
                                    if (startPoint.x - 15 <= areas[top].x) break;
                                    areas[top].width -= startPoint.x - areas[top].x;
                                    areas[top].x = startPoint.x;
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    if (backward) {
                                        if (endPoint.y - 15 <= areas[top].y) break;
                                        areas[top].height -= endPoint.y - areas[top].y;
                                        areas[top].y = endPoint.y;
                                        break;
                                    }
                                    if (startPoint.y - 15 <= areas[top].y) break;
                                    areas[top].height -= startPoint.y - areas[top].y;
                                    areas[top].y = startPoint.y;
                                    break;
                                }
                                case 3: {
                                    if (backward) {
                                        if (endPoint.y - 15 <= areas[top].y) break;
                                        areas[top].height -= endPoint.y - areas[top].y;
                                        areas[top].y = endPoint.y;
                                        break;
                                    }
                                    if (startPoint.y - 15 <= areas[top].y) break;
                                    areas[top].height -= startPoint.y - areas[top].y;
                                    areas[top].y = startPoint.y;
                                }
                            }
                            switch (writingMode[finish]) {
                                case 0: {
                                    if (backward) {
                                        if (startPoint.x + 15 >= areas[bottom].x + areas[bottom].width) break;
                                        areas[bottom].width = startPoint.x - areas[bottom].x;
                                        break;
                                    }
                                    if (endPoint.x + 15 >= areas[bottom].x + areas[bottom].width) break;
                                    areas[bottom].width = endPoint.x - areas[bottom].x;
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    if (backward) {
                                        if (startPoint.y + 15 >= areas[bottom].y + areas[bottom].height) break;
                                        areas[bottom].height = startPoint.y - areas[bottom].y;
                                        break;
                                    }
                                    if (endPoint.y + 15 >= areas[bottom].y + areas[bottom].height) break;
                                    areas[bottom].height = endPoint.y - areas[bottom].y;
                                    break;
                                }
                                case 3: {
                                    if (backward) {
                                        if (startPoint.y + 15 >= areas[bottom].y + areas[bottom].height) break;
                                        areas[bottom].height = startPoint.y - areas[bottom].y;
                                        break;
                                    }
                                    if (endPoint.y + 15 >= areas[bottom].y + areas[bottom].height) break;
                                    areas[bottom].height = endPoint.y - areas[bottom].y;
                                }
                            }
                        }
                    }
                    this.areas.put(p, areas);
                }
            } else {
                for (int v = 0; v != highlights.length; ++v) {
                    Rectangle[] areas;
                    Integer p;
                    if (highlights[v] == null) continue;
                    if (highlights[v].width < 0) {
                        highlights[v].width = -highlights[v].width;
                        highlights[v].x -= highlights[v].width;
                    }
                    if (highlights[v].height < 0) {
                        highlights[v].height = -highlights[v].height;
                        highlights[v].y -= highlights[v].height;
                    }
                    if (this.areas != null) {
                        p = page;
                        areas = (Rectangle[])this.areas.get(p);
                        if (areas != null) {
                            boolean matchFound = false;
                            int size = areas.length;
                            for (int i = 0; i < size; ++i) {
                                if (areas[i] == null || areas[i] == null || areas[i].x != highlights[v].x || areas[i].y != highlights[v].y || areas[i].width != highlights[v].width || areas[i].height != highlights[v].height) continue;
                                matchFound = true;
                                i = size;
                            }
                            if (!matchFound) {
                                int newSize = areas.length + 1;
                                Rectangle[] newAreas = new Rectangle[newSize];
                                for (int i = 0; i < areas.length; ++i) {
                                    if (areas[i] == null) continue;
                                    newAreas[i + 1] = new Rectangle(areas[i].x, areas[i].y, areas[i].width, areas[i].height);
                                }
                                areas = newAreas;
                                areas[0] = highlights[v];
                            }
                            this.areas.put(p, areas);
                            continue;
                        }
                        this.areas.put(p, highlights);
                        continue;
                    }
                    this.areas = new HashMap();
                    p = page;
                    areas = new Rectangle[]{highlights[v]};
                    this.areas.put(p, areas);
                }
            }
        }
    }

    public Rectangle[] getHighlightedAreas(int page) {
        if (this.areas == null) {
            return null;
        }
        Integer p = page;
        Rectangle[] areas = (Rectangle[])this.areas.get(p);
        if (areas != null) {
            int count = areas.length;
            Rectangle[] returnValue = new Rectangle[count];
            for (int ii = 0; ii < count; ++ii) {
                returnValue[ii] = areas[ii] == null ? null : new Rectangle(areas[ii].x, areas[ii].y, areas[ii].width, areas[ii].height);
            }
            return returnValue;
        }
        return null;
    }

    public void setLineAreas(Map la) {
        this.lineAreas = la;
    }

    public void setLineWritingMode(Map lineOrientation) {
        this.lineWritingMode = lineOrientation;
    }

    public Rectangle[] getLineAreas(int page) {
        if (this.lineAreas == null) {
            return null;
        }
        Rectangle[] lineAreas = (Rectangle[])this.lineAreas.get(page);
        if (lineAreas == null) {
            return null;
        }
        int count = lineAreas.length;
        Rectangle[] returnValue = new Rectangle[count];
        for (int ii = 0; ii < count; ++ii) {
            returnValue[ii] = lineAreas[ii] == null ? null : new Rectangle(lineAreas[ii].x, lineAreas[ii].y, lineAreas[ii].width, lineAreas[ii].height);
        }
        return returnValue;
    }

    public int[] getLineWritingMode(int page) {
        if (this.lineWritingMode == null) {
            return null;
        }
        int[] lineWritingMode = (int[])this.lineWritingMode.get(page);
        if (lineWritingMode == null) {
            return null;
        }
        int count = lineWritingMode.length;
        int[] returnValue = new int[count];
        System.arraycopy(lineWritingMode, 0, returnValue, 0, count);
        return returnValue;
    }

    private static Rectangle mergePartLines(Rectangle lastArea, Rectangle area) {
        int x1 = area.x;
        int x2 = area.x + area.width;
        int y1 = area.y;
        int y2 = area.y + area.height;
        int lx1 = lastArea.x;
        int lx2 = lastArea.x + lastArea.width;
        int ly1 = lastArea.y;
        int ly2 = lastArea.y + lastArea.height;
        area.x = x1 < lx1 ? x1 : lx1;
        area.y = y1 < ly1 ? y1 : ly1;
        area.height = y2 > ly2 ? y2 - area.y : ly2 - area.y;
        area.width = x2 > lx2 ? x2 - area.x : lx2 - area.x;
        return area;
    }
}

