/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;

public class OutputShape {
    private static final boolean ENABLE_CROPPING = true;
    protected boolean shapeIsOpen = false;
    boolean hasMoveTo = false;
    protected int shapeCount = 0;
    double minXcoord = 999999.0;
    double minYcoord = 999999.0;
    protected List<String> pathCommands;
    protected int currentColor;
    protected Rectangle cropBox;
    private Point2D midPoint;
    private double[] lastVisiblePoint;
    private double[] lastInvisiblePoint;
    private double[] previousPoint;
    private boolean isPathSegmentVisible;
    protected double[] entryPoint;
    boolean includeClip = false;
    private double[] exitPoint;
    private List<Point> largeBox;
    private boolean isLargeBox;
    private boolean largeBoxSideAlternation;
    static int debug = 0;
    Rectangle clipBox = null;
    private int pageRotation = 0;
    protected float scaling;
    private boolean debugPath = false;
    int pathCommand;
    private float[][] ctm;
    private Shape currentShape;
    private int minX;
    private int minY;
    protected int cmd = -1;
    int adjustY = 0;
    boolean isFilled = false;
    boolean evenStroke = true;

    public OutputShape(int cmd, float scaling, Shape currentShape, GraphicsState gs, AffineTransform scalingTransform, Point2D midPoint, Rectangle cropBox, int currentColor, int dpCount, int pageRotation, PdfPageData pageData, int pageNumber, boolean includeClip) {
        Area clip;
        double diff;
        this.includeClip = includeClip;
        if (currentShape.getBounds2D().getHeight() > (double)0.6f && currentShape.getBounds2D().getHeight() < 1.0 && currentShape.getBounds2D().getWidth() > 1.0 && (diff = currentShape.getBounds2D().getMinY() - (double)currentShape.getBounds().y) > 0.7) {
            this.adjustY = 1;
        }
        this.cmd = cmd;
        if (cmd == 21610) {
            if (cropBox != null) {
                this.minX = (int)cropBox.getMinX();
                this.minY = (int)cropBox.getMinY();
            }
        } else {
            this.minX = pageData.getCropBoxX(pageNumber);
            this.minY = pageData.getCropBoxY(pageNumber);
        }
        if (this.debugPath) {
            System.out.println("raw shape=" + currentShape.getBounds() + " minx=" + this.minX + ' ' + this.minY);
        }
        this.clipBox = (clip = gs.getClippingShape()) != null ? clip.getBounds() : null;
        if ((this.minX != 0 || this.minY != 0) && this.clipBox != null && cropBox != null) {
            this.clipBox.translate(-this.minX, -this.minY);
        }
        this.currentShape = currentShape;
        this.ctm = gs.CTM;
        this.scaling = scaling;
        this.currentColor = currentColor;
        this.cropBox = cropBox;
        this.midPoint = midPoint;
        this.pageRotation = pageRotation;
        this.isPathSegmentVisible = true;
        this.lastVisiblePoint = new double[2];
        this.lastInvisiblePoint = new double[2];
        this.previousPoint = new double[2];
        this.exitPoint = new double[2];
        this.entryPoint = new double[2];
        this.pathCommands = new ArrayList<String>();
        this.largeBox = new ArrayList<Point>();
        this.isLargeBox = true;
    }

    protected void generateShapeFromG2Data(GraphicsState gs, AffineTransform scalingTransform, Rectangle cropBox) {
        this.isFilled = gs.getFillType() == 2;
        int strokeWidth = (int)((double)(gs.getCTMAdjustedLineWidth() * this.scaling) + 0.99);
        this.evenStroke = strokeWidth != 0 && strokeWidth % 2 == 0;
        gs.setOutputLineWidth(strokeWidth);
        PathIterator it = this.currentShape.getPathIterator(scalingTransform);
        this.shapeIsOpen = true;
        this.beginShape();
        boolean firstDrawCommand = true;
        if (this.debugPath) {
            System.out.println("About to generate commands for shape with bounds" + this.currentShape.getBounds());
            System.out.println("------------------------------------------------");
            System.out.println("crop bounds=" + cropBox.getBounds());
            System.out.println("shape bounds=" + this.currentShape.getBounds());
            System.out.println("minX=" + this.minX + " minY=" + this.minY);
            if (this.clipBox != null) {
                System.out.println("clip bounds=" + this.clipBox.getBounds());
            }
        }
        int segCount = 0;
        while (!it.isDone()) {
            boolean isPointVisible;
            double[] coords = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            this.pathCommand = it.currentSegment(coords);
            ++segCount;
            if (cropBox != null) {
                for (int ii = 0; ii < 3; ++ii) {
                    coords[ii * 2] = coords[ii * 2] - (double)this.minX;
                    coords[ii * 2 + 1] = coords[ii * 2 + 1] - (double)this.minY;
                }
            }
            if (this.debugPath) {
                System.out.println("\n=======Get pathCommand segment " + (int)coords[0] + ' ' + (int)coords[1] + ' ' + (int)coords[2] + ' ' + (int)coords[3] + ' ' + (int)coords[4] + ' ' + (int)coords[5]);
            }
            boolean isCropBoxDrawn = false;
            if (this.cmd != 110) {
                isCropBoxDrawn = this.checkLargeBox(coords, this.pathCommand);
            }
            if (isCropBoxDrawn) {
                it.next();
                continue;
            }
            if (firstDrawCommand) {
                int dx = (int)coords[OutputShape.getCoordOffset(this.pathCommand)];
                int dy = (int)coords[OutputShape.getCoordOffset(this.pathCommand) + 1];
                Rectangle cropBoxtoTest = cropBox;
                if (this.clipBox != null) {
                    cropBoxtoTest = this.clipBox;
                }
                if (cropBoxtoTest != null && cropBoxtoTest.width > 1) {
                    if (dx == cropBoxtoTest.x) {
                        ++dx;
                    } else if (dx == cropBoxtoTest.x + cropBoxtoTest.width) {
                        --dx;
                    }
                }
                this.isPathSegmentVisible = cropBoxtoTest == null || cropBoxtoTest.contains(dx, dy);
                firstDrawCommand = false;
                if (this.debugPath) {
                    System.out.println("isPathSegmentVisible=" + this.isPathSegmentVisible);
                }
            }
            if (this.pathCommand == 3) {
                isPointVisible = this.testDrawLimits(coords, 3);
                if (this.debugPath) {
                    System.out.println("PathIterator.SEG_CUBICTO isPointVisible=" + isPointVisible);
                }
                if (isPointVisible && this.isPathSegmentVisible) {
                    this.bezierCurveTo(coords);
                }
                this.isPathSegmentVisible = isPointVisible;
            } else if (this.pathCommand == 1) {
                double[] lastPt = new double[]{this.previousPoint[0], this.previousPoint[1]};
                isPointVisible = this.testDrawLimits(coords, 1);
                if (this.debugPath) {
                    System.out.println("PathIterator.SEG_LINETO isPointVisible=" + isPointVisible + " isPathSegmentVisible=" + this.isPathSegmentVisible + ' ' + (int)coords[0] + ' ' + (int)coords[1]);
                }
                if (isPointVisible && this.isPathSegmentVisible) {
                    if (this.debugPath) {
                        System.out.println("pdf.lineTo(" + this.coordsToStringParam(coords, 2) + ')');
                    }
                    this.lineTo(coords);
                } else if (isPointVisible != this.isPathSegmentVisible) {
                    if (!this.isPathSegmentVisible) {
                        if (gs.getFillType() != 2) {
                            this.moveTo(this.entryPoint);
                            this.hasMoveTo = true;
                            if (this.debugPath) {
                                System.out.println("pdf.moveTo(" + this.coordsToStringParam(coords, 2));
                            }
                        } else {
                            if (!this.hasMoveTo && !cropBox.contains(lastPt[0], lastPt[1])) {
                                double cx = cropBox.x + cropBox.width;
                                double cy = cropBox.y + cropBox.height;
                                if (cx > this.lastInvisiblePoint[0]) {
                                    cx = cropBox.x;
                                }
                                if (this.lastInvisiblePoint[1] < (double)cropBox.y) {
                                    cy = cropBox.y;
                                } else if (cy < this.lastInvisiblePoint[1]) {
                                    cy = cropBox.y;
                                }
                                double[] cornerEntryPt = new double[]{cx, cy};
                                this.hasMoveTo = true;
                                this.moveTo(cornerEntryPt);
                                if (this.debugPath) {
                                    System.out.println("pdf.moveTo(" + this.coordsToStringParam(cornerEntryPt, 2));
                                }
                            }
                            this.lineTo(this.entryPoint);
                        }
                        this.lineTo(coords);
                        if (this.debugPath) {
                            System.out.println("pdf.lineTo(" + this.coordsToStringParam(coords, 2) + ");");
                        }
                        this.isPathSegmentVisible = true;
                    } else {
                        this.lineTo(this.exitPoint);
                        this.isPathSegmentVisible = false;
                        if (this.debugPath) {
                            System.out.println("pdf.lineTo(" + this.coordsToStringParam(this.exitPoint, 2) + ");");
                        }
                    }
                }
            } else if (this.pathCommand == 2) {
                if (this.debugPath) {
                    System.out.println("PathIterator.SEG_QUADTO");
                }
                if (this.testDrawLimits(coords, 2)) {
                    if (this.debugPath) {
                        System.out.println("pdf.quadraticCurveTo(" + this.coordsToStringParam(coords, 4));
                    }
                    this.quadraticCurveTo(coords);
                    this.isPathSegmentVisible = true;
                } else {
                    this.isPathSegmentVisible = false;
                }
            } else if (this.pathCommand == 0) {
                if (this.debugPath) {
                    System.out.println("PathIterator.SEG_MOVETO");
                }
                if (this.testDrawLimits(coords, 0)) {
                    this.isPathSegmentVisible = true;
                    if (this.debugPath) {
                        System.out.println("pdf.moveTo(" + this.coordsToStringParam(coords, 2) + ");");
                    }
                    this.hasMoveTo = true;
                    this.moveTo(coords);
                } else {
                    this.isPathSegmentVisible = false;
                }
            } else if (this.pathCommand == 4) {
                if (this.debugPath) {
                    System.out.println("pdf.closePath();");
                }
                this.closePath();
            }
            it.next();
        }
        if (this.pathCommands.size() == 1) {
            this.pathCommands.clear();
        } else {
            if (this.cmd == 21610 || !this.isPathSegmentVisible && gs.getFillType() != 2) {
                this.shapeIsOpen = false;
                this.finishShape();
                if (this.debugPath) {
                    System.out.println("pdf.closePath();");
                }
            }
            this.applyGraphicsStateToPath(gs);
        }
        if (this.cmd == 83 && segCount == 6 && this.clipBox != null && this.currentShape.getBounds().width > 10 && this.currentShape.getBounds().height > 10 && this.clipBox.x >= this.currentShape.getBounds().x && this.clipBox.x + this.clipBox.width <= this.currentShape.getBounds().x + this.currentShape.getBounds().width && this.clipBox.y >= this.currentShape.getBounds().y && this.clipBox.y + this.clipBox.height <= this.currentShape.getBounds().y + this.currentShape.getBounds().height) {
            this.pathCommands.clear();
            if (this.debugPath) {
                System.out.println("shape removed");
            }
        }
        this.checkShapeClosed();
        this.isFilled = false;
    }

    public void checkShapeClosed() {
    }

    protected void moveTo(double[] coords) {
    }

    protected void quadraticCurveTo(double[] coords) {
    }

    protected void lineTo(double[] coords) {
    }

    protected void closePath() {
    }

    protected void finishShape() {
    }

    protected void beginShape() {
    }

    protected void bezierCurveTo(double[] coords) {
    }

    private String setPrecision(double i, boolean isX) {
        String value = "";
        if (this.isFilled || this.evenStroke) {
            value = "" + (int)i;
        } else {
            int num = (int)i;
            value = value + num + ".5";
        }
        if (isX && i < this.minXcoord) {
            this.minXcoord = i;
        } else if (!isX && i < this.minYcoord) {
            this.minYcoord = i;
        }
        return value;
    }

    protected void applyGraphicsStateToPath(GraphicsState gs) {
    }

    protected static String determineLineCap(BasicStroke stroke) {
        String attribute;
        switch (stroke.getEndCap()) {
            case 1: {
                attribute = "round";
                break;
            }
            case 2: {
                attribute = "square";
                break;
            }
            default: {
                attribute = "butt";
            }
        }
        return attribute;
    }

    protected static String determineLineJoin(BasicStroke stroke) {
        String attribute;
        switch (stroke.getLineJoin()) {
            case 1: {
                attribute = "round";
                break;
            }
            case 2: {
                attribute = "bevel";
                break;
            }
            default: {
                attribute = "miter";
            }
        }
        return attribute;
    }

    private boolean testDrawLimits(double[] coords, int pathCommand) {
        boolean isCurrentPointVisible;
        double[] point;
        double y;
        double x;
        if (this.includeClip) {
            return true;
        }
        if (this.debugPath) {
            System.out.println("testDrawLimits coords[0] + coords[1]=" + (int)coords[0] + ' ' + (int)coords[1]);
        }
        int offset = OutputShape.getCoordOffset(pathCommand);
        if (this.debugPath) {
            System.out.println("crop=" + this.cropBox + " clip=" + this.clipBox);
        }
        Rectangle cropBox = this.cropBox;
        if (this.clipBox != null) {
            cropBox = cropBox.intersection(this.clipBox);
            if (this.debugPath) {
                System.out.println("merged crop=" + cropBox);
            }
        }
        if ((x = coords[offset]) > (double)(cropBox.x + 1)) {
            x -= 1.0;
        }
        if ((y = coords[offset + 1]) > (double)(cropBox.y + 1)) {
            y -= 1.0;
        }
        if (cropBox.contains((point = new double[]{x, y})[0], point[1])) {
            this.lastVisiblePoint = point;
            isCurrentPointVisible = true;
            if (this.debugPath) {
                System.out.println("Point visible in cropBox or clip");
            }
        } else {
            this.lastInvisiblePoint = point;
            isCurrentPointVisible = false;
            if (this.debugPath) {
                System.out.println("Point invisible " + (int)point[0] + ' ' + (int)point[1] + " crop=" + cropBox.getBounds());
            }
        }
        if (!isCurrentPointVisible && this.isPathSegmentVisible) {
            if (this.debugPath) {
                System.out.println("Case1 this point " + (int)x + ',' + (int)y + " invisible and isPathSegmentVisible");
            }
            this.findSwitchPoint(point, true);
        } else if (isCurrentPointVisible && !this.isPathSegmentVisible) {
            if (this.debugPath) {
                System.out.println("Case2 this point " + (int)x + ',' + (int)y + " visible and isPathSegment invisible");
            }
            this.findSwitchPoint(point, false);
        } else if (this.debugPath) {
            System.out.println("Case3 NOT COVERED isCurrentPointVisible=" + isCurrentPointVisible + " isPathSegmentVisible" + this.isPathSegmentVisible);
        }
        if (!isCurrentPointVisible && !cropBox.contains(this.previousPoint[0], this.previousPoint[1]) && pathCommand == 1) {
            if (this.debugPath) {
                System.out.println("checkTraversalPoints");
            }
            this.checkTraversalPoints(point, this.previousPoint, cropBox);
        }
        this.previousPoint = point;
        return isCurrentPointVisible;
    }

    private void checkTraversalPoints(double[] startPoint, double[] endPoint, Rectangle cropBox) {
        double m;
        boolean xTraversal = endPoint[0] < (double)cropBox.x && startPoint[0] > (double)(cropBox.x + cropBox.width) || startPoint[0] < (double)cropBox.x && endPoint[0] > (double)(cropBox.x + cropBox.width);
        boolean yTraversal = endPoint[1] < (double)cropBox.y && startPoint[1] > (double)(cropBox.y + cropBox.height) || startPoint[1] < (double)cropBox.y && endPoint[1] > (double)(cropBox.y + cropBox.height);
        boolean completeCropBoxMiss = OutputShape.isCompleteCropBoxMiss(startPoint, endPoint, cropBox);
        if (this.debugPath) {
            System.out.println("checkTraversalPoints xtrav=" + xTraversal + " yTrav=" + yTraversal + " completeCropBoxMiss=" + completeCropBoxMiss + ' ' + (endPoint[0] < (double)cropBox.x && startPoint[0] > (double)(cropBox.x + cropBox.width)));
            System.out.println("start=" + (int)startPoint[0] + ' ' + (int)startPoint[1] + "  end=" + (int)endPoint[0] + ' ' + (int)endPoint[1]);
        }
        if (!xTraversal && !yTraversal) {
            return;
        }
        double rawM = m = (endPoint[1] - startPoint[1]) / (endPoint[0] - startPoint[0]);
        if (Math.abs(endPoint[0] - startPoint[0]) < 1.0) {
            m = 0.0;
        }
        if (m < 0.001) {
            m = 0.0;
        }
        if (m == 0.0) {
            if (rawM < 0.0 && endPoint[0] < 0.0 && endPoint[0] < startPoint[0]) {
                this.exitPoint = OutputShape.calcCrossoverPoint(endPoint, cropBox, m, startPoint);
                this.entryPoint = OutputShape.calcCrossoverPoint(startPoint, cropBox, m, endPoint);
            } else {
                this.entryPoint = OutputShape.calcCrossoverPoint(endPoint, cropBox, m, startPoint);
                this.exitPoint = OutputShape.calcCrossoverPoint(startPoint, cropBox, m, endPoint);
            }
        } else {
            this.exitPoint = OutputShape.calcCrossoverPoint(endPoint, cropBox, m, startPoint);
            this.entryPoint = OutputShape.calcCrossoverPoint(startPoint, cropBox, m, endPoint);
        }
        if (this.debugPath) {
            System.out.println("entry=" + this.entryPoint[0] + ' ' + this.entryPoint[1] + " exit=" + this.exitPoint[0] + ' ' + this.exitPoint[1]);
            System.out.println("XXpdf.lineTo(" + this.coordsToStringParam(this.entryPoint, 2) + ");");
            System.out.println("XXpdf.lineTo(" + this.coordsToStringParam(this.exitPoint, 2) + "); hasMoveTo=" + this.hasMoveTo);
        }
        if (!this.hasMoveTo && endPoint[0] < 0.0 && startPoint[0] > this.entryPoint[0] && this.entryPoint[0] > this.exitPoint[0]) {
            double cx = cropBox.x + cropBox.width;
            double cy = cropBox.y + cropBox.height;
            if (cx > this.lastVisiblePoint[0]) {
                cx = cropBox.x;
            }
            if (cy < this.lastVisiblePoint[1]) {
                cy = cropBox.y;
            }
            double[] cornerEntryPt = new double[]{cx, cy};
            this.hasMoveTo = true;
            this.moveTo(cornerEntryPt);
            if (this.debugPath) {
                System.out.println("pdf.moveTo(" + this.coordsToStringParam(cornerEntryPt, 2));
            }
            this.lineTo(this.exitPoint);
            this.lineTo(this.entryPoint);
        } else {
            this.lineTo(this.entryPoint);
            this.lineTo(this.exitPoint);
        }
    }

    private static double[] calcCrossoverPoint(double[] pt, Rectangle cropBox, double m, double[] otherPt) {
        double x1 = 0.0;
        double y1 = 0.0;
        if (pt[1] < (double)cropBox.y || pt[1] > (double)(cropBox.y + cropBox.height)) {
            y1 = pt[1] < (double)cropBox.y ? (double)cropBox.y : (double)(cropBox.y + cropBox.height);
            x1 = m == 0.0 ? pt[0] : (y1 - pt[1]) / m + pt[0];
            if (x1 < (double)cropBox.x || x1 > (double)(cropBox.x + cropBox.width)) {
                x1 = x1 < (double)cropBox.x ? (double)cropBox.x : (double)(cropBox.x + cropBox.width);
                y1 = m * (x1 - pt[0]) + pt[1];
            }
        } else if ((pt[0] < (double)cropBox.x || pt[0] > (double)(cropBox.x + cropBox.width)) && ((y1 = m * ((x1 = pt[0] < (double)cropBox.x ? (double)cropBox.x : (double)(cropBox.x + cropBox.width)) - pt[0]) + pt[1]) < (double)cropBox.y || y1 > (double)(cropBox.y + cropBox.height))) {
            y1 = pt[1] < (double)cropBox.y ? (double)cropBox.y : (double)(cropBox.y + cropBox.height);
            x1 = (y1 - pt[1]) / m + pt[0];
        }
        return new double[]{x1, y1};
    }

    private void findSwitchPoint(double[] point, boolean exit) {
        double tan;
        double[] lastPoint;
        double[] switchPoint = new double[2];
        double[] dArray = lastPoint = exit ? this.lastVisiblePoint : this.lastInvisiblePoint;
        if (this.debugPath) {
            if (exit) {
                System.out.println("Find point of exit lastPoint=" + (int)lastPoint[0] + ' ' + (int)lastPoint[1] + " current=" + (int)point[0] + ' ' + (int)point[1]);
            } else {
                System.out.println("Find point of entry lastPoint=" + (int)lastPoint[0] + ' ' + (int)lastPoint[1] + " current=" + (int)point[0] + ' ' + (int)point[1]);
            }
        }
        if (!exit) {
            double[] tmp = point;
            point = lastPoint;
            lastPoint = tmp;
        }
        double xSide = point[0] - lastPoint[0];
        double ySide = point[1] - lastPoint[1];
        boolean xFound = false;
        boolean yFound = false;
        if (this.clipBox != null && point[0] >= (double)(this.clipBox.width + this.clipBox.x)) {
            switchPoint[0] = this.clipBox.width + this.clipBox.x;
            xFound = true;
        } else if (point[0] >= (double)(this.cropBox.width + this.cropBox.x)) {
            switchPoint[0] = this.cropBox.width + this.cropBox.x;
            xFound = true;
        } else if (this.clipBox != null && point[0] < (double)this.clipBox.x) {
            switchPoint[0] = this.clipBox.x;
            xFound = true;
        } else if (point[0] < (double)this.cropBox.x) {
            switchPoint[0] = this.cropBox.x;
            xFound = true;
        }
        if (this.clipBox != null && point[1] > (double)(this.clipBox.height + this.clipBox.y)) {
            switchPoint[1] = this.clipBox.height + this.clipBox.y;
            yFound = true;
        } else if (point[1] > (double)(this.cropBox.height + this.cropBox.y)) {
            switchPoint[1] = this.cropBox.height + this.cropBox.y;
            yFound = true;
        } else if (this.clipBox != null && point[1] < (double)this.clipBox.y) {
            switchPoint[1] = this.clipBox.y;
            yFound = true;
        } else if (point[1] < (double)this.cropBox.y) {
            switchPoint[1] = this.cropBox.y;
            yFound = true;
        }
        if (yFound) {
            if (xSide == 0.0) {
                switchPoint[0] = point[0];
            } else {
                tan = xSide / ySide;
                if (ySide == 0.0) {
                    tan = 1.0;
                }
                double distanceToCropY = switchPoint[1] - point[1];
                switchPoint[0] = point[0] + tan * distanceToCropY;
            }
        }
        if (xFound) {
            if (ySide == 0.0) {
                switchPoint[1] = point[1];
            } else {
                tan = ySide / xSide;
                double distanceToCropX = switchPoint[0] - point[0];
                switchPoint[1] = point[1] + tan * distanceToCropX;
            }
        }
        if (exit) {
            this.exitPoint = switchPoint;
            if (this.debugPath) {
                System.out.println("returns exit=" + (int)switchPoint[0] + ' ' + (int)switchPoint[1]);
            }
        } else {
            this.entryPoint = switchPoint;
            if (this.debugPath) {
                System.out.println("returns entry=" + (int)switchPoint[0] + ' ' + (int)switchPoint[1]);
            }
        }
    }

    private boolean checkLargeBox(double[] coords, int pathCommand) {
        boolean isDrawn = false;
        if (this.debugPath) {
            System.out.println("check large " + (int)coords[0] + ' ' + (int)coords[1]);
        }
        if (!(this.isLargeBox || pathCommand == 1 && pathCommand == 0)) {
            return false;
        }
        double px = coords[OutputShape.getCoordOffset(pathCommand)];
        double py = coords[OutputShape.getCoordOffset(pathCommand) + 1];
        double[] adjustedCords = this.correctCoords(new double[]{px, py});
        px = adjustedCords[0];
        py = adjustedCords[1];
        Point point = new Point((int)px, (int)py);
        if (this.largeBox.isEmpty()) {
            this.largeBox.add(point);
        } else {
            Point2D last = this.largeBox.get(this.largeBox.size() - 1);
            double xSide = last.getX() - point.getX();
            double ySide = last.getY() - point.getY();
            if (this.largeBox.size() == 1) {
                this.largeBoxSideAlternation = ySide != 0.0 ? xSide / ySide != 0.0 : true;
            }
            if (xSide / ySide == 0.0 || ySide / xSide == 0.0) {
                boolean currentSide;
                boolean bl = currentSide = xSide / ySide == 0.0;
                if (this.largeBox.size() > 1 || currentSide != this.largeBoxSideAlternation) {
                    this.largeBox.add(point);
                    this.largeBoxSideAlternation = xSide / ySide == 0.0;
                }
            } else if (!point.equals(this.largeBox.get(this.largeBox.size() - 1))) {
                this.isLargeBox = false;
                return false;
            }
            if (this.largeBox.size() >= 4 && this.isLargerThanCropBox()) {
                this.drawCropBox();
                isDrawn = true;
            }
        }
        return isDrawn;
    }

    private boolean isLargerThanCropBox() {
        int shortestSide;
        if (!this.isLargeBox || this.cropBox == null) {
            return false;
        }
        Point2D x = this.largeBox.get(this.largeBox.size() - 4);
        Point2D y = this.largeBox.get(this.largeBox.size() - 3);
        Point2D z = this.largeBox.get(this.largeBox.size() - 2);
        Point2D w = this.largeBox.get(this.largeBox.size() - 1);
        int n = shortestSide = this.cropBox.width < this.cropBox.height ? this.cropBox.width : this.cropBox.height;
        if (x.distance(y) < (double)shortestSide || y.distance(z) < (double)shortestSide || z.distance(w) < (double)shortestSide) {
            return false;
        }
        int outsideCount = 0;
        if (!this.cropBox.contains(x.getX(), x.getY())) {
            ++outsideCount;
        }
        if (!this.cropBox.contains(y.getX(), y.getY())) {
            ++outsideCount;
        }
        if (!this.cropBox.contains(z.getX(), z.getY())) {
            ++outsideCount;
        }
        if (!this.cropBox.contains(w.getX(), w.getY())) {
            ++outsideCount;
        }
        if (outsideCount <= 2) {
            return false;
        }
        HashSet<Point2D> points = new HashSet<Point2D>();
        points.add(x);
        points.add(y);
        points.add(z);
        points.add(w);
        outsideCount = 0;
        for (int hOffset = -1; hOffset <= 1; ++hOffset) {
            for (int wOffset = -1; wOffset <= 1; ++wOffset) {
                if (hOffset == 0 && wOffset == 0) continue;
                Rectangle outside = new Rectangle(this.cropBox);
                outside.translate(wOffset * this.cropBox.width, hOffset * this.cropBox.height);
                if (!OutputShape.doesPointSetCollide(points, outside)) continue;
                ++outsideCount;
            }
        }
        return outsideCount >= 3;
    }

    private static boolean doesPointSetCollide(Set<Point2D> points, Rectangle rect) {
        for (Point2D point : points) {
            Point2D pt = point;
            if (!rect.contains(pt)) continue;
            return true;
        }
        return false;
    }

    protected void drawCropBox() {
    }

    private double getClosestCropEdgeX(double x) {
        return x < (double)(this.cropBox.x + this.cropBox.width / 2) ? (double)this.cropBox.x : (double)(this.cropBox.x + this.cropBox.width);
    }

    private double getClosestCropEdgeY(double y) {
        return y < (double)(this.cropBox.y + this.cropBox.height / 2) ? (double)this.cropBox.y : (double)(this.cropBox.y + this.cropBox.height);
    }

    private double[] correctCoords(double[] coords) {
        if (this.cropBox != null) {
            int offset;
            switch (this.pathCommand) {
                case 3: {
                    offset = 4;
                    break;
                }
                case 2: {
                    offset = 2;
                    break;
                }
                default: {
                    offset = 0;
                }
            }
            if (offset > coords.length) {
                offset = coords.length - 2;
            }
            for (int i = 0; i < offset + 2; i += 2) {
                coords[i + 1] = coords[i + 1] + (double)this.adjustY;
                coords[i] = coords[i] - this.midPoint.getX() + (double)this.minX;
                int n = i;
                coords[n] = coords[n] + (double)(this.cropBox.width / 2);
                coords[i + 1] = coords[i + 1] - this.midPoint.getY() + (double)this.minY;
                coords[i + 1] = 0.0 - coords[i + 1];
                int n2 = i + 1;
                coords[n2] = coords[n2] + (double)(this.cropBox.height / 2);
            }
        }
        return coords;
    }

    private static int getCoordOffset(int pathCommand) {
        int offset;
        switch (pathCommand) {
            case 3: {
                offset = 4;
                break;
            }
            case 2: {
                offset = 2;
                break;
            }
            default: {
                offset = 0;
            }
        }
        return offset;
    }

    private static boolean isCompleteCropBoxMiss(double[] start, double[] end, Rectangle cropBox) {
        int xLimMin = cropBox.x;
        int xLimMax = xLimMin + cropBox.width;
        int yLimMin = cropBox.y;
        int yLimMax = xLimMax + cropBox.height;
        return (start[0] < (double)xLimMin && end[0] < (double)xLimMin || start[0] > (double)xLimMax && end[0] > (double)xLimMax) && (start[1] < (double)yLimMin && end[1] < (double)yLimMin || start[1] > (double)yLimMax && end[1] > (double)yLimMax);
    }

    protected String coordsToStringParam(double[] coords, int count) {
        int size = coords.length;
        double[] copy = new double[size];
        System.arraycopy(coords, 0, copy, 0, size);
        coords = this.correctCoords(copy);
        return this.convertCoords(coords, count);
    }

    protected String convertCoords(double[] coords, int count) {
        String result = "";
        int cropBoxW = 0;
        int cropBoxH = 0;
        if (this.cropBox != null) {
            cropBoxW = this.cropBox.width;
            cropBoxH = this.cropBox.height;
        }
        switch (this.pageRotation) {
            case 90: {
                for (int i = 0; i < count; i += 2) {
                    if (i != 0) {
                        result = result + ",";
                    }
                    if (this.ctm[0][0] == 0.0f && this.ctm[1][1] == 0.0f && this.ctm[0][1] > 0.0f && (this.ctm[1][0] < 0.0f || (double)Math.abs(this.ctm[1][0]) < 0.5)) {
                        result = result + this.setPrecision(((double)cropBoxH - coords[i + 1]) * (double)this.scaling, false);
                        result = result + ",";
                        result = result + this.setPrecision(coords[i] * (double)this.scaling, (i & 1) != 1);
                        continue;
                    }
                    result = result + this.setPrecision(((double)cropBoxH - coords[i + 1]) * (double)this.scaling, false);
                    result = result + ",";
                    result = result + this.setPrecision(coords[i] * (double)this.scaling, (i & 1) != 1);
                }
                break;
            }
            case 180: {
                for (int i = 0; i < count; i += 2) {
                    if (i != 0) {
                        result = result + ",";
                    }
                    result = result + this.setPrecision(((double)cropBoxW - coords[i]) * (double)this.scaling, true);
                    if (i + 1 != 0) {
                        result = result + ",";
                    }
                    result = result + this.setPrecision(((double)cropBoxH - coords[i + 1]) * (double)this.scaling, false);
                }
                break;
            }
            case 270: {
                for (int i = 0; i < count; i += 2) {
                    if (i != 0) {
                        result = result + ",";
                    }
                    if (this.ctm[0][0] == 0.0f && this.ctm[1][1] == 0.0f && this.ctm[0][1] > 0.0f && (this.ctm[1][0] < 0.0f || (double)Math.abs(this.ctm[1][0]) < 0.5)) {
                        result = result + this.setPrecision(((double)cropBoxH - coords[i + 1]) * (double)this.scaling, false);
                        result = result + ",";
                        result = result + this.setPrecision(coords[i] * (double)this.scaling, (i & 1) != 1);
                        continue;
                    }
                    result = result + this.setPrecision(coords[i + 1] * (double)this.scaling, false);
                    result = result + ",";
                    result = result + this.setPrecision(((double)cropBoxW - coords[i]) * (double)this.scaling, (i & 1) != 1);
                }
                break;
            }
            default: {
                for (int i = 0; i < count; i += 2) {
                    if (i != 0) {
                        result = result + ",";
                    }
                    result = result + this.setPrecision(coords[i] * (double)this.scaling, true);
                    if (i + 1 != 0) {
                        result = result + ",";
                    }
                    result = result + this.setPrecision(coords[i + 1] * (double)this.scaling, false);
                }
            }
        }
        return result;
    }

    public static String rgbToCSSColor(int raw) {
        int r = raw >> 16 & 0xFF;
        int g = raw >> 8 & 0xFF;
        int b = raw & 0xFF;
        return "rgb(" + r + ',' + g + ',' + b + ')';
    }

    public String getContent() {
        int size = this.pathCommands.size();
        StringBuilder result = new StringBuilder(size * 15);
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                result.append('\t');
            }
            result.append(this.pathCommands.get(i));
            if (i == size - 1) continue;
            result.append('\n');
        }
        return result.toString();
    }

    public boolean isEmpty() {
        return this.pathCommands.isEmpty();
    }

    public int getShapeColor() {
        return this.currentColor;
    }

    public double getMinXcoord() {
        return this.minXcoord;
    }

    public double getMinYcoord() {
        return this.minYcoord;
    }
}

