/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.Color;
import java.util.Map;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.io.ObjectStore;
import org.jpedal.render.SwingDisplay;
import org.jpedal.render.T3Renderer;

public class T3Display
extends SwingDisplay
implements T3Renderer {
    public T3Display(int pageNumber, ObjectStore newObjectRef, boolean isPrinting) {
        super(pageNumber, newObjectRef, isPrinting);
    }

    public T3Display(int pageNumber, boolean addBackground, int defaultSize, ObjectStore newObjectRef) {
        this.pageNumber = pageNumber;
        this.objectStoreRef = newObjectRef;
        this.addBackground = addBackground;
        this.setupArrays(defaultSize);
    }

    public T3Display(byte[] dvr, Map map) {
        super(dvr, map);
    }

    @Override
    public void setOptimisedRotation(boolean value) {
        this.optimisedTurnCode = value;
    }

    @Override
    public void setType3Glyph(String pKey) {
        this.rawKey = pKey;
        this.isType3Font = true;
    }

    @Override
    public void lockColors(PdfPaint strokePaint, PdfPaint nonstrokePaint, boolean lockColour) {
        this.colorsLocked = lockColour;
        Color strokeColor = Color.white;
        Color nonstrokeColor = Color.white;
        if (strokePaint != null && !strokePaint.isPattern()) {
            strokeColor = (Color)((Object)strokePaint);
        }
        this.strokeCol = new PdfColor(strokeColor.getRed(), strokeColor.getGreen(), strokeColor.getBlue());
        if (!nonstrokePaint.isPattern()) {
            nonstrokeColor = (Color)((Object)nonstrokePaint);
        }
        this.fillCol = new PdfColor(nonstrokeColor.getRed(), nonstrokeColor.getGreen(), nonstrokeColor.getBlue());
    }

    @Override
    public String toString() {
        return "T3Display: " + super.toString();
    }
}

