/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.PdfDecoder;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.external.ImageHandler;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.images.SamplingFactory;
import org.jpedal.io.ErrorTracker;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.TextState;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FontObject;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.Cmd;
import org.jpedal.parser.ColorCommands;
import org.jpedal.parser.CommandParser;
import org.jpedal.parser.ImageCommands;
import org.jpedal.parser.ImageDecoder;
import org.jpedal.parser.LayerDecoder;
import org.jpedal.parser.PdfFontFactory;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.ShadingCommands;
import org.jpedal.parser.ShapeCommands;
import org.jpedal.parser.T3Decoder;
import org.jpedal.parser.TextDecoder;
import org.jpedal.render.BaseDisplay;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;

public class PdfStreamDecoder
extends BaseDecoder {
    protected GraphicsState newGS = null;
    protected byte[] pageStream = null;
    PdfLayerList layers;
    protected boolean getSamplingOnly = false;
    TextState currentTextState = new TextState();
    private Map shadingColorspacesObjects = new HashMap(50);
    private boolean isStackInitialised = false;
    private Vector_Object graphicsStateStack;
    private Vector_Object strokeColorStateStack;
    private Vector_Object nonstrokeColorStateStack;
    private Vector_Object textStateStack;
    private boolean isTTHintingRequired = false;
    private Vector_Int textDirections = new Vector_Int();
    private Vector_Rectangle textAreas = new Vector_Rectangle();
    public boolean ignoreColors = false;
    int lastDataPointer = -1;
    private T3Decoder t3Decoder = null;
    private boolean removeRenderImages = false;
    private boolean textColorExtracted = false;
    private boolean colorExtracted = false;
    private boolean textExtracted = true;
    private boolean renderText = false;
    private boolean isFlattenedForm = false;
    private float flattenX = 0.0f;
    private float flattenY = 0.0f;
    private String imagesInFile = null;
    public static float currentThreshold = 0.595f;
    private boolean flattenXFormToImage = false;
    private boolean requestTimeout = false;
    private int timeoutInterval = -1;
    protected ImageHandler customImageHandler = null;
    private PdfFontFactory pdfFontFactory;
    private boolean isXMLExtraction = false;
    private StatusBar statusBar = null;
    private boolean markedContentExtracted = false;
    private PdfData pdfData = new PdfData();
    private PdfImageData pdfImages = new PdfImageData();
    protected static String indent = "";
    protected boolean isDataValid = true;
    private PdfFont currentFontData;
    protected boolean useHiResImageForDisplay = false;
    protected ObjectStore objectStoreStreamRef;
    private String formName = "";
    protected boolean isType3Font;
    public static boolean useTextPrintingForNonEmbeddedFonts = false;
    private boolean isTimeout = false;
    boolean isPrinting = false;
    private static final float[] matches;

    public PdfStreamDecoder(PdfObjectReader currentPdfFile) {
        this.init(currentPdfFile);
    }

    public PdfStreamDecoder(PdfObjectReader currentPdfFile, boolean useHiResImageForDisplay, PdfLayerList layers) {
        if (layers != null) {
            this.layers = layers;
        }
        this.init(currentPdfFile);
    }

    private void init(PdfObjectReader currentPdfFile) {
        this.cache = new PdfObjectCache();
        this.gs = new GraphicsState();
        this.layerDecoder = new LayerDecoder();
        this.errorTracker = new ErrorTracker();
        this.pageData = new PdfPageData();
        StandardFonts.checkLoaded(1);
        StandardFonts.checkLoaded(0);
        this.currentPdfFile = currentPdfFile;
        this.pdfFontFactory = new PdfFontFactory(currentPdfFile);
    }

    public final T3Size decodePageContent(GraphicsState newGS, byte[] pageStream) throws PdfException {
        this.newGS = newGS;
        this.pageStream = pageStream;
        return this.decodePageContent(null);
    }

    public T3Size decodePageContent(PdfObject pdfObject) throws PdfException {
        try {
            this.imagesProcessedFully = true;
            this.imageCount = 0;
            this.isTimeout = false;
            this.layerDecoder.setPdfLayerList(this.layers);
            this.imagesInFile = null;
            if (!this.renderDirectly && this.statusBar != null) {
                this.statusBar.percentageDone = 0.0f;
            }
            this.gs = this.newGS != null ? this.newGS : new GraphicsState(0, 0);
            if (this.renderPage) {
                if (this.current == null) {
                    throw new PdfException("DynamicVectorRenderer not setup PdfStreamDecoder setStore(...) should be called");
                }
                this.current.drawClip(this.gs, this.defaultClip, false);
                this.current.paintBackground(new Rectangle(this.pageData.getCropBoxX(this.pageNum), this.pageData.getCropBoxY(this.pageNum), this.pageData.getCropBoxWidth(this.pageNum), this.pageData.getCropBoxHeight(this.pageNum)));
            }
            byte[][] pageContents = null;
            if (pdfObject != null) {
                pageContents = pdfObject.getKeyArray(1216184967);
                this.isDataValid = pdfObject.streamMayBeCorrupt();
            }
            this.cache.pageGroupingObj = pdfObject == null ? null : pdfObject.getDictionary(1111442775);
            byte[] b_data = pdfObject != null && pageContents == null ? this.currentPdfFile.readStream(pdfObject, true, true, false, false, false, pdfObject.getCacheName(this.currentPdfFile.getObjectReader())) : (this.pageStream != null ? this.pageStream : this.currentPdfFile.getObjectReader().readPageIntoStream(pdfObject));
            this.lastDataPointer = -1;
            if (b_data != null && b_data.length > 0) {
                this.decodeStreamIntoObjects(b_data, false);
            }
            if (!this.isType3Font) {
                this.cache.resetFonts();
            }
            T3Size t3 = new T3Size();
            if (this.t3Decoder != null) {
                t3.x = this.t3Decoder.T3maxWidth;
                t3.y = this.t3Decoder.T3maxHeight;
                this.ignoreColors = this.t3Decoder.ignoreColors;
                this.t3Decoder = null;
            }
            return t3;
        }
        catch (Error err) {
            if (ExternalHandlers.throwMissingCIDError && err.getMessage().contains("kochi")) {
                throw err;
            }
            this.errorTracker.addPageFailureMessage("Problem decoding page " + err);
            return null;
        }
    }

    public void drawFlattenedForm(PdfObject form) throws PdfException {
        String defaultState;
        this.isFlattenedForm = true;
        boolean[] characteristic = ((FormObject)form).getCharacteristics();
        if (characteristic[0] || characteristic[1] || characteristic[5] || !form.getBoolean(524301630) && form.getParameterConstant(1147962727) == 1061176672) {
            return;
        }
        PdfObject imgObj = null;
        PdfObject APobjN = form.getDictionary(4384).getDictionary(30);
        Map otherValues = new HashMap();
        if (APobjN != null) {
            otherValues = APobjN.getOtherDictionaries();
        }
        if ((defaultState = form.getName(4387)) != null && defaultState.equals(((FormObject)form).getNormalOnState())) {
            if (APobjN.getDictionary(7998) != null) {
                imgObj = APobjN.getDictionary(7998);
            } else if (APobjN.getDictionary(2045494) != null && defaultState != null && defaultState.equals("Off")) {
                imgObj = APobjN.getDictionary(2045494);
            } else if (otherValues != null && defaultState != null) {
                imgObj = (PdfObject)otherValues.get(defaultState);
            } else if (otherValues != null && !otherValues.isEmpty()) {
                PdfObject val;
                Iterator keys = otherValues.keySet().iterator();
                String key = (String)keys.next();
                imgObj = val = (PdfObject)otherValues.get(key);
            }
        } else if (APobjN != null || form.getDictionary(7451).getDictionary(25) != null) {
            if (APobjN != null && APobjN.getDictionary(2045494) != null) {
                imgObj = APobjN.getDictionary(2045494);
            } else if (form.getDictionary(7451).getDictionary(25) != null && form.getDictionary(7451).getDictionary(6422) == null) {
                imgObj = form.getDictionary(7451).getDictionary(25);
            } else if (APobjN != null && APobjN.getDecodedStream() != null) {
                imgObj = APobjN;
            }
        }
        if (imgObj == null) {
            return;
        }
        this.currentPdfFile.checkResolved(imgObj);
        byte[] formData = imgObj.getDecodedStream();
        PdfObject resources = imgObj.getDictionary(2004251818);
        this.readResources(resources, false);
        float[] BBox = form.getFloatArray(573911876);
        if (this.isFlattenedForm) {
            this.flattenX = BBox[0];
            this.flattenY = BBox[1];
        }
        float[] matrix = imgObj.getFloatArray(1145198201);
        int pageRotation = this.pageData.getRotation(this.pageNum);
        float x = BBox[0];
        float y = BBox[1];
        Area newClip = null;
        if (matrix != null) {
            float[] BoundingBox;
            switch (pageRotation) {
                case 90: {
                    x = BBox[2];
                    if (!(matrix[4] < 0.0f)) break;
                    x = BBox[0] + matrix[4];
                    break;
                }
                default: {
                    x = BBox[0] + matrix[4];
                    newClip = new Area(new Rectangle((int)BBox[0], (int)BBox[1], (int)BBox[2], (int)BBox[3]));
                }
            }
            y = BBox[1] + matrix[5];
            float xScale = 1.0f;
            float yScale = 1.0f;
            PdfObject temp = form.getDictionary(4384);
            if (temp != null && (temp = temp.getDictionary(30)) != null && (BoundingBox = temp.getFloatArray(303185736)) != null && BBox[0] != BoundingBox[0] && BBox[1] != BoundingBox[1] && BBox[2] != BoundingBox[2] && BBox[3] != BoundingBox[3] && matrix[0] * matrix[3] == 1.0f && matrix[1] * matrix[2] == 0.0f) {
                float bbw = BBox[2] - BBox[0];
                float bbh = BBox[3] - BBox[1];
                float imw = BoundingBox[2] - BoundingBox[0];
                float imh = BoundingBox[3] - BoundingBox[1];
                if ((int)bbw != (int)imw) {
                    xScale = bbw / imw;
                    x -= imw * xScale;
                }
                if ((int)bbh != (int)imh) {
                    yScale = bbh / imh;
                }
            }
            this.gs.CTM = new float[][]{{matrix[0] * xScale, matrix[1], 0.0f}, {matrix[2], matrix[3] * yScale, 0.0f}, {x, y, 1.0f}};
        } else {
            this.gs.CTM = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {x, y, 1.0f}};
            newClip = new Area(new Rectangle((int)BBox[0], (int)BBox[1], (int)BBox[2], (int)BBox[3]));
        }
        if (newClip != null) {
            this.gs.updateClip(new Area(newClip));
        }
        this.current.drawClip(this.gs, this.defaultClip, false);
        this.setBooleanValue(24, this.isFlattenedForm);
        this.decodeStreamIntoObjects(formData, false);
        this.gs.updateClip(null);
        this.current.drawClip(this.gs, null, true);
    }

    @Override
    public void setObjectValue(int key, Object obj) {
        switch (key) {
            case -9: {
                this.setName((String)obj);
                break;
            }
            case 23: {
                boolean isOCR;
                this.current = (DynamicVectorRenderer)obj;
                boolean bl = isOCR = (this.renderMode & 0x20) == 32;
                if (!isOCR || this.current == null) break;
                this.current.setOCR(true);
                break;
            }
            case -18: {
                this.pageData = (PdfPageData)obj;
                if (!this.textColorExtracted) break;
                this.pdfData.enableTextColorDataExtraction();
                break;
            }
            case -3: {
                this.statusBar = (StatusBar)obj;
                break;
            }
            case -4: {
                this.layers = (PdfLayerList)obj;
                break;
            }
            case -6: {
                this.customImageHandler = (ImageHandler)obj;
                if (this.customImageHandler == null || this.current == null) break;
                this.current.setCustomImageHandler(this.customImageHandler);
                break;
            }
            case -7: {
                this.renderDirectly = true;
                Graphics2D g2 = (Graphics2D)obj;
                this.defaultClip = g2.getClip();
                break;
            }
            case -8: {
                this.objectStoreStreamRef = (ObjectStore)obj;
                this.current = new SwingDisplay(this.pageNum, this.objectStoreStreamRef, false);
                this.current.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
                if (this.customImageHandler == null || this.current == null) break;
                this.current.setCustomImageHandler(this.customImageHandler);
                break;
            }
            default: {
                super.setObjectValue(key, obj);
            }
        }
    }

    @Override
    public void setBooleanValue(int key, boolean value) {
        switch (key) {
            case 25: {
                this.isPrinting = value;
                break;
            }
            case -16: {
                this.flattenXFormToImage = value;
                break;
            }
            default: {
                super.setBooleanValue(key, value);
            }
        }
    }

    public void setDefaultColors(PdfPaint strokeCol, PdfPaint nonstrokeCol) {
        this.gs.strokeColorSpace.setColor(strokeCol);
        this.gs.nonstrokeColorSpace.setColor(nonstrokeCol);
        this.gs.setStrokeColor(strokeCol);
        this.gs.setNonstrokeColor(nonstrokeCol);
    }

    @Override
    public Object getObjectValue(int key) {
        switch (key) {
            case -19: {
                if (PdfDecoder.embedWidthData) {
                    this.pdfData.widthIsEmbedded();
                }
                this.pdfData.maxX = this.pageData.getMediaBoxWidth(this.pageNum);
                this.pdfData.maxY = this.pageData.getMediaBoxHeight(this.pageNum);
                return this.pdfData;
            }
            case -20: {
                return this.pdfImages;
            }
            case -21: {
                return this.textAreas;
            }
            case 22: {
                return this.textDirections;
            }
            case 23: {
                return this.current;
            }
            case 373243460: {
                return this.pdfFontFactory.getFontsInFile();
            }
            case 1026635598: {
                return this.imagesInFile;
            }
            case 4: {
                return this.pdfFontFactory.getnonEmbeddedCIDFonts();
            }
            case 1: {
                return this.cache.iterator(1);
            }
        }
        return super.getObjectValue(key);
    }

    public final void readResources(PdfObject Resources, boolean resetList) throws PdfException {
        if (resetList) {
            this.pdfFontFactory.resetfontsInFile();
        }
        this.cache.readResources(Resources, resetList, this.currentPdfFile);
    }

    public String decodeStreamIntoObjects(byte[] stream, boolean returnText) {
        TextDecoder textDecoder;
        CommandParser parser;
        if (stream.length == 0) {
            return null;
        }
        int startInlineStream = 0;
        long startTime = System.currentTimeMillis();
        this.parser = parser = new CommandParser(stream);
        int streamSize = stream.length;
        int dataPointer = 0;
        int startCommand = 0;
        String csInUse = "";
        String CSInUse = "";
        PdfShape currentDrawShape = new PdfShape();
        if (this.markedContentExtracted) {
            textDecoder = new TextDecoder(this.layerDecoder);
        } else {
            textDecoder = new TextDecoder(this.pdfData, this.isXMLExtraction, this.layerDecoder);
            textDecoder.setReturnText(returnText);
        }
        if (this.errorTracker != null) {
            textDecoder.setHandlerValue(23, this.errorTracker);
        }
        textDecoder.setParameters(this.isPageContent, this.renderPage, this.renderMode, this.extractionMode, this.isPrinting);
        textDecoder.setFileHandler(this.currentPdfFile);
        textDecoder.setIntValue(19, this.formLevel);
        textDecoder.setIntValue(20, this.textPrint);
        textDecoder.setBooleanValue(19, this.renderDirectly);
        textDecoder.setBooleanValue(21, this.generateGlyphOnRender);
        textDecoder.setRenderer(this.current);
        if (!this.renderDirectly && this.statusBar != null) {
            this.statusBar.percentageDone = 0.0f;
            this.statusBar.resetStatus("stream");
        }
        do {
            block93: {
                if (this.requestTimeout || this.timeoutInterval != -1 && System.currentTimeMillis() - startTime > (long)this.timeoutInterval) {
                    this.requestTimeout = false;
                    this.timeoutInterval = -1;
                    this.isTimeout = true;
                    break;
                }
                if (!this.renderDirectly && this.statusBar != null) {
                    this.statusBar.percentageDone = 90 * dataPointer / streamSize;
                }
                dataPointer = parser.getCommandValues(dataPointer, streamSize, this.tokenNumber);
                int commandID = parser.getCommandID();
                if (dataPointer >= 0) continue;
                dataPointer = -dataPointer;
                try {
                    int commandType = Cmd.getCommandType(commandID);
                    block1 : switch (commandType) {
                        case 0: {
                            Object fontID;
                            if (commandID != 4541763 && !this.layerDecoder.isLayerVisible() || this.getSamplingOnly || !this.renderText && !this.textExtracted) break;
                            textDecoder.setCommands(parser);
                            textDecoder.setGS(this.gs);
                            textDecoder.setTextState(this.currentTextState);
                            textDecoder.setIntValue(18, this.tokenNumber);
                            if (this.renderPage && commandID == 16980) {
                                this.current.drawClip(this.gs, this.defaultClip, true);
                                this.current.drawTR(2);
                                this.current.flagCommand(16980, this.tokenNumber);
                            }
                            if (commandID == 21610 || commandID == 21578 || commandID == 39 || commandID == 34) {
                                PdfFont restoredFont;
                                this.current.flagCommand(21610, this.tokenNumber);
                                if (this.currentTextState.hasFontChanged() && (restoredFont = this.resolveFont((String)(fontID = this.currentTextState.getFontID()))) != null) {
                                    this.currentFontData = restoredFont;
                                    this.current.drawFontBounds(this.currentFontData.getBoundingBox());
                                }
                                if (this.currentFontData == null) {
                                    this.currentFontData = new PdfFont(this.currentPdfFile);
                                    this.currentFontData.getGlyphData().logicalfontName = StandardFonts.expandName(this.currentTextState.getFontID());
                                }
                                if (this.currentTextState.hasFontChanged()) {
                                    this.currentTextState.setFontChanged(false);
                                }
                                textDecoder.setFont(this.currentFontData);
                            }
                            dataPointer = textDecoder.processToken(this.currentTextState, commandID, startCommand, dataPointer);
                            break;
                        }
                        case 2: {
                            Object fontID;
                            if (this.getSamplingOnly) break;
                            switch (commandID) {
                                case 66: {
                                    if (this.removeRenderImages) break;
                                    fontID = ShapeCommands.B(false, false, this.gs, this.formLevel, currentDrawShape, this.layerDecoder, this.renderPage, this.current);
                                    break block1;
                                }
                                case 98: {
                                    if (this.removeRenderImages) break;
                                    fontID = ShapeCommands.B(false, true, this.gs, this.formLevel, currentDrawShape, this.layerDecoder, this.renderPage, this.current);
                                    break block1;
                                }
                                case 25130: {
                                    if (this.removeRenderImages) break;
                                    fontID = ShapeCommands.B(true, true, this.gs, this.formLevel, currentDrawShape, this.layerDecoder, this.renderPage, this.current);
                                    break block1;
                                }
                                case 16938: {
                                    if (this.removeRenderImages) break;
                                    fontID = ShapeCommands.B(true, false, this.gs, this.formLevel, currentDrawShape, this.layerDecoder, this.renderPage, this.current);
                                    break block1;
                                }
                                case 99: {
                                    float x3 = parser.parseFloat(1);
                                    float y3 = parser.parseFloat(0);
                                    float x2 = parser.parseFloat(3);
                                    float y2 = parser.parseFloat(2);
                                    float x = parser.parseFloat(5);
                                    float y = parser.parseFloat(4);
                                    currentDrawShape.addBezierCurveC(x, y, x2, y2, x3, y3);
                                    break block1;
                                }
                                case 100: {
                                    ShapeCommands.D(parser, this.gs);
                                    break block1;
                                }
                                case 70: {
                                    if (this.removeRenderImages) break;
                                    this.F(false, this.formLevel, currentDrawShape);
                                    break block1;
                                }
                                case 102: {
                                    if (this.removeRenderImages) break;
                                    this.F(false, this.formLevel, currentDrawShape);
                                    break block1;
                                }
                                case 17962: {
                                    if (this.removeRenderImages) break;
                                    this.F(true, this.formLevel, currentDrawShape);
                                    break block1;
                                }
                                case 26154: {
                                    if (this.removeRenderImages) break;
                                    this.F(true, this.formLevel, currentDrawShape);
                                    break block1;
                                }
                                case 104: {
                                    currentDrawShape.closeShape();
                                    break block1;
                                }
                                case 74: {
                                    ShapeCommands.J(false, parser.parseInt(0), this.gs);
                                    break block1;
                                }
                                case 106: {
                                    ShapeCommands.J(true, parser.parseInt(0), this.gs);
                                    break block1;
                                }
                                case 108: {
                                    currentDrawShape.lineTo(parser.parseFloat(1), parser.parseFloat(0));
                                    break block1;
                                }
                                case 77: {
                                    this.gs.setMitreLimit((int)parser.parseFloat(0));
                                    break block1;
                                }
                                case 109: {
                                    currentDrawShape.moveTo(parser.parseFloat(1), parser.parseFloat(0));
                                    break block1;
                                }
                                case 110: {
                                    ShapeCommands.N(currentDrawShape, this.gs, this.formLevel, this.defaultClip, this.renderPage, this.current, this.pageData, this.pageNum);
                                    break block1;
                                }
                                case 29285: {
                                    currentDrawShape.appendRectangle(parser.parseFloat(3), parser.parseFloat(2), parser.parseFloat(1), parser.parseFloat(0));
                                    break block1;
                                }
                                case 83: {
                                    if (this.removeRenderImages) break;
                                    Shape shape = ShapeCommands.S(false, this.layerDecoder, this.gs, currentDrawShape, this.current, this.renderPage);
                                    break block1;
                                }
                                case 115: {
                                    if (this.removeRenderImages) break;
                                    Shape shape = ShapeCommands.S(true, this.layerDecoder, this.gs, currentDrawShape, this.current, this.renderPage);
                                    break block1;
                                }
                                case 118: {
                                    currentDrawShape.addBezierCurveV(parser.parseFloat(3), parser.parseFloat(2), parser.parseFloat(1), parser.parseFloat(0));
                                    break block1;
                                }
                                case 119: {
                                    this.gs.setLineWidth(parser.parseFloat(0));
                                    break block1;
                                }
                                case 22314: {
                                    currentDrawShape.setEVENODDWindingRule();
                                    currentDrawShape.setClip(true);
                                    break block1;
                                }
                                case 87: {
                                    currentDrawShape.setNONZEROWindingRule();
                                    currentDrawShape.setClip(true);
                                    break block1;
                                }
                                case 121: {
                                    currentDrawShape.addBezierCurveY(parser.parseFloat(3), parser.parseFloat(2), parser.parseFloat(1), parser.parseFloat(0));
                                }
                            }
                            break;
                        }
                        case 3: {
                            if (this.getSamplingOnly || !this.renderPage && !this.textColorExtracted && !this.colorExtracted || !this.renderPage) break;
                            ShadingCommands.sh(parser.generateOpAsString(0, true), this.cache, this.gs, this.isPrinting, this.shadingColorspacesObjects, this.pageNum, this.currentPdfFile, this.pageData, this.current);
                            break;
                        }
                        case 1: {
                            if (this.getSamplingOnly || !this.renderPage && !this.textColorExtracted && !this.colorExtracted) break;
                            if (commandID != 5456718 && commandID != 7562094 && commandID != 21315 && commandID != 29539) {
                                this.current.resetOnColorspaceChange();
                            }
                            switch (commandID) {
                                case 25459: {
                                    boolean alreadyUsed;
                                    String colorspaceObject = parser.generateOpAsString(0, true);
                                    boolean isLowerCase = true;
                                    boolean bl = alreadyUsed = !isLowerCase && colorspaceObject.equals(csInUse) || isLowerCase && colorspaceObject.equals(CSInUse);
                                    if (isLowerCase) {
                                        csInUse = colorspaceObject;
                                    } else {
                                        CSInUse = colorspaceObject;
                                    }
                                    ColorCommands.CS(isLowerCase, colorspaceObject, this.gs, this.cache, this.currentPdfFile, this.isPrinting, this.pageNum, this.pageData, alreadyUsed);
                                    break block1;
                                }
                                case 17235: {
                                    boolean alreadyUsed;
                                    String colorspaceObject = parser.generateOpAsString(0, true);
                                    boolean isLowerCase = false;
                                    boolean bl = alreadyUsed = !isLowerCase && colorspaceObject.equals(csInUse) || isLowerCase && colorspaceObject.equals(CSInUse);
                                    if (isLowerCase) {
                                        csInUse = colorspaceObject;
                                    } else {
                                        CSInUse = colorspaceObject;
                                    }
                                    ColorCommands.CS(isLowerCase, colorspaceObject, this.gs, this.cache, this.currentPdfFile, this.isPrinting, this.pageNum, this.pageData, alreadyUsed);
                                    break block1;
                                }
                                case 29287: {
                                    ColorCommands.RG(true, this.gs, parser, this.cache);
                                    break block1;
                                }
                                case 21063: {
                                    ColorCommands.RG(false, this.gs, parser, this.cache);
                                    break block1;
                                }
                                case 5456718: {
                                    ColorCommands.SCN(false, this.gs, parser, this.cache);
                                    break block1;
                                }
                                case 7562094: {
                                    ColorCommands.SCN(true, this.gs, parser, this.cache);
                                    break block1;
                                }
                                case 21315: {
                                    ColorCommands.SCN(false, this.gs, parser, this.cache);
                                    break block1;
                                }
                                case 29539: {
                                    ColorCommands.SCN(true, this.gs, parser, this.cache);
                                    break block1;
                                }
                                case 103: {
                                    ColorCommands.G(true, this.gs, parser, this.cache);
                                    break block1;
                                }
                                case 71: {
                                    ColorCommands.G(false, this.gs, parser, this.cache);
                                    break block1;
                                }
                                case 107: {
                                    ColorCommands.K(true, this.gs, parser, this.cache);
                                    break block1;
                                }
                                case 75: {
                                    ColorCommands.K(false, this.gs, parser, this.cache);
                                }
                            }
                            break;
                        }
                        case 4: {
                            switch (commandID) {
                                case 25453: {
                                    PdfStreamDecoder.CM(this.gs, parser);
                                    break;
                                }
                                case 113: {
                                    this.gs = this.Q(this.gs, true);
                                    break;
                                }
                                case 81: {
                                    this.gs = this.Q(this.gs, false);
                                    break;
                                }
                                case 26483: {
                                    if (this.getSamplingOnly) break;
                                    PdfObject GS = (PdfObject)this.cache.GraphicsStates.get(parser.generateOpAsString(0, true));
                                    this.currentPdfFile.checkResolved(GS);
                                    this.gs.setMode(GS);
                                    this.current.setGraphicsState(2, this.gs.getAlpha(2));
                                    this.current.setGraphicsState(1, this.gs.getAlpha(1));
                                }
                            }
                            this.gs.setTextState(this.currentTextState);
                            if (commandID != 25453 || textDecoder == null) break;
                            textDecoder.reset();
                            break;
                        }
                        case 5: {
                            if (commandID == 16969) {
                                startInlineStream = dataPointer;
                                break;
                            }
                            PdfObject XObject2 = null;
                            int subtype = 1;
                            if (commandID == 17519) {
                                String name = parser.generateOpAsString(0, true);
                                byte[] rawData = null;
                                XObject2 = this.cache.getXObjects(name);
                                if (XObject2 != null) {
                                    rawData = XObject2.getUnresolvedData();
                                    this.currentPdfFile.checkResolved(XObject2);
                                    subtype = XObject2.getParameterConstant(1147962727);
                                }
                                if (subtype == 373244477 && (this.formLevel <= 10 || dataPointer != this.lastDataPointer)) {
                                    this.lastDataPointer = dataPointer;
                                    this.processXForm(dataPointer, XObject2, this.defaultClip, parser);
                                }
                            }
                            if (subtype != 373244477) {
                                ImageDecoder imageDecoder = new ImageDecoder(this.customImageHandler, this.objectStoreStreamRef, this.renderDirectly, this.pdfImages, this.formLevel, this.pageData, this.imagesInFile, this.formName);
                                imageDecoder.setIntValue(22, this.pageNum);
                                imageDecoder.setIntValue(19, this.formLevel);
                                imageDecoder.setHandlerValue(23, this.errorTracker);
                                imageDecoder.setRes(this.cache);
                                imageDecoder.setGS(this.gs);
                                imageDecoder.setSamplingOnly(this.getSamplingOnly);
                                imageDecoder.setIntValue(-12, this.streamType);
                                imageDecoder.setName(this.fileName);
                                imageDecoder.setFloatValue(17, this.multiplyer);
                                imageDecoder.setFloatValue(12, this.samplingUsed);
                                imageDecoder.setFileHandler(this.currentPdfFile);
                                imageDecoder.setRenderer(this.current);
                                imageDecoder.setIntValue(26, this.imageStatus);
                                imageDecoder.setParameters(this.isPageContent, this.renderPage, this.renderMode, this.extractionMode, this.isPrinting, this.isType3Font, this.useHiResImageForDisplay);
                                imageDecoder.setIntValue(14, this.imageCount);
                                if (commandID == 17519) {
                                    if (!(XObject2 == null || !this.layerDecoder.isLayerVisible() || this.layers != null && !this.layers.isVisible(XObject2) || this.gs.CTM != null && this.gs.CTM[1][1] == 0.0f && this.gs.CTM[1][0] != 0.0f && (double)Math.abs(this.gs.CTM[1][0]) < 0.2)) {
                                        dataPointer = imageDecoder.processDOImage(parser.generateOpAsString(0, true), dataPointer, XObject2);
                                    }
                                } else if (this.layerDecoder.isLayerVisible()) {
                                    dataPointer = imageDecoder.processIDImage(dataPointer, startInlineStream, parser.getStream(), this.tokenNumber);
                                }
                                this.samplingUsed = imageDecoder.getFloatValue(12);
                                this.imageCount = imageDecoder.getIntValue(14);
                                this.imagesInFile = imageDecoder.getImagesInFile();
                                if (imageDecoder.getBooleanValue(16)) {
                                    this.hasYCCKimages = true;
                                }
                                if (imageDecoder.getBooleanValue(15)) {
                                    this.imagesProcessedFully = true;
                                }
                            }
                            break;
                        }
                        case 6: {
                            if (this.getSamplingOnly || !this.renderText && !this.textExtracted) break;
                            if (this.t3Decoder == null) {
                                this.t3Decoder = new T3Decoder();
                            }
                            this.t3Decoder.setCommands(parser);
                            this.t3Decoder.setCommands(parser);
                            this.t3Decoder.processToken(commandID);
                        }
                    }
                }
                catch (Exception e) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("[PDF] " + e + " Processing token >" + Cmd.getCommandAsString(commandID) + "<>" + this.fileName + " <" + this.pageNum);
                    }
                    if (!this.isDataValid) {
                        dataPointer = streamSize;
                    }
                    if (e.getMessage() != null && e.getMessage().contains("JPeg 2000")) {
                        throw new RuntimeException("JPeg 2000 Images needs the VM parameter -Dorg.jpedal.jai=true switch turned on");
                    }
                }
                catch (OutOfMemoryError ee) {
                    this.errorTracker.addPageFailureMessage("Memory error decoding token stream");
                    if (!LogWriter.isOutput()) break block93;
                    LogWriter.writeLog("[MEMORY] Memory error - trying to recover");
                }
            }
            startCommand = dataPointer;
            parser.reset();
            ++this.tokenNumber;
        } while (streamSize > dataPointer);
        if (!this.renderDirectly && this.statusBar != null) {
            this.statusBar.percentageDone = 100.0f;
        }
        this.isTTHintingRequired = textDecoder.isTTHintingRequired();
        this.textAreas = (Vector_Rectangle)textDecoder.getObjectValue(-21);
        this.textDirections = (Vector_Int)textDecoder.getObjectValue(22);
        return "";
    }

    private PdfFont resolveFont(String fontID) {
        PdfFont restoredFont = (PdfFont)this.cache.resolvedFonts.get(fontID);
        if (restoredFont == null) {
            block10: {
                PdfObject newFont = (PdfObject)this.cache.unresolvedFonts.get(fontID);
                if (newFont == null) {
                    this.cache.directFonts.remove(fontID);
                }
                if (this.isFlattenedForm && newFont == null) {
                    String name = StandardFonts.expandName(fontID.replace(",", "-"));
                    if (FontMappings.fontSubstitutionAliasTable.get(name) == null && FontMappings.fontSubstitutionTable != null && FontMappings.fontSubstitutionTable.get(name) == null) {
                        String rawName = name.toLowerCase();
                        name = rawName.contains("bold") ? "Arial-Bold" : (rawName.contains("italic") ? "Arial-Italic" : "Arial");
                    }
                    newFont = new FontObject("1 0 R");
                    fontID = StandardFonts.expandName(name);
                    newFont.setName((Object)678461817, name);
                    newFont.setName((Object)879786873, name);
                    newFont.setConstant(1147962727, 1217103210);
                }
                if (newFont != null) {
                    this.currentPdfFile.checkResolved(newFont);
                    try {
                        DynamicVectorRenderer current = this.current;
                        DynamicVectorRenderer possibleHTMLDVR = (DynamicVectorRenderer)current.getObjectValue(26);
                        if (possibleHTMLDVR != null) {
                            current = possibleHTMLDVR;
                        }
                        boolean fallbackToArial = false;
                        boolean isHTML = BaseDisplay.isHTMLorSVG(current);
                        if (isHTML && !current.getBooleanValue(46)) {
                            fallbackToArial = true;
                        }
                        restoredFont = this.pdfFontFactory.createFont(fallbackToArial, newFont, fontID, this.objectStoreStreamRef, this.renderPage, this.errorTracker, this.isPrinting);
                    }
                    catch (PdfException e) {
                        if (!LogWriter.isOutput()) break block10;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
            }
            if (restoredFont != null && !this.isFlattenedForm) {
                this.cache.resolvedFonts.put(fontID, restoredFont);
            }
        }
        return restoredFont;
    }

    @Override
    public boolean getBooleanValue(int key) {
        switch (key) {
            case -1: {
                return this.pdfFontFactory.hasEmbeddedFonts();
            }
            case 1: {
                return this.errorTracker.pageSuccessful;
            }
            case 4: {
                return this.pdfFontFactory.hasNonEmbeddedCIDFonts();
            }
            case 2: {
                return this.imagesProcessedFully;
            }
            case 8: {
                return this.hasYCCKimages;
            }
            case 16: {
                return this.isTimeout;
            }
            case 32: {
                return this.isTTHintingRequired;
            }
        }
        throw new RuntimeException("Unknown value " + key);
    }

    public void dispose() {
        if (this.pdfData != null) {
            this.pdfData.dispose();
        }
    }

    public void reqestTimeout(Object value) {
        if (value == null) {
            this.requestTimeout = true;
        } else if (value instanceof Integer) {
            this.timeoutInterval = (Integer)value;
        }
    }

    @Override
    public void setIntValue(int key, int value) {
        switch (key) {
            case -10: {
                this.pageNum = value;
                break;
            }
            case 20: {
                this.textPrint = value;
                break;
            }
            default: {
                super.setIntValue(key, value);
            }
        }
    }

    public void setXMLExtraction(boolean isXMLExtraction) {
        this.isXMLExtraction = isXMLExtraction;
    }

    @Override
    public void setParameters(boolean isPageContent, boolean renderPage, int renderMode, int extractionMode) {
        super.setParameters(isPageContent, renderPage, renderMode, extractionMode);
        this.renderText = renderPage && (renderMode & 1) == 1;
        this.textExtracted = (extractionMode & 1) == 1;
        this.textColorExtracted = (extractionMode & 0x40) == 64;
        this.colorExtracted = (extractionMode & 0x200) == 512;
        this.removeRenderImages = renderPage && (renderMode & 0x10) == 16;
    }

    private void processXForm(int dataPointer, PdfObject XObject2, Shape defaultClip, CommandParser parser) throws PdfException {
        boolean debug = false;
        if (!this.layerDecoder.isLayerVisible() || this.layers != null && !this.layers.isVisible(XObject2) || XObject2 == null) {
            return;
        }
        String oldFormName = this.formName;
        String name = parser.generateOpAsString(0, true);
        if (this.formLevel > 1) {
            name = this.formName + '_' + this.formLevel + '_' + name;
        }
        String details = name;
        try {
            if (ImageCommands.trackImages) {
                this.imagesInFile = this.imagesInFile == null ? details + " Form" : details + " Form\n" + this.imagesInFile;
            }
            parser.reset();
            byte[] objectData = this.currentPdfFile.readStream(XObject2, true, true, false, false, false, XObject2.getCacheName(this.currentPdfFile.getObjectReader()));
            if (objectData != null) {
                boolean isIdentity;
                String oldIndent = indent;
                indent = indent + "   ";
                float[] transformMatrix = new float[6];
                float[] matrix = XObject2.getFloatArray(1145198201);
                boolean bl = isIdentity = matrix == null || PdfStreamDecoder.isIdentity(matrix);
                if (matrix != null) {
                    transformMatrix = matrix;
                }
                float[][] oldCTM = null;
                float lineWidthInForm = -1.0f;
                if (matrix != null && !isIdentity) {
                    float[][] currentCTM = new float[3][3];
                    for (int i = 0; i < 3; ++i) {
                        System.arraycopy(this.gs.CTM[i], 0, currentCTM[i], 0, 3);
                    }
                    oldCTM = currentCTM;
                    float[][] CTM = this.gs.CTM;
                    Object scaleFactor = new float[][]{{transformMatrix[0], transformMatrix[1], 0.0f}, {transformMatrix[2], transformMatrix[3], 0.0f}, {transformMatrix[4], transformMatrix[5], 1.0f}};
                    scaleFactor = Matrix.multiply(scaleFactor, CTM);
                    this.gs.CTM = scaleFactor;
                    lineWidthInForm = transformMatrix[0] * this.gs.getLineWidth();
                    if (lineWidthInForm == 0.0f) {
                        lineWidthInForm = transformMatrix[1] * this.gs.getLineWidth();
                    }
                    if (lineWidthInForm < 0.0f) {
                        lineWidthInForm = -lineWidthInForm;
                    }
                }
                ++this.formLevel;
                this.formName = this.formLevel == 1 ? name : this.formName + '_' + name;
                GenericColorSpace mainStrokeColorData = (GenericColorSpace)this.gs.strokeColorSpace.clone();
                GenericColorSpace mainnonStrokeColorData = (GenericColorSpace)this.gs.nonstrokeColorSpace.clone();
                if (lineWidthInForm > 0.0f) {
                    this.gs.setLineWidth(lineWidthInForm);
                }
                float maxStrokeValue = this.gs.getAlphaMax(1);
                float maxFillValue = this.gs.getAlphaMax(2);
                this.gs.setMaxAlpha(1, this.gs.getAlpha(1));
                if (this.formLevel == 1) {
                    this.gs.setMaxAlpha(2, this.gs.getAlpha(2));
                }
                PdfObjectCache mainCache = this.cache.copy();
                this.cache.reset(mainCache);
                PdfObject Resources = XObject2.getDictionary(2004251818);
                this.readResources(Resources, false);
                this.cache.groupObj = XObject2.getDictionary(1111442775);
                this.currentPdfFile.checkResolved(this.cache.groupObj);
                float[] BBox = XObject2.getFloatArray(303185736);
                Area clip = null;
                boolean clipChanged = false;
                if (BBox != null && BBox[2] > 1.0f && BBox[3] > 1.0f && this.gs.getClippingShape() == null && this.gs.CTM[0][1] == 0.0f && this.gs.CTM[1][0] == 0.0f && this.gs.CTM[2][1] != 0.0f && this.gs.CTM[2][0] < 0.0f) {
                    clip = this.setClip(defaultClip, BBox);
                    clipChanged = true;
                } else if (BBox != null && BBox[0] == 0.0f && BBox[1] == 0.0f && BBox[2] > 1.0f && BBox[3] > 1.0f && BBox[2] != BBox[3] && ((double)this.gs.CTM[0][0] > 0.99 || this.gs.CTM[2][1] < -1.0f) && (this.gs.CTM[2][0] < -1.0f || this.gs.CTM[2][0] > 1.0f) && this.gs.CTM[2][1] != 0.0f) {
                    clip = this.setClip(defaultClip, BBox);
                    clipChanged = true;
                } else if (this.formLevel > 1 && BBox != null && BBox[0] > 50.0f && BBox[1] > 50.0f && this.gs.getClippingShape() != null && BBox[0] - 1.0f > (float)this.gs.getClippingShape().getBounds().x && BBox[1] - 1.0f > (float)this.gs.getClippingShape().getBounds().y) {
                    clip = this.setClip(defaultClip, BBox);
                    clipChanged = true;
                }
                if (objectData.length > 0) {
                    PdfObject newSMask = this.getSMask(BBox);
                    int firstValue = PdfStreamDecoder.getFirstValue(this.gs.getBM());
                    if (!PdfStreamDecoder.isTransparent(this.cache.groupObj) && (this.flattenXFormToImage || this.isPrinting && this.gs.CTM[2][0] == 0.0f && this.gs.CTM[2][1] == 0.0f && newSMask == null && firstValue != 1451587725 && this.gs.getAlpha(2) == 1.0f || (this.gs.getAlpha(2) == 1.0f || this.layerDecoder.layerLevel > 0 || this.formLevel == 1 && this.gs.getAlpha(2) < 0.1f) && newSMask == null && firstValue != 1451587725)) {
                        this.decodeStreamIntoObjects(objectData, false);
                    } else if (newSMask != null || firstValue == 1451587725) {
                        this.createMaskForm(XObject2, name, newSMask, firstValue);
                    } else {
                        DynamicVectorRenderer oldCurrent = this.current;
                        this.current = new SwingDisplay(this.pageNum, this.objectStoreStreamRef, false);
                        this.current.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
                        boolean oldRenderDirectly = this.renderDirectly;
                        float strokeAlpha = this.gs.getAlpha(1);
                        float maxStroke = this.gs.getAlphaMax(1);
                        float fillAlpha = this.gs.getAlpha(2);
                        float maxFill = this.gs.getAlphaMax(2);
                        this.currentPdfFile.checkResolved(this.cache.pageGroupingObj);
                        if (this.cache.pageGroupingObj != null && this.renderDirectly) {
                            this.gs.setMaxAlpha(1, 1.0f);
                        } else {
                            this.gs.setMaxAlpha(1, strokeAlpha);
                            this.gs.setMaxAlpha(2, fillAlpha);
                        }
                        if (this.renderDirectly && (this.cache.pageGroupingObj == null || this.cache.pageGroupingObj != null && this.cache.groupObj != null && (this.cache.groupObj.getDictionary(2087749783).getParameterConstant(2087749783) == 1247168582 || this.cache.groupObj.getDictionary(2087749783).getParameterConstant(2087749783) != this.cache.pageGroupingObj.getDictionary(2087749783).getParameterConstant(2087749783)))) {
                            this.gs.setMaxAlpha(2, 1.0f);
                        }
                        if (!this.renderDirectly) {
                            this.gs.setAlpha(1, 1.0f);
                            this.gs.setAlpha(2, 1.0f);
                        }
                        this.renderDirectly = false;
                        oldCurrent.setGraphicsState(1, 1.0f);
                        oldCurrent.setGraphicsState(2, 1.0f);
                        this.decodeStreamIntoObjects(objectData, false);
                        this.gs.setMaxAlpha(1, maxStroke);
                        this.gs.setMaxAlpha(2, maxFill);
                        if (!this.renderDirectly) {
                            this.gs.setAlpha(1, strokeAlpha);
                            this.gs.setAlpha(2, fillAlpha);
                        }
                        oldCurrent.drawXForm(this.current, this.gs);
                        this.current = oldCurrent;
                        this.current.setGraphicsState(1, strokeAlpha);
                        this.current.setGraphicsState(2, fillAlpha);
                        this.renderDirectly = oldRenderDirectly;
                    }
                }
                if (clipChanged) {
                    this.gs.setClippingShape(clip);
                    this.current.drawClip(this.gs, clip, false);
                }
                --this.formLevel;
                if (oldCTM != null) {
                    this.gs.CTM = oldCTM;
                } else if (this.gs.CTM[0][0] == 1.0f && this.gs.CTM[1][1] == 1.0f) {
                    this.gs.CTM = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
                }
                this.gs.strokeColorSpace = mainStrokeColorData;
                this.gs.nonstrokeColorSpace = mainnonStrokeColorData;
                this.cache.restore(mainCache);
                this.gs.setMaxAlpha(1, maxStrokeValue);
                this.gs.setMaxAlpha(2, maxFillValue);
                indent = oldIndent;
            }
        }
        catch (Error e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            this.imagesProcessedFully = false;
            this.errorTracker.addPageFailureMessage("Error " + e + " in DO");
            if (ExternalHandlers.throwMissingCIDError && e.getMessage().contains("kochi")) {
                throw e;
            }
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + e);
            }
            this.imagesProcessedFully = false;
            this.errorTracker.addPageFailureMessage("Error " + e + " in DO");
        }
        this.formName = oldFormName;
    }

    private PdfObject getSMask(float[] BBox) {
        PdfObject newSMask = null;
        if (this.gs.SMask != null && this.gs.SMask.getGeneralType(489767774) == 507461173) {
            return null;
        }
        if (this.gs.SMask != null && BBox != null && BBox[2] > 0.0f && (this.gs.SMask.getParameterConstant(608780341) != 489767739 || this.gs.SMask.getFloatArray(4627) != null)) {
            newSMask = this.gs.SMask.getDictionary(23);
            this.currentPdfFile.checkResolved(newSMask);
        }
        return newSMask;
    }

    private static int getFirstValue(PdfArrayIterator BMvalue) {
        int firstValue = -1;
        if (BMvalue != null && BMvalue.hasMoreTokens()) {
            firstValue = BMvalue.getNextValueAsConstant(false);
        }
        return firstValue;
    }

    private void createMaskForm(PdfObject XObject2, String name, PdfObject newSMask, int firstValue) throws PdfException {
        float[] BBox = XObject2.getFloatArray(303185736);
        int fx = (int)BBox[0];
        int fy = (int)BBox[1];
        int fw = (int)BBox[2];
        int fh = (int)BBox[3];
        if (fx < 0) {
            fx = 0;
        }
        BufferedImage image = null;
        if (newSMask != null) {
            image = this.getImageFromPdfObject(XObject2, fx, fw, fy, fh);
            BufferedImage smaskImage = this.getImageFromPdfObject(newSMask, fx, fw, fy, fh);
            PdfObject ColorSpace2 = null;
            PdfObject group = newSMask.getDictionary(1111442775);
            if (group != null) {
                this.currentPdfFile.checkResolved(group);
                ColorSpace2 = group.getDictionary(2087749783);
            }
            if (ColorSpace2 != null) {
                this.currentPdfFile.checkResolved(ColorSpace2);
            }
            image = ImageCommands.applySmask(image, smaskImage, newSMask, true, true, ColorSpace2, XObject2, this.gs);
            if (smaskImage != null) {
                smaskImage.flush();
            }
        }
        GraphicsState gs1 = new GraphicsState();
        gs1.CTM = new float[][]{{image.getWidth(), 0.0f, 1.0f}, {0.0f, image.getHeight(), 1.0f}, {0.0f, 0.0f, 0.0f}};
        if (this.isFlattenedForm) {
            gs1.x = this.flattenX;
            gs1.y = this.flattenY;
        } else {
            gs1.x = fx;
            gs1.y = fy - image.getHeight();
        }
        gs1.CTM[2][0] = gs1.x;
        gs1.CTM[2][1] = gs1.y;
        this.current.drawImage(this.pageNum, image, gs1, false, name, 1, -1);
    }

    private BufferedImage createTransparentForm(PdfObject XObject2, int fx, int fy, int fw, int fh) {
        PdfStreamDecoder glyphDecoder;
        SwingDisplay glyphDisplay;
        ObjectStore localStore;
        byte[] objectData1;
        block6: {
            objectData1 = this.currentPdfFile.readStream(XObject2, true, true, false, false, false, XObject2.getCacheName(this.currentPdfFile.getObjectReader()));
            localStore = new ObjectStore(null);
            glyphDisplay = new SwingDisplay(0, false, 20, localStore);
            glyphDisplay.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
            glyphDecoder = new PdfStreamDecoder(this.currentPdfFile, this.useHiResImageForDisplay, null);
            glyphDecoder.setParameters(this.isPageContent, this.renderPage, this.renderMode, this.extractionMode);
            glyphDecoder.setObjectValue(-8, localStore);
            glyphDecoder.setIntValue(19, this.formLevel);
            glyphDecoder.setFloatValue(17, this.multiplyer);
            glyphDecoder.setFloatValue(12, this.samplingUsed);
            glyphDecoder.setObjectValue(23, glyphDisplay);
            try {
                PdfObject SMaskResources = XObject2.getDictionary(2004251818);
                if (SMaskResources != null) {
                    glyphDecoder.readResources(SMaskResources, false);
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        if (objectData1 != null) {
            glyphDecoder.decodeStreamIntoObjects(objectData1, false);
        }
        int hh = fh;
        if (fy > fh) {
            hh = fy - fh;
        }
        BufferedImage image = new BufferedImage(fw, hh, 2);
        Graphics2D formG2 = image.createGraphics();
        if (!this.isFlattenedForm) {
            formG2.translate(-fx, -fh);
        }
        formG2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        glyphDisplay.setG2(formG2);
        glyphDisplay.paint(null, null, null);
        localStore.flush();
        return image;
    }

    private static boolean isTransparent(PdfObject groupObj) {
        boolean isTransparentRGB = false;
        if (groupObj != null) {
            String S = groupObj.getName(35);
            PdfObject colspace = groupObj.getDictionary(2087749783);
            isTransparentRGB = S != null && S.equals("Transparency") && colspace != null && colspace.getParameterConstant(2087749783) == 1785221209;
        }
        return isTransparentRGB;
    }

    private Area setClip(Shape defaultClip, float[] BBox) {
        int h;
        int w;
        int y;
        int x;
        float scalingH;
        float scalingW = this.gs.CTM[0][0];
        if (scalingW == 0.0f) {
            scalingW = this.gs.CTM[0][1];
        }
        if ((scalingH = this.gs.CTM[1][1]) == 0.0f) {
            scalingH = this.gs.CTM[1][0];
        }
        if (this.gs.CTM[0][1] > 0.0f && this.gs.CTM[1][0] < 0.0f) {
            x = (int)(this.gs.CTM[2][0] - BBox[3]);
            y = (int)(this.gs.CTM[2][1] + BBox[0]);
            w = (int)((BBox[3] - BBox[1]) * scalingW);
            h = (int)((BBox[2] - BBox[0]) * scalingH);
        } else if (this.gs.CTM[0][1] < 0.0f && this.gs.CTM[1][0] > 0.0f) {
            x = (int)(this.gs.CTM[2][0] + BBox[1]);
            y = (int)(this.gs.CTM[2][1] - BBox[2]);
            w = (int)((BBox[3] - BBox[1]) * -scalingW);
            h = (int)((BBox[2] - BBox[0]) * -scalingH);
        } else {
            x = (int)(this.gs.CTM[2][0] + BBox[0]);
            y = (int)(this.gs.CTM[2][1] + BBox[1] - 1.0f);
            w = (int)(1.0f + (BBox[2] - BBox[0]) * scalingW);
            h = (int)(2.0f + (BBox[3] - BBox[1]) * scalingH);
            if (this.gs.CTM[2][1] < 0.0f) {
                h = (int)((float)h - this.gs.CTM[2][1] * scalingH);
            }
            if (this.gs.CTM[2][0] < 0.0f) {
                w = (int)((float)w - this.gs.CTM[2][0] * scalingH);
            }
            if (this.gs.CTM[1][1] < 0.0f) {
                y -= h;
            }
        }
        Area clip = this.gs.getClippingShape() == null ? null : (Area)this.gs.getClippingShape().clone();
        Area newClip = new Area(new Rectangle(x, y, w, h));
        this.gs.updateClip(new Area(newClip));
        this.current.drawClip(this.gs, defaultClip, false);
        return clip;
    }

    private static boolean isIdentity(float[] matrix) {
        boolean isIdentity = true;
        if (matrix != null) {
            for (int ii = 0; ii < 6; ++ii) {
                if (matrix[ii] == matches[ii]) continue;
                isIdentity = false;
                break;
            }
        }
        return isIdentity;
    }

    private BufferedImage getImageFromPdfObject(PdfObject newSMask, int fx, int fw, int fy, int fh) throws PdfException {
        BufferedImage smaskImage;
        PdfStreamDecoder glyphDecoder;
        SwingDisplay glyphDisplay;
        ObjectStore localStore;
        byte[] objectData;
        block10: {
            objectData = this.currentPdfFile.readStream(newSMask, true, true, false, false, false, newSMask.getCacheName(this.currentPdfFile.getObjectReader()));
            localStore = new ObjectStore(null);
            glyphDisplay = new SwingDisplay(0, false, 20, localStore);
            boolean useHiRes = true;
            glyphDecoder = new PdfStreamDecoder(this.currentPdfFile, useHiRes, null);
            glyphDecoder.setParameters(this.isPageContent, this.renderPage, this.renderMode, this.extractionMode);
            glyphDecoder.setObjectValue(-8, localStore);
            glyphDisplay.setHiResImageForDisplayMode(useHiRes);
            glyphDecoder.setObjectValue(23, glyphDisplay);
            glyphDecoder.setFloatValue(17, this.multiplyer);
            glyphDecoder.setFloatValue(12, this.samplingUsed);
            glyphDecoder.setBooleanValue(24, this.isFlattenedForm);
            glyphDecoder.setIntValue(19, this.formLevel);
            glyphDecoder.setIntValue(26, 2);
            try {
                PdfObject SMaskResources = newSMask.getDictionary(2004251818);
                if (SMaskResources != null) {
                    glyphDecoder.readResources(SMaskResources, false);
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block10;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        if (objectData != null) {
            glyphDecoder.decodeStreamIntoObjects(objectData, false);
        }
        glyphDecoder.dispose();
        int hh = fh;
        if (fy > fh) {
            hh = fy - fh;
        }
        if (fw == 0) {
            fw = 1;
        }
        try {
            smaskImage = new BufferedImage(fw, hh, 2);
        }
        catch (Error err) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + err.getMessage());
            }
            smaskImage = null;
        }
        if (smaskImage != null) {
            Graphics2D formG2 = smaskImage.createGraphics();
            formG2.translate(-fx, -fh);
            glyphDisplay.setG2(formG2);
            glyphDisplay.paint(null, null, null);
            localStore.flush();
        }
        return smaskImage;
    }

    private void pushGraphicsState(GraphicsState gs) {
        if (!this.isStackInitialised) {
            this.isStackInitialised = true;
            this.graphicsStateStack = new Vector_Object(10);
            this.textStateStack = new Vector_Object(10);
            this.strokeColorStateStack = new Vector_Object(20);
            this.nonstrokeColorStateStack = new Vector_Object(20);
        }
        this.graphicsStateStack.push(gs.clone());
        this.textStateStack.push(this.currentTextState.clone());
        this.nonstrokeColorStateStack.push(gs.nonstrokeColorSpace.clone());
        this.strokeColorStateStack.push(gs.strokeColorSpace.clone());
        this.current.resetOnColorspaceChange();
    }

    private GraphicsState restoreGraphicsState(GraphicsState gs) {
        boolean hasClipChanged = false;
        if (!this.isStackInitialised) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("No GraphicsState saved to retrieve");
            }
            gs = new GraphicsState();
            this.currentTextState = new TextState();
        } else {
            hasClipChanged = gs.hasClipChanged();
            gs = (GraphicsState)this.graphicsStateStack.pull();
            this.currentTextState = (TextState)this.textStateStack.pull();
            gs.strokeColorSpace = (GenericColorSpace)this.strokeColorStateStack.pull();
            gs.nonstrokeColorSpace = (GenericColorSpace)this.nonstrokeColorStateStack.pull();
            if (gs.strokeColorSpace.getID() == -2073385820) {
                gs.strokeColorSpace.restoreColorStatus();
            }
            if (gs.nonstrokeColorSpace.getID() == -2073385820) {
                gs.nonstrokeColorSpace.restoreColorStatus();
            }
        }
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(gs.CTM, 0, gs.lastCTM, 0, 3);
        }
        if (this.renderPage) {
            if (hasClipChanged) {
                this.current.drawClip(gs, this.defaultClip, true);
            }
            this.current.resetOnColorspaceChange();
            this.current.drawFillColor(gs.getNonstrokeColor());
            this.current.drawStrokeColor(gs.getStrokeColor());
            this.current.setGraphicsState(2, gs.getAlpha(2));
            this.current.setGraphicsState(1, gs.getAlpha(1));
        }
        return gs;
    }

    private GraphicsState Q(GraphicsState gs, boolean isLowerCase) {
        if (isLowerCase) {
            this.pushGraphicsState(gs);
        } else {
            gs = this.restoreGraphicsState(gs);
            this.currentTextState.setFontChanged(true);
        }
        return gs;
    }

    private static void CM(GraphicsState gs, CommandParser parser) {
        float[][] Trm = new float[3][3];
        Trm[0][0] = parser.parseFloat(5);
        Trm[0][1] = parser.parseFloat(4);
        Trm[0][2] = 0.0f;
        Trm[1][0] = parser.parseFloat(3);
        Trm[1][1] = parser.parseFloat(2);
        Trm[1][2] = 0.0f;
        Trm[2][0] = parser.parseFloat(1);
        Trm[2][1] = parser.parseFloat(0);
        Trm[2][2] = 1.0f;
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(gs.CTM, 0, gs.lastCTM, 0, 3);
        }
        gs.CTM = Matrix.multiply(Trm, gs.CTM);
        if (gs.CTM[0][0] > 0.0f && gs.CTM[1][1] > 0.0f && gs.CTM[1][0] > 0.0f && (double)gs.CTM[1][0] < 0.01 && gs.CTM[0][1] < 0.0f) {
            gs.CTM[0][1] = 0.0f;
            gs.CTM[1][0] = 0.0f;
        }
    }

    private void F(boolean isStar, int formLevel, PdfShape currentDrawShape) {
        float[] BC;
        if (formLevel > 0 && this.cache.groupObj != null && !this.cache.groupObj.getBoolean(27) && this.gs.getAlphaMax(2) > 0.84f && this.gs.nonstrokeColorSpace.getID() == 1498837125) {
            PdfArrayIterator BMvalue = this.gs.getBM();
            int firstValue = -1;
            if (BMvalue != null && BMvalue.hasMoreTokens()) {
                firstValue = BMvalue.getNextValueAsConstant(false);
            }
            if (this.gs.nonstrokeColorSpace.getColor().getRGB() == -1 || firstValue == 1451587725 && this.gs.getAlpha(2) == 1.0f) {
                return;
            }
        }
        if (this.gs.SMask != null && this.gs.nonstrokeColorSpace.getID() == 1498837125) {
            BC = this.gs.SMask.getFloatArray(4627);
            if (this.gs.nonstrokeColorSpace.getColor().getRGB() == -16777216 && BC != null && BC[0] == 1.0f) {
                return;
            }
        }
        if (this.gs.SMask != null && this.gs.nonstrokeColorSpace.getID() == 1247168582) {
            BC = this.gs.SMask.getFloatArray(4627);
            if (this.gs.nonstrokeColorSpace.getColor().getRGB() == -16777216 && BC != null && BC[0] == 0.0f) {
                return;
            }
        }
        if (this.gs.SMask != null && this.gs.SMask.getDictionary(23) != null && this.gs.nonstrokeColorSpace.getID() == 1785221209) {
            block29: {
                if (this.gs.nonstrokeColorSpace.getColor().getRGB() == -1 && this.gs.getOPM() == 1.0f) {
                    return;
                }
                BC = this.gs.SMask.getFloatArray(4627);
                if (this.gs.nonstrokeColorSpace.getColor().getRGB() == -16777216 && BC != null && BC[0] == 1.0f && BC[1] == 1.0f && BC[2] == 1.0f) {
                    return;
                }
                try {
                    this.createSMaskFill();
                }
                catch (PdfException e) {
                    if (!LogWriter.isOutput()) break block29;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            return;
        }
        if (this.gs.SMask != null && this.gs.SMask.getGeneralType(489767774) != 507461173 && this.gs.nonstrokeColorSpace.getID() == 1785221209 && this.gs.getOPM() == 1.0f && this.gs.nonstrokeColorSpace.getColor().getRGB() == -16777216) {
            return;
        }
        if (this.layerDecoder.isLayerVisible()) {
            float[] rawData;
            int firstValue;
            if (isStar) {
                currentDrawShape.setEVENODDWindingRule();
            } else {
                currentDrawShape.setNONZEROWindingRule();
            }
            currentDrawShape.closeShape();
            Shape currentShape = currentDrawShape.generateShapeFromPath(this.gs.CTM, this.gs.getLineWidth(), 70, this.current.getType());
            if (this.gs.nonstrokeColorSpace.getID() == 1498837125 && this.gs.getOPM() == 1.0f) {
                PdfArrayIterator BMvalue = this.gs.getBM();
                firstValue = -1;
                if (BMvalue != null && BMvalue.hasMoreTokens()) {
                    firstValue = BMvalue.getNextValueAsConstant(false);
                }
                if (firstValue == 1451587725 && (rawData = this.gs.nonstrokeColorSpace.getRawValues()) != null && rawData[3] == 1.0f) {
                    currentShape = null;
                }
            }
            if (currentShape != null && this.gs.nonstrokeColorSpace.getID() == 1247168582 && this.gs.getOPM() == 1.0f) {
                PdfArrayIterator BMvalue = this.gs.getBM();
                firstValue = -1;
                if (BMvalue != null && BMvalue.hasMoreTokens()) {
                    firstValue = BMvalue.getNextValueAsConstant(false);
                }
                if (firstValue == 1451587725) {
                    rawData = this.gs.nonstrokeColorSpace.getRawValues();
                    boolean isZero = true;
                    for (float aRawData : rawData) {
                        if (aRawData == 0.0f) continue;
                        isZero = false;
                    }
                    if (isZero) {
                        currentShape = null;
                    }
                }
            }
            if (currentShape != null && this.gs.getAlpha(2) < 1.0f && this.gs.nonstrokeColorSpace.getID() == 960981604 && this.gs.getOPM() == 1.0f && this.gs.nonstrokeColorSpace.getColor().getRGB() == -16777216) {
                boolean ignoreTransparent = true;
                float[] raw = this.gs.nonstrokeColorSpace.getRawValues();
                if (raw != null) {
                    int count = raw.length;
                    for (int ii = 0; ii < count; ++ii) {
                        if (!(raw[ii] > 0.0f)) continue;
                        ignoreTransparent = false;
                        ii = count;
                    }
                }
                if (ignoreTransparent) {
                    currentShape = null;
                }
            }
            if (currentShape != null && this.renderPage) {
                this.gs.setStrokeColor(this.gs.strokeColorSpace.getColor());
                this.gs.setNonstrokeColor(this.gs.nonstrokeColorSpace.getColor());
                this.gs.setFillType(2);
                this.current.drawShape(currentShape, this.gs, 70);
            }
        }
        currentDrawShape.setClip(false);
        currentDrawShape.resetPath();
    }

    private void createSMaskFill() throws PdfException {
        PdfObject maskObj = this.gs.SMask.getDictionary(23);
        this.currentPdfFile.checkResolved(maskObj);
        float[] BBox = maskObj.getFloatArray(303185736);
        int fx = (int)BBox[0];
        int fy = (int)BBox[1];
        int fw = (int)BBox[2];
        int fh = (int)BBox[3];
        if (fx < 0) {
            fx = 0;
        }
        BufferedImage smaskImage = this.getImageFromPdfObject(maskObj, fx, fw, fy, fh);
        WritableRaster ras = smaskImage.getRaster();
        int w = ras.getWidth();
        int h = ras.getHeight();
        int[] values = new int[4];
        int fillColor = this.gs.nonstrokeColorSpace.getColor().getRGB();
        values[0] = (byte)(fillColor >> 16 & 0xFF);
        values[1] = (byte)(fillColor >> 8 & 0xFF);
        values[2] = (byte)(fillColor & 0xFF);
        int[] transparentPixel = new int[]{0, 0, 0, 0};
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                boolean transparent;
                ras.getPixels(x, y, 1, 1, values);
                boolean bl = transparent = values[0] == 0 && values[1] == 0 && values[2] == 0 && values[3] == 255;
                if (transparent) {
                    ras.setPixels(x, y, 1, 1, transparentPixel);
                    continue;
                }
                int[] newPixel = new int[4];
                newPixel[3] = 191;
                newPixel[0] = values[0];
                newPixel[1] = values[1];
                newPixel[2] = values[2];
                ras.setPixels(x, y, 1, 1, newPixel);
            }
        }
        GraphicsState gs1 = new GraphicsState();
        gs1.CTM = new float[][]{{smaskImage.getWidth(), 0.0f, 1.0f}, {0.0f, smaskImage.getHeight(), 1.0f}, {0.0f, 0.0f, 0.0f}};
        gs1.x = fx;
        gs1.y = fy - smaskImage.getHeight();
        gs1.CTM[2][0] = gs1.x;
        gs1.CTM[2][1] = gs1.y;
        this.current.drawImage(this.pageNum, smaskImage, gs1, false, "F" + this.tokenNumber, 1, -1);
        smaskImage.flush();
    }

    static {
        SamplingFactory.setDownsampleMode(null);
        matches = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    }
}

