/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class PdfObject
implements Cloneable {
    protected boolean isIndexed;
    protected boolean maybeIndirect = false;
    protected boolean isFullyResolved = true;
    protected boolean isDataExternal = false;
    private boolean streamMayBeCorrupt;
    public static final int DECODED = 0;
    public static final int UNDECODED_REF = 1;
    public static final int UNDECODED_DIRECT = 2;
    private int status = 0;
    byte[] unresolvedData = null;
    Map otherValues = new HashMap();
    protected int pageNumber = -1;
    int PDFkeyInt = -1;
    int objType = -1;
    private int id = -1;
    protected int colorspace = -1;
    protected int subtype = -1;
    protected int type = -1;
    private int BitsPerComponent = -1;
    private int BitsPerCoordinate = -1;
    private int BitsPerFlag = -1;
    private int Count = 0;
    private int FormType = -1;
    private int Length = -1;
    private int Length1 = -1;
    private int Length2 = -1;
    private int Length3 = -1;
    private int Rotate = -1;
    private float[] ArtBox;
    private float[] BBox;
    private float[] BleedBox;
    private float[] CropBox;
    private float[] Decode;
    private float[] Domain;
    private float[] Matrix;
    private float[] MediaBox;
    private float[] Range;
    private float[] TrimBox;
    protected PdfObject ColorSpace = null;
    protected PdfObject DecodeParms = null;
    protected PdfObject Encoding = null;
    protected PdfObject Function = null;
    protected PdfObject Resources = null;
    protected PdfObject Shading = null;
    protected PdfObject SMask = null;
    private boolean ignoreRecursion = false;
    private boolean ignoreStream = false;
    protected boolean isZapfDingbats = false;
    protected boolean isSymbol = false;
    private boolean isCompressedStream = false;
    protected int generalType = -1;
    private String generalTypeAsString = null;
    protected boolean includeParent = false;
    private String Creator = null;
    private String Parent = null;
    private String Name = null;
    private String S = null;
    private String Title = null;
    private byte[] rawCreator;
    private byte[] rawParent;
    private byte[] rawName = null;
    private byte[] rawS;
    private byte[] rawTitle = null;
    public static boolean debug = false;
    protected String ref = null;
    int intRef;
    int gen;
    protected boolean hasStream = false;
    public byte[] stream = null;
    private byte[] DecodedStream = null;
    private long startStreamOnDisk = -1L;
    private PdfFileReader objReader = null;
    private String cacheName = null;
    private byte[][] Filter = null;
    private byte[][] TR = null;
    private byte[][] keys;
    private byte[][] values;
    private Object[] DecodeParmsAsArray;
    private PdfObject[] objs;
    protected Object currentKey = null;
    protected int parentType = -1;
    private boolean isInCompressedStream;
    private static int newXFAFormID = 1;

    protected void setInternalReference() {
        this.ref = newXFAFormID++ + " 0 X";
    }

    protected PdfObject() {
    }

    public PdfObject(byte[] bytes) {
    }

    public PdfObject(int intRef, int gen) {
        this.setRef(intRef, gen);
    }

    public void setRef(int intRef, int gen) {
        this.intRef = intRef;
        this.gen = gen;
        this.ref = null;
    }

    public String getCacheName(PdfFileReader objReader) {
        if (this.isCached()) {
            this.cacheName = null;
            this.getCachedStreamFile(objReader);
        }
        return this.cacheName;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public PdfObject(String ref) {
        this.ref = ref;
    }

    public PdfObject(int type) {
        this.generalType = type;
    }

    protected static boolean[] deepCopy(boolean[] input) {
        if (input == null) {
            return null;
        }
        int count = input.length;
        boolean[] deepCopy = new boolean[count];
        System.arraycopy(input, 0, deepCopy, 0, count);
        return deepCopy;
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getUnresolvedData() {
        return this.unresolvedData;
    }

    public int getPDFkeyInt() {
        return this.PDFkeyInt;
    }

    public void setUnresolvedData(byte[] unresolvedData, int PDFkeyInt) {
        this.unresolvedData = unresolvedData;
        this.PDFkeyInt = PDFkeyInt;
    }

    public void setStatus(int status) {
        this.status = status;
        this.unresolvedData = null;
    }

    protected static float[] deepCopy(float[] input) {
        if (input == null) {
            return null;
        }
        int count = input.length;
        float[] deepCopy = new float[count];
        System.arraycopy(input, 0, deepCopy, 0, count);
        return deepCopy;
    }

    protected static double[] deepCopy(double[] input) {
        if (input == null) {
            return null;
        }
        int count = input.length;
        double[] deepCopy = new double[count];
        System.arraycopy(input, 0, deepCopy, 0, count);
        return deepCopy;
    }

    protected static int[] deepCopy(int[] input) {
        if (input == null) {
            return null;
        }
        int count = input.length;
        int[] deepCopy = new int[count];
        System.arraycopy(input, 0, deepCopy, 0, count);
        return deepCopy;
    }

    protected static byte[][] deepCopy(byte[][] input) {
        if (input == null) {
            return null;
        }
        int count = input.length;
        byte[][] deepCopy = new byte[count][];
        System.arraycopy(input, 0, deepCopy, 0, count);
        return deepCopy;
    }

    public PdfObject getDictionary(int id) {
        switch (id) {
            case 2087749783: {
                return this.ColorSpace;
            }
            case 1888135062: {
                return this.DecodeParms;
            }
            case 1518239089: {
                return this.Function;
            }
            case 2004251818: {
                return this.Resources;
            }
            case 878474856: {
                return this.Shading;
            }
            case 489767774: {
                return this.SMask;
            }
        }
        return null;
    }

    public int getGeneralType(int id) {
        if (id == 1232564598 && this.isZapfDingbats) {
            return 5;
        }
        if (id == 1232564598 && this.isSymbol) {
            return 4;
        }
        if (id == 608780341) {
            return this.objType;
        }
        return this.generalType;
    }

    public String getGeneralStringValue() {
        return this.generalTypeAsString;
    }

    public void setGeneralStringValue(String generalTypeAsString) {
        this.generalTypeAsString = generalTypeAsString;
    }

    public void setIntNumber(int id, int value) {
        switch (id) {
            case -1344207655: {
                this.BitsPerComponent = value;
                break;
            }
            case -335950113: {
                this.BitsPerCoordinate = value;
                break;
            }
            case 1500422077: {
                this.BitsPerFlag = value;
                break;
            }
            case 1061502502: {
                this.Count = value;
                break;
            }
            case 982024818: {
                this.FormType = value;
                break;
            }
            case 1043816557: {
                this.Length = value;
                break;
            }
            case 929066303: {
                this.Length1 = value;
                break;
            }
            case 929066304: {
                this.Length2 = value;
                break;
            }
            case 929066305: {
                this.Length3 = value;
                break;
            }
            case 1144088180: {
                this.Rotate = value;
                break;
            }
        }
    }

    public void setFloatNumber(int id, float value) {
        switch (id) {
            default: 
        }
    }

    public int getInt(int id) {
        switch (id) {
            case -1344207655: {
                return this.BitsPerComponent;
            }
            case -335950113: {
                return this.BitsPerCoordinate;
            }
            case 1500422077: {
                return this.BitsPerFlag;
            }
            case 1061502502: {
                return this.Count;
            }
            case 982024818: {
                return this.FormType;
            }
            case 1043816557: {
                return this.Length;
            }
            case 929066303: {
                return this.Length1;
            }
            case 929066304: {
                return this.Length2;
            }
            case 929066305: {
                return this.Length3;
            }
            case 1144088180: {
                return this.Rotate;
            }
        }
        return -1;
    }

    public float getFloatNumber(int id) {
        switch (id) {
            default: 
        }
        return -1.0f;
    }

    public boolean getBoolean(int id) {
        switch (id) {
            default: 
        }
        return false;
    }

    public void setBoolean(int id, boolean value) {
        switch (id) {
            default: 
        }
    }

    public void setDictionary(int id, PdfObject value) {
        value.id = id;
        switch (id) {
            case 2087749783: {
                this.ColorSpace = value;
                break;
            }
            case 1888135062: {
                this.DecodeParms = value;
                break;
            }
            case 1518239089: {
                this.Function = value;
                break;
            }
            case 2004251818: {
                this.Resources = value;
                break;
            }
            case 878474856: {
                this.Shading = value;
                break;
            }
            case 489767774: {
                this.SMask = value;
                break;
            }
            default: {
                this.setOtherValues(id, value);
            }
        }
    }

    protected void setOtherValues(int id, PdfObject value) {
        if (this.objType == 373244477 || this.objType == 487790868 || this.currentKey != null) {
            this.otherValues.put(this.currentKey, value);
            this.currentKey = null;
        }
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public int getParentID() {
        return this.parentType;
    }

    public void setParentID(int parentType) {
        this.parentType = parentType;
    }

    public boolean hasStream() {
        return this.hasStream;
    }

    public int setConstant(int pdfKeyType, int keyStart, int keyLength, byte[] raw) {
        int id;
        block6: {
            int PDFvalue = -1;
            id = 0;
            int x = 0;
            try {
                for (int i2 = keyLength - 1; i2 > -1; --i2) {
                    int next = raw[keyStart + i2];
                    id += (next -= 48) << x;
                    x += 8;
                }
                switch (id) {
                    default: 
                }
                if (PDFvalue == -1 && debug) {
                    byte[] bytes = new byte[keyLength];
                    System.arraycopy(raw, keyStart, bytes, 0, keyLength);
                    System.out.println("key=" + new String(bytes) + ' ' + id + " not implemented in setConstant in " + this);
                    System.out.println("final public static int " + new String(bytes) + '=' + id + ';');
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return id;
    }

    public int getParameterConstant(int key) {
        int def = -1;
        switch (key) {
            case 2087749783: {
                return this.colorspace;
            }
            case 1147962727: {
                return this.subtype;
            }
            case 608780341: {
                return this.type;
            }
        }
        return def;
    }

    public int setConstant(int pdfKeyType, int id) {
        int PDFvalue = id;
        switch (id) {
            case -1044665361: {
                PDFvalue = 373243460;
            }
        }
        switch (pdfKeyType) {
            case 2087749783: {
                this.colorspace = PDFvalue;
                break;
            }
            case 1147962727: {
                this.subtype = PDFvalue;
                break;
            }
            case 608780341: {
                this.type = PDFvalue;
            }
        }
        return PDFvalue;
    }

    public float[] getFloatArray(int id) {
        float[] array = null;
        switch (id) {
            case 1142050954: {
                return PdfObject.deepCopy(this.ArtBox);
            }
            case 303185736: {
                return PdfObject.deepCopy(this.BBox);
            }
            case 1179546749: {
                return PdfObject.deepCopy(this.BleedBox);
            }
            case 1076199815: {
                return PdfObject.deepCopy(this.CropBox);
            }
            case 859785322: {
                return PdfObject.deepCopy(this.Decode);
            }
            case 1026641277: {
                return PdfObject.deepCopy(this.Domain);
            }
            case 1145198201: {
                return PdfObject.deepCopy(this.Matrix);
            }
            case 1313305473: {
                return PdfObject.deepCopy(this.MediaBox);
            }
            case 826160983: {
                return PdfObject.deepCopy(this.Range);
            }
            case 1026982273: {
                return PdfObject.deepCopy(this.TrimBox);
            }
        }
        return PdfObject.deepCopy(array);
    }

    public byte[][] getKeyArray(int id) {
        switch (id) {
            default: 
        }
        return null;
    }

    public double[] getDoubleArray(int id) {
        double[] array = null;
        switch (id) {
            default: 
        }
        return PdfObject.deepCopy(array);
    }

    public boolean[] getBooleanArray(int id) {
        boolean[] array = null;
        switch (id) {
            default: 
        }
        return PdfObject.deepCopy(array);
    }

    public int[] getIntArray(int id) {
        int[] array = null;
        switch (id) {
            default: 
        }
        return PdfObject.deepCopy(array);
    }

    public void setFloatArray(int id, float[] value) {
        switch (id) {
            case 1142050954: {
                this.ArtBox = value;
                break;
            }
            case 303185736: {
                this.BBox = value;
                break;
            }
            case 1179546749: {
                this.BleedBox = value;
                break;
            }
            case 1076199815: {
                this.CropBox = value;
                break;
            }
            case 859785322: {
                this.Decode = PdfObject.ignoreIdentity(value);
                break;
            }
            case 1026641277: {
                this.Domain = value;
                break;
            }
            case 1145198201: {
                this.Matrix = value;
                break;
            }
            case 1313305473: {
                this.MediaBox = value;
                break;
            }
            case 826160983: {
                this.Range = value;
                break;
            }
            case 1026982273: {
                this.TrimBox = value;
                break;
            }
        }
    }

    private static float[] ignoreIdentity(float[] value) {
        boolean isIdentity = true;
        if (value != null) {
            int count = value.length;
            for (int aa = 0; aa < count; aa += 2) {
                if (value[aa] == 0.0f && value[aa + 1] == 1.0f) continue;
                isIdentity = false;
                aa = count;
            }
        }
        if (isIdentity) {
            return null;
        }
        return value;
    }

    public void setIntArray(int id, int[] value) {
        switch (id) {
            default: 
        }
    }

    public void setBooleanArray(int id, boolean[] value) {
        switch (id) {
            default: 
        }
    }

    public void setDoubleArray(int id, double[] value) {
        switch (id) {
            default: 
        }
    }

    public void setMixedArray(int id, byte[][] value) {
        switch (id) {
            case 1011108731: {
                this.Filter = value;
                break;
            }
        }
    }

    public String getStringValue(int id, int mode) {
        byte[] data = null;
        switch (id) {
            case 506543413: {
                data = this.rawName;
            }
        }
        switch (mode) {
            case 0: {
                if (data != null) {
                    return new String(data);
                }
                return null;
            }
            case 1: {
                if (data != null) {
                    return new String(data);
                }
                return null;
            }
            case 2: {
                if (data != null) {
                    int len = data.length;
                    if (len > 6 && data[6] == 43) {
                        int length = len - 7;
                        byte[] newData = new byte[length];
                        System.arraycopy(data, 7, newData, 0, length);
                        return new String(newData);
                    }
                    return new String(data);
                }
                return null;
            }
        }
        throw new RuntimeException("Value not defined in getName(int,mode)");
    }

    public int getNameAsConstant(int id) {
        return -1;
    }

    public String getName(int id) {
        String str = null;
        switch (id) {
            case 506543413: {
                if (this.Name == null && this.rawName != null) {
                    this.Name = new String(this.rawName);
                }
                return this.Name;
            }
            case 35: {
                if (this.S == null && this.rawS != null) {
                    this.S = new String(this.rawS);
                }
                return this.S;
            }
        }
        return str;
    }

    public String getStringKey(int id) {
        String str = null;
        switch (id) {
            case 1110793845: {
                if (this.Parent == null && this.rawParent != null) {
                    this.Parent = new String(this.rawParent);
                }
                return this.Parent;
            }
        }
        return str;
    }

    public String getTextStreamValue(int id) {
        String str = null;
        switch (id) {
            case 827818359: {
                if (this.Creator == null && this.rawCreator != null) {
                    this.Creator = StringUtils.getTextString(this.rawCreator, false);
                }
                return this.Creator;
            }
            case 506543413: {
                if (this.Name == null && this.rawName != null) {
                    this.Name = StringUtils.getTextString(this.rawName, false);
                }
                return this.Name;
            }
            case 960773209: {
                if (this.Title == null && this.rawTitle != null) {
                    this.Title = StringUtils.getTextString(this.rawTitle, false);
                }
                return this.Title;
            }
        }
        return str;
    }

    public void setName(int id, byte[] value) {
        switch (id) {
            case 506543413: {
                this.rawName = value;
                break;
            }
            case 35: {
                this.rawS = value;
                break;
            }
            case 1110793845: {
                if (!this.includeParent) break;
                this.rawParent = value;
                break;
            }
            default: {
                if (this.objType != 487790868) break;
                this.otherValues.put(this.currentKey, value);
            }
        }
    }

    public void setName(Object id, String value) {
        this.otherValues.put(id, value);
    }

    public void setStringKey(int id, byte[] value) {
        switch (id) {
            case 1110793845: {
                this.rawParent = value;
                break;
            }
        }
    }

    public void setTextStreamValue(int id, byte[] value) {
        switch (id) {
            case 827818359: {
                this.rawCreator = value;
                break;
            }
            case 506543413: {
                this.rawName = value;
                break;
            }
            case 960773209: {
                this.rawTitle = value;
                break;
            }
        }
    }

    public byte[] getDecodedStream() {
        if (this.isCached()) {
            byte[] cached;
            block3: {
                cached = null;
                try {
                    File f = new File(this.getCachedStreamFile(this.objReader));
                    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
                    cached = new byte[(int)f.length()];
                    bis.read(cached);
                    bis.close();
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            return cached;
        }
        return this.DecodedStream;
    }

    public void setStream(byte[] stream) {
        this.stream = stream;
        if (this.getObjectType() == 2087749783) {
            this.hasStream = true;
        }
    }

    public void setDecodedStream(byte[] stream) {
        this.DecodedStream = stream;
    }

    public String getObjectRefAsString() {
        if (this.ref == null) {
            this.ref = this.intRef + " " + this.gen + " R";
        }
        return this.ref;
    }

    public int getObjectRefID() {
        block7: {
            int ptr;
            if (this.intRef == 0 && this.ref != null && !this.ref.contains("[") && (ptr = this.ref.indexOf(32)) > 0) {
                block6: {
                    try {
                        this.intRef = Integer.parseInt(this.ref.substring(0, ptr));
                    }
                    catch (Exception e) {
                        if (!LogWriter.isOutput()) break block6;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                int ptr2 = this.ref.indexOf(82, ptr);
                if (ptr2 > 0) {
                    try {
                        this.gen = Integer.parseInt(this.ref.substring(ptr + 1, ptr2 - 1));
                    }
                    catch (Exception e) {
                        if (!LogWriter.isOutput()) break block7;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
            }
        }
        return this.intRef;
    }

    public int getObjectRefGeneration() {
        return this.gen;
    }

    public PdfArrayIterator getMixedArray(int id) {
        switch (id) {
            case 1011108731: {
                return new PdfArrayIterator(this.Filter);
            }
        }
        return null;
    }

    public void setDictionaryPairs(byte[][] keys, byte[][] values, PdfObject[] objs) {
        this.keys = keys;
        this.values = values;
        this.objs = objs;
    }

    public PdfKeyPairsIterator getKeyPairsIterator() {
        return new PdfKeyPairsIterator(this.keys, this.values, this.objs);
    }

    public void setKeyArray(int id, byte[][] keyValues) {
        switch (id) {
            default: 
        }
    }

    public void setStringArray(int id, byte[][] keyValues) {
        switch (id) {
            case 9250: {
                this.TR = keyValues;
                break;
            }
        }
    }

    public byte[][] getStringArray(int id) {
        switch (id) {
            case 9250: {
                return PdfObject.deepCopy(this.TR);
            }
        }
        return null;
    }

    public Object[] getObjectArray(int id) {
        switch (id) {
            case 1888135062: {
                return this.DecodeParmsAsArray;
            }
        }
        return null;
    }

    public void setObjectArray(int id, Object[] objectValues) {
        switch (id) {
            case 1888135062: {
                this.DecodeParmsAsArray = objectValues;
                break;
            }
        }
    }

    public PdfObject duplicate() {
        PdfObject copy = new PdfObject();
        return copy;
    }

    public Object clone() {
        Object o;
        block2: {
            o = null;
            try {
                o = super.clone();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return o;
    }

    public boolean decompressStreamWhenRead() {
        return false;
    }

    public int getObjectType() {
        return this.objType;
    }

    public byte[] getStringValueAsByte(int id) {
        return null;
    }

    public boolean isCompressedStream() {
        return this.isCompressedStream;
    }

    public void setCompressedStream(boolean isCompressedStream) {
        this.isCompressedStream = isCompressedStream;
    }

    public boolean ignoreRecursion() {
        return this.ignoreRecursion;
    }

    public void ignoreRecursion(boolean ignoreRecursion) {
        this.ignoreRecursion = ignoreRecursion;
    }

    public byte[] getTextStreamValueAsByte(int id) {
        return null;
    }

    public byte[][] getByteArray(int id) {
        return null;
    }

    public void setTextStreamValue(int id2, String value) {
    }

    public Map getOtherDictionaries() {
        return this.otherValues;
    }

    public void setCurrentKey(Object key) {
        this.currentKey = key;
    }

    public String toString(float[] floatArray, boolean appendPageNumber) {
        if (floatArray == null) {
            return null;
        }
        StringBuilder value = new StringBuilder();
        if (appendPageNumber) {
            value.append(this.pageNumber);
            value.append(' ');
        }
        for (float aFloatArray : floatArray) {
            value.append(aFloatArray);
            value.append(' ');
        }
        return value.toString();
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int number) {
        this.pageNumber = number;
    }

    public void setPageNumber(Object field) {
        if (field instanceof String) {
            try {
                this.pageNumber = Integer.parseInt((String)field);
            }
            catch (NumberFormatException e) {
                this.pageNumber = 1;
            }
        } else {
            LogWriter.writeFormLog("{FormObject.setPageNumber} pagenumber being set to UNKNOWN type", false);
        }
    }

    public void setCache(long offset, PdfFileReader objReader) {
        this.startStreamOnDisk = offset;
        this.objReader = objReader;
    }

    public boolean isCached() {
        return this.startStreamOnDisk != -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCachedStreamFile(PdfFileReader objReader) {
        File tmpFile = null;
        if (this.startStreamOnDisk != -1L) {
            try {
                tmpFile = File.createTempFile("jpedal-", ".bin", new File(ObjectStore.temp_dir));
                tmpFile.deleteOnExit();
                objReader.spoolStreamDataToDisk(tmpFile, this.startStreamOnDisk);
                this.cacheName = tmpFile.getAbsolutePath();
            }
            catch (Exception e) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            finally {
                if (tmpFile != null) {
                    tmpFile.deleteOnExit();
                }
            }
        }
        if (this.getObjectType() != 979194486) {
            objReader.readStream(this, true, true, false, this.getObjectType() == 1365674082, this.isCompressedStream, this.cacheName);
        }
        return this.cacheName;
    }

    public boolean isColorSpaceIndexed() {
        return this.isIndexed;
    }

    public void setInCompressedStream(boolean isInCompressedStream) {
    }

    public boolean isInCompressedStream() {
        return this.isInCompressedStream;
    }

    public void maybeIndirect(boolean b) {
        this.maybeIndirect = b;
    }

    public boolean maybeIndirect() {
        return this.maybeIndirect;
    }

    public boolean isFullyResolved() {
        return this.isFullyResolved;
    }

    public void setFullyResolved(boolean isFullyResolved) {
        this.isFullyResolved = isFullyResolved;
    }

    public boolean isDataExternal() {
        return this.isDataExternal;
    }

    public void isDataExternal(boolean isDataExternal) {
        this.isDataExternal = isDataExternal;
    }

    public boolean ignoreStream() {
        return this.ignoreStream;
    }

    public void ignoreStream(boolean ignoreStream) {
        this.ignoreStream = ignoreStream;
    }

    public void setStreamMayBeCorrupt(boolean streamMayBeCorrupt) {
        this.streamMayBeCorrupt = streamMayBeCorrupt;
    }

    public boolean streamMayBeCorrupt() {
        return this.streamMayBeCorrupt;
    }

    public void moveCacheValues(PdfObject pdfObject) {
        this.startStreamOnDisk = pdfObject.startStreamOnDisk;
        pdfObject.startStreamOnDisk = -1L;
        this.cacheName = pdfObject.cacheName;
        pdfObject.cacheName = null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PdfObject [");
        if (this.rawName != null) {
            builder.append("rawName=");
            builder.append(new String(this.rawName));
            builder.append(", ");
        }
        builder.append("isIndexed=");
        builder.append(this.isIndexed);
        builder.append(", maybeIndirect=");
        builder.append(this.maybeIndirect);
        builder.append(", isFullyResolved=");
        builder.append(this.isFullyResolved);
        builder.append(", isDataExternal=");
        builder.append(this.isDataExternal);
        builder.append(", streamMayBeCorrupt=");
        builder.append(this.streamMayBeCorrupt);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", ");
        if (this.unresolvedData != null) {
            builder.append("unresolvedData=");
            builder.append(new String(this.unresolvedData));
            builder.append(", ");
        }
        if (this.otherValues != null) {
            builder.append("otherValues=");
            builder.append(this.otherValues);
            builder.append(", ");
        }
        builder.append("pageNumber=");
        builder.append(this.pageNumber);
        builder.append(", PDFkeyInt=");
        builder.append(this.PDFkeyInt);
        builder.append(", objType=");
        builder.append(this.objType);
        builder.append(", id=");
        builder.append(this.id);
        builder.append(", colorspace=");
        builder.append(this.colorspace);
        builder.append(", subtype=");
        builder.append(this.subtype);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", BitsPerComponent=");
        builder.append(this.BitsPerComponent);
        builder.append(", BitsPerCoordinate=");
        builder.append(this.BitsPerCoordinate);
        builder.append(", BitsPerFlag=");
        builder.append(this.BitsPerFlag);
        builder.append(", Count=");
        builder.append(this.Count);
        builder.append(", FormType=");
        builder.append(this.FormType);
        builder.append(", Length=");
        builder.append(this.Length);
        builder.append(", Length1=");
        builder.append(this.Length1);
        builder.append(", Length2=");
        builder.append(this.Length2);
        builder.append(", Length3=");
        builder.append(this.Length3);
        builder.append(", Rotate=");
        builder.append(this.Rotate);
        builder.append(", ");
        if (this.ArtBox != null) {
            builder.append("ArtBox=");
            builder.append(Arrays.toString(this.ArtBox));
            builder.append(", ");
        }
        if (this.BBox != null) {
            builder.append("BBox=");
            builder.append(Arrays.toString(this.BBox));
            builder.append(", ");
        }
        if (this.BleedBox != null) {
            builder.append("BleedBox=");
            builder.append(Arrays.toString(this.BleedBox));
            builder.append(", ");
        }
        if (this.CropBox != null) {
            builder.append("CropBox=");
            builder.append(Arrays.toString(this.CropBox));
            builder.append(", ");
        }
        if (this.Decode != null) {
            builder.append("Decode=");
            builder.append(Arrays.toString(this.Decode));
            builder.append(", ");
        }
        if (this.Domain != null) {
            builder.append("Domain=");
            builder.append(Arrays.toString(this.Domain));
            builder.append(", ");
        }
        if (this.Matrix != null) {
            builder.append("Matrix=");
            builder.append(Arrays.toString(this.Matrix));
            builder.append(", ");
        }
        if (this.MediaBox != null) {
            builder.append("MediaBox=");
            builder.append(Arrays.toString(this.MediaBox));
            builder.append(", ");
        }
        if (this.Range != null) {
            builder.append("Range=");
            builder.append(Arrays.toString(this.Range));
            builder.append(", ");
        }
        if (this.TrimBox != null) {
            builder.append("TrimBox=");
            builder.append(Arrays.toString(this.TrimBox));
            builder.append(", ");
        }
        if (this.ColorSpace != null) {
            builder.append("ColorSpace=");
            builder.append(this.ColorSpace);
            builder.append(", ");
        }
        if (this.DecodeParms != null) {
            builder.append("DecodeParms=");
            builder.append(this.DecodeParms);
            builder.append(", ");
        }
        if (this.Encoding != null) {
            builder.append("Encoding=");
            builder.append(this.Encoding);
            builder.append(", ");
        }
        if (this.Function != null) {
            builder.append("Function=");
            builder.append(this.Function);
            builder.append(", ");
        }
        if (this.Resources != null) {
            builder.append("Resources=");
            builder.append(this.Resources);
            builder.append(", ");
        }
        if (this.Shading != null) {
            builder.append("Shading=");
            builder.append(this.Shading);
            builder.append(", ");
        }
        if (this.SMask != null) {
            builder.append("SMask=");
            builder.append(this.SMask);
            builder.append(", ");
        }
        builder.append("ignoreRecursion=");
        builder.append(this.ignoreRecursion);
        builder.append(", ignoreStream=");
        builder.append(this.ignoreStream);
        builder.append(", isZapfDingbats=");
        builder.append(this.isZapfDingbats);
        builder.append(", isSymbol=");
        builder.append(this.isSymbol);
        builder.append(", isCompressedStream=");
        builder.append(this.isCompressedStream);
        builder.append(", generalType=");
        builder.append(this.generalType);
        builder.append(", ");
        if (this.generalTypeAsString != null) {
            builder.append("generalTypeAsString=");
            builder.append(this.generalTypeAsString);
            builder.append(", ");
        }
        builder.append("includeParent=");
        builder.append(this.includeParent);
        builder.append(", ");
        if (this.Creator != null) {
            builder.append("Creator=");
            builder.append(this.Creator);
            builder.append(", ");
        }
        if (this.Parent != null) {
            builder.append("Parent=");
            builder.append(this.Parent);
            builder.append(", ");
        }
        if (this.Name != null) {
            builder.append("Name=");
            builder.append(this.Name);
            builder.append(", ");
        }
        if (this.S != null) {
            builder.append("S=");
            builder.append(this.S);
            builder.append(", ");
        }
        if (this.Title != null) {
            builder.append("Title=");
            builder.append(this.Title);
            builder.append(", ");
        }
        if (this.rawCreator != null) {
            builder.append("rawCreator=");
            builder.append(new String(this.rawCreator));
            builder.append(", ");
        }
        if (this.rawParent != null) {
            builder.append("rawParent=");
            builder.append(new String(this.rawParent));
            builder.append(", ");
        }
        if (this.rawS != null) {
            builder.append("rawS=");
            builder.append(new String(this.rawS));
            builder.append(", ");
        }
        if (this.rawTitle != null) {
            builder.append("rawTitle=");
            builder.append(new String(this.rawTitle));
            builder.append(", ");
        }
        if (this.ref != null) {
            builder.append("ref=");
            builder.append(this.ref);
            builder.append(", ");
        }
        builder.append("intRef=");
        builder.append(this.intRef);
        builder.append(", gen=");
        builder.append(this.gen);
        builder.append(", hasStream=");
        builder.append(this.hasStream);
        builder.append(", ");
        if (this.stream != null) {
            builder.append("stream=");
            builder.append(new String(this.stream));
            builder.append(", ");
        }
        if (this.DecodedStream != null) {
            builder.append("DecodedStream=");
            builder.append(new String(this.DecodedStream));
            builder.append(", ");
        }
        builder.append("startStreamOnDisk=");
        builder.append(this.startStreamOnDisk);
        builder.append(", ");
        if (this.objReader != null) {
            builder.append("objReader=");
            builder.append(this.objReader);
            builder.append(", ");
        }
        if (this.cacheName != null) {
            builder.append("cacheName=");
            builder.append(this.cacheName);
            builder.append(", ");
        }
        if (this.Filter != null) {
            builder.append("Filter=");
            builder.append(Arrays.toString((Object[])this.Filter));
            builder.append(", ");
        }
        if (this.TR != null) {
            builder.append("TR=");
            builder.append(Arrays.toString((Object[])this.TR));
            builder.append(", ");
        }
        if (this.keys != null) {
            builder.append("keys=");
            builder.append(Arrays.toString((Object[])this.keys));
            builder.append(", ");
        }
        if (this.values != null) {
            builder.append("values=");
            builder.append(Arrays.toString((Object[])this.values));
            builder.append(", ");
        }
        if (this.DecodeParmsAsArray != null) {
            builder.append("DecodeParmsAsArray=");
            builder.append(Arrays.toString(this.DecodeParmsAsArray));
            builder.append(", ");
        }
        if (this.objs != null) {
            builder.append("objs=");
            builder.append(Arrays.toString(this.objs));
            builder.append(", ");
        }
        if (this.currentKey != null) {
            builder.append("currentKey=");
            builder.append(this.currentKey);
            builder.append(", ");
        }
        builder.append("parentType=");
        builder.append(this.parentType);
        builder.append(", isInCompressedStream=");
        builder.append(this.isInCompressedStream);
        builder.append("]");
        return builder.toString();
    }
}

