/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import org.jpedal.fonts.StandardFonts;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class PdfArrayIterator {
    public static final int TYPE_KEY_INTEGER = 1;
    public static final int TYPE_VALUE_INTEGER = 2;
    byte[][] rawData = null;
    boolean hasHexChars = false;
    int tokenCount = 0;
    int currentToken = 0;
    int spaceChar = -1;

    public PdfArrayIterator(byte[][] rawData) {
        this.rawData = rawData;
        if (rawData != null) {
            this.tokenCount = rawData.length;
        }
    }

    public PdfArrayIterator(String colorspaceObject) {
        byte[][] rawData = new byte[][]{StringUtils.toBytes(colorspaceObject)};
        this.tokenCount = 1;
    }

    public boolean hasMoreTokens() {
        return this.currentToken < this.tokenCount;
    }

    public int getNextValueType() {
        if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
            return -1;
        }
        int len = this.rawData[this.currentToken].length;
        boolean isNumber = true;
        for (int ii = 0; ii < len; ++ii) {
            byte firstByte = this.rawData[this.currentToken][ii];
            if (firstByte >= 47 && firstByte < 58) continue;
            ii = len;
            isNumber = false;
        }
        if (isNumber) {
            if (this.rawData[this.currentToken][0] != 47) {
                return 1;
            }
            return 2;
        }
        return -1;
    }

    public String getNextValueAsFontChar(int pointer, boolean containsHexNumbers, boolean allNumbers) {
        String value;
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            int length = this.rawData[this.currentToken].length - 1;
            byte[] raw = new byte[length];
            System.arraycopy(this.rawData[this.currentToken], 1, raw, 0, length);
            value = new String(raw);
            value = StandardFonts.convertNumberToGlyph(value, containsHexNumbers, allNumbers);
            char c = value.charAt(0);
            if (c == 'B' || c == 'c' || c == 'C' || c == 'G') {
                int i = 1;
                int l = value.length();
                while (!this.hasHexChars && i < l) {
                    this.hasHexChars = Character.isLetter(value.charAt(i++));
                }
            }
            if (raw.length == 5 && raw[0] == 115 && raw[1] == 112 && raw[2] == 97 && raw[3] == 99 && raw[4] == 101) {
                this.spaceChar = pointer;
            }
            ++this.currentToken;
        } else {
            throw new RuntimeException("Out of range exception with PdfArrayIterator");
        }
        return value;
    }

    public float getNextValueAsFloat() {
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            byte[] raw = this.rawData[this.currentToken];
            ++this.currentToken;
            if (raw[0] == 110 && raw[1] == 117 && raw[2] == 108 && raw[2] == 108) {
                return 0.0f;
            }
            return NumberUtils.parseFloat(0, raw.length, raw);
        }
        throw new RuntimeException("Out of range exception with PdfArrayIterator");
    }

    public int getNextValueAsInteger() {
        return this.getNextValueAsInteger(true);
    }

    public int getNextValueAsInteger(boolean rollOn) {
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            byte[] raw = this.rawData[this.currentToken];
            if (rollOn) {
                ++this.currentToken;
            }
            int i = 0;
            if (raw[0] == 47) {
                ++i;
            }
            return NumberUtils.parseInt(i, raw.length, raw);
        }
        throw new RuntimeException("Out of range exception with PdfArrayIterator");
    }

    public float[] getNextValueAsFloatArray() {
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            byte[] raw = this.rawData[this.currentToken];
            ++this.currentToken;
            if (raw[0] == 110 && raw[1] == 117 && raw[2] == 108 && raw[2] == 108) {
                return new float[1];
            }
            int length = raw.length;
            int elementCount = 1;
            int elementReached = 0;
            for (int ii = 1; ii < length; ++ii) {
                if (raw[ii] != 32 && raw[ii] != 10 && raw[ii] != 13 || raw[ii - 1] == 32 || raw[ii - 1] != 10 || raw[ii - 1] != 13) continue;
                ++elementCount;
            }
            float[] values = new float[elementCount];
            for (int ii = 0; ii < length; ++ii) {
                while (ii < length && (raw[ii] == 32 || raw[ii] == 10 || raw[ii] == 13)) {
                    ++ii;
                }
                int start = ii;
                while (ii < length && raw[ii] != 32 && raw[ii] != 10 && raw[ii] != 13) {
                    ++ii;
                }
                values[elementReached] = NumberUtils.parseFloat(start, ii, raw);
                ++elementReached;
            }
            return values;
        }
        throw new RuntimeException("Out of range exception with PdfArrayIterator");
    }

    public int getNextValueAsConstant(boolean moveToNextAfter) {
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            byte[] raw = this.rawData[this.currentToken];
            if (moveToNextAfter) {
                ++this.currentToken;
            }
            return PdfDictionary.getIntKey(1, raw.length - 1, raw);
        }
        throw new RuntimeException("Out of range exception with PdfArrayIterator");
    }

    public int getSpaceChar() {
        return this.spaceChar;
    }

    public boolean hasHexChars() {
        return this.hasHexChars;
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public String getNextValueAsString(boolean rollon) {
        String value = "";
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null) {
                throw new RuntimeException("Null Value exception with PdfArrayIterator rawData=" + this.rawData);
            }
            byte[] raw = this.rawData[this.currentToken];
            if (raw != null) {
                value = new String(raw);
            }
            if (rollon) {
                ++this.currentToken;
            }
        } else {
            throw new RuntimeException("Out of range exception with PdfArrayIterator");
        }
        return value;
    }

    public byte[] getNextValueAsByte(boolean rollon) {
        byte[] value = null;
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null) {
                throw new RuntimeException("Null Value exception with PdfArrayIterator rawData=" + this.rawData);
            }
            byte[] raw = this.rawData[this.currentToken];
            if (raw != null) {
                int length = raw.length;
                value = new byte[length];
                System.arraycopy(raw, 0, value, 0, length);
            }
            if (rollon) {
                ++this.currentToken;
            }
        } else {
            throw new RuntimeException("Out of range exception with PdfArrayIterator");
        }
        return value;
    }

    public int getNextValueAsKey() {
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            byte[] raw = this.rawData[this.currentToken];
            ++this.currentToken;
            return PdfDictionary.getIntKey(0, raw.length, raw);
        }
        throw new RuntimeException("Out of range exception with PdfArrayIterator");
    }

    public boolean isNextValueRef() {
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                return false;
            }
        } else {
            throw new RuntimeException("Out of range exception with PdfArrayIterator");
        }
        byte[] raw = this.rawData[this.currentToken];
        boolean isRef = raw[raw.length - 1] == 82;
        return isRef;
    }

    public void resetToStart() {
        if (this.rawData != null) {
            this.tokenCount = this.rawData.length;
        }
        this.currentToken = 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PdfArrayIterator [");
        if (this.rawData != null) {
            builder.append("rawData=");
            for (int i = 0; i < this.rawData.length; ++i) {
                builder.append(new String(this.rawData[i]));
                builder.append(", ");
            }
            builder.append("], ");
        }
        builder.append("hasHexChars=");
        builder.append(this.hasHexChars);
        builder.append(", tokenCount=");
        builder.append(this.tokenCount);
        builder.append(", currentToken=");
        builder.append(this.currentToken);
        builder.append(", spaceChar=");
        builder.append(this.spaceChar);
        builder.append("]");
        return builder.toString();
    }
}

