/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.overridingImplementations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import org.jpedal.objects.acroforms.overridingImplementations.CustomImageIcon;
import org.jpedal.objects.raw.FormObject;

public class FixImageIcon
extends CustomImageIcon
implements Icon,
SwingConstants {
    private static final long serialVersionUID = 8946195842453749725L;
    private int selected = -1;
    private static final int UNSELECTEDICON = 0;
    private static final int SELECTEDICON = 1;
    private BufferedImage imageSelected = null;
    private BufferedImage imageUnselected = null;

    public FixImageIcon(BufferedImage img, int iconRot) {
        super(iconRot);
        this.imageSelected = img != null ? img : FormObject.getOpaqueImage();
        this.selected = -1;
    }

    public FixImageIcon(BufferedImage selImg, BufferedImage unselImg, int iconRot, int sel) {
        super(iconRot);
        this.imageSelected = selImg;
        this.imageUnselected = unselImg;
        this.selected = sel;
    }

    @Override
    public Image getImage() {
        BufferedImage image;
        switch (this.selected) {
            case 0: {
                image = this.imageUnselected;
                break;
            }
            default: {
                image = this.imageSelected;
            }
        }
        return image;
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        BufferedImage image = (BufferedImage)this.getImage();
        if (image == null) {
            return;
        }
        if (c.isEnabled()) {
            g.setColor(c.getBackground());
        } else {
            g.setColor(Color.gray);
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.iconWidth > 0 && this.iconHeight > 0) {
            int drawWidth = this.iconWidth;
            int drawHeight = this.iconHeight;
            boolean rotateIcon = false;
            if (this.iconRotation == 270 || this.iconRotation == 90) {
                rotateIcon = true;
                drawWidth = this.iconHeight;
                drawHeight = this.iconWidth;
            }
            int posX = 0;
            int posY = 0;
            int finalRotation = this.displaySingle ? FixImageIcon.validateRotationValue(this.pageRotate - this.iconRotation) : this.pageRotate;
            if (finalRotation == 270) {
                g2.rotate(-1.5707963267948966);
                g2.translate(-drawWidth, 0);
                g2.drawImage(image, -posX, posY, drawWidth, drawHeight, null);
            } else if (finalRotation == 90) {
                g2.rotate(1.5707963267948966);
                g2.translate(0, -drawHeight);
                g2.drawImage(image, posX, -posY, drawWidth, drawHeight, null);
            } else if (finalRotation == 180) {
                g2.rotate(Math.PI);
                g2.translate(-drawWidth, -drawHeight);
                g2.drawImage(image, -posX, -posY, drawWidth, drawHeight, null);
            } else {
                g2.drawImage(image, posX, posY, drawWidth, drawHeight, null);
            }
        } else {
            g2.drawImage((Image)image, 0, 0, null);
        }
        g2.translate(-x, -y);
    }

    public void swapImage(boolean selectedImage) {
        if (this.selected == -1) {
            return;
        }
        this.selected = selectedImage ? 1 : 0;
    }

    public void setPrinting(boolean print, int multiplier) {
    }

    public void setImageIcon(BufferedImage imageSpace) {
        this.imageSelected = imageSpace;
        this.selected = -1;
        this.iconRotation = 0;
        this.iconOpp = this.iconRotation - 180;
        if (this.iconOpp < 0) {
            this.iconOpp += 360;
        }
    }
}

