/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.formData;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.external.CustomFormPrint;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.JPedalBorderFactory;
import org.jpedal.objects.acroforms.formData.ComponentData;
import org.jpedal.objects.acroforms.overridingImplementations.FixImageIcon;
import org.jpedal.objects.acroforms.overridingImplementations.PdfSwingPopup;
import org.jpedal.objects.acroforms.overridingImplementations.ReadOnlyTextIcon;
import org.jpedal.objects.acroforms.utils.FormUtils;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class SwingData
extends ComponentData {
    public static boolean JVMBugRightAlignFix = false;
    CustomFormPrint customFormPrint = null;
    private JPanel panel;
    public static int readOnlyScaling = -1;
    boolean renderFormsWithJPedalFontRenderer = false;
    private Component[] popups = new Component[0];
    int maxLengthForTextOnPage = 0;

    public SwingData() {
    }

    public SwingData(int html) {
        this.formFactoryType = html;
    }

    @Override
    public void loseFocus() {
    }

    @Override
    public void setValue(String ref, Object value, boolean isValid, boolean isFormatted) {
        Object checkObj = super.setValue(ref, value, isValid, isFormatted, this.getValue(ref));
        if (checkObj != null) {
            this.setFormValue(value, checkObj);
        }
    }

    @Override
    public Object getFormValue(Object checkObj) {
        Object retValue = "";
        if (checkObj != null) {
            int index = (Integer)checkObj;
            Object comp = this.checkGUIObjectResolved((Integer)checkObj);
            FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(index));
            int type = formObject.getFormType();
            switch (type) {
                case 9: {
                    retValue = ((JCheckBox)comp).isSelected();
                    break;
                }
                case 2: {
                    retValue = ((JComboBox)comp).getSelectedItem();
                    break;
                }
                case 1: {
                    retValue = ((JList)comp).getSelectedValues();
                    break;
                }
                case 8: {
                    retValue = ((JRadioButton)comp).isSelected();
                    break;
                }
                case 4: {
                    retValue = ((JTextComponent)comp).getText();
                    break;
                }
                case 6: {
                    retValue = ((JTextComponent)comp).getText();
                    break;
                }
                case 5: {
                    retValue = ((JTextComponent)comp).getText();
                    break;
                }
                case 3: {
                    if (comp instanceof JButton) {
                        retValue = ((ReadOnlyTextIcon)((JButton)comp).getIcon()).getText();
                        break;
                    }
                    retValue = formObject.getTextString();
                    break;
                }
                default: {
                    switch (formObject.getGUIType()) {
                        case 0: {
                            retValue = formObject.getTextString();
                        }
                    }
                }
            }
        }
        return retValue;
    }

    public void setFormValue(Object value, Object checkObj) {
        if (checkObj != null) {
            int index = (Integer)checkObj;
            Component comp = (Component)this.checkGUIObjectResolved(index);
            FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(index));
            int type = formObject.getFormType();
            switch (type) {
                case 9: {
                    ((JCheckBox)comp).setSelected(Boolean.valueOf((String)value));
                    break;
                }
                case 2: {
                    ((JComboBox)comp).setSelectedItem(value);
                    break;
                }
                case 1: {
                    ((JList)comp).setSelectedValue(value, false);
                    break;
                }
                case 8: {
                    ((JRadioButton)comp).setText((String)value);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    ((JTextComponent)comp).setText((String)value);
                    break;
                }
                case 3: {
                    this.checkGUIObjectResolved(index);
                    if (comp instanceof JButton) {
                        ((ReadOnlyTextIcon)((JButton)comp).getIcon()).setText((String)value);
                        break;
                    }
                    ((JTextComponent)comp).setText((String)value);
                    break;
                }
                case 7: 
                case 10: 
                case 11: {
                    break;
                }
            }
        }
    }

    public void debugForms() {
    }

    public void showForms() {
        if (this.nextFreeField > 0) {
            for (int i = 0; i < this.nextFreeField + 1; ++i) {
                FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(i));
                if (formObject == null) continue;
                Component comp = (Component)this.checkGUIObjectResolved(i);
                int type = formObject.getFormType();
                if (comp == null) continue;
                if (type == 7 || type == 10 || type == 11) {
                    comp.setBackground(Color.blue);
                } else if (type == 4 || type == 3 || type == 5 || type == 6) {
                    comp.setBackground(Color.red);
                    if (comp instanceof JButton) {
                        comp.setBackground(Color.cyan);
                    }
                } else {
                    comp.setBackground(Color.green);
                }
                comp.setForeground(Color.lightGray);
                comp.setVisible(true);
                comp.setEnabled(true);
                ((JComponent)comp).setOpaque(true);
                if (type == 7 || type == 9 || type == 10 || type == 11) {
                    ((AbstractButton)comp).setIcon(null);
                    continue;
                }
                if (type != 2) continue;
                ((JComboBox)comp).setEditable(false);
            }
        }
    }

    private void renderComponent(Graphics2D g2, int currentComp, Component comp, int rotation, boolean printcombo, int indent, boolean isPrinting) {
        if (comp != null) {
            boolean editable = false;
            int page = this.getPageForFormObject(this.convertIDtoRef(currentComp));
            if (!printcombo && comp instanceof JComboBox) {
                Object selected;
                JComboBox combo = (JComboBox)comp;
                if (combo.isEditable()) {
                    editable = true;
                    combo.setEditable(false);
                }
                if (combo.getComponentCount() > 0 && (selected = combo.getSelectedItem()) != null) {
                    JTextField text = new JTextField();
                    text.setText(selected.toString());
                    text.setBackground(combo.getBackground());
                    text.setForeground(combo.getForeground());
                    text.setFont(combo.getFont());
                    text.setBorder(combo.getBorder());
                    this.renderComponent(g2, currentComp, text, rotation, false, indent, isPrinting);
                }
                printcombo = true;
            }
            if (!printcombo) {
                AffineTransform ax = g2.getTransform();
                if (isPrinting) {
                    this.scaleComponent(page, 1.0f, rotation, currentComp, comp, false, false, indent);
                    switch (360 - rotation) {
                        case 270: {
                            AffineTransform at = AffineTransform.getRotateInstance(4.71238898038469, 0.0, 0.0);
                            g2.translate(comp.getBounds().y + this.cropOtherY[page] - this.insetH, this.pageData.getCropBoxHeight(page) - comp.getBounds().x + this.insetW);
                            g2.transform(at);
                            g2.translate(-this.insetW, 0);
                            break;
                        }
                        case 90: {
                            AffineTransform at = AffineTransform.getRotateInstance(1.5707963267948966, 0.0, 0.0);
                            g2.translate(comp.getBounds().y + this.cropOtherY[page] - this.insetH, comp.getBounds().x + this.insetW);
                            g2.transform(at);
                            g2.translate(0, -this.insetH);
                            break;
                        }
                        case 180: {
                            AffineTransform at = AffineTransform.getRotateInstance(Math.PI, 0.0, 0.0);
                            g2.translate(comp.getBounds().x - this.insetW, comp.getBounds().y + this.cropOtherY[page]);
                            g2.transform(at);
                            g2.translate(-this.insetW, -this.insetH);
                            break;
                        }
                        default: {
                            g2.translate(comp.getBounds().x - this.insetW, comp.getBounds().y + this.cropOtherY[page]);
                            break;
                        }
                    }
                } else {
                    this.scaleComponent(page, 1.0f, rotation, currentComp, comp, false, false, indent);
                    Rectangle rect = comp.getBounds();
                    g2.translate(rect.x - this.insetW, rect.y + this.cropOtherY[page]);
                    if (this.getFieldType(comp) == 0) {
                        int rotate;
                        if (this.pageData.getRotation(page) == 90 || this.pageData.getRotation(page) == 270) {
                            comp.setBounds(rect.x, rect.y, rect.height, rect.width);
                            rect = comp.getBounds();
                        }
                        if ((rotate = rotation - this.pageData.getRotation(0)) < 0) {
                            rotate = 360 + rotate;
                        }
                        switch (rotate) {
                            case 270: {
                                AffineTransform at = AffineTransform.getRotateInstance((double)rotate * Math.PI / 180.0, 0.0, 0.0);
                                g2.transform(at);
                                g2.translate(-rect.width, 0);
                                break;
                            }
                            case 90: {
                                AffineTransform at = AffineTransform.getRotateInstance((double)rotate * Math.PI / 180.0, 0.0, 0.0);
                                g2.transform(at);
                                g2.translate(0, -rect.height);
                                break;
                            }
                            case 180: {
                                AffineTransform at = AffineTransform.getRotateInstance((double)rotate * Math.PI / 180.0, 0.0, 0.0);
                                g2.transform(at);
                                g2.translate(-rect.width, -rect.height);
                            }
                        }
                    }
                }
                boolean isPainted = false;
                if (JVMBugRightAlignFix && comp instanceof JTextField) {
                    JTextField field = new JTextField();
                    JTextField source = (JTextField)comp;
                    if (source.getHorizontalAlignment() == 4) {
                        String newText;
                        field.setFont(source.getFont());
                        field.setLocation(source.getLocation());
                        field.setSize(source.getSize());
                        field.setBorder(source.getBorder());
                        field.setHorizontalAlignment(4);
                        int additionalBlanks = 0;
                        int width = g2.getFontMetrics(comp.getFont()).stringWidth(new String(SwingData.createCharArray(' ', this.maxLengthForTextOnPage - source.getText().length())) + source.getText());
                        int eightPointWidth = g2.getFontMetrics(comp.getFont().deriveFont(7.0f)).stringWidth(new String(SwingData.createCharArray(' ', this.maxLengthForTextOnPage - source.getText().length())) + source.getText());
                        int difference = width - eightPointWidth;
                        if (difference > 0) {
                            additionalBlanks = difference / g2.getFontMetrics(comp.getFont().deriveFont(7.0f)).stringWidth(" ");
                        }
                        String originalTest = source.getText();
                        int bunchOfSpaces = this.maxLengthForTextOnPage + additionalBlanks - source.getText().length();
                        field.setText(new String(SwingData.createCharArray(' ', bunchOfSpaces)) + originalTest);
                        width = g2.getFontMetrics(comp.getFont()).stringWidth(field.getText());
                        int insets = 0;
                        if (field.getBorder() != null) {
                            insets = field.getBorder().getBorderInsets((Component)field).left + field.getBorder().getBorderInsets((Component)field).right;
                        }
                        boolean needsChange = false;
                        while (bunchOfSpaces > 0 && width > field.getWidth() - insets) {
                            bunchOfSpaces = this.maxLengthForTextOnPage + additionalBlanks - source.getText().length();
                            newText = new String(SwingData.createCharArray(' ', bunchOfSpaces)) + originalTest;
                            field.setText(newText);
                            --additionalBlanks;
                            width = g2.getFontMetrics(comp.getFont().deriveFont(7.0f)).stringWidth(field.getText());
                            needsChange = true;
                        }
                        if (needsChange) {
                            bunchOfSpaces = this.maxLengthForTextOnPage + --additionalBlanks - source.getText().length();
                            newText = new String(SwingData.createCharArray(' ', bunchOfSpaces)) + originalTest;
                            field.setText(newText);
                        }
                        field.paint(g2);
                        isPainted = true;
                    }
                }
                if (!isPainted) {
                    comp.paint(g2);
                }
                g2.setTransform(ax);
            }
            if (editable) {
                ((JComboBox)comp).setEditable(true);
            }
        }
    }

    private static char[] createCharArray(char c, int count) {
        if (count <= 0) {
            return new char[0];
        }
        char[] result = new char[count];
        Arrays.fill(result, 0, result.length, c);
        return result;
    }

    @Override
    public void renderFormsOntoG2(Object raw, int pageIndex, float currentScaling, int currentIndent, int currentRotation, Map componentsToIgnore, FormFactory formFactory, PdfObjectReader currentPdfFile, int pageHeight) {
        AffineTransform defaultAf;
        Graphics2D g2;
        block29: {
            int currentComp;
            boolean isPrinting;
            if (this.formsUnordered == null || this.rasterizeForms) {
                return;
            }
            this.componentsToIgnore = componentsToIgnore;
            boolean bl = isPrinting = formFactory != null;
            if (JVMBugRightAlignFix && isPrinting) {
                this.maxLengthForTextOnPage = 0;
                for (Object o : this.formsUnordered[pageIndex]) {
                    JTextField text;
                    int newLength;
                    Component comp;
                    Object nextVal = o;
                    currentComp = (Integer)this.refToCompIndex.get(nextVal);
                    if (currentComp == -1 || !((comp = (Component)this.checkGUIObjectResolved(currentComp)) instanceof JTextField) || (newLength = (text = (JTextField)comp).getText().length()) <= this.maxLengthForTextOnPage || text.getHorizontalAlignment() != 4) continue;
                    this.maxLengthForTextOnPage = newLength;
                }
            }
            g2 = (Graphics2D)raw;
            defaultAf = g2.getTransform();
            AffineTransform aff = g2.getTransform();
            aff.scale(1.0, -1.0);
            aff.translate(0.0, -pageHeight - this.insetH);
            g2.setTransform(aff);
            try {
                JPanel dummyPanel = new JPanel();
                for (Object nextVal : this.formsUnordered[pageIndex]) {
                    boolean[] flags;
                    Object rawObj = this.refToCompIndex.get(nextVal);
                    if (rawObj == null || (currentComp = ((Integer)rawObj).intValue()) == -1 || (flags = ((FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(currentComp))).getCharacteristics())[1] || isPrinting && !flags[2]) continue;
                    this.checkGUIObjectResolved(currentComp);
                    FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(currentComp));
                    Component comp = (Component)formObject.getGUIComponent();
                    if (comp != null && comp.isVisible()) {
                        this.syncKidValues(currentComp);
                        Rectangle bounds = formObject.getBoundingRectangle();
                        float boundHeight = bounds.height;
                        int swingHeight = comp.getPreferredSize().height + 6;
                        if (this.renderFormsWithJPedalFontRenderer) {
                            Object[] rawForm;
                            String ref = this.convertIDtoRef(currentComp);
                            for (Object aRawForm : rawForm = this.getRawForm(ref)) {
                                if (aRawForm == null) continue;
                                FormObject form = (FormObject)aRawForm;
                                System.out.println(ref + ' ' + form.getTextFont() + ' ' + form.getTextString());
                            }
                        } else if (!this.isFormNotPrinted(currentComp)) {
                            if (comp instanceof JList && ((JList)comp).getSelectedIndex() != -1 && boundHeight < (float)swingHeight) {
                                JList comp2 = (JList)comp;
                                dummyPanel.add(comp);
                                ListModel model = comp2.getModel();
                                Object[] array = new Object[model.getSize()];
                                int selectedIndex = comp2.getSelectedIndex();
                                int c = 0;
                                array[c++] = model.getElementAt(selectedIndex);
                                for (int i = 0; i < array.length; ++i) {
                                    if (i == selectedIndex) continue;
                                    array[c++] = model.getElementAt(i);
                                }
                                comp2.setListData(array);
                                comp2.setSelectedIndex(0);
                                try {
                                    this.renderComponent(g2, currentComp, comp2, currentRotation, false, currentIndent, isPrinting);
                                    dummyPanel.remove(comp2);
                                }
                                catch (Exception exception) {}
                            } else {
                                boolean customPrintoverRide = false;
                                if (this.customFormPrint != null) {
                                    this.scaleComponent(this.currentPage, 1.0f, this.rotation, currentComp, comp, false, false, this.indent);
                                    customPrintoverRide = this.customFormPrint.print(g2, currentComp, comp, this);
                                }
                                if (!customPrintoverRide) {
                                    Icon obj22;
                                    if (comp instanceof AbstractButton && (obj22 = ((AbstractButton)comp).getIcon()) != null) {
                                        if (obj22 instanceof FixImageIcon) {
                                            ((FixImageIcon)obj22).setPrinting(true, 1);
                                        } else if (readOnlyScaling > 0 && obj22 instanceof ReadOnlyTextIcon) {
                                            ((ReadOnlyTextIcon)obj22).setPrinting(true, readOnlyScaling);
                                        }
                                    }
                                    dummyPanel.add(comp);
                                    try {
                                        this.renderComponent(g2, currentComp, comp, currentRotation, false, currentIndent, isPrinting);
                                        dummyPanel.remove(comp);
                                    }
                                    catch (Exception obj22) {
                                        // empty catch block
                                    }
                                    if (comp instanceof AbstractButton) {
                                        obj22 = ((AbstractButton)comp).getIcon();
                                        if (obj22 instanceof FixImageIcon) {
                                            ((FixImageIcon)obj22).setPrinting(false, 1);
                                        } else if (obj22 instanceof ReadOnlyTextIcon) {
                                            ((ReadOnlyTextIcon)obj22).setPrinting(false, 1);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (++currentComp != this.nextFreeField + 1) continue;
                    break;
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block29;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        g2.setTransform(defaultAf);
        if (this.currentPage == pageIndex && this.panel != null) {
            this.resetScaledLocation(this.displayScaling, this.rotation, this.indent);
        }
    }

    private void scaleComponent(int curPage, float scale, int rotate, int id, Component curComp, boolean redraw, boolean popups, int indent) {
        FormObject form;
        if (curComp == null) {
            return;
        }
        if (this.layers != null) {
            String ref = this.convertIDtoRef(id);
            String layerName = null;
            Object[] rawForm = this.getRawForm(ref);
            if (rawForm[0] != null) {
                layerName = ((FormObject)rawForm[0]).getLayerName();
            }
            if (layerName != null && this.layers.isLayerName(layerName)) {
                boolean isVisible = this.layers.isVisible(layerName);
                curComp.setVisible(isVisible);
            }
        }
        float[] box = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        boolean calcBounds = true;
        if (popups) {
            Rectangle popRect = curComp.getBounds();
            if (popRect.x != 0 && popRect.y != 0) {
                calcBounds = false;
            } else {
                box = this.popupBounds[id];
            }
        } else {
            FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(id));
            Rectangle rect = formObject.getBoundingRectangle();
            box = new float[]{rect.x, rect.y, rect.width + rect.x, rect.height + rect.y};
        }
        int[] bounds = new int[]{0, 0, 0, 0};
        if (calcBounds) {
            int cropRotation = rotate;
            bounds = this.cropComponent(box, curPage, scale, cropRotation, id, redraw);
        }
        if (popups) {
            bounds[2] = (int)(this.popupBounds[id][2] - this.popupBounds[id][0]);
            bounds[3] = (int)(this.popupBounds[id][3] - this.popupBounds[id][1]);
        }
        Font resetFont = curComp.getFont();
        if (!popups && resetFont != null) {
            this.recalcFontSize(scale, rotate, id, curComp);
        }
        if (!popups && curComp instanceof JComponent && ((JComponent)curComp).getBorder() != null && (form = (FormObject)this.rawFormData.get(this.convertIDtoRef(id))) != null) {
            ((JComponent)curComp).setBorder((Border)this.generateBorderfromForm(form, scale));
        }
        if (calcBounds && this.xReached != null) {
            bounds[0] = bounds[0] + this.xReached[curPage];
            bounds[1] = bounds[1] + this.yReached[curPage];
        }
        int pageWidth = (this.pageData.getRotation(curPage) + rotate) % 180 == 90 ? this.pageData.getCropBoxHeight(curPage) : this.pageData.getCropBoxWidth(curPage);
        if (this.displayView == 2) {
            double newIndent = rotate == 0 || rotate == 180 ? (double)((this.widestPageNR - pageWidth) / 2) : (double)((this.widestPageR - pageWidth) / 2);
            indent = (int)((double)indent + newIndent * (double)scale);
        }
        int totalOffsetX = this.userX + indent + this.insetW;
        int totalOffsetY = this.userY + this.insetH;
        Rectangle boundRect = new Rectangle(totalOffsetX + bounds[0], totalOffsetY + bounds[1], bounds[2], bounds[3]);
        if (popups) {
            if (!calcBounds) {
                Rectangle popRect = curComp.getBounds();
                boundRect.x = popRect.x;
                boundRect.y = popRect.y;
            }
            SwingData.checkPopupBoundsOnPage(boundRect, this.panel.getVisibleRect());
        }
        curComp.setBounds(boundRect);
        if (curComp != null && curComp instanceof AbstractButton) {
            AbstractButton but = (AbstractButton)curComp;
            Icon curIcon = but.getIcon();
            boolean displaySingle = false;
            if (this.displayView == 1 || this.displayView == 0) {
                displaySingle = true;
            }
            int combinedRotation = rotate;
            if (curIcon instanceof FixImageIcon) {
                ((FixImageIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), combinedRotation, displaySingle);
            } else if (curIcon instanceof ReadOnlyTextIcon) {
                ((ReadOnlyTextIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), combinedRotation, displaySingle);
            }
            curIcon = but.getPressedIcon();
            if (curIcon instanceof FixImageIcon) {
                ((FixImageIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), combinedRotation, displaySingle);
            }
            if ((curIcon = but.getSelectedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), combinedRotation, displaySingle);
            }
            if ((curIcon = but.getRolloverIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), combinedRotation, displaySingle);
            }
            if ((curIcon = but.getRolloverSelectedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), combinedRotation, displaySingle);
            }
        }
    }

    private void recalcFontSize(float scale, int rotate, int id, Component curComp) {
        int size;
        FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(id));
        int rawSize = formObject.getTextSize();
        if (rawSize == -1) {
            rawSize = 0;
        }
        if (rawSize == 0) {
            Rectangle bounds = formObject.getBoundingRectangle();
            int width = bounds.width;
            int height = bounds.height;
            if (rotate == 90 || rotate == 270) {
                int tmp = height;
                height = width;
                width = tmp;
            }
            rawSize = (int)((double)height * 0.85);
            if (curComp instanceof JTextArea) {
                String text = ((JTextArea)curComp).getText();
                rawSize = SwingData.calculateFontSize(height, width, true, text);
            } else if (curComp instanceof JTextField) {
                String text = ((JTextComponent)curComp).getText();
                rawSize = SwingData.calculateFontSize(height, width, false, text);
            } else if (curComp instanceof JButton) {
                String text = ((JButton)curComp).getText();
                if (text != null) {
                    rawSize = SwingData.calculateFontSize(height, width, false, text);
                }
            } else if (curComp instanceof JList) {
                int count = ((JList)curComp).getModel().getSize() + 2;
                rawSize /= count;
            }
        }
        if ((size = (int)((float)rawSize * scale)) < 1) {
            size = 1;
        }
        Font resetFont = curComp.getFont();
        Font newFont = new Font(resetFont.getFontName(), resetFont.getStyle(), size);
        curComp.setFont(newFont);
    }

    @Override
    public Object generateBorderfromForm(FormObject form, float scaling) {
        float[] BC = form.getDictionary(7451).getFloatArray(4627);
        if (BC == null && form.getParameterConstant(1147962727) == 1110792305) {
            BC = form.getFloatArray(19);
        }
        Border newBorder = JPedalBorderFactory.createBorderStyle(form.getDictionary(4643), FormObject.generateColor(BC), Color.white, scaling);
        return newBorder;
    }

    private int[] cropComponent(float[] box, int curPage, float s, int r, int i, boolean redraw) {
        if (this.displayView != 1 && this.displayView != 0) {
            r = (r + this.pageData.getRotation(curPage)) % 360;
        }
        int cropX = this.pageData.getCropBoxX(curPage);
        int cropY = this.pageData.getCropBoxY(curPage);
        int cropW = this.pageData.getCropBoxWidth(curPage);
        int mediaW = this.pageData.getMediaBoxWidth(curPage);
        int mediaH = this.pageData.getMediaBoxHeight(curPage);
        int cropOtherX = mediaW - cropW - cropX;
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        switch (r) {
            case 0: {
                float x100 = box[0];
                if (redraw) {
                    x100 -= (float)cropX;
                }
                float y100 = (float)mediaH - box[3] - (float)this.cropOtherY[curPage];
                float w100 = box[2] - box[0];
                float h100 = box[3] - box[1];
                x = (int)(x100 * s);
                y = (int)(y100 * s);
                w = (int)(w100 * s);
                h = (int)(h100 * s);
                break;
            }
            case 90: {
                float x100 = box[1] - (float)cropY;
                float y100 = box[0] - (float)cropX;
                float w100 = box[3] - box[1];
                float h100 = box[2] - box[0];
                x = (int)(x100 * s);
                y = (int)(y100 * s);
                w = (int)(w100 * s);
                h = (int)(h100 * s);
                break;
            }
            case 180: {
                float w100 = box[2] - box[0];
                float h100 = box[3] - box[1];
                float y100 = box[1] - (float)cropY;
                float x100 = (float)mediaW - box[2] - (float)cropOtherX;
                x = (int)(x100 * s);
                y = (int)(y100 * s);
                w = (int)(w100 * s);
                h = (int)(h100 * s);
                break;
            }
            case 270: {
                float w100 = box[3] - box[1];
                float h100 = box[2] - box[0];
                float x100 = (float)mediaH - box[3] - (float)this.cropOtherY[curPage];
                float y100 = (float)mediaW - box[2] - (float)cropOtherX;
                x = (int)(x100 * s);
                y = (int)(y100 * s);
                w = (int)(w100 * s);
                h = (int)(h100 * s);
            }
        }
        return new int[]{x, y, w, h};
    }

    @Override
    public boolean resetComponents(int formCount, int pageCount, boolean keepValues) {
        if (!super.resetComponents(formCount, pageCount, keepValues)) {
            return false;
        }
        if (!keepValues) {
            this.popups = new Component[0];
        }
        return true;
    }

    @Override
    public void removeAllComponentsFromScreen() {
        if (this.panel != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.panel.removeAll();
            } else {
                Runnable doPaintComponent = new Runnable(){

                    @Override
                    public void run() {
                        SwingData.this.panel.removeAll();
                    }
                };
                SwingUtilities.invokeLater(doPaintComponent);
            }
        }
    }

    @Override
    public void setRootDisplayComponent(final Object rootComp) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.panel = (JPanel)rootComp;
        } else {
            Runnable doPaintComponent = new Runnable(){

                @Override
                public void run() {
                    SwingData.this.panel = (JPanel)rootComp;
                }
            };
            SwingUtilities.invokeLater(doPaintComponent);
        }
    }

    @Override
    protected Object checkGUIObjectResolved(int formNum) {
        FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(formNum));
        Object comp = null;
        if (formObject != null) {
            comp = formObject.getGUIComponent();
        }
        if (formObject != null && comp == null && formObject != null && (comp = this.resolveGUIComponent(formObject, formNum)) != null) {
            this.setGUIComp(formObject, formNum, comp);
        }
        return comp;
    }

    private Component resolveGUIComponent(FormObject formObject, int formNum) {
        Object retComponent;
        Integer widgetType;
        if (formObject == null) {
            return null;
        }
        FormFactory formFactory = this.pdfDecoder.getFormRenderer().getFormFactory();
        int subtype = formObject.getParameterConstant(1147962727);
        boolean[] flags = formObject.getFieldFlags();
        if (flags != null) {
            boolean readOnly = flags[1];
            boolean required = flags[2];
            boolean bl = flags[3];
        }
        if (subtype == 1197118) {
            boolean isPushButton = false;
            boolean isRadio = false;
            if (flags != null) {
                isPushButton = flags[17];
                isRadio = flags[16];
            }
            if (isPushButton) {
                widgetType = FormFactory.PUSHBUTTON;
                retComponent = formFactory.pushBut(formObject);
            } else if (isRadio) {
                widgetType = FormFactory.RADIOBUTTON;
                retComponent = formFactory.radioBut(formObject);
            } else {
                widgetType = FormFactory.CHECKBOXBUTTON;
                retComponent = formFactory.checkBoxBut(formObject);
            }
        } else if (subtype == 9288) {
            boolean isMultiline = false;
            boolean hasPassword = false;
            if (flags != null) {
                isMultiline = flags[13];
                hasPassword = flags[14];
            }
            if (isMultiline) {
                if (hasPassword) {
                    widgetType = FormFactory.MULTILINEPASSWORD;
                    retComponent = formFactory.multiLinePassword(formObject);
                } else {
                    widgetType = FormFactory.MULTILINETEXT;
                    retComponent = formFactory.multiLineText(formObject);
                }
            } else if (hasPassword) {
                widgetType = FormFactory.SINGLELINEPASSWORD;
                retComponent = formFactory.singleLinePassword(formObject);
            } else {
                widgetType = FormFactory.SINGLELINETEXT;
                retComponent = formFactory.singleLineText(formObject);
            }
        } else if (subtype == 4920) {
            boolean isCombo = false;
            if (flags != null) {
                isCombo = flags[18];
            }
            if (isCombo) {
                widgetType = FormFactory.COMBOBOX;
                retComponent = formFactory.comboBox(formObject);
            } else {
                widgetType = FormFactory.LIST;
                retComponent = formFactory.listField(formObject);
            }
        } else if (subtype == 2308407) {
            widgetType = FormFactory.SIGNATURE;
            retComponent = formFactory.signature(formObject);
        } else {
            widgetType = FormFactory.ANNOTATION;
            retComponent = formFactory.annotationButton(formObject);
        }
        this.completeField(formObject, formNum, -widgetType.intValue(), retComponent, this.currentPdfFile);
        formObject.setGUIComponent(retComponent);
        return (Component)retComponent;
    }

    @Override
    public void setGUIComp(FormObject formObject, int formNum, Object rawField) {
        Component retComponent = (Component)rawField;
        int formPage = formObject.getPageNumber();
        String name2 = formObject.getTextStreamValue(36);
        if (name2 != null) {
            String stateToCheck = formObject.getNormalOnState();
            if (stateToCheck != null && stateToCheck.length() > 0) {
                name2 = name2 + "-(" + stateToCheck + ')';
            }
            retComponent.setName(name2);
        }
        if (formObject.getParameterConstant(1147962727) == 1061176672) {
            retComponent.setVisible(false);
        }
        this.scaleComponent(formPage, this.displayScaling, this.rotation, formNum, retComponent, true, false, this.indent);
    }

    @Override
    public void resetScaledLocation(final float currentScaling, final int currentRotation, int currentIndent) {
        if (this.trackPagesRendered == null) {
            return;
        }
        if (this.forceRedraw || currentScaling != this.lastScaling || (float)currentRotation != this.oldRotation || (float)currentIndent != this.oldIndent) {
            this.oldRotation = currentRotation;
            this.lastScaling = currentScaling;
            this.oldIndent = currentIndent;
            this.forceRedraw = false;
            int currentComp = this.startPage < this.trackPagesRendered.length ? this.trackPagesRendered[this.startPage] : 0;
            if (this.panel != null) {
                if (SwingUtilities.isEventDispatchThread()) {
                    for (int i = 0; i < this.popups.length; ++i) {
                        this.scaleComponent(this.currentPage, currentScaling, currentRotation, i, this.popups[i], true, true, this.indent);
                        this.panel.add(this.popups[i]);
                    }
                } else {
                    Runnable doPaintComponent = new Runnable(){

                        @Override
                        public void run() {
                            for (int i = 0; i < SwingData.this.popups.length; ++i) {
                                SwingData.this.scaleComponent(SwingData.this.currentPage, currentScaling, currentRotation, i, SwingData.this.popups[i], true, true, SwingData.this.indent);
                                SwingData.this.panel.add(SwingData.this.popups[i]);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(doPaintComponent);
                }
            }
            if (this.currentPage > 0 && currentComp != -1 && this.nextFreeField + 1 > currentComp) {
                this.checkGUIObjectResolved(currentComp);
                FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(currentComp));
                if (formObject != null) {
                    Component rawComp = (Component)formObject.getGUIComponent();
                    while (formObject != null && currentComp < this.nextFreeField + 1 && currentComp > -1 && formObject.getPageNumber() >= this.startPage && formObject.getPageNumber() < this.endPage && rawComp != null) {
                        if (this.panel != null) {
                            Rectangle bounds = formObject.getBoundingRectangle();
                            if (rawComp instanceof JList && bounds.height < rawComp.getPreferredSize().height) {
                                JList comp = (JList)rawComp;
                                rawComp = SwingData.wrapComponentInScrollPane(comp);
                                formObject.setGUIComponent(comp);
                                int index = comp.getSelectedIndex();
                                if (index > -1) {
                                    comp.ensureIndexIsVisible(index);
                                }
                            }
                            if (SwingUtilities.isEventDispatchThread()) {
                                this.panel.remove(rawComp);
                                this.scaleComponent(formObject.getPageNumber(), currentScaling, currentRotation, currentComp, rawComp, true, false, this.indent);
                                this.panel.add(rawComp);
                            } else {
                                final Component finalComp = rawComp;
                                final int pageID = formObject.getPageNumber();
                                final int id = currentComp;
                                Runnable doPaintComponent = new Runnable(){

                                    @Override
                                    public void run() {
                                        SwingData.this.panel.remove(finalComp);
                                        SwingData.this.scaleComponent(pageID, currentScaling, currentRotation, id, finalComp, true, false, SwingData.this.indent);
                                        SwingData.this.panel.add(finalComp);
                                    }
                                };
                                SwingUtilities.invokeLater(doPaintComponent);
                            }
                        }
                        if ((formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(++currentComp))) == null) continue;
                        rawComp = (Component)formObject.getGUIComponent();
                    }
                }
            }
        }
    }

    private static Component wrapComponentInScrollPane(JList comp) {
        JScrollPane scroll = new JScrollPane(comp);
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setHorizontalScrollBarPolicy(30);
        scroll.setLocation(comp.getLocation());
        scroll.setPreferredSize(comp.getPreferredSize());
        scroll.setSize(comp.getSize());
        return scroll;
    }

    @Override
    public void displayComponent(int currentComp, FormObject formObject, Object comp, int startPage, int page) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.scaleComponent(formObject.getPageNumber(), this.displayScaling, this.rotation, currentComp, (Component)comp, true, false, this.indent);
        } else {
            final int id = currentComp;
            final int pageID = formObject.getPageNumber();
            final Component comp1 = (Component)comp;
            Runnable doPaintComponent = new Runnable(){

                @Override
                public void run() {
                    SwingData.this.scaleComponent(pageID, SwingData.this.displayScaling, SwingData.this.rotation, id, comp1, true, false, SwingData.this.indent);
                }
            };
            SwingUtilities.invokeLater(doPaintComponent);
        }
    }

    @Override
    public void syncKidValues(int currentComp) {
        String ref = this.convertIDtoRef(currentComp);
        FormObject form = (FormObject)this.rawFormData.get(ref);
        String name = form.getTextStreamValue(36);
        if (this.LastValueChanged.containsKey(name)) {
            this.syncFormsByName(name);
            this.LastValueChanged.remove(name);
        }
    }

    @Override
    public void syncAllValues() {
        for (Object o : this.LastValueByName.keySet()) {
            this.syncFormsByName((String)o);
        }
    }

    private void syncFormsByName(String name) {
        Object[] forms;
        Object lastMapValue;
        block14: {
            if (!this.LastValueByName.containsKey(name)) {
                return;
            }
            lastMapValue = this.LastValueByName.get(name);
            try {
                this.pdfDecoder.getFormRenderer().getComponentNameList();
            }
            catch (PdfException e) {
                if (!LogWriter.isOutput()) break block14;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        for (Object form1 : forms = this.getRawForm(name)) {
            FormObject form;
            Object index;
            if (form1 == null || (index = this.refToCompIndex.get((form = (FormObject)form1).getObjectRefAsString())) == null) continue;
            int currentComp = (Integer)index;
            FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(currentComp));
            int type = formObject.getFormType();
            this.checkGUIObjectResolved(currentComp);
            Component comp = (Component)formObject.getGUIComponent();
            if (type == 8 || type == 9) {
                Icon icn;
                JToggleButton checkComp = (JToggleButton)comp;
                String currOnState = form.getNormalOnState();
                if (currOnState == null && lastMapValue == null || currOnState != null && currOnState.equals(lastMapValue)) {
                    if (checkComp.isSelected()) continue;
                    checkComp.setSelected(true);
                    icn = checkComp.getPressedIcon();
                    if (icn == null || !(icn instanceof FixImageIcon)) continue;
                    ((FixImageIcon)icn).swapImage(true);
                    continue;
                }
                if (!checkComp.isSelected()) continue;
                checkComp.setSelected(false);
                icn = checkComp.getPressedIcon();
                if (icn == null || !(icn instanceof FixImageIcon)) continue;
                ((FixImageIcon)icn).swapImage(false);
                continue;
            }
            if (type == 2) {
                JComboBox combo = (JComboBox)comp;
                if (combo.getSelectedItem() == null) {
                    if (lastMapValue == null) continue;
                    combo.setSelectedItem(lastMapValue);
                    continue;
                }
                if (combo.getSelectedItem().equals(lastMapValue)) continue;
                combo.setSelectedItem(lastMapValue);
                continue;
            }
            if (type != 4 && type != 3 && type != 6 && type != 5) continue;
            String text = null;
            if (comp instanceof JTextComponent) {
                text = ((JTextComponent)comp).getText();
            } else if (comp instanceof JButton) {
                text = ((ReadOnlyTextIcon)((JButton)comp).getIcon()).getText();
            }
            if (lastMapValue == null) {
                if (text == null) continue;
                if (comp instanceof JTextComponent) {
                    ((JTextComponent)comp).setText(null);
                    continue;
                }
                if (!(comp instanceof JButton)) continue;
                ((ReadOnlyTextIcon)((JButton)comp).getIcon()).setText("");
                continue;
            }
            if (lastMapValue.equals(text)) continue;
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setText(lastMapValue.toString());
                continue;
            }
            if (!(comp instanceof JButton)) continue;
            ((ReadOnlyTextIcon)((JButton)comp).getIcon()).setText(lastMapValue.toString());
        }
    }

    @Override
    public void reportError(int code, Object[] args) {
        if (!PdfDecoder.showErrorMessages) {
            return;
        }
        if (code == 1) {
            JOptionPane.showMessageDialog(this.panel, "The values entered does not match the format of the field [" + args[0] + " ]", "Warning: Javascript Window", 1);
        } else if (code == 2) {
            JOptionPane.showMessageDialog(this.panel, "Invalid date/time: please ensure that the date/time exists. Field [" + args[0] + " ] should match format " + args[1], "Warning: Javascript Window", 1);
        } else if (code == 3) {
            JOptionPane.showMessageDialog(this.panel, args[1], "Warning: Javascript Window", 1);
        } else {
            JOptionPane.showMessageDialog(this.panel, "The values entered does not match the format of the field", "Warning: Javascript Window", 1);
        }
    }

    @Override
    public void invalidate(String name) {
        Object[] forms = this.getComponentsByName(name);
        if (forms == null) {
            return;
        }
        for (Object form : forms) {
            if (form == null) continue;
            ((Component)form).repaint();
        }
    }

    @Override
    public void storeDisplayValue(String fieldRef) {
        Object compIndex = this.refToCompIndex.get(fieldRef);
        if (compIndex == null) {
            return;
        }
        int index = (Integer)compIndex;
        FormObject form = (FormObject)this.rawFormData.get(fieldRef);
        Component comp = (Component)this.checkGUIObjectResolved(index);
        FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(index));
        int type = formObject.getFormType();
        switch (type) {
            case 2: {
                form.setSelectedItem((String)((JComboBox)comp).getSelectedItem());
                break;
            }
            case 1: {
                form.setTopIndex(((JList)comp).getSelectedIndices());
                break;
            }
            case 8: {
                JRadioButton radioBut = (JRadioButton)comp;
                if (!radioBut.isSelected()) break;
                form.setChildOnState(FormUtils.removeStateToCheck(radioBut.getName(), true));
                break;
            }
            case 9: {
                JCheckBox checkBox = (JCheckBox)comp;
                if (!checkBox.isSelected()) break;
                form.setCurrentState(FormUtils.removeStateToCheck(checkBox.getName(), true));
                break;
            }
            case 4: {
                form.setTextValue(((JTextComponent)comp).getText());
                break;
            }
            case 6: {
                form.setTextValue(((JTextComponent)comp).getText());
                break;
            }
            case 3: {
                if (!(comp instanceof JTextComponent)) break;
                form.setTextValue(((JTextComponent)comp).getText());
                break;
            }
            case 5: {
                if (!(comp instanceof JTextComponent)) break;
                form.setTextValue(((JTextComponent)comp).getText());
            }
        }
    }

    @Override
    public void setCompVisible(String ref, boolean visible) {
        Integer checkObj = this.convertRefToID(ref);
        if (checkObj == null) {
            return;
        }
        ((Component)this.checkGUIObjectResolved(checkObj)).setVisible(visible);
    }

    @Override
    public void popup(FormObject formObj, PdfObjectReader currentPdfFile) {
        JComponent popup;
        if (formObj.isPopupBuilt()) {
            popup = (JComponent)formObj.getPopupObj();
        } else {
            PdfObject popupObj = formObj.getDictionary(1061176672);
            currentPdfFile.checkResolved(popupObj);
            if (popupObj == null) {
                popupObj = new FormObject();
                ((FormObject)popupObj).copyInheritedValuesFromParent(formObj);
                ((FormObject)popupObj).setParent(formObj.getObjectRefAsString());
            }
            popup = new PdfSwingPopup(formObj, popupObj, this.pageData.getCropBoxWidth(this.currentPage));
            float[][] tmpf = new float[this.popupBounds.length + 1][4];
            System.arraycopy(this.popupBounds, 0, tmpf, 0, this.popupBounds.length);
            tmpf[this.popupBounds.length] = popupObj.getFloatArray(573911876);
            this.popupBounds = tmpf;
            JComponent[] tmp = new JComponent[this.popups.length + 1];
            System.arraycopy(this.popups, 0, tmp, 0, this.popups.length);
            tmp[this.popups.length] = popup;
            this.popups = tmp;
            formObj.setPopupBuilt(popup);
            popup.setVisible(popupObj.getBoolean(524301630));
            this.forceRedraw = true;
            this.resetScaledLocation(this.displayScaling, this.rotation, this.indent);
            this.panel.repaint();
        }
        if (popup.isVisible()) {
            popup.setVisible(false);
        } else {
            popup.setVisible(true);
        }
    }

    @Override
    public void setTextColor(String ref, Color textColor) {
        Integer checkObj = this.convertRefToID(ref);
        if (checkObj == null) {
            return;
        }
        Object comp = this.checkGUIObjectResolved(checkObj);
        if (comp != null) {
            ((Component)comp).setForeground(textColor);
        }
    }

    @Override
    public void setCustomPrintInterface(CustomFormPrint customFormPrint) {
        this.customFormPrint = customFormPrint;
    }

    @Override
    public int getFieldType(Object comp) {
        if (comp instanceof FormObject) {
            return super.getFieldType(comp);
        }
        if (comp instanceof JTextField || comp instanceof JTextArea || comp instanceof JPasswordField) {
            return 0;
        }
        if (comp instanceof JRadioButton || comp instanceof JCheckBox || comp instanceof JButton) {
            return 1;
        }
        if (comp instanceof JList || comp instanceof JComboBox) {
            return 2;
        }
        return -1;
    }

    @Override
    public void flagLastUsedValue(Object component, FormObject formObject, boolean sync) {
        JToggleButton radioComp;
        Component comp = (Component)component;
        String parent = formObject.getStringKey(1110793845);
        String name = formObject.getTextStreamValue(36);
        if (parent != null) {
            if (comp instanceof JComboBox) {
                this.LastValueByName.put(name, ((JComboBox)comp).getSelectedItem());
                this.LastValueChanged.put(name, null);
            } else if (comp instanceof JTextComponent) {
                this.LastValueByName.put(name, ((JTextComponent)comp).getText());
                this.LastValueChanged.put(name, null);
            } else if (comp instanceof JToggleButton) {
                boolean isSelected = ((JToggleButton)comp).isSelected();
                if (isSelected) {
                    this.LastValueByName.put(name, formObject.getNormalOnState());
                    this.LastValueChanged.put(name, null);
                } else if (!isSelected && this.LastValueByName.get(formObject.getTextStreamValue(36)) != null) {
                    String currOnState = formObject.getNormalOnState();
                    if (this.LastValueByName.get(formObject.getTextStreamValue(36)).equals(currOnState)) {
                        if (formObject.getFieldFlags()[15]) {
                            ((JToggleButton)comp).setSelected(true);
                            Icon icn = ((JToggleButton)comp).getPressedIcon();
                            if (icn != null && icn instanceof FixImageIcon) {
                                ((FixImageIcon)icn).swapImage(true);
                            }
                        } else {
                            this.LastValueChanged.put(name, null);
                        }
                    }
                }
            }
        } else if (comp instanceof JToggleButton && !(radioComp = (JToggleButton)comp).isSelected() && formObject.getFieldFlags()[15]) {
            radioComp.setSelected(true);
            Icon icn = radioComp.getPressedIcon();
            if (icn != null && icn instanceof FixImageIcon) {
                ((FixImageIcon)icn).swapImage(true);
            }
        }
        if (sync) {
            this.syncFormsByName(FormUtils.removeStateToCheck(comp.getName(), false));
        }
    }

    @Override
    public void setCompVisible(Object comp, boolean visible) {
        ((Component)comp).setVisible(visible);
    }
}

