/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.io.Serializable;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;

public class PdfShape
implements Serializable {
    private static final long serialVersionUID = -4877252327369495970L;
    int complexClipCount = 0;
    private Vector_Float shape_primitive_x2 = new Vector_Float(1000);
    private Vector_Float shape_primitive_y = new Vector_Float(1000);
    private Vector_Int shape_primitives = new Vector_Int(1000);
    private int winding_rule = 1;
    private Vector_Float shape_primitive_x3 = new Vector_Float(1000);
    private Vector_Float shape_primitive_y3 = new Vector_Float(1000);
    private Vector_Float shape_primitive_y2 = new Vector_Float(1000);
    private Vector_Float shape_primitive_x = new Vector_Float(1000);
    private static final int H = 3;
    private static final int L = 2;
    private static final int V = 6;
    private static final int M = 1;
    private static final int Y = 4;
    private static final int C = 5;
    private boolean isClip = false;
    private boolean emulateEvenOddRule = false;

    public final void closeShape() {
        this.shape_primitives.addElement(3);
        this.shape_primitive_x.addElement(0.0f);
        this.shape_primitive_y.addElement(0.0f);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(0.0f);
        this.shape_primitive_y3.addElement(0.0f);
    }

    public final void addBezierCurveC(float x, float y, float x2, float y2, float x3, float y3) {
        this.shape_primitives.addElement(5);
        this.shape_primitive_x.addElement(x);
        this.shape_primitive_y.addElement(y);
        this.shape_primitive_x2.addElement(x2);
        this.shape_primitive_y2.addElement(y2);
        this.shape_primitive_x3.addElement(x3);
        this.shape_primitive_y3.addElement(y3);
    }

    public final void setNONZEROWindingRule() {
        this.winding_rule = 1;
    }

    public final void lineTo(float x, float y) {
        this.shape_primitives.addElement(2);
        this.shape_primitive_x.addElement(x);
        this.shape_primitive_y.addElement(y);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(0.0f);
        this.shape_primitive_y3.addElement(0.0f);
    }

    public final void addBezierCurveV(float x2, float y2, float x3, float y3) {
        this.shape_primitives.addElement(6);
        this.shape_primitive_x.addElement(200.0f);
        this.shape_primitive_y.addElement(200.0f);
        this.shape_primitive_x2.addElement(x2);
        this.shape_primitive_y2.addElement(y2);
        this.shape_primitive_x3.addElement(x3);
        this.shape_primitive_y3.addElement(y3);
    }

    public final Shape generateShapeFromPath(float[][] CTM, float thickness, int cmd, int type) {
        int i;
        boolean is_clip = this.isClip;
        if (cmd == 110) {
            is_clip = false;
        }
        Path2D current_path = null;
        Area current_area = null;
        float[] x = this.shape_primitive_x.get();
        float[] y = this.shape_primitive_y.get();
        float[] x2 = this.shape_primitive_x2.get();
        float[] y2 = this.shape_primitive_y2.get();
        float[] x3 = this.shape_primitive_x3.get();
        float[] y3 = this.shape_primitive_y3.get();
        int[] command = this.shape_primitives.get();
        int end = this.shape_primitives.size() - 1;
        boolean show = false;
        boolean debug = false;
        if (this.winding_rule == 0 && type == 4 && this.getSegmentCount() > 6) {
            float xx = 0.0f;
            float yy = 0.0f;
            for (i = 0; i < end && !this.emulateEvenOddRule; ++i) {
                if (command[i] == 3) {
                    this.emulateEvenOddRule = true;
                    continue;
                }
                if (command[i] == 2) {
                    if (xx != x[i] || yy != y[i]) continue;
                    this.emulateEvenOddRule = true;
                    continue;
                }
                if (command[i] == 1) {
                    xx = x[i];
                    yy = y[i];
                    continue;
                }
                if (xx != x3[i] || yy != y3[i]) continue;
                this.emulateEvenOddRule = true;
            }
        }
        for (i = 0; i < end; ++i) {
            if (current_path == null) {
                current_path = new GeneralPath(this.winding_rule);
                ((Path2D.Float)current_path).moveTo(x[i], y[i]);
            }
            if (command[i] == 3) {
                current_path.closePath();
                if (is_clip) {
                    if (current_area == null) {
                        current_area = new Area(current_path);
                        if (current_area.getBounds2D().getWidth() <= 0.0 || current_area.getBounds2D().getHeight() <= 0.0) {
                            current_area = new Area(((Path2D.Float)current_path).getBounds2D());
                        }
                    } else {
                        current_area.add(new Area(current_path));
                    }
                    current_path = null;
                }
            }
            if (command[i] == 2) {
                ((Path2D.Float)current_path).lineTo(x[i], y[i]);
                continue;
            }
            if (command[i] == 1) {
                ((Path2D.Float)current_path).moveTo(x[i], y[i]);
                continue;
            }
            if (command[i] == 4) {
                ((Path2D.Float)current_path).curveTo(x[i], y[i], x3[i], y3[i], x3[i], y3[i]);
                continue;
            }
            if (command[i] == 5) {
                ((Path2D.Float)current_path).curveTo(x[i], y[i], x2[i], y2[i], x3[i], y3[i]);
                continue;
            }
            if (command[i] != 6) continue;
            float c_x = (float)current_path.getCurrentPoint().getX();
            float c_y = (float)current_path.getCurrentPoint().getY();
            ((Path2D.Float)current_path).curveTo(c_x, c_y, x2[i], y2[i], x3[i], y3[i]);
        }
        if (current_path != null && (current_path.getBounds().getHeight() == 0.0 || (double)thickness > 0.8 && (double)thickness < 0.9 && ((Path2D.Float)current_path).getBounds2D().getHeight() < (double)0.1f) && (((Path2D.Float)current_path).getBounds2D().getWidth() != 0.0 || ((Path2D.Float)current_path).getBounds2D().getHeight() != 0.0)) {
            if (thickness > 1.0f && ((Path2D.Float)current_path).getBounds2D().getWidth() < 1.0) {
                ((Path2D.Float)current_path).moveTo(0.0f, -thickness / 2.0f);
                ((Path2D.Float)current_path).lineTo(0.0f, thickness / 2.0f);
            } else {
                ((Path2D.Float)current_path).moveTo(0.0f, 1.0f);
            }
        }
        if (current_path != null && current_path.getBounds().getWidth() == 0.0) {
            ((Path2D.Float)current_path).moveTo(1.0f, 0.0f);
        }
        if (CTM[0][0] != 1.0f || CTM[1][0] != 0.0f || CTM[2][0] != 0.0f || CTM[0][1] != 0.0f || CTM[1][1] != 1.0f || CTM[2][1] != 0.0f || CTM[0][2] != 0.0f || CTM[1][2] != 0.0f || CTM[2][2] != 1.0f) {
            AffineTransform CTM_transform = new AffineTransform(CTM[0][0], CTM[0][1], CTM[1][0], CTM[1][1], CTM[2][0], CTM[2][1]);
            if (current_path != null) {
                ((Path2D.Float)current_path).transform(CTM_transform);
            } else if (current_area != null) {
                current_area.transform(CTM_transform);
            }
        }
        Shape current_shape = !is_clip ? (current_area == null ? current_path : current_area) : current_area;
        if (cmd == 110 && this.getSegmentCount() > 2500) {
            ++this.complexClipCount;
        }
        return current_shape;
    }

    public final void appendRectangle(float x, float y, float w, float h) {
        this.moveTo(x, y);
        this.lineTo(x + w, y);
        this.lineTo(x + w, y + h);
        this.lineTo(x, y + h);
        this.lineTo(x, y);
        this.closeShape();
    }

    public final void moveTo(float x, float y) {
        this.shape_primitives.addElement(1);
        this.shape_primitive_x.addElement(x);
        this.shape_primitive_y.addElement(y);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(0.0f);
        this.shape_primitive_y3.addElement(0.0f);
    }

    public final void addBezierCurveY(float x, float y, float x3, float y3) {
        this.shape_primitives.addElement(4);
        this.shape_primitive_x.addElement(x);
        this.shape_primitive_y.addElement(y);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(x3);
        this.shape_primitive_y3.addElement(y3);
    }

    public final void resetPath() {
        this.shape_primitives.clear();
        this.shape_primitive_x.clear();
        this.shape_primitive_y.clear();
        this.shape_primitive_x2.clear();
        this.shape_primitive_y2.clear();
        this.shape_primitive_x3.clear();
        this.shape_primitive_y3.clear();
        this.winding_rule = 1;
        this.emulateEvenOddRule = false;
    }

    public final void setEVENODDWindingRule() {
        this.winding_rule = 0;
    }

    public int getSegmentCount() {
        if (this.shape_primitives == null) {
            return 0;
        }
        return this.shape_primitives.size() - 1;
    }

    public void setClip(boolean b) {
        this.isClip = b;
    }

    public boolean isClip() {
        return this.isClip;
    }

    public boolean requiresEvenOddEmulation() {
        return this.emulateEvenOddRule;
    }

    public int getComplexClipCount() {
        return this.complexClipCount;
    }
}

