/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.Area;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.objects.TextState;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;

public class GraphicsState {
    public float x;
    public float y;
    TextState currentTextState = new TextState();
    private float strokeAlpha = 1.0f;
    private float nonstrokeAlpha = 1.0f;
    private float maxStrokeAlpha = 1.0f;
    private float maxNonstrokeAlpha = 1.0f;
    public float[][] lastCTM = new float[3][3];
    private PdfObject TR;
    public PdfObject SMask;
    public GenericColorSpace strokeColorSpace = new DeviceRGBColorSpace();
    public GenericColorSpace nonstrokeColorSpace = new DeviceRGBColorSpace();
    private boolean hasClipChanged = false;
    private boolean op = false;
    private boolean OP = false;
    private float OPM = 0.0f;
    private PdfPaint nonstrokeColor = new PdfColor(0, 0, 0);
    private PdfPaint strokeColor = new PdfColor(0, 0, 0);
    private Area current_clipping_shape = null;
    private final boolean debugClip = false;
    public float[][] CTM = new float[3][3];
    private int current_line_dash_phase = 0;
    private Area TRmask = null;
    private int fill_type;
    private int mitre_limit = 0;
    private float[] current_line_dash_array = new float[0];
    private int current_line_cap_style = 0;
    private float current_line_width = 1.0f;
    private int output_line_width = -1;
    private int current_line_join_style = 0;
    private int text_render_type = 2;
    private int minX = 0;
    private int minY = 0;
    public static final int STROKE = 1;
    public static final int FILL = 2;
    public static final int FILLSTROKE = 3;
    public static final int INVISIBLE = 4;
    public static final int CLIPTEXT = 7;
    private PdfArrayIterator BM;

    public GraphicsState() {
        this.resetCTM();
    }

    public GraphicsState(int minX, int minY) {
        this.minX = -minX;
        this.minY = -minY;
        this.resetCTM();
    }

    public void setMaxAlpha(int type, float value) {
        switch (type) {
            case 1: {
                this.maxStrokeAlpha = value;
                break;
            }
            case 2: {
                this.maxNonstrokeAlpha = value;
            }
        }
    }

    public void setAlpha(int type, float value) {
        switch (type) {
            case 1: {
                if (value > this.maxStrokeAlpha) {
                    value = this.maxStrokeAlpha;
                }
                this.strokeAlpha = value;
                break;
            }
            case 2: {
                if (value > this.maxNonstrokeAlpha) {
                    value = this.maxNonstrokeAlpha;
                }
                this.nonstrokeAlpha = value;
            }
        }
    }

    public float getAlpha(int type) {
        float value = 1.0f;
        switch (type) {
            case 1: {
                if (this.strokeAlpha > this.maxStrokeAlpha) {
                    value = this.maxStrokeAlpha;
                    break;
                }
                value = this.strokeAlpha;
                break;
            }
            case 2: {
                value = this.nonstrokeAlpha > this.maxNonstrokeAlpha ? this.maxNonstrokeAlpha : this.nonstrokeAlpha;
            }
        }
        return value;
    }

    public float getAlphaMax(int type) {
        float value = 1.0f;
        switch (type) {
            case 1: {
                value = this.maxStrokeAlpha;
                break;
            }
            case 2: {
                value = this.maxNonstrokeAlpha;
            }
        }
        return value;
    }

    public boolean getNonStrokeOP() {
        return this.op;
    }

    public float getOPM() {
        return this.OPM;
    }

    public PdfObject getTR() {
        return this.TR;
    }

    public final void setTextRenderType(int text_render_type) {
        this.text_render_type = text_render_type;
        this.TRmask = null;
    }

    public final int getTextRenderType() {
        return this.text_render_type;
    }

    public final void setMitreLimit(int mitre_limit) {
        this.mitre_limit = mitre_limit;
    }

    public final float getLineWidth() {
        return this.current_line_width;
    }

    public final int getOutputLineWidth() {
        return this.output_line_width;
    }

    public final void setFillType(int fill_type) {
        this.fill_type = fill_type;
    }

    public final void updateClip(Area current_area) {
        if (this.current_clipping_shape == null || current_area == null) {
            this.current_clipping_shape = current_area;
            this.hasClipChanged = true;
        } else {
            this.current_clipping_shape.intersect(current_area);
            this.hasClipChanged = true;
        }
        this.getClass();
    }

    public final void addClip(Area current_area) {
        if (this.TRmask == null) {
            this.TRmask = current_area;
        } else {
            this.TRmask.add(current_area);
        }
    }

    public final Stroke getStroke() {
        BasicStroke current_stroke;
        int dashCount;
        float w = this.current_line_width;
        if (this.CTM[0][0] != 0.0f) {
            w *= this.CTM[0][0];
        } else if (this.CTM[0][1] != 0.0f) {
            w *= this.CTM[0][1];
        }
        if (w < 0.0f) {
            w = -w;
        }
        if (this.mitre_limit < 1) {
            this.mitre_limit = 1;
        }
        if ((dashCount = this.current_line_dash_array.length) > 0) {
            float[] dash = new float[dashCount];
            for (int aa = 0; aa < dashCount; ++aa) {
                dash[aa] = this.CTM[0][0] != 0.0f ? this.current_line_dash_array[aa] * this.CTM[0][0] : this.current_line_dash_array[aa] * this.CTM[0][1];
                if (dash[aa] < 0.0f) {
                    dash[aa] = -dash[aa];
                }
                if (!(dash[aa] < 0.05f)) continue;
                dash[aa] = 0.05f;
            }
            current_stroke = new BasicStroke(w, this.current_line_cap_style, this.current_line_join_style, this.mitre_limit, dash, this.current_line_dash_phase);
        } else {
            current_stroke = new BasicStroke(w, this.current_line_cap_style, this.current_line_join_style, this.mitre_limit);
        }
        return current_stroke;
    }

    public float getCTMAdjustedLineWidth() {
        float w = this.current_line_width;
        if (this.CTM[0][0] != 0.0f) {
            w *= this.CTM[0][0];
        } else if (this.CTM[0][1] != 0.0f) {
            w *= this.CTM[0][1];
        }
        if (w < 0.0f) {
            w = -w;
        }
        return w;
    }

    public final void setLineWidth(float current_line_width) {
        this.current_line_width = current_line_width;
    }

    public void setCTMAdjustedLineWidth(float width) {
        if (this.CTM[0][0] != 0.0f) {
            width /= this.CTM[0][0];
        } else if (this.CTM[0][1] != 0.0f) {
            width /= this.CTM[0][1];
        }
        this.current_line_width = width;
    }

    public final void setOutputLineWidth(int output_line_width) {
        this.output_line_width = output_line_width;
    }

    public final Area getClippingShape() {
        if (this.TRmask != null && this.current_clipping_shape == null) {
            return this.TRmask;
        }
        if (this.TRmask != null) {
            this.TRmask.intersect(this.current_clipping_shape);
            this.getClass();
            return this.TRmask;
        }
        this.getClass();
        return this.current_clipping_shape;
    }

    public void setMode(PdfObject GS) {
        boolean notMask;
        this.nonstrokeAlpha = 1.0f;
        this.op = false;
        this.OP = false;
        if (GS == null) {
            return;
        }
        float LW = GS.getFloatNumber(7207);
        if (LW != -1.0f) {
            this.current_line_width = LW;
        }
        boolean AIS = GS.getBoolean(1120547);
        this.SMask = GS.getDictionary(489767774);
        boolean bl = notMask = this.SMask == null || AIS || this.SMask.getGeneralType(489767774) == 507461173;
        if (notMask) {
            float newCA = GS.getFloatNumber(4881);
            float newca = GS.getFloatNumber(13105);
            if (newCA != -1.0f) {
                this.setAlpha(1, newCA);
            }
            if (newca != -1.0f) {
                this.setAlpha(2, newca);
            }
        }
        this.OP = GS.getBoolean(7968);
        this.op = GS.getBoolean(16192);
        float newOPM = GS.getFloatNumber(2039837);
        this.OPM = newOPM != -1.0f ? newOPM : 0.0f;
        this.TR = GS.getDictionary(9250);
        if (this.TR != null) {
            boolean isIdentity = false;
            if (this.TR.getGeneralType(9250) == 1567455623) {
                isIdentity = true;
            } else {
                int count;
                byte[][] maskArray = this.TR.getKeyArray(9250);
                if (maskArray != null && (count = maskArray.length) > 0) {
                    isIdentity = true;
                    for (byte[] aMaskArray : maskArray) {
                        int nextID = PdfDictionary.getIntKey(1, aMaskArray.length - 1, aMaskArray);
                        if (nextID == 1567455623) continue;
                        isIdentity = false;
                        break;
                    }
                }
            }
            if (isIdentity) {
                this.TR = null;
            }
        }
        this.BM = GS.getMixedArray(4637);
    }

    public final void setCapStyle(int cap_style) {
        this.current_line_cap_style = cap_style;
    }

    public final void setJoinStyle(int join_style) {
        this.current_line_join_style = join_style;
    }

    public final void checkWholePageClip(int max_y) {
        if (this.current_clipping_shape != null && this.current_clipping_shape.getBounds().getHeight() > (double)(max_y + 2) && this.current_clipping_shape.getBounds().y >= 0) {
            this.current_clipping_shape = null;
            this.hasClipChanged = true;
            this.getClass();
        }
    }

    public final void setDashArray(float[] current_line_dash_array) {
        this.current_line_dash_array = current_line_dash_array;
    }

    public final Object clone() {
        GraphicsState newGS = new GraphicsState();
        newGS.x = this.x;
        newGS.y = this.y;
        if (this.TR != null) {
            newGS.TR = (PdfObject)this.TR.clone();
        }
        newGS.maxNonstrokeAlpha = this.maxNonstrokeAlpha;
        newGS.maxStrokeAlpha = this.maxStrokeAlpha;
        newGS.strokeAlpha = this.strokeAlpha;
        newGS.nonstrokeAlpha = this.nonstrokeAlpha;
        newGS.op = this.op;
        newGS.OP = this.OP;
        newGS.OPM = this.OPM;
        newGS.nonstrokeColor = this.nonstrokeColor;
        newGS.strokeColor = this.strokeColor;
        if (this.current_clipping_shape != null) {
            newGS.current_clipping_shape = (Area)this.current_clipping_shape.clone();
        }
        if (this.CTM != null) {
            for (int i = 0; i < 3; ++i) {
                System.arraycopy(this.CTM[i], 0, newGS.CTM[i], 0, 3);
            }
        }
        newGS.hasClipChanged = this.hasClipChanged;
        newGS.current_line_dash_phase = this.current_line_dash_phase;
        if (this.TRmask != null) {
            newGS.TRmask = (Area)this.TRmask.clone();
        }
        newGS.fill_type = this.fill_type;
        newGS.mitre_limit = this.mitre_limit;
        if (this.current_line_dash_array != null) {
            int size = this.current_line_dash_array.length;
            newGS.current_line_dash_array = new float[size];
            System.arraycopy(this.current_line_dash_array, 0, newGS.current_line_dash_array, 0, size);
        }
        newGS.current_line_cap_style = this.current_line_cap_style;
        newGS.current_line_width = this.current_line_width;
        newGS.current_line_join_style = this.current_line_join_style;
        newGS.text_render_type = this.text_render_type;
        newGS.minX = this.minX;
        newGS.minY = this.minY;
        return newGS;
    }

    private void resetCTM() {
        this.CTM[0][0] = 1.0f;
        this.CTM[1][0] = 0.0f;
        this.CTM[2][0] = this.minX;
        this.CTM[0][1] = 0.0f;
        this.CTM[1][1] = 1.0f;
        this.CTM[2][1] = this.minY;
        this.CTM[0][2] = 0.0f;
        this.CTM[1][2] = 0.0f;
        this.CTM[2][2] = 1.0f;
    }

    public final void setDashPhase(int current_line_dash_phase) {
        this.current_line_dash_phase = current_line_dash_phase;
    }

    public final int getFillType() {
        return this.fill_type;
    }

    public final void setClippingShape(Area new_clip) {
        this.current_clipping_shape = new_clip;
        this.hasClipChanged = true;
        this.getClass();
    }

    public PdfPaint getNonstrokeColor() {
        return this.nonstrokeColor;
    }

    public void setNonstrokeColor(PdfPaint currentNonstrokeColor) {
        this.nonstrokeColor = currentNonstrokeColor;
    }

    public PdfPaint getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(PdfPaint strokeColor) {
        this.strokeColor = strokeColor;
    }

    public PdfArrayIterator getBM() {
        return this.BM;
    }

    public boolean hasClipChanged() {
        boolean flag = this.hasClipChanged;
        this.hasClipChanged = false;
        return flag;
    }

    public void setTextState(TextState currentTextState) {
        this.currentTextState = currentTextState;
    }

    public TextState getTextState() {
        return this.currentTextState;
    }
}

