/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.linear;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.io.LinearizedHintTable;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.linear.LinearThread;
import org.jpedal.objects.raw.LinearizedObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class LinearParser {
    public boolean isLinearizationTested = false;
    private PageObject linObject = null;
    private Map linObjects = new HashMap();
    private int linearPageCount = -1;
    private PdfObject linearObj = null;
    private LinearizedHintTable linHintTable = null;
    private int E = -1;
    public LinearThread linearizedBackgroundReaderer = null;

    public void closePdfFile() {
        this.E = -1;
        this.linearObj = null;
        this.isLinearizationTested = false;
        this.linObjects.clear();
        if (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive()) {
            this.linearizedBackgroundReaderer.interrupt();
        }
        while (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive() && !this.linearizedBackgroundReaderer.isInterrupted()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) continue;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        this.linHintTable = null;
    }

    public boolean isPageAvailable(int rawPage, PdfObjectReader currentPdfFile) {
        boolean isPageAvailable = true;
        try {
            if (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive() && rawPage > 1 && this.linHintTable != null) {
                Integer key = rawPage;
                if (this.linObjects.containsKey(key)) {
                    this.linObject = (PageObject)this.linObjects.get(key);
                    return true;
                }
                int objID = this.linHintTable.getPageObjectRef(rawPage);
                byte[] pageData = this.linHintTable.getObjData(objID);
                if (pageData != null) {
                    this.linObject = new PageObject(objID + " 0 R");
                    this.linObject.setStatus(2);
                    this.linObject.setUnresolvedData(pageData, 540096309);
                    this.linObject.isDataExternal(true);
                    ObjectDecoder objDecoder = new ObjectDecoder(currentPdfFile.getObjectReader());
                    if (!objDecoder.resolveFully(this.linObject)) {
                        isPageAvailable = false;
                    } else {
                        if (this.linObject != null) {
                            byte[] b_data = currentPdfFile.getObjectReader().readPageIntoStream(this.linObject);
                            if (b_data == null) {
                                isPageAvailable = false;
                            } else {
                                PdfObject Resources = this.linObject.getDictionary(2004251818);
                                if (Resources == null) {
                                    this.linObject = null;
                                    isPageAvailable = false;
                                } else if (!objDecoder.resolveFully(Resources)) {
                                    this.linObject = null;
                                    isPageAvailable = false;
                                } else {
                                    Resources.isDataExternal(true);
                                    new PdfStreamDecoder(currentPdfFile).readResources(Resources, true);
                                    if (!Resources.isFullyResolved()) {
                                        this.linObject = null;
                                        isPageAvailable = false;
                                    }
                                }
                            }
                        }
                        if (isPageAvailable && this.linObject != null) {
                            this.linObjects.put(key, this.linObject);
                        }
                    }
                } else {
                    isPageAvailable = false;
                }
            } else {
                this.linObject = null;
            }
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            isPageAvailable = false;
        }
        return isPageAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readLinearData(PdfObjectReader currentPdfFile, File tempURLFile, InputStream is, PdfDecoder pdfDecoder) throws IOException {
        FileChannel fileChannel;
        int read;
        FileChannel fos = new RandomAccessFile(tempURLFile, "rws").getChannel();
        fos.force(true);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        while ((read = is.read(buffer)) != -1) {
            if (read > 0) {
                fileChannel = fos;
                synchronized (fileChannel) {
                    byte[] b = new byte[read];
                    System.arraycopy(buffer, 0, b, 0, read);
                    ByteBuffer f = ByteBuffer.wrap(b);
                    fos.write(f);
                }
            }
            bytesRead += read;
        }
        is.close();
        fileChannel = fos;
        synchronized (fileChannel) {
            fos.close();
        }
        return null;
    }

    public PdfObject readHintTable(PdfObject pdfObject, PdfObjectReader currentPdfFile) throws PdfException {
        long Ooffset = -1L;
        this.linearPageCount = -1;
        int O = this.linearObj.getInt(31);
        if (O != -1) {
            this.linearObj.setIntNumber(31, -1);
            currentPdfFile.getObjectReader().readReferenceTable(this.linearObj);
            pdfObject = new PageObject(O, 0);
            currentPdfFile.readObject(pdfObject);
            this.linearPageCount = this.linearObj.getInt(30);
            Ooffset = currentPdfFile.getObjectReader().getOffset(O);
        } else {
            pdfObject = currentPdfFile.getObjectReader().readReferenceTable(null);
        }
        int[] H = this.linearObj.getIntArray(24);
        byte[] hintStream = currentPdfFile.getObjectReader().getBytes(H[0], H[1]);
        int length = hintStream.length;
        int startHint = 0;
        int i = 0;
        boolean contentIsDodgy = false;
        int keyStart2 = i;
        while (hintStream[i] != 10 && hintStream[i] != 13 && hintStream[i] != 32 && hintStream[i] != 47 && hintStream[i] != 60 && hintStream[i] != 62) {
            if (hintStream[i] < 48 || hintStream[i] > 57) {
                contentIsDodgy = true;
            }
            ++i;
        }
        if (!contentIsDodgy) {
            int number = NumberUtils.parseInt(keyStart2, i, hintStream);
            while (hintStream[i] == 10 || hintStream[i] == 13 || hintStream[i] == 32 || hintStream[i] == 47 || hintStream[i] == 60) {
                ++i;
            }
            keyStart2 = i;
            while (i < 10 && hintStream[i] != 10 && hintStream[i] != 13 && hintStream[i] != 32 && hintStream[i] != 47 && hintStream[i] != 60 && hintStream[i] != 62) {
                ++i;
            }
            int generation = NumberUtils.parseInt(keyStart2, i, hintStream);
            while (i < length - 1) {
                if (hintStream[i] == 60 && hintStream[i + 1] == 60) {
                    startHint = i;
                    i = length;
                }
                ++i;
            }
            byte[] data = new byte[length - startHint];
            System.arraycopy(hintStream, startHint, data, 0, data.length);
            LinearizedObject hintObj = new LinearizedObject(number, generation);
            hintObj.setStatus(2);
            hintObj.setUnresolvedData(data, 2004845231);
            currentPdfFile.checkResolved(hintObj);
            this.linHintTable.readTable(hintObj, this.linearObj, O, Ooffset);
        }
        return pdfObject;
    }

    public int getPageCount() {
        return this.linearPageCount;
    }

    public boolean hasLinearData() {
        return this.linearObj != null && this.E != -1;
    }

    public PdfObject getLinearPageObject() {
        return this.linObject;
    }

    public PdfObject getLinearObject(boolean isOpen, PdfObjectReader currentPdfFile) {
        if (!this.isLinearizationTested) {
            // empty if block
        }
        return this.linearObj;
    }
}

