/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.Serializable;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.ArrayDecoder;
import org.jpedal.io.ColorObjectDecoder;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.objects.raw.ColorSpaceObject;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.NamesObject;
import org.jpedal.objects.raw.ObjectFactory;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class ObjectDecoder
implements Serializable {
    private static final long serialVersionUID = 7141499991569886872L;
    PdfFileReader objectReader = null;
    DecryptionFactory decryption = null;
    private Object PDFkey;
    static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    static final boolean debugFastCode = false;
    private int pdfKeyType;
    private int PDFkeyInt;
    static String padding = "";
    boolean isInlineImage = false;
    private int endPt = -1;

    public ObjectDecoder(PdfFileReader pdfFileReader) {
        this.init(pdfFileReader);
    }

    private ObjectDecoder() {
    }

    private void init(PdfFileReader objectReader) {
        this.objectReader = objectReader;
        this.decryption = objectReader.getDecryptionObject();
    }

    public int readDictionaryAsObject(PdfObject pdfObject, int i, byte[] raw) {
        if (this.endPt == -1) {
            this.endPt = raw.length;
        }
        int length = raw.length;
        i = this.readObjectDataValues(pdfObject, i, raw, length);
        if (!pdfObject.ignoreStream() && pdfObject.getGeneralType(-1) != 6420) {
            this.readStreamData(pdfObject, i, raw, length);
        }
        if (pdfObject.getObjectType() == 373244477) {
            this.setFieldNames(pdfObject);
        }
        return i;
    }

    private int readObjectDataValues(PdfObject pdfObject, int i, byte[] raw, int length) {
        int level = 0;
        if (this.isInlineImage) {
            level = 1;
        }
        while (true) {
            if (i < length && raw[i] == 37) {
                i = ObjectDecoder.stripComment(length, i, raw);
            }
            if (i >= length || this.endPt != -1 && i >= this.endPt || raw[i] == 101 && raw[i + 1] == 110 && raw[i + 2] == 100 && raw[i + 3] == 111 || raw[i] == 115 && raw[i + 1] == 116 && raw[i + 2] == 114 && raw[i + 3] == 101 && raw[i + 4] == 97 && raw[i + 5] == 109) break;
            if (raw[i] == 60 && raw[i + 1] == 60) {
                ++i;
                ++level;
            } else if (raw[i] == 62 && i + 1 != length && raw[i + 1] == 62 && raw[i - 1] != 62) {
                ++i;
                if (--level == 0) {
                    break;
                }
            } else if (raw[i] == 47 && (raw[i + 1] == 47 || raw[i + 1] == 32)) {
                ++i;
            } else if (raw[i] == 47) {
                int keyLength;
                int keyStart = ++i;
                if ((i += (keyLength = ObjectDecoder.findDictionaryEnd(i, raw, length))) == length) break;
                boolean isStringPair = false;
                if (pdfObject.getID() == 1184787) {
                    isStringPair = ObjectDecoder.isStringPair(i, raw, isStringPair);
                }
                int type = pdfObject.getObjectType();
                boolean isMap = this.isMapObject(pdfObject, i, raw, length, keyStart, keyLength, isStringPair, type);
                if (raw[i] == 47 || raw[i] == 40 || raw[i] == 91) {
                    --i;
                }
                if (this.pdfKeyType == -1) {
                    i = ObjectUtils.handleUnknownType(i, raw, length);
                }
                if (this.PDFkeyInt != -1 && this.pdfKeyType != -1) {
                    i = this.setValue(pdfObject, i, raw, length, isMap);
                }
            } else if (raw[i] == 91 && level == 0 && pdfObject.getObjectType() == 1485011327) {
                ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, i, raw.length, 18, null, 826094945);
                objDecoder.readArray(false, raw, pdfObject, 339034948);
            }
            ++i;
        }
        return i;
    }

    private boolean isMapObject(PdfObject pdfObject, int i, byte[] raw, int length, int keyStart, int keyLength, boolean stringPair, int type) {
        boolean isMap;
        if (type == 487790868 && (pdfObject.getID() == 893350012 || pdfObject.getID() == 1184787 && stringPair || pdfObject.getID() == 17 && raw[i - 2] == 47)) {
            this.pdfKeyType = 30;
            this.PDFkey = PdfDictionary.getKey(keyStart, keyLength, raw);
            this.PDFkeyInt = 487790868;
            isMap = true;
        } else {
            isMap = false;
            this.PDFkey = null;
            this.getKeyType(pdfObject, i, raw, length, keyLength, keyStart, type);
        }
        return isMap;
    }

    private static int findDictionaryEnd(int jj, byte[] raw, int length) {
        int keyLength = 0;
        while (raw[jj] != 32 && raw[jj] != 13 && raw[jj] != 9 && raw[jj] != 10 && raw[jj] != 91 && raw[jj] != 47 && raw[jj] != 40 && raw[jj] != 60 && raw[jj] != 62) {
            ++keyLength;
            if (++jj != length) continue;
            break;
        }
        return keyLength;
    }

    private void getKeyType(PdfObject pdfObject, int i, byte[] raw, int length, int keyLength, int keyStart, int type) {
        int ptr;
        this.PDFkeyInt = PdfDictionary.getIntKey(keyStart, keyLength, raw);
        if (this.PDFkeyInt == 895578984 && (type == 7451 || type == 373244477 || type == 2004845231)) {
            this.PDFkeyInt = 25;
        }
        if (this.isInlineImage) {
            this.PDFkeyInt = PdfObjectFactory.getInlineID(this.PDFkeyInt);
        }
        int id = pdfObject.getID();
        if (type == 2004251818 && (this.PDFkeyInt == 2087749783 || this.PDFkeyInt == -1938465939 || this.PDFkeyInt == 878474856 || this.PDFkeyInt == 979194486 || this.PDFkeyInt == 373243460 || this.PDFkeyInt == 1146450818)) {
            this.pdfKeyType = 2;
        } else if (type == 1485011327 && this.PDFkeyInt == 20) {
            this.PDFkeyInt = 339034948;
            this.pdfKeyType = 18;
        } else if ((type == 373244477 || type == 7451) && this.PDFkeyInt == 20) {
            if (id == 4384 || id == 4369) {
                this.pdfKeyType = 40;
            } else if (id == 2570558) {
                this.pdfKeyType = 25;
            } else {
                this.PDFkeyInt = 339034948;
                this.pdfKeyType = 18;
            }
        } else {
            this.pdfKeyType = !(type != 373244477 && type != 7451 || id != 4384 && id != 4369 || this.PDFkeyInt != 17) ? 40 : (this.PDFkeyInt == 1110717793 && type == -1567847737 ? 22 : (this.PDFkeyInt == 506543413 && type == -1567847737 ? 25 : ((type == 2087749783 || type == 1518239089) && this.PDFkeyInt == 30 ? 7 : (this.PDFkeyInt == 826096968 && type == 2087749783 && pdfObject.getParameterConstant(2087749783) == 391471749 ? 7 : (id == 2570558 && pdfObject.getObjectType() == 373244477 && (this.PDFkeyInt == 32 || this.PDFkeyInt == 31) ? 25 : (this.isInlineImage && this.PDFkeyInt == 2087749783 ? 1 : PdfDictionary.getKeyType(this.PDFkeyInt, type)))))));
        }
        if (id == 878474856 && this.PDFkeyInt == 1518239089) {
            ptr = i;
            while (raw[ptr] >= 48 && raw[ptr] < 58 || raw[ptr] == 32) {
                ++ptr;
            }
            if (raw[ptr] == 91) {
                this.pdfKeyType = 14;
            }
        }
        if (this.pdfKeyType == -1 && id == 1448698499) {
            this.pdfKeyType = ObjectDecoder.getPairedValues(pdfObject, i, raw, this.pdfKeyType, length, keyLength, keyStart);
        } else if ((id == 30 || id == 20 || id == 34) && pdfObject.getParentID() == 4384 && pdfObject.getObjectType() == 373244477 && raw[i] != 91) {
            ptr = i;
            while (raw[ptr] >= 48 && raw[ptr] < 58 || raw[ptr] == 32) {
                ++ptr;
            }
            if (!(raw[keyStart] == 76 && raw[keyStart + 1] == 101 && raw[keyStart + 2] == 110 && raw[keyStart + 3] == 103 && raw[keyStart + 4] == 116 && raw[keyStart + 5] == 104 || raw[keyStart] == 79 && raw[keyStart + 1] == 110 || raw[keyStart] == 79 && raw[keyStart + 1] == 102 && raw[keyStart + 2] == 102 || raw[ptr] != 82)) {
                this.pdfKeyType = ObjectDecoder.getPairedValues(pdfObject, i, raw, this.pdfKeyType, length, keyLength, keyStart);
            }
        }
        if (this.PDFkeyInt == 1888135062) {
            this.pdfKeyType = ObjectDecoder.setTypeForDecodeParams(i, raw, length, this.pdfKeyType);
        }
    }

    private int setValue(PdfObject pdfObject, int i, byte[] raw, int length, boolean map) {
        boolean ignoreRecursion = pdfObject.ignoreRecursion();
        if (this.pdfKeyType == 5 && pdfObject.isDataExternal()) {
            this.pdfKeyType = 1;
        }
        switch (this.pdfKeyType) {
            case 25: {
                i = this.setTextStreamValue(pdfObject, i, raw, ignoreRecursion);
                break;
            }
            case 35: {
                i = this.setNameTreeValue(pdfObject, i, raw, length, ignoreRecursion);
                break;
            }
            case 2: {
                i = this.setDictionaryValue(pdfObject, i, raw, length, ignoreRecursion);
                break;
            }
            case 20: {
                ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, i, this.endPt, 20);
                i = objDecoder.readArray(ignoreRecursion, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 12: {
                ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, i, this.endPt, 12);
                i = objDecoder.readArray(false, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 14: {
                ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, i, this.endPt, 14);
                i = objDecoder.readArray(ignoreRecursion, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 18: {
                ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, i, this.endPt, 18);
                i = objDecoder.readArray(ignoreRecursion, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 22: {
                ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, i, this.endPt, 22);
                i = objDecoder.readArray(false, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 16: {
                ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, i, this.endPt, 16);
                i = objDecoder.readArray(false, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 9: {
                ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, i, this.endPt, 9);
                i = objDecoder.readArray(false, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 10: {
                ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, i, this.endPt, 10);
                i = objDecoder.readArray(false, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 30: {
                i = this.setNameStringValue(pdfObject, i, raw, map);
                break;
            }
            case 8: {
                i = this.setBooleanValue(pdfObject, i, raw, this.PDFkeyInt);
                break;
            }
            case 3: {
                i = this.setStringConstantValue(pdfObject, i, raw);
                break;
            }
            case 4: {
                i = this.setStringKeyValue(pdfObject, i, raw);
                break;
            }
            case 6: {
                ++i;
                while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47) {
                    ++i;
                }
                i = this.setNumberValue(pdfObject, i, raw, this.PDFkeyInt);
                break;
            }
            case 7: {
                i = this.setFloatValue(pdfObject, i, raw, length);
                break;
            }
            case 5: {
                i = this.setUnreadDictionaryValue(pdfObject, i, raw);
                break;
            }
            case 40: {
                if (raw.length - 5 > 0 && raw[i + 1] == 110 && raw[i + 2] == 117 && raw[i + 3] == 108 && raw[i + 4] == 108) {
                    i += 5;
                    break;
                }
                i = this.setVariousValue(pdfObject, i, raw, length, this.PDFkeyInt, map, ignoreRecursion);
                break;
            }
            case 1: {
                i = this.setDictionaryValue(pdfObject, i, raw, ignoreRecursion);
            }
        }
        return i;
    }

    private static boolean isStringPair(int i, byte[] raw, boolean stringPair) {
        int len = raw.length;
        for (int aa = i; aa < len; ++aa) {
            if (raw[aa] == 40) {
                aa = len;
                stringPair = true;
                continue;
            }
            if (raw[aa] == 47 || raw[aa] == 62 || raw[aa] == 60 || raw[aa] == 91 || raw[aa] == 82) {
                aa = len;
                continue;
            }
            if (raw[aa] != 77 || raw[aa + 1] != 67 || raw[aa + 2] != 73 || raw[aa + 3] != 68) continue;
            aa = len;
        }
        return stringPair;
    }

    private static int stripComment(int length, int i, byte[] raw) {
        while (i < length && raw[i] != 10 && raw[i] != 13) {
            ++i;
        }
        while (i < length && (raw[i] == 9 || raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 60)) {
            ++i;
        }
        return i;
    }

    private int setVariousValue(PdfObject pdfObject, int i, byte[] raw, int length, int PDFkeyInt, boolean map, boolean ignoreRecursion) {
        if (raw[i] != 60) {
            ++i;
        }
        if (raw[i] == 47) {
            i = this.setNameStringValue(pdfObject, i, raw, map);
        } else if (raw[i] == 102 && raw[i + 1] == 97 && raw[i + 2] == 108 && raw[i + 3] == 115 && raw[i + 4] == 101) {
            pdfObject.setBoolean(PDFkeyInt, false);
            i += 4;
        } else if (raw[i] == 116 && raw[i + 1] == 114 && raw[i + 2] == 117 && raw[i + 3] == 101) {
            pdfObject.setBoolean(PDFkeyInt, true);
            i += 3;
        } else if (raw[i] == 40 || raw[i] == 60 && raw[i - 1] != 60 && raw[i + 1] != 60) {
            i = this.readTextStream(pdfObject, i, raw, PDFkeyInt, ignoreRecursion);
        } else if (raw[i] == 91) {
            if (PDFkeyInt == 2627089) {
                ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, i, this.endPt, 18);
                i = objDecoder.readArray(ignoreRecursion, raw, pdfObject, PDFkeyInt);
            } else if (PDFkeyInt == 27) {
                ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, i, this.endPt, 20);
                i = objDecoder.readArray(ignoreRecursion, raw, pdfObject, PDFkeyInt);
            } else if (PDFkeyInt == 19) {
                ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, i, this.endPt, 10);
                i = objDecoder.readArray(ignoreRecursion, raw, pdfObject, PDFkeyInt);
            } else {
                ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, i, this.endPt, 20);
                i = objDecoder.readArray(ignoreRecursion, raw, pdfObject, PDFkeyInt);
            }
        } else if (raw[i] == 60 && raw[i + 1] == 60) {
            i = this.readDictionary(pdfObject, i, raw, PDFkeyInt, ignoreRecursion);
        } else {
            int jj = i;
            int j = i + 1;
            byte[] data = raw;
            int typeFound = 0;
            boolean isNumber = true;
            boolean isRef = false;
            boolean isString = false;
            String objRef = pdfObject.getObjectRefAsString();
            do {
                if (data[j] == 82 && !isString) {
                    isRef = true;
                    int end = j;
                    j = i;
                    i = end;
                    while (data[j] == 91 || data[j] == 32 || data[j] == 13 || data[j] == 10) {
                        ++j;
                    }
                    int keyStart = j;
                    int refStart = j;
                    while (data[j] != 10 && data[j] != 13 && data[j] != 32 && data[j] != 47 && data[j] != 60 && data[j] != 62) {
                        ++j;
                    }
                    int ref = NumberUtils.parseInt(keyStart, j, data);
                    while (data[j] == 10 || data[j] == 13 || data[j] == 32) {
                        ++j;
                    }
                    keyStart = j;
                    while (data[j] != 10 && data[j] != 13 && data[j] != 32 && data[j] != 47 && data[j] != 60 && data[j] != 62) {
                        ++j;
                    }
                    int generation = NumberUtils.parseInt(keyStart, j, data);
                    while (data[j] == 10 || data[j] == 13 || data[j] == 32 || data[j] == 47 || data[j] == 60) {
                        ++j;
                    }
                    if (data[j] != 82) {
                        throw new RuntimeException("ref=" + ref + " gen=" + ref + " 1. Unexpected value " + data[j] + " in file - please send to IDRsolutions for analysis char=" + (char)data[j]);
                    }
                    objRef = new String(data, refStart, 1 + j - refStart);
                    byte[] newData = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(ref, generation), ref, generation);
                    int firstChar = 0;
                    int newLength = newData.length - 3;
                    for (int aa = 3; aa < newLength; ++aa) {
                        if (newData[aa - 2] == 111 && newData[aa - 1] == 98 && newData[aa] == 106) {
                            for (firstChar = aa + 1; firstChar < newLength && (newData[firstChar] == 10 || newData[firstChar] == 13 || newData[firstChar] == 32 || newData[firstChar] == 9); ++firstChar) {
                            }
                            aa = newLength;
                            continue;
                        }
                        if (newData[aa] > 47 && newData[aa] < 58 || newData[aa] == 111 || newData[aa] == 98 || newData[aa] == 106 || newData[aa] == 82 || newData[aa] == 32 || newData[aa] == 10 || newData[aa] == 13) continue;
                        aa = newLength;
                        firstChar = 0;
                    }
                    boolean bl = isString = newData[firstChar] == 40;
                    if (pdfObject.getID() == 4369 && newData[0] == 60 && newData[1] == 60) {
                        PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, objRef, pdfObject.getObjectType(), pdfObject.getID());
                        valueObj.setID(PDFkeyInt);
                        pdfObject.setDictionary(PDFkeyInt, valueObj);
                        valueObj.setStatus(2);
                        valueObj.setUnresolvedData(newData, 2);
                        isNumber = false;
                        typeFound = 4;
                        i = j;
                        break;
                    }
                    if (pdfObject.getID() == -1 && newData[0] == 60 && newData[1] == 60) {
                        isNumber = false;
                        typeFound = 0;
                        i = j;
                        break;
                    }
                    if (PDFkeyInt == 2037870513 && data[i] == 82) {
                        int jj2 = 0;
                        while (newData[jj2] != 91 && (newData[++jj2] != 60 || newData[jj2 + 1] == 60)) {
                        }
                        ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, jj2, this.endPt, 18);
                        objDecoder.readArray(ignoreRecursion, newData, pdfObject, PDFkeyInt);
                        i = j;
                        break;
                    }
                    data = newData;
                    if (data == null) {
                        pdfObject.setFullyResolved(false);
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("[Linearized] " + objRef + " not yet available (4)");
                        }
                        i = length;
                        break;
                    }
                    jj = 3;
                    if (data.length <= 3) {
                        jj = 0;
                    } else {
                        while (data[jj - 2] != 111 || data[jj - 1] != 98 || data[jj] != 106) {
                            if (++jj != data.length) continue;
                            jj = 0;
                            break;
                        }
                    }
                    if (data[jj] != 40) {
                        ++jj;
                    }
                    while (data[jj] == 10 || data[jj] == 13 || data[jj] == 32) {
                        ++jj;
                    }
                    j = jj;
                    continue;
                }
                if (data[j] == 91 || data[j] == 40) break;
                if (data[j] == 60) {
                    typeFound = 0;
                    break;
                }
                if (data[j] == 62 || data[j] == 47) {
                    typeFound = 1;
                    break;
                }
                if (data[j] == 32 || data[j] == 10 || data[j] == 13 || data[j] >= 48 && data[j] <= 57 || data[j] == 46) continue;
                isNumber = false;
            } while (++j != data.length);
            int count = 0;
            for (int aa = jj + 1; aa < data.length; ++aa) {
                if (data[aa] != 47) continue;
                ++count;
            }
            while (data[jj] == 10 || data[jj] == 13 || data[jj] == 32) {
                ++jj;
            }
            if (typeFound != 4) {
                if (count == 0 && data[jj] == 47) {
                    jj = this.setNameStringValue(pdfObject, jj, data, map);
                } else if (data[jj] == 40) {
                    jj = this.readTextStream(pdfObject, jj, data, PDFkeyInt, ignoreRecursion);
                } else if (data[jj] == 91) {
                    ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, jj, this.endPt, 20);
                    jj = objDecoder.readArray(ignoreRecursion, data, pdfObject, PDFkeyInt);
                } else if (typeFound == 0) {
                    try {
                        jj = this.readDictionaryFromRefOrDirect(-1, pdfObject, objRef, jj, data, PDFkeyInt);
                    }
                    catch (Exception e) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("Exception: " + e.getMessage());
                        }
                    }
                } else if (isNumber) {
                    jj = this.setNumberValue(pdfObject, jj, data, PDFkeyInt);
                } else if (typeFound == 1) {
                    jj = this.setNameStringValue(pdfObject, jj, data, map);
                }
            }
            if (!isRef) {
                i = jj;
            }
        }
        return i;
    }

    private static int setTypeForDecodeParams(int i, byte[] raw, int length, int pdfKeyType) {
        int ii;
        for (ii = i; ii < length && (raw[ii] == 32 || raw[ii] == 9 || raw[ii] == 13 || raw[ii] == 10); ++ii) {
        }
        if (raw[ii] != 60) {
            while (ii < length && (raw[ii] == 32 || raw[ii] == 9 || raw[ii] == 13 || raw[ii] == 10 || raw[ii] == 91)) {
                ++ii;
            }
            if (raw[ii] == 60) {
                pdfKeyType = 22;
            }
        }
        return pdfKeyType;
    }

    private int setNameTreeValue(PdfObject pdfObject, int i, byte[] raw, int length, boolean ignoreRecursion) {
        boolean isRef = false;
        while (raw[i] != 91) {
            if (raw[i] == 40) {
                isRef = false;
                break;
            }
            if (raw[i] >= 48 && raw[i] <= 57) {
                isRef = true;
                break;
            }
            ++i;
        }
        byte[] data = raw;
        int start = i;
        int j = i;
        int count = 0;
        if (isRef) {
            int keyStart2 = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int number = NumberUtils.parseInt(keyStart2, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            keyStart2 = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int generation = NumberUtils.parseInt(keyStart2, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            if (raw[i] != 82) {
                throw new RuntimeException("3. Unexpected value in file " + raw[i] + " - please send to IDRsolutions for analysis");
            }
            if (!ignoreRecursion) {
                data = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(number, generation), number, generation);
                if (data == null) {
                    pdfObject.setFullyResolved(false);
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (1)");
                    }
                    i = length;
                    return i;
                }
                j = 3;
                while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111) {
                    ++j;
                }
                while (data[j] == 10 || data[j] == 13 || data[j] == 32) {
                    ++j;
                }
                start = j;
            }
        }
        while (j < data.length) {
            if (data[j] == 91 || data[j] == 40) {
                ++count;
            } else if (data[j] == 93 || data[j] == 41) {
                --count;
            }
            if (count == 0) break;
            ++j;
        }
        if (!ignoreRecursion) {
            byte[] newString;
            block23: {
                int stringLength = j - start + 1;
                newString = new byte[stringLength];
                System.arraycopy(data, start, newString, 0, stringLength);
                if (pdfObject.getObjectType() != 1113489015 && this.decryption != null) {
                    try {
                        newString = this.decryption.decrypt(newString, pdfObject.getObjectRefAsString(), false, null, false, false);
                    }
                    catch (PdfSecurityException e) {
                        if (!LogWriter.isOutput()) break block23;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
            }
            pdfObject.setTextStreamValue(this.PDFkeyInt, newString);
        }
        if (!isRef) {
            i = j;
        }
        return i;
    }

    private int setDictionaryValue(PdfObject pdfObject, int i, byte[] raw, boolean ignoreRecursion) {
        boolean isKey;
        int end = i;
        int nextC = i;
        while (raw[nextC] == 10 || raw[nextC] == 32 || raw[nextC] == 9) {
            ++nextC;
        }
        if (raw[nextC] == 110 && raw[nextC + 1] == 117 && raw[nextC + 2] == 108 && raw[nextC + 3] == 108) {
            i = nextC + 4;
            return i;
        }
        if (raw[i] != 60 && raw[i + 1] != 60) {
            end += 2;
        }
        boolean inDictionary = true;
        boolean bl = isKey = raw[end - 1] == 47;
        while (inDictionary) {
            if (raw[end] == 60 && raw[end + 1] == 60) {
                int level2 = 1;
                ++end;
                while (level2 > 0) {
                    if (raw[end] == 60 && raw[end + 1] == 60) {
                        ++level2;
                        end += 2;
                        continue;
                    }
                    if (raw[end - 1] == 62 && raw[end] == 62) {
                        if (--level2 <= 0) continue;
                        end += 2;
                        continue;
                    }
                    ++end;
                }
                inDictionary = false;
                continue;
            }
            if (raw[end] == 82) {
                inDictionary = false;
                continue;
            }
            if (isKey && (raw[end] == 32 || raw[end] == 13 || raw[end] == 10 || raw[end] == 9)) {
                inDictionary = false;
                continue;
            }
            if (raw[end] == 47) {
                inDictionary = false;
                --end;
                continue;
            }
            if (raw[end] == 62 && raw[end + 1] == 62) {
                inDictionary = false;
                --end;
                continue;
            }
            ++end;
        }
        this.readDictionary(pdfObject, i, raw, this.PDFkeyInt, ignoreRecursion);
        return end;
    }

    private int setFloatValue(PdfObject pdfObject, int i, byte[] raw, int length) {
        int jj;
        ++i;
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47) {
            ++i;
        }
        int keyStart = i;
        while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
            ++i;
        }
        float number = NumberUtils.parseFloat(keyStart, i, raw);
        for (jj = i; jj < length && (raw[jj] == 32 || raw[jj] == 13 || raw[jj] == 10); ++jj) {
        }
        if (raw[jj] >= 48 && raw[jj] <= 57) {
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            keyStart = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int generation = NumberUtils.parseInt(keyStart, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            if (raw[i] != 82) {
                throw new RuntimeException("3. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            byte[] data = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed((int)number, generation), (int)number, generation);
            if (data == null) {
                pdfObject.setFullyResolved(false);
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (3)");
                }
                i = length;
                return i;
            }
            int j = 3;
            while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111) {
                ++j;
            }
            while (data[j] == 10 || data[j] == 13 || data[j] == 32) {
                ++j;
            }
            int count = j;
            while (data[count] != 10 && data[count] != 13 && data[count] != 32) {
                ++count;
            }
            number = NumberUtils.parseFloat(j, count, data);
        }
        pdfObject.setFloatNumber(this.PDFkeyInt, number);
        return --i;
    }

    private int setStringKeyValue(PdfObject pdfObject, int i, byte[] raw) {
        ++i;
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47) {
            ++i;
        }
        int keyStart = i;
        int keyLength = 1;
        boolean isNull = false;
        while (raw[i] != 82 && !isNull) {
            if (this.PDFkeyInt == 1110793845 && raw[i] == 110 && raw[i + 1] == 117 && raw[i + 2] == 108 && raw[i + 3] == 108) {
                isNull = true;
            }
            ++i;
            ++keyLength;
        }
        --i;
        if (!isNull) {
            byte[] stringBytes = new byte[keyLength];
            System.arraycopy(raw, keyStart, stringBytes, 0, keyLength);
            pdfObject.setStringKey(this.PDFkeyInt, stringBytes);
        }
        return i;
    }

    private int setDictionaryValue(PdfObject pdfObject, int i, byte[] raw, int length, boolean ignoreRecursion) {
        boolean isRef;
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47) {
            ++i;
        }
        byte[] data = raw;
        int j = i;
        boolean bl = isRef = data[j] != 60;
        if (isRef) {
            int keyStart2 = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int number = NumberUtils.parseInt(keyStart2, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            keyStart2 = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int generation = NumberUtils.parseInt(keyStart2, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            if (raw[i] != 82) {
                throw new RuntimeException("3. Unexpected value in file " + raw[i] + " - please send to IDRsolutions for analysis");
            }
            if (!ignoreRecursion) {
                data = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(number, generation), number, generation);
                if (data == null) {
                    pdfObject.setFullyResolved(false);
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (2)");
                    }
                    i = length;
                    return i;
                }
                if (data[0] == 60 && data[1] == 60) {
                    j = 0;
                } else {
                    j = 3;
                    while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111) {
                        if (data[j] == 47) {
                            j = 0;
                            break;
                        }
                        if (++j != data.length) continue;
                        j = 0;
                        break;
                    }
                    while (data[j] == 10 || data[j] == 13 || data[j] == 32) {
                        ++j;
                    }
                }
            }
        }
        int endJ = j;
        while (data[endJ] == 60 || data[endJ] == 32 || data[endJ] == 13 || data[endJ] == 10) {
            ++endJ;
        }
        if (data[endJ] == 62) {
            j = endJ + 1;
        } else {
            PdfObject valueObj = ObjectFactory.createObject(this.PDFkeyInt, pdfObject.getObjectRefAsString(), pdfObject.getObjectType(), pdfObject.getID());
            valueObj.setID(this.PDFkeyInt);
            if (ignoreRecursion) {
                j = this.readKeyPairs(this.PDFkeyInt, data, j, -2, null);
            } else {
                int count = this.readKeyPairs(this.PDFkeyInt, data, j, -1, null);
                j = this.readKeyPairs(this.PDFkeyInt, data, j, count, valueObj);
                pdfObject.setDictionary(this.PDFkeyInt, valueObj);
            }
        }
        if (!isRef) {
            i = j;
        }
        return i;
    }

    private int setStringConstantValue(PdfObject pdfObject, int i, byte[] raw) {
        ++i;
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47) {
            ++i;
        }
        int keyStart = i;
        int keyLength = 0;
        while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
            ++i;
            ++keyLength;
        }
        pdfObject.setConstant(this.PDFkeyInt, keyStart, keyLength, raw);
        return --i;
    }

    private int setBooleanValue(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt) {
        ++i;
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47) {
            ++i;
        }
        int keyStart = i;
        while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
            ++i;
        }
        --i;
        if (raw[keyStart] == 116 && raw[keyStart + 1] == 114 && raw[keyStart + 2] == 117 && raw[keyStart + 3] == 101) {
            pdfObject.setBoolean(PDFkeyInt, true);
        } else if (raw[keyStart] == 102 && raw[keyStart + 1] == 97 && raw[keyStart + 2] == 108 && raw[keyStart + 3] == 115 && raw[keyStart + 4] == 101) {
            pdfObject.setBoolean(PDFkeyInt, false);
        } else {
            throw new RuntimeException("Unexpected value for Boolean value for" + PDFkeyInt + '=' + this.PDFkey);
        }
        return i;
    }

    private int setTextStreamValue(PdfObject pdfObject, int i, byte[] raw, boolean ignoreRecursion) {
        if (raw[i + 1] == 40 && raw[i + 2] == 41) {
            pdfObject.setTextStreamValue(this.PDFkeyInt, new byte[1]);
            if (raw[i += 3] == 47) {
                --i;
            }
        } else {
            i = this.readTextStream(pdfObject, i, raw, this.PDFkeyInt, ignoreRecursion);
        }
        return i;
    }

    private void setFieldNames(PdfObject pdfObject) {
        String fieldName = pdfObject.getTextStreamValue(36);
        if (fieldName != null) {
            String parent = pdfObject.getStringKey(1110793845);
            boolean isMultiple = false;
            while (parent != null) {
                FormObject parentObj = new FormObject(parent, false);
                this.objectReader.readObject(parentObj);
                String newName = parentObj.getTextStreamValue(36);
                if (fieldName == null && newName != null) {
                    fieldName = newName;
                } else if (!(newName == null || fieldName.equals(newName) && parent.equals(pdfObject.getObjectRefAsString()))) {
                    fieldName = newName + '.' + fieldName;
                    isMultiple = true;
                }
                if (newName == null) break;
                parent = parentObj.getParentRef();
            }
            if (isMultiple) {
                pdfObject.setTextStreamValue(36, StringUtils.toBytes(fieldName));
            }
        }
    }

    private void readStreamData(PdfObject pdfObject, int i, byte[] raw, int length) {
        for (int xx = i; xx < length - 5 && (raw[xx] != 62 || raw[xx + 1] != 62); ++xx) {
            if (raw[xx] != 115 || raw[xx + 1] != 116 || raw[xx + 2] != 114 || raw[xx + 3] != 101 || raw[xx + 4] != 97 || raw[xx + 5] != 109) continue;
            if (!pdfObject.isCached()) {
                this.readStreamIntoObject(pdfObject, xx, raw);
            }
            xx = length;
        }
    }

    private static int getPairedValues(PdfObject pdfObject, int i, byte[] raw, int pdfKeyType, int length, int keyLength, int keyStart) {
        boolean isPair = false;
        int jj = i;
        while (jj < length) {
            while (jj < length && (raw[jj] == 32 || raw[jj] == 10 || raw[jj] == 13 || raw[jj] == 10)) {
                ++jj;
            }
            if (jj < length && raw[jj] >= 48 && raw[jj] <= 57) {
                while (jj < length && raw[jj] >= 48 && raw[jj] <= 57) {
                    ++jj;
                }
                while (jj < length && (raw[jj] == 32 || raw[jj] == 10 || raw[jj] == 13 || raw[jj] == 10)) {
                    ++jj;
                }
                while (jj < length && (raw[jj] >= 48 && raw[jj] <= 57 || raw[jj] == 32 || raw[jj] == 10 || raw[jj] == 13 || raw[jj] == 10)) {
                    ++jj;
                }
                if (jj >= length || raw[jj] != 82) break;
                ++jj;
            }
            while (jj < length && (raw[jj] == 32 || raw[jj] == 10 || raw[jj] == 13 || raw[jj] == 10)) {
                ++jj;
            }
            if (raw[jj] == 62 && raw[jj + 1] == 62) {
                isPair = true;
                break;
            }
            if (raw[jj] != 47) break;
            ++jj;
            while (jj < length && raw[jj] != 32 && raw[jj] != 10 && raw[jj] != 13 && raw[jj] != 10) {
                ++jj;
            }
        }
        if (isPair) {
            pdfObject.setCurrentKey(PdfDictionary.getKey(keyStart, keyLength, raw));
            return 5;
        }
        return pdfKeyType;
    }

    private int setUnreadDictionaryValue(PdfObject pdfObject, int i, byte[] raw) {
        if (raw[i] != 60) {
            ++i;
        }
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 9) {
            ++i;
        }
        int start = i;
        PdfObject valueObj = ObjectFactory.createObject(this.PDFkeyInt, pdfObject.getObjectRefAsString(), pdfObject.getObjectType(), pdfObject.getID());
        valueObj.setID(this.PDFkeyInt);
        if (raw[i] != 110 || raw[i + 1] != 117 || raw[i + 2] != 108 || raw[i + 3] != 108) {
            pdfObject.setDictionary(this.PDFkeyInt, valueObj);
        }
        int status = 2;
        if (raw[i] == 47) {
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            int keyStart = i;
            int keyLength = 0;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
                ++keyLength;
            }
            --i;
            int constant = valueObj.setConstant(this.PDFkeyInt, keyStart, keyLength, raw);
            if (constant == -1 || this.isInlineImage) {
                byte[] newStr = new byte[keyLength];
                System.arraycopy(raw, keyStart, newStr, 0, keyLength);
                String s = new String(newStr);
                valueObj.setGeneralStringValue(s);
            }
            status = 0;
        } else if (raw[i] != 101 || raw[i + 1] != 110 || raw[i + 2] != 100 || raw[i + 3] != 111 || raw[i + 4] != 98) {
            int reflevel;
            while (raw[i] == 91 && this.PDFkeyInt != 2087749783 || raw[i] == 32 || raw[i] == 13 || raw[i] == 10) {
                ++i;
            }
            if (raw[i] == 60 && raw[i + 1] == 60) {
                i += 2;
                reflevel = 1;
                while (reflevel > 0) {
                    if (raw[i] == 60 && raw[i + 1] == 60) {
                        i += 2;
                        ++reflevel;
                        continue;
                    }
                    if (raw[i] == 62 && i + 1 == raw.length) {
                        reflevel = 0;
                        continue;
                    }
                    if (raw[i] == 62 && raw[i + 1] == 62) {
                        i += 2;
                        --reflevel;
                        continue;
                    }
                    ++i;
                }
            } else if (raw[i] == 91) {
                ++i;
                reflevel = 1;
                while (reflevel > 0) {
                    if (raw[i] == 40) {
                        ++i;
                        while (raw[i] != 41 || ObjectUtils.isEscaped(raw, i)) {
                            ++i;
                        }
                    } else if (raw[i] == 91) {
                        ++reflevel;
                    } else if (raw[i] == 93) {
                        --reflevel;
                    }
                    ++i;
                }
                --i;
            } else if (raw[i] == 110 && raw[i + 1] == 117 && raw[i + 2] == 108 && raw[i + 3] == 108) {
                i += 4;
            } else {
                status = 1;
                while ((raw[i] != 82 || raw[i - 1] == 101) && ++i != raw.length) {
                }
                if (++i >= raw.length) {
                    i = raw.length - 1;
                }
            }
        }
        valueObj.setStatus(status);
        if (status != 0) {
            int StrLength = i - start;
            byte[] unresolvedData = new byte[StrLength];
            System.arraycopy(raw, start, unresolvedData, 0, StrLength);
            if (unresolvedData[StrLength - 1] == 82) {
                for (int jj = 0; jj < StrLength; ++jj) {
                    if (unresolvedData[jj] != 10 && unresolvedData[jj] != 13) continue;
                    unresolvedData[jj] = 32;
                }
            }
            valueObj.setUnresolvedData(unresolvedData, this.PDFkeyInt);
        }
        if (raw[i] == 47 || raw[i] == 62) {
            --i;
        }
        return i;
    }

    int readDictionary(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, boolean ignoreRecursion) {
        String objectRef = pdfObject.getObjectRefAsString();
        if (raw[i] != 60) {
            ++i;
        }
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32) {
            ++i;
        }
        if (raw[i] == 47) {
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            int keyStart = i;
            int keyLength = 0;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
                ++keyLength;
            }
            --i;
            if (!ignoreRecursion) {
                PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, objectRef, pdfObject.getObjectType(), pdfObject.getID());
                valueObj.setID(PDFkeyInt);
                int constant = valueObj.setConstant(PDFkeyInt, keyStart, keyLength, raw);
                if (constant == -1 || this.isInlineImage) {
                    byte[] newStr = new byte[keyLength];
                    System.arraycopy(raw, keyStart, newStr, 0, keyLength);
                    String s = new String(newStr);
                    valueObj.setGeneralStringValue(s);
                }
                pdfObject.setDictionary(PDFkeyInt, valueObj);
                if (pdfObject.isDataExternal()) {
                    valueObj.isDataExternal(true);
                    if (!this.resolveFully(valueObj)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
            }
        } else if (raw[i] != 101 || raw[i + 1] != 110 || raw[i + 2] != 100 || raw[i + 3] != 111 || raw[i + 4] != 98) {
            if (raw[i] == 40 && PDFkeyInt == 6691) {
                int start = ++i;
                while (i < raw.length && (raw[++i] != 41 || ObjectUtils.isEscaped(raw, i))) {
                }
                byte[] data = ObjectUtils.readEscapedValue(i, raw, start, false);
                NamesObject JS = new NamesObject(objectRef);
                JS.setDecodedStream(data);
                pdfObject.setDictionary(6691, JS);
            } else if (ignoreRecursion) {
                while (raw[i] == 91 || raw[i] == 32 || raw[i] == 13 || raw[i] == 10) {
                    ++i;
                }
                if (raw[i] == 60 && raw[i + 1] == 60) {
                    i += 2;
                    int reflevel = 1;
                    while (reflevel > 0) {
                        if (raw[i] == 60 && raw[i + 1] == 60) {
                            i += 2;
                            ++reflevel;
                            continue;
                        }
                        if (raw[i] == 62 && raw[i + 1] == 62) {
                            i += 2;
                            --reflevel;
                            continue;
                        }
                        ++i;
                    }
                    --i;
                } else {
                    i = this.readDictionaryFromRefOrDirect(PDFkeyInt, pdfObject, objectRef, i, raw, PDFkeyInt);
                }
                if (i < raw.length && raw[i] == 47) {
                    --i;
                }
            } else {
                i = this.readDictionaryFromRefOrDirect(PDFkeyInt, pdfObject, objectRef, i, raw, PDFkeyInt);
            }
        }
        return i;
    }

    private int readTextStream(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, boolean ignoreRecursion) {
        block77: {
            if (PDFkeyInt == 39 || PDFkeyInt == 9986) {
                if (PDFkeyInt == 9986) {
                    ++i;
                }
                boolean isRef = false;
                while (raw[i] != 91) {
                    if (raw[i] == 40) {
                        isRef = false;
                        break;
                    }
                    if (raw[i] >= 48 && raw[i] <= 57) {
                        isRef = true;
                        break;
                    }
                    ++i;
                }
                byte[] data = raw;
                int start = i;
                int j = i;
                int count = 0;
                if (isRef) {
                    int keyStart2 = i;
                    while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                        ++i;
                    }
                    int number = NumberUtils.parseInt(keyStart2, i, raw);
                    while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                        ++i;
                    }
                    keyStart2 = i;
                    while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                        ++i;
                    }
                    int generation = NumberUtils.parseInt(keyStart2, i, raw);
                    while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                        ++i;
                    }
                    if (raw[i] != 82) {
                        throw new RuntimeException("3. Unexpected value in file " + raw[i] + " - please send to IDRsolutions for analysis");
                    }
                    if (!ignoreRecursion) {
                        data = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(number, generation), number, generation);
                        if (data == null) {
                            pdfObject.setFullyResolved(false);
                            if (LogWriter.isOutput()) {
                                LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (6)");
                            }
                            return raw.length;
                        }
                        j = 3;
                        while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111) {
                            if (++j != data.length) continue;
                            j = 0;
                            break;
                        }
                        while (data[j] == 10 || data[j] == 13 || data[j] == 32) {
                            ++j;
                        }
                        start = j;
                    }
                }
                while (j < data.length) {
                    if (data[j] == 91 || data[j] == 40) {
                        ++count;
                    } else if (data[j] == 93 || data[j] == 41) {
                        --count;
                    }
                    if (count == 0) break;
                    ++j;
                }
                if (!ignoreRecursion) {
                    int stringLength = j - start + 1;
                    byte[] newString = new byte[stringLength];
                    System.arraycopy(data, start, newString, 0, stringLength);
                    if (PDFkeyInt != 6691) {
                        for (int aa = 0; aa < stringLength; ++aa) {
                            if (newString[aa] != 10 && newString[aa] != 13) continue;
                            newString[aa] = 32;
                        }
                    }
                    pdfObject.setTextStreamValue(PDFkeyInt, newString);
                }
                if (!isRef) {
                    i = j;
                }
            } else {
                try {
                    if (raw[i] != 60 && raw[i] != 40) {
                        ++i;
                    }
                    while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32) {
                        ++i;
                    }
                    if (raw[i] == 47) {
                        pdfObject.setTextStreamValue(PDFkeyInt, new byte[1]);
                        return --i;
                    }
                    boolean isRef = raw[i] != 60 && raw[i] != 40;
                    int j = i;
                    byte[] data = raw;
                    if (isRef) {
                        int keyStart2 = i;
                        while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                            ++i;
                        }
                        int number = NumberUtils.parseInt(keyStart2, i, raw);
                        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                            ++i;
                        }
                        keyStart2 = i;
                        while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                            ++i;
                        }
                        int generation = NumberUtils.parseInt(keyStart2, i, raw);
                        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                            ++i;
                        }
                        if (raw[i] != 82) {
                            return raw.length;
                        }
                        if (!ignoreRecursion) {
                            data = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(number, generation), number, generation);
                            if (data == null) {
                                pdfObject.setFullyResolved(false);
                                if (LogWriter.isOutput()) {
                                    LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (7)");
                                }
                                return raw.length;
                            }
                            if (data[0] == 40) {
                                j = 0;
                            } else {
                                j = 3;
                                while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111) {
                                    ++j;
                                }
                                while (data[j] == 10 || data[j] == 13 || data[j] == 32) {
                                    ++j;
                                }
                            }
                        }
                    }
                    int start = 0;
                    if (!isRef || !ignoreRecursion) {
                        while (data[j] != 40 && data[j] != 60) {
                            ++j;
                        }
                        byte startChar = data[j];
                        start = j;
                        int bracketCount = 1;
                        while (j < data.length) {
                            if (!(startChar != 40 || data[++j] != 41 && data[j] != 40 || ObjectUtils.isEscaped(data, j))) {
                                if (data[j] == 40) {
                                    ++bracketCount;
                                } else if (data[j] == 41) {
                                    --bracketCount;
                                }
                                if (bracketCount == 0) break;
                            }
                            if (startChar != 60 || data[j] != 62 && data[j] != 0) continue;
                        }
                    }
                    if (!ignoreRecursion) {
                        byte[] newString;
                        block76: {
                            if (data[start] == 60) {
                                int byteCount = j - ++start >> 1;
                                newString = new byte[byteCount];
                                int byteReached = 0;
                                while (start != j) {
                                    while (data[start] == 32 || data[start] == 10 || data[start] == 13) {
                                        ++start;
                                    }
                                    int topHex = data[start];
                                    if (topHex >= 65 && topHex <= 70) {
                                        topHex -= 55;
                                    } else if (topHex >= 97 && topHex <= 102) {
                                        topHex -= 87;
                                    } else if (topHex >= 48 && topHex <= 57) {
                                        topHex -= 48;
                                    } else if (LogWriter.isOutput()) {
                                        LogWriter.writeLog("Unexpected number " + (char)data[start]);
                                    }
                                    ++start;
                                    while (data[start] == 32 || data[start] == 10 || data[start] == 13) {
                                        ++start;
                                    }
                                    int bottomHex = data[start];
                                    if (bottomHex >= 65 && bottomHex <= 70) {
                                        bottomHex -= 55;
                                    } else if (bottomHex >= 97 && bottomHex <= 102) {
                                        bottomHex -= 87;
                                    } else if (bottomHex >= 48 && bottomHex <= 57) {
                                        bottomHex -= 48;
                                    } else {
                                        if (LogWriter.isOutput()) {
                                            LogWriter.writeLog("Unexpected number " + (char)data[start]);
                                        }
                                        return i;
                                    }
                                    ++start;
                                    int finalValue = bottomHex + (topHex << 4);
                                    newString[byteReached] = (byte)finalValue;
                                    ++byteReached;
                                }
                            } else {
                                if (data[start] == 40) {
                                    ++start;
                                }
                                newString = ObjectUtils.readEscapedValue(j, data, start, PDFkeyInt == 6420);
                            }
                            if (pdfObject.getObjectType() != 1113489015) {
                                try {
                                    if (this.decryption != null && !pdfObject.isInCompressedStream()) {
                                        newString = this.decryption.decryptString(newString, pdfObject.getObjectRefAsString());
                                    }
                                }
                                catch (PdfSecurityException e) {
                                    if (!LogWriter.isOutput()) break block76;
                                    LogWriter.writeLog("Exception: " + e.getMessage());
                                }
                            }
                        }
                        pdfObject.setTextStreamValue(PDFkeyInt, newString);
                    }
                    if (!isRef) {
                        i = j;
                    }
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block77;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        return i;
    }

    int setNumberValue(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt) {
        int jj;
        int keyStart = i;
        int rawLength = raw.length;
        while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62 && raw[i] != 40 && raw[i] != 46) {
            ++i;
        }
        int number = NumberUtils.parseInt(keyStart, i, raw);
        for (jj = i; jj < rawLength && (raw[jj] == 32 || raw[jj] == 13 || raw[jj] == 10); ++jj) {
        }
        boolean isRef = false;
        if (raw[jj] >= 48 && raw[jj] <= 57) {
            int aa = jj;
            while (raw[aa] != 10 && raw[aa] != 13 && raw[aa] != 32 && raw[aa] != 47 && raw[aa] != 60 && raw[aa] != 62) {
                ++aa;
            }
            while (aa < rawLength && (raw[aa] == 10 || raw[aa] == 13 || raw[aa] == 32 || raw[aa] == 47)) {
                ++aa;
            }
            boolean bl = isRef = aa < rawLength && raw[aa] == 82;
        }
        if (isRef) {
            int count;
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            keyStart = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int generation = NumberUtils.parseInt(keyStart, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            if (raw[i] != 82) {
                throw new RuntimeException("3. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            byte[] data = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(number, generation), number, generation);
            if (data == null) {
                pdfObject.setFullyResolved(false);
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (8)");
                }
                return rawLength;
            }
            int j = 0;
            int len = data.length;
            if ((len <= 1 || data[0] != 60 || data[1] != 60) && len >= 3) {
                j = 3;
                if (len > 3) {
                    while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111) {
                        if (++j != len) continue;
                        j = 0;
                        break;
                    }
                }
            }
            if (len > 1) {
                while (j < data.length && (data[j] == 9 || data[j] == 10 || data[j] == 13 || data[j] == 32)) {
                    ++j;
                }
            }
            for (count = j; count < len && data[count] != 9 && data[count] != 10 && data[count] != 13 && data[count] != 32; ++count) {
            }
            number = NumberUtils.parseInt(j, count, data);
        }
        pdfObject.setIntNumber(PDFkeyInt, number);
        return --i;
    }

    int readDictionaryFromRefOrDirect(int id, PdfObject pdfObject, String objectRef, int i, byte[] raw, int PDFkeyInt) {
        block43: {
            int generation;
            int ref;
            int keyStart;
            byte[] data;
            int j;
            block0: while (true) {
                int possibleArrayStart = -1;
                while (raw[i] == 91 || raw[i] == 32 || raw[i] == 13 || raw[i] == 10) {
                    if (raw[i] == 91) {
                        possibleArrayStart = i;
                    }
                    ++i;
                }
                if (PDFkeyInt == 2087749783 || id == 2087749783 || pdfObject.getPDFkeyInt() == 2087749783) {
                    ColorObjectDecoder colDecoder = new ColorObjectDecoder(this.objectReader);
                    return colDecoder.processColorSpace(pdfObject, pdfObject.getObjectRefAsString(), i, raw);
                }
                if (possibleArrayStart != -1 && (PDFkeyInt == 489767739 || PDFkeyInt == 9250 || PDFkeyInt == 2037870513)) {
                    return this.processArray(pdfObject, raw, PDFkeyInt, possibleArrayStart);
                }
                if (raw[i] == 37) {
                    while (raw[i] != 13 && raw[i] != 10) {
                        ++i;
                    }
                    while (raw[i] == 91 || raw[i] == 32 || raw[i] == 13 || raw[i] == 10) {
                        ++i;
                    }
                }
                if (raw[i] == 60) {
                    i = this.convertDirectDictionaryToObject(pdfObject, objectRef, i, raw, PDFkeyInt);
                    break block43;
                }
                if (raw[i] == 47) {
                    i = ObjectUtils.setDirectValue(pdfObject, i, raw, PDFkeyInt);
                    break block43;
                }
                j = i;
                data = raw;
                while (true) {
                    block44: {
                        if (data[j] == 91 || data[j] == 32 || data[j] == 13 || data[j] == 10) {
                            ++j;
                            continue;
                        }
                        boolean hasNull = false;
                        do {
                            if (hasNull && data[j] == 93) {
                                return j;
                            }
                            keyStart = j;
                            while (data[j] != 10 && data[j] != 13 && data[j] != 32 && data[j] != 47 && data[j] != 60 && data[j] != 62) {
                                if (data[j] == 108 && data[j - 1] == 108 && data[j - 2] == 117 && data[j - 3] == 110) {
                                    hasNull = true;
                                }
                                if (hasNull && data[j] == 93) {
                                    return j;
                                }
                                ++j;
                            }
                            ref = NumberUtils.parseInt(keyStart, j, data);
                            while (data[j] == 10 || data[j] == 13 || data[j] == 32) {
                                ++j;
                            }
                            if (ref != 69560 || data[keyStart] != 110) break block44;
                            hasNull = true;
                        } while (data[j] != 60);
                        i = j;
                        continue block0;
                    }
                    keyStart = j;
                    while (data[j] != 10 && data[j] != 13 && data[j] != 32 && data[j] != 47 && data[j] != 60 && data[j] != 62) {
                        ++j;
                    }
                    generation = NumberUtils.parseInt(keyStart, j, data);
                    while (data[j] == 10 || data[j] == 13 || data[j] == 32 || data[j] == 47 || data[j] == 60) {
                        ++j;
                    }
                    if (data[j] != 82) {
                        throw new RuntimeException("ref=" + ref + " gen=" + ref + " 1. Unexpected value " + data[j] + " in file - please send to IDRsolutions for analysis char=" + (char)data[j]);
                    }
                    data = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(ref, generation), ref, generation);
                    if (data == null) {
                        pdfObject.setFullyResolved(false);
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (11)");
                        }
                        return raw.length;
                    }
                    if (data != null && data.length > 4 && data[0] == 37 && data[1] == 80 && data[2] == 68 && data[3] == 70) {
                        data = null;
                    }
                    if (data == null) break block0;
                    int j2 = 0;
                    if (data[j2] != 91 && data[0] != 60 && data[1] != 60) {
                        while ((j2 < 3 || j2 > 2 && data[j2 - 1] != 106 && data[j2 - 2] != 98 && data[j2 - 3] != 111) && data[j2] != 47) {
                            ++j2;
                        }
                        while (data[j2] != 91 && (data[j2] == 10 || data[j2] == 13 || data[j2] == 32)) {
                            ++j2;
                        }
                    }
                    if (data[j2] != 91) {
                        j = 0;
                        break block0;
                    }
                    j = j2;
                }
                break;
            }
            if (data != null) {
                boolean isMissingValue;
                while (data[j] == 10 || data[j] == 13 || data[j] == 32) {
                    ++j;
                }
                boolean bl = isMissingValue = j < raw.length && raw[j] == 60;
                if (isMissingValue) {
                    int xx;
                    for (xx = j; xx < data.length && (raw[xx] == 60 || raw[xx] == 10 || raw[xx] == 13 || raw[xx] == 32); ++xx) {
                    }
                    if (raw[xx] == 47) {
                        isMissingValue = false;
                    }
                }
                if (isMissingValue) {
                    keyStart = j;
                    while (data[j] != 10 && data[j] != 13 && data[j] != 32 && data[j] != 47 && data[j] != 60 && data[j] != 62) {
                        ++j;
                    }
                    ref = NumberUtils.parseInt(keyStart, j, data);
                    while (data[j] == 10 || data[j] == 13 || data[j] == 32 || data[j] == 47 || data[j] == 60) {
                        ++j;
                    }
                    keyStart = j;
                    while (data[j] != 10 && data[j] != 13 && data[j] != 32 && data[j] != 47 && data[j] != 60 && data[j] != 62) {
                        ++j;
                    }
                    generation = NumberUtils.parseInt(keyStart, j, data);
                    while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111 && data[j] != 60) {
                        ++j;
                    }
                }
                while (data[j] == 10 || data[j] == 13 || data[j] == 32 || data[j] == 9) {
                    ++j;
                }
                if (data[0] != 60) {
                    while (data[j] != 60 && data[j + 1] != 60) {
                        if (data[j] == 110 && data[j + 1] == 117 && data[j + 2] == 108 && data[j + 3] == 108) {
                            return i;
                        }
                        if (data[j] == 47) break;
                        if (data[j] == 40) {
                            j = this.readTextStream(pdfObject, j, data, PDFkeyInt, true);
                            break;
                        }
                        ++j;
                    }
                }
                i = this.handleValue(pdfObject, i, PDFkeyInt, j, ref, generation, data);
            }
        }
        return i;
    }

    private int processArray(PdfObject pdfObject, byte[] raw, int PDFkeyInt, int possibleArrayStart) {
        int endPoint;
        for (endPoint = possibleArrayStart; raw[endPoint] != 93 && endPoint <= raw.length; ++endPoint) {
        }
        PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, null, pdfObject.getObjectType(), pdfObject.getID());
        valueObj.setID(PDFkeyInt);
        pdfObject.setDictionary(PDFkeyInt, valueObj);
        valueObj.ignoreRecursion(pdfObject.ignoreRecursion());
        if (valueObj.isDataExternal()) {
            valueObj.isDataExternal(true);
            if (!this.resolveFully(valueObj)) {
                pdfObject.setFullyResolved(false);
            }
        }
        int type = 9;
        if (PDFkeyInt == 9250) {
            type = 14;
        }
        ArrayDecoder objDecoder = new ArrayDecoder(this.objectReader, possibleArrayStart, endPoint, type);
        int i = objDecoder.readArray(pdfObject.ignoreRecursion(), raw, valueObj, PDFkeyInt);
        return i;
    }

    private int handleValue(PdfObject pdfObject, int i, int PDFkeyInt, int j, int ref, int generation, byte[] data) {
        int dataLen = data.length;
        if (data[j] == 47) {
            int keyStart = ++j;
            int keyLength = 0;
            while (j < dataLen && data[j] != 10 && data[j] != 13 && data[j] != 32 && data[j] != 47 && data[j] != 60 && data[j] != 62) {
                ++j;
                ++keyLength;
            }
            --i;
            if (PDFkeyInt == -1) {
                pdfObject.setConstant(PDFkeyInt, keyStart, keyLength, data);
            } else {
                PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, null, pdfObject.getObjectType(), pdfObject.getID());
                valueObj.setID(PDFkeyInt);
                valueObj.setConstant(PDFkeyInt, keyStart, keyLength, data);
                pdfObject.setDictionary(PDFkeyInt, valueObj);
                if (pdfObject.isDataExternal()) {
                    valueObj.isDataExternal(true);
                    if (!this.resolveFully(valueObj)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
            }
        } else {
            PdfObject valueObj;
            if (PDFkeyInt == -1) {
                valueObj = pdfObject;
            } else {
                valueObj = ObjectFactory.createObject(PDFkeyInt, ref, generation, pdfObject.getObjectType());
                valueObj.setID(PDFkeyInt);
                valueObj.setInCompressedStream(pdfObject.isInCompressedStream());
                if (pdfObject.isDataExternal()) {
                    valueObj.isDataExternal(true);
                    if (!this.resolveFully(valueObj)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
                if (PDFkeyInt != 2004251818) {
                    valueObj.ignoreRecursion(pdfObject.ignoreRecursion());
                }
            }
            ObjectDecoder objDecoder = new ObjectDecoder(this.objectReader);
            objDecoder.readDictionaryAsObject(valueObj, j, data);
            if (PDFkeyInt != -1) {
                pdfObject.setDictionary(PDFkeyInt, valueObj);
            }
        }
        return i;
    }

    int convertDirectDictionaryToObject(PdfObject pdfObject, String objectRef, int i, byte[] raw, int PDFkeyInt) {
        PdfObject valueObj;
        if (PDFkeyInt == -1) {
            valueObj = pdfObject;
            int objCount = 0;
            int refStarts = -1;
            int refEnds = -1;
            if (raw[0] == 60) {
                for (int ii = 0; ii < raw.length; ++ii) {
                    if (raw[ii] == 47) {
                        ++objCount;
                    }
                    if (objCount != 1) continue;
                    if (refStarts == -1) {
                        if (raw[ii] <= 48 || raw[ii] >= 57) continue;
                        refStarts = ii;
                        continue;
                    }
                    if (raw[ii] != 82) continue;
                    refEnds = ii + 1;
                }
                if (objCount == 1 && refStarts != -1 && refEnds != -1) {
                    objectRef = new String(raw, refStarts, refEnds - refStarts);
                    valueObj.setRef(objectRef);
                }
            }
        } else {
            valueObj = ObjectFactory.createObject(PDFkeyInt, objectRef, pdfObject.getObjectType(), pdfObject.getID());
            valueObj.setInCompressedStream(pdfObject.isInCompressedStream());
            valueObj.setID(PDFkeyInt);
            if (pdfObject.isCached()) {
                valueObj.moveCacheValues(pdfObject);
            }
        }
        ObjectDecoder objDecoder = new ObjectDecoder(this.objectReader);
        i = objDecoder.readDictionaryAsObject(valueObj, i, raw);
        if (i < raw.length && raw[i] == 62) {
            --i;
        }
        if (PDFkeyInt != -1) {
            pdfObject.setDictionary(PDFkeyInt, valueObj);
        }
        int count = raw.length;
        while (i < count - 1 && raw[i] == 62 && raw[i + 1] == 62 && (++i + 1 >= raw.length || raw[i + 1] != 62)) {
        }
        return i;
    }

    private int readKeyPairs(int id, byte[] data, int j, int pairs, PdfObject pdfObject) {
        boolean debug = false;
        int start = j;
        int numberOfPairs = pairs;
        boolean isCountOnly = false;
        boolean skipToEnd = false;
        Object keys = null;
        Object values = null;
        PdfObject[] objs = null;
        if (pairs == -1) {
            isCountOnly = true;
        } else if (pairs == -2) {
            isCountOnly = true;
            skipToEnd = true;
        } else {
            keys = new byte[numberOfPairs][];
            values = new byte[numberOfPairs][];
            objs = new PdfObject[numberOfPairs];
        }
        pairs = 0;
        while (true) {
            PdfObject valueObj;
            byte[] dictData;
            boolean isDirect;
            if (data[start] == 9 || data[start] == 10 || data[start] == 13 || data[start] == 32 || data[start] == 60) {
                ++start;
                continue;
            }
            if (data[start] == 37) {
                while (data[start] != 10 && data[start] != 13) {
                    ++start;
                }
                while (data[start] == 9 || data[start] == 10 || data[start] == 13 || data[start] == 32 || data[start] == 60) {
                    ++start;
                }
            }
            if (data[start] == 62) break;
            if (data[start] == 47) {
                ++pairs;
            } else {
                throw new RuntimeException("Unexpected value " + data[start] + " - not key pair");
            }
            int tokenStart = ++start;
            while (data[start] != 32 && data[start] != 10 && data[start] != 13 && data[start] != 91 && data[start] != 60 && data[start] != 47) {
                ++start;
            }
            int tokenLength = start - tokenStart;
            byte[] tokenKey = new byte[tokenLength];
            System.arraycopy(data, tokenStart, tokenKey, 0, tokenLength);
            if (!isCountOnly) {
                keys[pairs - 1] = tokenKey;
            }
            while (data[start] == 10 || data[start] == 13 || data[start] == 32) {
                ++start;
            }
            boolean bl = isDirect = data[start] == 60 || data[start] == 91 || data[start] == 47;
            if (isDirect) {
                int level;
                while (data[start - 1] != 60 && data[start] != 60 && data[start] != 91 && data[start] != 47) {
                    ++start;
                }
                int streamStart = start;
                boolean isObject = true;
                if (data[start] == 60) {
                    start += 2;
                    level = 1;
                    while (level > 0) {
                        if (data[start] == 60 && data[start + 1] == 60) {
                            start += 2;
                            ++level;
                            continue;
                        }
                        if (data[start] == 62 && data[start + 1] == 62) {
                            start += 2;
                            --level;
                            continue;
                        }
                        ++start;
                    }
                } else if (data[start] == 91) {
                    level = 1;
                    ++start;
                    boolean inStream = false;
                    while (level > 0) {
                        if (!inStream && data[start] == 40) {
                            inStream = true;
                        } else if (inStream && data[start] == 41 && (data[start - 1] != 92 || data[start - 2] == 92)) {
                            inStream = false;
                        }
                        if (!inStream) {
                            if (data[start] == 91) {
                                ++level;
                            } else if (data[start] == 93) {
                                --level;
                            }
                        }
                        ++start;
                    }
                    isObject = false;
                } else if (data[start] == 47) {
                    ++start;
                    while (data[start] != 47 && data[start] != 10 && data[start] != 13 && data[start] != 32 && (++start >= data.length - 1 || data[start] != 62 || data[start + 1] != 62)) {
                    }
                }
                if (isCountOnly) continue;
                int len = start - streamStart;
                dictData = new byte[len];
                System.arraycopy(data, streamStart, dictData, 0, len);
                values[pairs - 1] = dictData;
                String ref = pdfObject.getObjectRefAsString();
                if (pdfObject.getObjectType() == 2087749783) {
                    ColorObjectDecoder colDecoder = new ColorObjectDecoder(this.objectReader);
                    if (isObject && !isDirect) {
                        colDecoder.handleColorSpaces(pdfObject, 0, dictData);
                        objs[pairs - 1] = pdfObject;
                        continue;
                    }
                    ColorSpaceObject colObject = new ColorSpaceObject(ref);
                    if (isDirect) {
                        colObject.setRef(-1, 0);
                    }
                    colDecoder.handleColorSpaces(colObject, 0, dictData);
                    objs[pairs - 1] = colObject;
                    continue;
                }
                if (!isObject) continue;
                PdfObject valueObj2 = ObjectFactory.createObject(id, ref, pdfObject.getObjectType(), pdfObject.getID());
                valueObj2.setID(id);
                this.readDictionaryFromRefOrDirect(id, valueObj2, ref, 0, dictData, -1);
                objs[pairs - 1] = valueObj2;
                continue;
            }
            int number = 0;
            int generation = 0;
            int refStart = start;
            int keyStart2 = start;
            boolean isNull = false;
            if (data[start] == 110 && data[start + 1] == 117 && data[start + 2] == 108 && data[start + 3] == 108) {
                start += 4;
                isNull = true;
            } else {
                while (data[start] != 10 && data[start] != 13 && data[start] != 32 && data[start] != 47 && data[start] != 60 && data[start] != 62) {
                    ++start;
                }
                number = NumberUtils.parseInt(keyStart2, start, data);
                while (data[start] == 10 || data[start] == 13 || data[start] == 32 || data[start] == 47 || data[start] == 60) {
                    ++start;
                }
                keyStart2 = start;
                while (data[start] != 10 && data[start] != 13 && data[start] != 32 && data[start] != 47 && data[start] != 60 && data[start] != 62) {
                    ++start;
                }
                generation = NumberUtils.parseInt(keyStart2, start, data);
                while (data[start] == 10 || data[start] == 13 || data[start] == 32 || data[start] == 47 || data[start] == 60) {
                    ++start;
                }
            }
            if (!isNull && data[start] != 82) {
                throw new RuntimeException((char)data[start - 1] + " " + (char)data[start] + " " + (char)data[start + 1] + " 3. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            ++start;
            if (isCountOnly) continue;
            if (isNull) {
                objs[pairs - 1] = null;
                continue;
            }
            if (PdfDictionary.getKeyType(id, pdfObject.getObjectType()) == 5) {
                String ref = new String(data, refStart, start - refStart);
                PdfObject valueObj3 = ObjectFactory.createObject(id, ref, pdfObject.getObjectType(), pdfObject.getID());
                valueObj3.setStatus(1);
                valueObj3.setUnresolvedData(StringUtils.toBytes(ref), id);
                objs[pairs - 1] = valueObj3;
                continue;
            }
            byte[] rawDictData = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(number, generation), number, generation);
            if (rawDictData == null) {
                pdfObject.setFullyResolved(false);
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (12)");
                }
                return data.length;
            }
            int jj = 0;
            while ((jj < 3 || rawDictData[jj - 1] != 106 && rawDictData[jj - 2] != 98 && rawDictData[jj - 3] != 111) && rawDictData[jj] != 47 && rawDictData[jj] != 91 && rawDictData[jj] != 60) {
                if (++jj != rawDictData.length) continue;
                jj = 0;
                break;
            }
            while (rawDictData[jj] == 10 || rawDictData[jj] == 13 || rawDictData[jj] == 32) {
                ++jj;
            }
            int len = rawDictData.length - jj;
            dictData = new byte[len];
            System.arraycopy(rawDictData, jj, dictData, 0, len);
            values[pairs - 1] = dictData;
            String ref = number + " " + generation + " R";
            if (pdfObject.getObjectType() == 373243460 && id == 373243460) {
                objs[pairs - 1] = null;
                values[pairs - 1] = StringUtils.toBytes(ref);
                continue;
            }
            if (pdfObject.getObjectType() == 979194486) {
                valueObj = ObjectFactory.createObject(id, ref, 979194486, 979194486);
                valueObj.setStatus(1);
                valueObj.setUnresolvedData(StringUtils.toBytes(ref), id);
                objs[pairs - 1] = valueObj;
                continue;
            }
            valueObj = ObjectFactory.createObject(id, ref, pdfObject.getObjectType(), pdfObject.getID());
            valueObj.setID(id);
            if (valueObj.getObjectType() == 2087749783) {
                ColorObjectDecoder colDecoder = new ColorObjectDecoder(this.objectReader);
                colDecoder.handleColorSpaces(valueObj, 0, dictData);
            } else {
                this.readDictionaryFromRefOrDirect(id, valueObj, ref, 0, dictData, -1);
            }
            objs[pairs - 1] = valueObj;
        }
        if (!isCountOnly) {
            pdfObject.setDictionaryPairs((byte[][])keys, (byte[][])values, objs);
        }
        if (skipToEnd || !isCountOnly) {
            return start;
        }
        return pairs;
    }

    void readStreamIntoObject(PdfObject pdfObject, int j, byte[] data) {
        int count = data.length;
        byte[] stream = null;
        PdfArrayIterator maskFilters = pdfObject.getMixedArray(1011108731);
        boolean isJBigEncoded = false;
        int firstMaskValue = -1;
        if (maskFilters != null && maskFilters.hasMoreTokens()) {
            firstMaskValue = maskFilters.getNextValueAsConstant(true);
            if (firstMaskValue == 1247500931) {
                isJBigEncoded = true;
            }
            while (maskFilters.hasMoreTokens() && !isJBigEncoded) {
                firstMaskValue = maskFilters.getNextValueAsConstant(true);
                if (firstMaskValue != 1247500931) continue;
                isJBigEncoded = true;
            }
        }
        for (int a = j; a < count; ++a) {
            int ptr;
            if (data[a] != 115 || data[a + 1] != 116 || data[a + 2] != 114 || data[a + 3] != 101 || data[a + 4] != 97 || data[a + 5] != 109) continue;
            a += 6;
            while (data[a] == 32) {
                ++a;
            }
            if (data[a] == 13 && data[a + 1] == 10) {
                a += 2;
            } else if (data[a] == 10 && data[a + 1] == 10 && data[a + 2] == 10 && data[a + 3] == -1 && firstMaskValue == 1180911742) {
                a += 3;
            } else if (data[a] == 10 && data[a + 1] == 10 && data[a + 2] == -1 && firstMaskValue == 1180911742) {
                a += 2;
            } else if (data[a] == 10 || data[a] == 13) {
                // empty if block
            }
            int start = ++a;
            --a;
            int streamLength = 0;
            int setStreamLength = pdfObject.getInt(1043816557);
            boolean isValid = false;
            if (setStreamLength != -1) {
                streamLength = setStreamLength;
                a = start + streamLength;
                if (a < count && data[a] == 13 && a + 1 < count && data[a + 1] == 10) {
                    a += 2;
                }
                if (count <= a + 9 || data[a] != 101 || data[a + 1] != 110 || data[a + 2] != 100 || data[a + 3] != 115 || data[a + 4] != 116 || data[a + 5] != 114 || data[a + 6] != 101 || data[a + 7] != 97 || data[a + 8] != 109) {
                    int current = a;
                    if (a < count) {
                        while (!isValid && ++a != count) {
                            if (data[a] != 101 || data[a + 1] != 110 || data[a + 2] != 100 || data[a + 3] != 115 || data[a + 4] != 116 || data[a + 5] != 114 || data[a + 6] != 101 || data[a + 7] != 97 || data[a + 8] != 109) continue;
                            streamLength = a - start;
                            isValid = true;
                        }
                    }
                    if (!isValid) {
                        a = current;
                        if (a > count) {
                            a = count;
                        }
                        while (!isValid && --a >= 0) {
                            if (data[a] != 101 || data[a + 1] != 110 || data[a + 2] != 100 || data[a + 3] != 115 || data[a + 4] != 116 || data[a + 5] != 114 || data[a + 6] != 101 || data[a + 7] != 97 || data[a + 8] != 109) continue;
                            streamLength = a - start;
                            isValid = true;
                        }
                    }
                    if (!isValid) {
                        a = current;
                    }
                }
                if (this.decryption != null && this.decryption.getBooleanValue(101)) {
                    streamLength = setStreamLength;
                }
            } else {
                while (++a != count && (data[a] != 101 || data[a + 1] != 110 || data[a + 2] != 100 || data[a + 3] != 115 || data[a + 4] != 116 || data[a + 5] != 114 || data[a + 6] != 101 || data[a + 7] != 97 || data[a + 8] != 109)) {
                }
                int end = a - 1;
                if (end > start) {
                    streamLength = end - start + 1;
                }
            }
            if (streamLength > 1 && (this.decryption == null || !this.decryption.getBooleanValue(101)) && (ptr = start + streamLength - 1) < data.length && ptr > 0 && (data[ptr] == 10 || data[ptr] == 13 && (pdfObject != null && isJBigEncoded || ptr > 0 && data[ptr - 1] == 10))) {
                --streamLength;
                --ptr;
            }
            if (start + streamLength > count) {
                streamLength = count - start;
            }
            if (streamLength < 0) {
                return;
            }
            if (streamLength < 0) {
                throw new RuntimeException("Negative stream length " + streamLength + " start=" + start + " count=" + count);
            }
            stream = new byte[streamLength];
            System.arraycopy(data, start, stream, 0, streamLength);
            a = count;
        }
        if (pdfObject != null) {
            pdfObject.setStream(stream);
            if (pdfObject.decompressStreamWhenRead()) {
                this.objectReader.readStream(pdfObject, true, true, false, pdfObject.getObjectType() == 1365674082, pdfObject.isCompressedStream(), null);
            }
        }
    }

    private int setNameStringValue(PdfObject pdfObject, int i, byte[] raw, boolean isMap) {
        byte[] stringBytes;
        while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 40) {
            ++i;
        }
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32) {
            ++i;
        }
        int j2 = i;
        byte[] arrayData = raw;
        boolean isIndirect = raw[i] != 47 && raw[i] != 40 && raw[i] != 60;
        boolean startsWithBrace = raw[i] == 40;
        boolean isInsideArray = false;
        if (isIndirect) {
            int aa;
            for (aa = i + 1; aa < raw.length && (raw[aa] == 10 || raw[aa] == 13 || raw[aa] == 32); ++aa) {
            }
            if (raw[aa] == 47 || raw[aa] == 93) {
                isIndirect = false;
                i = aa + 1;
                isInsideArray = true;
            }
        }
        if (isIndirect) {
            int keyStart = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int ref = NumberUtils.parseInt(keyStart, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            keyStart = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int generation = NumberUtils.parseInt(keyStart, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            if (raw[i] != 82) {
                throw new RuntimeException(padding + "2. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            arrayData = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(ref, generation), ref, generation);
            if (arrayData == null) {
                pdfObject.setFullyResolved(false);
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (13)");
                }
                return raw.length;
            }
            if (arrayData[0] == 47) {
                j2 = 0;
            } else {
                j2 = 3;
                while (arrayData[j2] != 47) {
                    ++j2;
                }
            }
        }
        if (arrayData[++j2] == 47) {
            return j2 - 1;
        }
        int end = j2 + 1;
        if (isInsideArray) {
            while (arrayData[j2] == 10 || arrayData[j2] == 13 || arrayData[j2] == 32 || arrayData[j2] == 47) {
                ++j2;
            }
            int slashes = 0;
            int lastChar = 0;
            while (arrayData[end] != 93) {
                if (arrayData[end] == 47 && (lastChar == 32 || lastChar == 10 || lastChar == 13)) {
                    ++slashes;
                }
                lastChar = arrayData[end];
                if (++end != arrayData.length) continue;
            }
            int charCount = end - slashes;
            int ptr = 0;
            stringBytes = new byte[charCount - j2];
            int previous = 0;
            for (int ii = j2; ii < charCount; ++ii) {
                int nextChar = arrayData[ii];
                if (nextChar == 47) {
                    if (previous != 32 && previous != 10 && previous != 13) {
                        stringBytes[ptr] = 32;
                        ++ptr;
                    }
                } else {
                    stringBytes[ptr] = nextChar;
                    ++ptr;
                }
                previous = nextChar;
            }
        } else {
            while (!(!startsWithBrace ? arrayData[end] == 32 || arrayData[end] == 10 || arrayData[end] == 13 || arrayData[end] == 47 || arrayData[end] == 62 : arrayData[end] == 41)) {
                if (++end != arrayData.length) continue;
            }
            int charCount = end - j2;
            stringBytes = new byte[charCount];
            System.arraycopy(arrayData, j2, stringBytes, 0, charCount);
        }
        if (isMap) {
            pdfObject.setName(this.PDFkey, StringUtils.getTextString(stringBytes, false));
        } else {
            pdfObject.setName(this.PDFkeyInt, stringBytes);
        }
        if (!isIndirect) {
            i = end - 1;
        }
        return i;
    }

    public synchronized boolean resolveFully(PdfObject pdfObject) {
        boolean fullyResolved;
        boolean bl = fullyResolved = pdfObject != null;
        if (fullyResolved) {
            byte[] raw = pdfObject.getStatus() == 0 ? StringUtils.toBytes(pdfObject.getObjectRefAsString()) : pdfObject.getUnresolvedData();
            pdfObject.setStatus(0);
            if (raw[0] != 101 && raw[1] != 110 && raw[2] != 100 && raw[3] != 111 && raw[4] != 98) {
                int j = 0;
                while (raw[j] == 91 || raw[j] == 32 || raw[j] == 13 || raw[j] == 10) {
                    ++j;
                }
                int keyStart = j;
                while (raw[j] != 10 && raw[j] != 13 && raw[j] != 32 && raw[j] != 47 && raw[j] != 60 && raw[j] != 62) {
                    ++j;
                }
                int ref = NumberUtils.parseInt(keyStart, j, raw);
                while (raw[j] == 10 || raw[j] == 13 || raw[j] == 32) {
                    ++j;
                }
                keyStart = j;
                while (raw[j] != 10 && raw[j] != 13 && raw[j] != 32 && raw[j] != 47 && raw[j] != 60 && raw[j] != 62) {
                    ++j;
                }
                int generation = NumberUtils.parseInt(keyStart, j, raw);
                if (raw[raw.length - 1] == 82) {
                    fullyResolved = this.resolveFullyChildren(pdfObject, fullyResolved, raw, ref, generation);
                }
                if (fullyResolved) {
                    pdfObject.ignoreRecursion(false);
                    ObjectDecoder objDecoder = new ObjectDecoder(this.objectReader);
                    objDecoder.readDictionaryAsObject(pdfObject, j, raw);
                }
            }
        }
        return fullyResolved;
    }

    private boolean resolveFullyChildren(PdfObject pdfObject, boolean fullyResolved, byte[] raw, int ref, int generation) {
        pdfObject.setRef(new String(raw));
        pdfObject.isDataExternal(true);
        byte[] pageData = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(ref, generation), ref, generation);
        if (pageData == null) {
            pdfObject.setFullyResolved(false);
            fullyResolved = false;
        } else {
            pdfObject.setStatus(2);
            pdfObject.setUnresolvedData(pageData, 2004845231);
            pdfObject.isDataExternal(true);
            if (!this.resolveFully(pdfObject)) {
                pdfObject.setFullyResolved(false);
            }
        }
        return fullyResolved;
    }

    public void checkResolved(PdfObject pdfObject) {
        if (pdfObject != null && pdfObject.getStatus() != 0) {
            byte[] raw = pdfObject.getUnresolvedData();
            pdfObject.setStatus(0);
            if (!(raw[0] == 101 && raw[1] == 110 && raw[2] == 100 && raw[3] == 111 && raw[4] == 98 || raw[0] == 110 && raw[1] == 117 && raw[2] == 108 && raw[3] == 108)) {
                String objectRef = pdfObject.getObjectRefAsString();
                if (raw[0] == 91) {
                    int ptr = 0;
                    int len = raw.length;
                    for (int jj = 0; jj < len; ++jj) {
                        if (raw[jj] < 48 || raw[jj] > 57) continue;
                        ptr = jj;
                        jj = len;
                    }
                    int end = ptr;
                    while (raw[end] >= 48 && raw[end] <= 57 || raw[end] == 32 || raw[end] == 10 || raw[end] == 13 || raw[end] == 9) {
                        ++end;
                    }
                    if (raw[end] == 82) {
                        pdfObject.setRef(new String(raw, ptr, len - ptr));
                    }
                } else if (raw[raw.length - 1] == 82) {
                    pdfObject.setRef(new String(raw));
                }
                ObjectDecoder objDecoder = new ObjectDecoder(this.objectReader);
                objDecoder.readDictionaryFromRefOrDirect(-1, pdfObject, objectRef, 0, raw, -1);
            }
        }
    }

    public void setEndPt(int dataPointer) {
        this.endPt = dataPointer;
    }
}

