/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.jpedal.color.ColorSpaces;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;

public class ImageTransformer {
    private BufferedImage current_image;
    private float[][] Trm;
    private float[][] CTM;
    private int i_x = 0;
    private int i_y = 0;
    private int i_w = 0;
    private int i_h = 0;

    public ImageTransformer(GraphicsState current_graphics_state, BufferedImage new_image, boolean scaleImage) {
        this.current_image = new_image;
        int w = this.current_image.getWidth();
        int h = this.current_image.getHeight();
        this.CTM = current_graphics_state.CTM;
        this.Trm = new float[3][3];
        this.Trm[0][0] = this.CTM[0][0] / (float)w;
        this.Trm[0][1] = -(this.CTM[0][1] / (float)w);
        this.Trm[0][2] = 0.0f;
        this.Trm[1][0] = -(this.CTM[1][0] / (float)h);
        this.Trm[1][1] = this.CTM[1][1] / (float)h;
        this.Trm[1][2] = 0.0f;
        this.Trm[2][0] = this.CTM[2][0];
        this.Trm[2][1] = this.CTM[2][1];
        this.Trm[2][2] = 1.0f;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                if (!((double)this.Trm[x][y] > 0.99 & this.Trm[x][y] < 1.0f)) continue;
                this.Trm[x][y] = 1.0f;
            }
        }
        this.scale(scaleImage, w, h);
        this.completeImage();
    }

    private void scale(boolean scaleImage, int w, int h) {
        if ((double)this.Trm[0][0] != 1.0 || (double)this.Trm[1][1] != 1.0 || (double)this.Trm[0][1] != 0.0 || (double)this.Trm[1][0] != 0.0) {
            AffineTransformOp invert;
            AffineTransform image_at = new AffineTransform(this.Trm[0][0], this.Trm[0][1], this.Trm[1][0], this.Trm[1][1], 0.0f, 0.0f);
            Area r = new Area(new Rectangle(0, 0, w, h));
            r.transform(image_at);
            double ny = r.getBounds2D().getY();
            double nx = r.getBounds2D().getX();
            float a = this.Trm[0][0];
            float b = this.Trm[0][1];
            float c = this.Trm[1][0];
            float d = this.Trm[1][1];
            image_at = new AffineTransform((double)a, (double)b, (double)c, (double)d, -nx, -ny);
            if (a < 0.0f) {
                a = -a;
            }
            if (b < 0.0f) {
                b = -b;
            }
            if (c < 0.0f) {
                c = -c;
            }
            if (d < 0.0f) {
                d = -d;
            }
            if (a > 5.0f || b > 5.0f || c > 5.0f || d > 5.0f) {
                return;
            }
            if (w > 1 && h > 1) {
                if (this.CTM[0][0] == 0.0f && this.CTM[1][1] == 0.0f && this.CTM[0][1] > 0.0f && this.CTM[1][0] < 0.0f) {
                    image_at.scale(-1.0, 1.0);
                    image_at.translate(-this.current_image.getWidth(), 0.0);
                }
                invert = new AffineTransformOp(image_at, ColorSpaces.hints);
            } else {
                boolean isSolid = true;
                if (h == 1) {
                    WritableRaster ras = this.current_image.getRaster();
                    int bands = ras.getNumBands();
                    int width = ras.getWidth();
                    int[] elements = new int[width * bands + 1];
                    ras.getPixels(0, 0, width, 1, elements);
                    for (int j = 0; j < bands; ++j) {
                        int first = elements[0];
                        for (int i = 1; i < width; ++i) {
                            if (elements[i * j] == first) continue;
                            isSolid = false;
                            i = width;
                            j = bands;
                        }
                    }
                }
                invert = isSolid ? new AffineTransformOp(image_at, null) : new AffineTransformOp(image_at, ColorSpaces.hints);
            }
            if (this.CTM[1][0] != 0.0f || this.CTM[0][1] != 0.0f) {
                this.current_image = ColorSpaceConvertor.convertToARGB(this.current_image);
            }
            if (scaleImage && h > 1) {
                boolean failed = false;
                try {
                    this.current_image = invert.filter(this.current_image, null);
                }
                catch (Exception e) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                    failed = true;
                }
                if (failed) {
                    try {
                        invert = new AffineTransformOp(image_at, null);
                        this.current_image = invert.filter(this.current_image, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void completeImage() {
        this.calcCoordinates();
    }

    private final void calcCoordinates() {
        if (this.CTM[1][0] == 0.0f && this.CTM[0][1] == 0.0f) {
            this.i_x = (int)this.CTM[2][0];
            this.i_y = (int)this.CTM[2][1];
            this.i_w = (int)this.CTM[0][0];
            this.i_h = (int)this.CTM[1][1];
            if (this.i_w < 0) {
                this.i_w = -this.i_w;
            }
            if (this.i_h < 0) {
                this.i_h = -this.i_h;
            }
        } else {
            this.i_w = (int)Math.sqrt(this.CTM[0][0] * this.CTM[0][0] + this.CTM[0][1] * this.CTM[0][1]);
            this.i_h = (int)Math.sqrt(this.CTM[1][1] * this.CTM[1][1] + this.CTM[1][0] * this.CTM[1][0]);
            if (this.CTM[1][0] > 0.0f && this.CTM[0][1] < 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)(this.CTM[2][1] + this.CTM[0][1]);
            } else if (this.CTM[1][0] < 0.0f && this.CTM[0][1] > 0.0f) {
                this.i_x = (int)(this.CTM[2][0] + this.CTM[1][0]);
                this.i_y = (int)this.CTM[2][1];
            } else if (this.CTM[1][0] > 0.0f && this.CTM[0][1] > 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            } else {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            }
        }
        if (this.CTM[1][1] < 0.0f) {
            this.i_y -= this.i_h;
        }
        if (this.CTM[0][0] < 0.0f) {
            this.i_x -= this.i_w;
        }
    }

    public final int getImageY() {
        return this.i_y;
    }

    public final BufferedImage getImage() {
        return this.current_image;
    }

    public final int getImageW() {
        return this.i_w;
    }

    public final int getImageH() {
        return this.i_h;
    }

    public final int getImageX() {
        return this.i_x;
    }

    public final void clipImage(Area current_shape) {
        Area final_clip = (Area)current_shape.clone();
        int image_w = this.current_image.getWidth();
        int image_h = this.current_image.getHeight();
        double shape_x = final_clip.getBounds2D().getX();
        double shape_y = final_clip.getBounds2D().getY();
        double shape_h = final_clip.getBounds2D().getHeight();
        double d_y = (double)image_h - shape_h;
        AffineTransform upside_down = new AffineTransform();
        upside_down.translate(-shape_x, -shape_y);
        upside_down.scale(1.0, -1.0);
        upside_down.translate(shape_x, -(shape_y + shape_h));
        final_clip.transform(upside_down);
        AffineTransform align_clip = new AffineTransform();
        align_clip.translate(-this.i_x, (double)this.i_y + d_y);
        final_clip.transform(align_clip);
        double x = final_clip.getBounds2D().getX();
        double y = final_clip.getBounds2D().getY();
        double w = final_clip.getBounds2D().getWidth();
        double h = final_clip.getBounds2D().getHeight();
        int image_type = this.current_image.getType();
        if (image_type == 0) {
            image_type = 2;
        } else if (image_type == 1) {
            image_type = 2;
        }
        BufferedImage offscreen = new BufferedImage(image_w, image_h, image_type);
        Graphics2D image_g2 = offscreen.createGraphics();
        if (!offscreen.getColorModel().hasAlpha()) {
            image_g2.setBackground(Color.white);
            image_g2.fill(new Rectangle(0, 0, image_w, image_h));
        }
        image_g2.setClip(final_clip);
        try {
            image_g2.drawImage((Image)this.current_image, 0, 0, null);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " plotting clipping image");
        }
        if (y < 0.0) {
            h += y;
            y = 0.0;
        }
        if (x < 0.0) {
            w += x;
            x = 0.0;
        }
        if (w > (double)image_w) {
            w = image_w;
        }
        if (h > (double)image_h) {
            h = image_h;
        }
        if (y + h > (double)image_h) {
            h = (double)image_h - y;
        }
        if (x + w > (double)image_w) {
            w = (double)image_w - x;
        }
        try {
            this.current_image = offscreen.getSubimage((int)x, (int)y, (int)w, (int)h);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " extracting clipped image with values x=" + x + " y=" + y + " w=" + w + " h=" + h + " from image ");
        }
        double x1 = (double)this.i_x > shape_x ? (double)this.i_x : shape_x;
        double y1 = (double)this.i_y > shape_y ? (double)this.i_y : shape_y;
        this.i_x = (int)x1;
        this.i_y = (int)y1;
        this.i_w = (int)w;
        this.i_h = (int)h;
    }
}

