/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFExponential
extends PDFGenericFunction
implements PDFFunction {
    private static final long serialVersionUID = 5385374201115057519L;
    private float[] C0 = new float[]{0.0f};
    private float[] C1 = new float[]{1.0f};
    private float N;
    int returnValues;

    public PDFExponential(float N, float[] C0, float[] C1, float[] domain, float[] range) {
        super(domain, range);
        this.N = N;
        if (C0 != null) {
            this.C0 = C0;
        }
        if (C1 != null) {
            this.C1 = C1;
        }
        this.returnValues = this.C0.length;
    }

    @Override
    public float[] computeStitch(float[] subinput) {
        return this.compute(subinput);
    }

    @Override
    public float[] compute(float[] values) {
        float[] output = new float[this.returnValues];
        float[] result = new float[this.returnValues];
        float x = PDFExponential.min(PDFExponential.max(values[0], this.domain[0]), this.domain[1]);
        if (this.N == 1.0f) {
            for (int i = 0; i < this.C0.length; ++i) {
                output[i] = this.C0[i] + x * (this.C1[i] - this.C0[i]);
                if (this.range != null) {
                    output[i] = PDFExponential.min(PDFExponential.max(output[i], this.range[i * 2]), this.range[i * 2 + 1]);
                }
                result[i] = output[i];
            }
        } else {
            for (int i = 0; i < this.C0.length; ++i) {
                output[i] = this.C0[i] + (float)Math.pow(x, this.N) * (this.C1[i] - this.C0[i]);
                if (this.range != null) {
                    output[i] = PDFExponential.min(PDFExponential.max(output[i], this.range[i * 2]), this.range[i * 2 + 1]);
                }
                result[i] = output[i];
            }
        }
        return result;
    }
}

