/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;
import org.jpedal.function.PostscriptFactory;
import org.jpedal.utils.LogWriter;

public class PDFCalculator
extends PDFGenericFunction
implements PDFFunction {
    private static final long serialVersionUID = -2771458940865489908L;
    int returnValues;
    byte[] stream;

    public PDFCalculator(byte[] stream, float[] domain, float[] range) {
        super(domain, range);
        this.returnValues = range.length / 2;
        this.stream = stream;
    }

    @Override
    public float[] computeStitch(float[] subinput) {
        return this.compute(subinput);
    }

    @Override
    public float[] compute(float[] values) {
        float[] result;
        block6: {
            float[] output = new float[this.returnValues];
            result = new float[this.returnValues];
            try {
                PostscriptFactory post = new PostscriptFactory(this.stream);
                post.resetStacks(values);
                double[] stack = post.executePostscript();
                if (this.domain.length / 2 == 1) {
                    int imax = this.range.length / 2;
                    for (int i = 0; i < imax; ++i) {
                        output[i] = (float)stack[i];
                        result[i] = PDFCalculator.min(PDFCalculator.max(output[i], this.range[i * 2]), this.range[i * 2 + 1]);
                    }
                } else {
                    int imax = this.range.length / 2;
                    for (int i = 0; i < imax; ++i) {
                        output[i] = (float)stack[i];
                        result[i] = PDFCalculator.min(PDFCalculator.max(output[i], this.range[i * 2]), this.range[i * 2 + 1]);
                    }
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return result;
    }
}

